/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.ireportadapter.service;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import com.hs.vsm.ireportadapter.model.SendEmailForm;
import com.hs.vsm.ireportadapter.sendemail.SendEmailQueue;
import com.hs.vsm.ireportadapter.util.AdapterUtil;
import com.hs.vsm.ireportadapter.util.LocaleUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.model.vo.BackTask;
import com.security.ireport.model.vo.ReportPlugVO;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.UserInfo;
import com.security.ireport.service.IReportProductAdapter;
import com.security.ireport.util.CreateReportSessionId;
import com.security.logserver.module.condition.model.TreeNode;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class VSMProductAdapterImpl
extends IReportProductAdapter {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private final Locale defaultLocal = Locale.SIMPLIFIED_CHINESE;

    public boolean addReportMenu(ReportPlugVO report) {
        return true;
    }

    public boolean delReportMenu(ReportPlugVO report) {
        return true;
    }

    public TreeNode getMenuNode(String userName) {
        return null;
    }

    public Locale getUserLocale() {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            locale = ActionContext.getContext().getLocale();
        }
        if (null == locale) {
            locale = this.defaultLocal;
        }
        return locale;
    }

    public String getUserName() {
        ActionContext ctx = ActionContext.getContext();
        if (null == ctx) {
            return "";
        }
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        LOGGER.info((Object)("current log User: " + currentUser.getUserName()));
        return currentUser.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordOperationLog(SysOptLog sysOptLog) {
        ISysOptLog sysOptLogMgr = AdapterUtil.getSysOptLog();
        com.hs.lego.core.system.syslog.sdk.model.SysOptLog sysOptLogLego = new com.hs.lego.core.system.syslog.sdk.model.SysOptLog();
        sysOptLogLego.setDate(sysOptLog.getDate());
        sysOptLogLego.setDetail(sysOptLog.getDetail());
        sysOptLogLego.setDetailPara(sysOptLog.getDetailPara());
        if (2 == sysOptLog.getLevel()) {
            sysOptLogLego.setLevel(SysoplogLevel.warning.getValue());
        } else {
            sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        }
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation(sysOptLog.getOperation());
        sysOptLogLego.setOperator(sysOptLog.getOperator());
        if (0 == sysOptLog.getResult()) {
            sysOptLogLego.setResult(1);
        } else {
            sysOptLogLego.setResult(0);
        }
        sysOptLogLego.setTarget(sysOptLog.getTarget());
        sysOptLogLego.setTargetLocal(sysOptLog.getTargetLocal());
        String terminalIp = "127.0.0.1";
        try {
            terminalIp = ServletActionContext.getRequest().getRemoteAddr();
        }
        catch (Exception e) {
            LOGGER.error((Object)"execute Scheduled Task ServletActionContext is null", (Throwable)e);
        }
        finally {
            sysOptLogLego.setTerminalIp(terminalIp);
            if (null != sysOptLogMgr) {
                sysOptLogMgr.writeOptLog(sysOptLogLego);
            }
        }
    }

    public boolean isBusinessException(Exception e) {
        boolean flag = false;
        if (e instanceof LegoCheckedException) {
            flag = true;
        }
        return flag;
    }

    public void throwException(String message, String level, Throwable inThrowable) {
        LegoCheckedException legoExceptioin = (LegoCheckedException)inThrowable;
        throw new LegoCheckedException(legoExceptioin.getErrorCode());
    }

    public long getSessionId() {
        return CreateReportSessionId.getNextSessionId();
    }

    public UserInfo getUserInfo() {
        return new UserInfo("admin");
    }

    public long addBackTask(BackTask backTask, long reportSessionId) {
        return 0L;
    }

    public void notifyReport(String authId, int taskId, int conditionId, String reportInfo) {
        LOGGER.info((Object)("module VSM_ATICsendEmail. taskId:" + taskId + " conditionId:" + conditionId));
        SendEmailForm sendEmailForm = new SendEmailForm();
        sendEmailForm.setAuthId(authId);
        sendEmailForm.setTaskId(taskId);
        sendEmailForm.setConditionId(conditionId);
        sendEmailForm.setReportInfo(reportInfo);
        SendEmailQueue.add(sendEmailForm);
    }

    public String notifySendEmail(String[] addressees, String theme, String content, String attachments) {
        LOGGER.info((Object)"module VSM_ATIC reportQueryResult sendEmail.");
        LOGGER.info((Object)("theme:" + AdapterUtil.getcleanedMessage(theme)));
        LOGGER.info((Object)("content:" + AdapterUtil.getcleanedMessage(content)));
        LOGGER.info((Object)("attachments:" + AdapterUtil.getcleanedMessage(attachments)));
        String resultInfo = "success";
        StringBuffer addresseStr = new StringBuffer();
        for (int i = 0; i < addressees.length; ++i) {
            addresseStr.append(addressees[i]).append(';');
        }
        String resultStr = LocaleUtil.INSTANCE.getText("report.commom.sysLog.failure");
        Object[] email = new Object[]{addresseStr.toString()};
        resultStr = MessageFormat.format(resultStr, email);
        try {
            System.getProperties().setProperty("mail.mime.splitlongparameters", "false");
            JavaMailSenderImpl javaMail = new JavaMailSenderImpl();
            MimeMessage mailMessage = javaMail.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "GB2312");
            IRemoteNotifyServerService remoteNotifyServerService = AdapterUtil.getRemoteNotifyServerService();
            if (null == remoteNotifyServerService) {
                LOGGER.error((Object)"lego.err.570506");
                this.deleteReportFile(attachments);
                return LocaleUtil.INSTANCE.getText("lego.err.570506");
            }
            RemoteNotifyServer remoteNotifyServer = remoteNotifyServerService.getRemoteNotifyServer();
            if (null != remoteNotifyServer) {
                LOGGER.info((Object)("email config host:" + AdapterUtil.getcleanedMessage(remoteNotifyServer.getServer()) + " port:" + remoteNotifyServer.getPort()));
                javaMail.setHost(remoteNotifyServer.getServer());
                javaMail.setPort(Integer.parseInt(remoteNotifyServer.getPort()));
                Properties prop = new Properties();
                prop.setProperty("mail.smtp.timeout", "60000");
                if (remoteNotifyServer.isIsValidateEnable()) {
                    prop.setProperty("mail.smtp.auth", "true");
                    StringBuffer pvalue = DataProtectServiceConst.sdpDecryptLocalBuffer((String)remoteNotifyServer.getPassword());
                    javaMail.setUsername(remoteNotifyServer.getUserName());
                    javaMail.setPassword(pvalue == null ? "" : pvalue.toString());
                }
                javaMail.setJavaMailProperties(prop);
                messageHelper.setFrom(remoteNotifyServer.getEmailFrom());
                messageHelper.setSubject(theme);
                String emailSignature = remoteNotifyServer.getEmailSignature();
                messageHelper.setText("<html><head></head><body><h3>" + content + "</h3>" + this.getEmailSignature(emailSignature) + "</body></html>", true);
                FileSystemResource file = new FileSystemResource(new File(attachments));
                String filename = MimeUtility.encodeText((String)file.getFilename());
                filename = filename.replaceAll("\r", "").replaceAll("\n", "");
                messageHelper.addAttachment(filename, (InputStreamSource)file);
                if (addressees.length > 0) {
                    String[] mainAdd = addressees[0].split(";");
                    messageHelper.setTo(mainAdd);
                    if (addressees.length == 2) {
                        for (int k = mainAdd.length - 1; k >= 0; --k) {
                            addressees[1] = addressees[1].replaceAll(mainAdd[k], "");
                        }
                        String[] ccAdd = addressees[1].split(";");
                        if (ccAdd.length > 0 && !"".equals(ccAdd[0])) {
                            messageHelper.setCc(ccAdd);
                        }
                    }
                    try {
                        javaMail.send(mailMessage);
                    }
                    catch (Exception e) {
                        resultInfo = resultStr = MessageFormat.format(resultStr, Arrays.toString(mailMessage.getAllRecipients()));
                        LOGGER.error((Object)("sendMail email exception:" + e));
                    }
                }
            } else {
                resultInfo = LocaleUtil.INSTANCE.getText("report.commom.sysLog.failure");
            }
        }
        catch (MessagingException e) {
            resultInfo = resultStr;
            LOGGER.error((Object)("MessagingException error:" + (Object)((Object)e)));
        }
        catch (UnsupportedEncodingException e) {
            resultInfo = resultStr;
            LOGGER.error((Object)("UnsupportedEncodingException:" + e));
        }
        catch (Exception e) {
            resultInfo = resultStr;
            LOGGER.error((Object)("unknow Exception:" + e));
        }
        this.deleteReportFile(attachments);
        return resultInfo;
    }

    private String getEmailSignature(String emailSignature) {
        if (!AdapterUtil.isNull(emailSignature)) {
            String[] emailSignatureTeam = emailSignature.split("\n");
            StringBuilder boundary = new StringBuilder();
            for (int i = 0; i <= 60; ++i) {
                boundary.append('-');
            }
            StringBuilder temp = new StringBuilder(boundary.toString() + "<br><span style=\"font-size:12\">");
            for (int i = 0; i < emailSignatureTeam.length; ++i) {
                if (i == emailSignatureTeam.length - 1) {
                    temp.append(emailSignatureTeam[i] + "</span>");
                    return temp.toString();
                }
                temp.append(emailSignatureTeam[i] + "</span><br><span style=\"font-size:12\">");
            }
            return temp.toString();
        }
        return "";
    }

    private void deleteReportFile(String attachments) {
        int indexOther;
        int index = attachments.lastIndexOf("\\");
        int realIndex = index > (indexOther = attachments.lastIndexOf("/")) ? index : indexOther;
        String appPath = attachments.substring(0, realIndex);
        if (!this.delete(appPath)) {
            LOGGER.error((Object)"delete reportFile error!");
        }
    }

    public boolean delete(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            LOGGER.error((Object)("delete file failure:" + file.getName() + " not exist!"));
            return false;
        }
        if (file.isFile()) {
            return this.deleteFile(fileName);
        }
        return this.deleteDirectory(fileName);
    }

    public boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                LOGGER.info((Object)("delete file success:" + file.getName()));
                return true;
            }
            LOGGER.error((Object)("delete file failure:" + file.getName() + " not exist!"));
            return false;
        }
        LOGGER.error((Object)("delete file failure:" + file.getName() + " not exist!"));
        return false;
    }

    public boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            LOGGER.error((Object)"delete filedir failure, not exist!");
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        if (null != files) {
            try {
                for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = this.deleteFile(files[i].getCanonicalPath())) : files[i].isDirectory() && !(flag = this.deleteDirectory(files[i].getCanonicalPath()))); ++i) {
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"getCanonicalPath() throws IOException", (Throwable)e);
            }
        } else {
            LOGGER.error((Object)"getCanonicalPath() error, files is null.");
        }
        if (!flag) {
            LOGGER.error((Object)"delete fileDirectory failure:");
            return false;
        }
        if (dirFile.delete()) {
            LOGGER.info((Object)"delete fileDirectory success:");
            return true;
        }
        return false;
    }

    public Connection getProductDBConn() {
        LOGGER.info((Object)"start getProductDBConn");
        Connection conn = null;
        try {
            conn = AdapterUtil.getDbConnection2Report();
        }
        catch (Exception e) {
            LOGGER.error((Object)"getProductConn failed.", (Throwable)e);
        }
        LOGGER.info((Object)"end getProductDBConn");
        return conn;
    }
}

