/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.ireportadapter.util;

import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import com.hs.vsm.common.sdk.ireport.service.IReportEmailInfoService;
import com.hs.vsm.ireportadapter.util.LocaleUtil;
import com.security.ireport.connpool.DBPoolFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.xml.sax.SAXException;

public final class AdapterUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final String DB_PATH = "legoPlatInstalled.xml";
    private static Boolean checkReadDBFile = false;
    private static String driveClass = "";
    private static String url = "";
    private static String userName = "";
    private static String password = "";

    private AdapterUtil() {
    }

    public static ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            LOGGER.error((Object)"get sysLogService service error");
        }
        return null;
    }

    public static Connection getDbConnection2Report() {
        Connection conn = null;
        try {
            AdapterUtil.readDBFile();
            LOGGER.info((Object)("getDbConnection2Report url : " + url));
            if (null == DBPoolFactory.getInstance().getDBPool("VSM_DB_Connection")) {
                DBPoolFactory.getInstance().add("VSM_DB_Connection", driveClass, url, userName, password);
            }
            conn = DBPoolFactory.getInstance().getDBConnect("VSM_DB_Connection");
            LOGGER.info((Object)"end getDbConnection2Report");
            return conn;
        }
        catch (Exception e) {
            LOGGER.error((Object)"getDbConnection2Report error", (Throwable)e);
            return null;
        }
    }

    private static String getDBFilePath() {
        String installPathStr = ".";
        try {
            String calpath = new File(installPathStr).getCanonicalPath();
            String osName = System.getProperty("os.name");
            installPathStr = osName.equals("Linux") ? calpath.substring(0, calpath.lastIndexOf(File.separator + "components" + File.separator) + 1) : calpath.substring(0, calpath.lastIndexOf(File.separator + "Runtime" + File.separator) + 1);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException error", (Throwable)e);
        }
        boolean isSpLinux = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("/");
        boolean isSpWindows = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("\\");
        if (!isSpLinux && !isSpWindows) {
            installPathStr = installPathStr + File.separator;
        }
        String filePath = installPathStr + DB_PATH;
        return filePath;
    }

    private static void readXmlElement(List<Element> elementsList) {
        for (Element element : elementsList) {
            String keyString = element.elementText("string");
            if (keyString.equalsIgnoreCase("lego.db.driver")) {
                driveClass = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
            }
            if (keyString.equalsIgnoreCase("lego.db.url")) {
                url = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
                LOGGER.info((Object)("readXmlElement start url : " + url));
                if (null != url && url.contains("?")) {
                    String partOne = url.substring(0, url.indexOf("?"));
                    String partTwo = url.substring(url.indexOf("?") + 1, url.length());
                    url = partOne + "/lego?createDatabaseIfNotExist=true&autoReconnect=true&useUnicode=true&characterEncoding=utf-8";
                    url = url + "&" + partTwo;
                    LOGGER.info((Object)("readXmlElement [if] url : " + url));
                } else {
                    url = url + "/lego?createDatabaseIfNotExist=true&autoReconnect=true&useUnicode=true&characterEncoding=utf-8";
                    LOGGER.info((Object)("readXmlElement [else] url : " + url));
                }
            }
            if (keyString.equalsIgnoreCase("esight.db.nmsdbuser")) {
                userName = element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value");
            }
            if (!keyString.equalsIgnoreCase("esight.db.nmsdbpassword.encrypt")) continue;
            password = DataProtectServiceConst.sdpDecryptLocal((String)element.element("com.huawei.elog.base.model.ContextPropVal").elementText("value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readDBFile() {
        if (!checkReadDBFile.booleanValue()) {
            FileInputStream fileInputStream = null;
            try {
                File file = new File(AdapterUtil.getDBFilePath());
                fileInputStream = new FileInputStream(file);
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                String feature = "http://apache.org/xml/features/disallow-doctype-decl";
                dbf.setFeature(feature, true);
                dbf.setExpandEntityReferences(false);
                dbf.setXIncludeAware(false);
                dbf.setValidating(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = new DOMReader().read(db.parse(fileInputStream));
                if (null == document) {
                    LOGGER.error((Object)"document is null");
                    return;
                }
                Element root = document.getRootElement();
                List elementsList = root.element("propMap").elements("entry");
                if (null != elementsList && !elementsList.isEmpty()) {
                    AdapterUtil.readXmlElement(elementsList);
                }
                checkReadDBFile = true;
                LOGGER.info((Object)"read legoPlatInstalled success");
            }
            catch (SAXException e) {
                LOGGER.error((Object)"SAXException error");
            }
            catch (ParserConfigurationException e) {
                LOGGER.error((Object)"ParserConfigurationException error");
            }
            catch (IOException e) {
                LOGGER.error((Object)"IOException error");
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"fileInputStream.close() fail");
                    }
                }
            }
        }
    }

    public static IReportEmailInfoService getReportEmailInfoService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IReportEmailInfoService reportEmailInfoService = (IReportEmailInfoService)context.getService("reportEmailInfoService", IReportEmailInfoService.class);
            if (reportEmailInfoService != null) {
                return reportEmailInfoService;
            }
            LOGGER.error((Object)"get IReportEmailInfoService service error");
        }
        LOGGER.error((Object)"get IReportEmailInfoService service error");
        return null;
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static IRemoteNotifyServerService getRemoteNotifyServerService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)context.getService("remoteNotifyServerService", IRemoteNotifyServerService.class);
            if (remoteNotifyServerService != null) {
                return remoteNotifyServerService;
            }
            LOGGER.error((Object)"get getRemoteNotifyServerService service error");
        }
        LOGGER.error((Object)"get getRemoteNotifyServerService service error");
        return null;
    }

    public static IZoneService getZoneService() {
        IZoneService zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        if (zoneService == null) {
            LOGGER.error((Object)"get getZoneService service error");
        }
        return zoneService;
    }

    public static String getText(String i18n) {
        return LocaleUtil.INSTANCE.getText(i18n);
    }

    public static String getcleanedMessage(String message) {
        if (null == message) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

