/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.ireportadapter.util;

import com.hs.vsm.ireportadapter.util.AdapterUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Locale;

public final class LocaleUtil
implements LocaleProvider {
    public static final LocaleUtil INSTANCE = new LocaleUtil();
    private final transient TextProvider textProvider = new TextProviderFactory().createInstance(this.getClass(), (LocaleProvider)this);

    private LocaleUtil() {
    }

    public Locale getCurrentUserLocale() {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            locale = ActionContext.getContext().getLocale();
        }
        if (null == locale) {
            locale = this.getOSLanguage();
        }
        return locale;
    }

    public String getText(String textName) {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            return this.textProvider.getText(textName);
        }
        locale = this.getOSLanguage();
        String returnStr = this.getText(textName, locale);
        if (AdapterUtil.isNull(returnStr)) {
            returnStr = textName;
        }
        return returnStr;
    }

    public String getText(String aTextName, Locale locale) {
        return LocalizedTextUtil.findDefaultText((String)aTextName, (Locale)locale);
    }

    public String getText(String key, String[] args) {
        return this.textProvider.getText(key, args);
    }

    public Locale getLocale() {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            locale = ActionContext.getContext().getLocale();
        }
        if (null == locale) {
            locale = this.getOSLanguage();
        }
        return locale;
    }

    public Locale getOSLanguage() {
        Locale locale = null;
        String language = System.getProperty("user.language");
        locale = "zh".equalsIgnoreCase(language) ? new Locale("zh", "CN") : new Locale("en");
        return locale;
    }
}

