/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.neglobal.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.hs.vsm.neglobal.util.UpdateDeployState;
import com.hs.vsm.secservice.neglobal.common.CommonUtil;
import com.hs.vsm.secservice.neglobal.model.GloBlackListIpInfo;
import com.hs.vsm.secservice.neglobal.model.GloWhiteListIpInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;

public class GloBlackAndWhiteList
extends BaseAction {
    public static final int IP_AND_MASK = 0;
    public static final int IP_RANGE = 1;
    private static final long serialVersionUID = -8414047553472489336L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private GloBlackListIpForm gloBlackListIpForm;
    private GloBlackListForm gloBlackListForm;
    private List<GloBlackListIpForm> blackListIpFormList;
    private List<GloBlackListForm> zifList;
    private Long deviceId;
    private IGloBlackListService gloBlackListService;
    private IGloWhiteListService gloWhiteListService;
    private IAticDeviceService aticDeviceService;
    private Long pkid;
    private int[] pkids;
    private GloWhiteListIpForm gloWhiteListIpForm;
    private GloWhiteListForm gloWhiteListForm;
    private List<GloBlackListIpForm> whiteListIpFormList;
    private List<GloWhiteListForm> subList;
    private Long wid;

    public void saveBlackListIp() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.deviceId);
        BisUtil.checkUserSecurity(deviceList);
        this.gloBlackListIpForm.setDeviceId(this.deviceId);
        if (!this.checkBlackAndWhiteListService()) {
            this.responseResult("failure");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
            return;
        }
        String resultStr = "";
        List<GloWhiteListIpInfo> wIpList = this.gloWhiteListService.queryAllWhitelist(this.deviceId);
        List<GloBlackListIpInfo> bIpList = this.gloBlackListService.queryAllBlacklist(this.deviceId);
        int ipaddrs = 0;
        try {
            this.fillGloBlackListIpForm(this.gloBlackListIpForm);
            if (0 == this.gloBlackListIpForm.getMaskType()) {
                String[] srcIpRange = IPUtil.getSubnetRange((String)this.gloBlackListIpForm.getBlacklistIp(), (int)this.gloBlackListIpForm.getIntMask());
                if (null != wIpList && !wIpList.isEmpty() && null != (resultStr = this.checkIpInWhiteList(wIpList, srcIpRange))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
                    return;
                }
                if (null != bIpList && !bIpList.isEmpty() && null != (resultStr = this.checkWhiteIpInBlackList(bIpList, srcIpRange))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
                    return;
                }
                this.zifList = new ArrayList<GloBlackListForm>();
                this.gloBlackListForm = new GloBlackListForm();
                this.gloBlackListForm.setBlacklistIp(srcIpRange[0]);
                this.gloBlackListForm.setStartIp(srcIpRange[0]);
                this.gloBlackListForm.setEndIp(srcIpRange[1]);
                this.gloBlackListForm.setMask(this.gloBlackListIpForm.getIntMask());
                this.gloBlackListForm.setDeviceId(String.valueOf(this.deviceId));
                this.gloBlackListIpForm.setDeleteFlag(0);
                this.zifList.add(this.gloBlackListForm);
                this.gloBlackListIpForm.setGloBlackListForms(this.zifList);
            } else if (1 == this.gloBlackListIpForm.getMaskType()) {
                String[] networkSegment2 = new String[]{this.gloBlackListIpForm.getStartIp(), this.gloBlackListIpForm.getEndIp()};
                String[] networkSegment = IPUtil.getNetworkSegment((String)this.gloBlackListIpForm.getStartIp(), (String)this.gloBlackListIpForm.getEndIp());
                ipaddrs = networkSegment.length;
                if (null != wIpList && !wIpList.isEmpty() && null != (resultStr = this.checkIpInWhiteList(wIpList, networkSegment2))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
                    return;
                }
                if (null != bIpList && !bIpList.isEmpty() && null != (resultStr = this.checkWhiteIpInBlackList(bIpList, networkSegment2))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
                    return;
                }
                this.zifList = new ArrayList<GloBlackListForm>();
                for (String ipaddress : networkSegment) {
                    this.gloBlackListForm = new GloBlackListForm();
                    String[] ipMask = ipaddress.split("/");
                    this.gloBlackListForm.setBlacklistIp(ipMask[0]);
                    this.gloBlackListForm.setMask(Integer.valueOf(ipMask[1]));
                    if (this.gloBlackListForm.getMask() < 8) {
                        this.responseResult("ip range larger");
                        return;
                    }
                    this.gloBlackListForm.setDeviceId(String.valueOf(this.deviceId));
                    this.gloBlackListIpForm.setDeleteFlag(0);
                    this.zifList.add(this.gloBlackListForm);
                }
                this.gloBlackListIpForm.setGloBlackListForms(this.zifList);
            }
            int blistNums = this.gloBlackListService.queryAllBlackCount(this.deviceId);
            int wlistNums = this.gloWhiteListService.queryAllWhiteCount(this.deviceId);
            if (blistNums + wlistNums + ipaddrs >= 40960) {
                this.responseResult("toMuch");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
                return;
            }
            String deviceName = this.getDeviceName(this.deviceId);
            String[] detailPara = null;
            detailPara = this.gloBlackListIpForm.getMaskType() == 1 ? new String[]{this.gloBlackListIpForm.getStartIp() + "-" + this.gloBlackListIpForm.getEndIp()} : new String[]{this.gloBlackListIpForm.getBlacklistIp() + "/" + this.gloBlackListIpForm.getIntMask()};
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add", detailPara);
            this.logger.info((Object)("add newIpBlackList : " + this.getcleanedMessage(this.gloBlackListIpForm.getBlacklistIp()) + " successfully"));
            this.gloBlackListService.saveBlackListIp(this.gloBlackListIpForm);
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.blacklist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.add.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        UpdateDeployState.setDeployBlistState(String.valueOf(this.deviceId));
        this.responseResult("success");
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkBlackIpAndMask() {
        boolean maskResult;
        if (null == this.gloBlackListIpForm) {
            return false;
        }
        if (this.gloBlackListIpForm.getMaskType() == 0) {
            if (null == this.gloBlackListIpForm.getIntMask()) {
                return false;
            }
            this.gloBlackListIpForm.setBlacklistIp(this.gloBlackListIpForm.getBlacklistIp().trim());
            String ip = this.gloBlackListIpForm.getBlacklistIp();
            if (IPUtil.isIpv4((String)ip)) {
                if (this.gloBlackListIpForm.getIntMask() < 8) return false;
                if (this.gloBlackListIpForm.getIntMask() <= 32) return true;
                return false;
            }
            if (!IPUtil.isIpv6((String)ip)) return false;
            if (this.gloBlackListIpForm.getIntMask() < 8) return false;
            if (this.gloBlackListIpForm.getIntMask() <= 128) return true;
            return false;
        }
        if (this.gloBlackListIpForm.getMaskType() != 1) return false;
        this.gloBlackListIpForm.setStartIp(this.gloBlackListIpForm.getStartIp().trim());
        this.gloBlackListIpForm.setEndIp(this.gloBlackListIpForm.getEndIp().trim());
        if (!IPUtil.isIpv4((String)this.gloBlackListIpForm.getStartIp()) || !IPUtil.isIpv4((String)this.gloBlackListIpForm.getEndIp())) {
            if (!IPUtil.isIpv6((String)this.gloBlackListIpForm.getStartIp())) return false;
            if (!IPUtil.isIpv6((String)this.gloBlackListIpForm.getEndIp())) {
                return false;
            }
        }
        boolean bl = maskResult = false;
        if (maskResult) {
            return false;
        }
        if (IPUtil.compareTo((String)this.gloBlackListIpForm.getStartIp(), (String)this.gloBlackListIpForm.getEndIp()) != 1) return true;
        return false;
    }

    private String getDeviceName(Long deviceID) {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.deviceId);
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = null;
        if (null != this.aticDeviceService) {
            aticDevice = this.aticDeviceService.getDeviceByMoid(deviceID.longValue());
        }
        if (null != aticDevice) {
            return aticDevice.getName();
        }
        return null;
    }

    private void fillGloBlackListIpForm(GloBlackListIpForm form) {
        if (form != null && form.getMaskType() == 0) {
            int mask = form.getIntMask();
            String startIp = CommonUtil.getMaskStartIp(form.getBlacklistIp(), mask);
            String endIp = CommonUtil.getMaskEndIp(form.getBlacklistIp(), mask);
            form.setStartIp(startIp);
            form.setEndIp(endIp);
        } else if (null != form) {
            form.setIntMask(1);
        }
    }

    public void deleteBlackListIp() {
        this.gloBlackListIpForm = this.gloBlackListService.findByIpListId(this.pkid);
        String deviceName = this.getDeviceName(this.deviceId);
        String[] detailPara = null;
        if (null == this.gloBlackListIpForm) {
            return;
        }
        detailPara = this.gloBlackListIpForm.getMaskType() == 1 ? new String[]{this.gloBlackListIpForm.getStartIp() + "-" + this.gloBlackListIpForm.getEndIp()} : new String[]{this.gloBlackListIpForm.getBlacklistIp() + "/" + this.gloBlackListIpForm.getIntMask()};
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.blacklist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del", detailPara);
        this.gloBlackListService.deleteBlackListIp(this.getPkid());
        this.responseResult("success");
        UpdateDeployState.setDeployBlistState(String.valueOf(this.deviceId));
    }

    public boolean validatePkids() {
        if (null == this.pkids) {
            return false;
        }
        for (int testPkid : this.pkids) {
            if (testPkid >= 0) continue;
            return false;
        }
        return true;
    }

    public void deleteBathBlackListIp() {
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.blacklist", "lego.dic.module.neGlobalApp");
        String deviceName = this.getDeviceName(this.deviceId);
        if (null != this.gloBlackListService) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < this.getPkids().length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId((long)this.pkids[i]);
                bo.setTargetName(deviceName);
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.gloBlackListService.batchDelGloBlackList2(batchOpList);
            StringBuffer names = new StringBuffer();
            for (BatchOperation bo : this.batchOperationResult.getResult()) {
                names.append(bo.getTargetName()).append(',');
            }
            this.logger.info((Object)("delete ipBlackList : " + this.getcleanedMessage(names.toString())));
        }
        this.bathResult(this.batchOperationResult);
        UpdateDeployState.setDeployBlistState(String.valueOf(this.deviceId));
    }

    public void deleteAllBlackListIp() {
        String deviceName = this.getDeviceName(this.deviceId);
        if (null == deviceName || null == this.gloBlackListService) {
            this.logger.error((Object)"get aticDeviceService or gloBlackListService is error");
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.allblacklist", "lego.dic.module.neGlobalApp", deviceName, true, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del.allblacklist", null);
            throw new LegoCheckedException(570506L);
        }
        try {
            this.gloBlackListService.batchDelAllGloBlackList2(String.valueOf(this.deviceId));
        }
        catch (Exception e) {
            this.logger.error((Object)"delete all blacklist is failed");
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.allblacklist", "lego.dic.module.neGlobalApp", deviceName, true, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del.allblacklist", null);
            throw new LegoCheckedException(731047L, (Throwable)e);
        }
        this.logger.info((Object)("delete AllIpBlackList by Device: " + deviceName));
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.allblacklist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.oplog.del.allblacklist", new String[]{deviceName});
        this.responseResult("success");
        UpdateDeployState.setDeployBlistState(String.valueOf(this.deviceId));
    }

    public void deleteAllWhiteListIp() {
        String deviceName = this.getDeviceName(this.deviceId);
        if (null == deviceName || null == this.gloWhiteListService) {
            this.logger.error((Object)"get aticDeviceService or gloWhiteListService is error");
            throw new LegoCheckedException(570506L);
        }
        try {
            this.gloWhiteListService.batchDelAllGloWhiteList2(String.valueOf(this.deviceId));
        }
        catch (Exception e) {
            this.logger.error((Object)"delete all whitelist is failed");
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.allwhitelist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.del.allwhitelist", null);
            throw new LegoCheckedException(731048L, (Throwable)e);
        }
        this.logger.info((Object)("delete AllIpWhiteList by Device: " + deviceName));
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.allwhitelist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.del.allwhitelist", new String[]{deviceName});
        this.responseResult("success");
        UpdateDeployState.setDeployBypassState(String.valueOf(this.deviceId));
    }

    public void saveWhiteListIp() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(this.deviceId);
        BisUtil.checkUserSecurity(deviceList);
        this.gloWhiteListIpForm.setDeviceId(this.deviceId);
        if (!this.checkBlackAndWhiteListService()) {
            this.responseResult("failure");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
            return;
        }
        String resultStr = "";
        List<GloBlackListIpInfo> bIpList = this.gloBlackListService.queryAllBlacklist(this.deviceId);
        List<GloWhiteListIpInfo> wIpList = this.gloWhiteListService.queryAllWhitelist(this.deviceId);
        int ipaddrs = 0;
        try {
            this.fillGloWhiteListIpForm(this.gloWhiteListIpForm);
            if (0 == this.gloWhiteListIpForm.getMaskType()) {
                String[] subNetRange = IPUtil.getSubnetRange((String)this.gloWhiteListIpForm.getWhitelistIp(), (int)this.gloWhiteListIpForm.getIntMask());
                if (null != bIpList && !bIpList.isEmpty() && null != (resultStr = this.checkWhiteIpInBlackList(bIpList, subNetRange))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
                    return;
                }
                if (null != wIpList && !wIpList.isEmpty() && null != (resultStr = this.checkIpInWhiteList(wIpList, subNetRange))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
                    return;
                }
                this.subList = new ArrayList<GloWhiteListForm>();
                this.gloWhiteListForm = new GloWhiteListForm();
                this.gloWhiteListForm.setWhitelistIp(subNetRange[0]);
                this.gloWhiteListForm.setStartIp(subNetRange[0]);
                this.gloWhiteListForm.setEndIp(subNetRange[1]);
                this.gloWhiteListForm.setMask(this.gloWhiteListIpForm.getIntMask());
                this.gloWhiteListForm.setDeviceId(String.valueOf(this.deviceId));
                this.subList.add(this.gloWhiteListForm);
                this.gloWhiteListIpForm.setGloWhiteListForms(this.subList);
            } else if (1 == this.gloWhiteListIpForm.getMaskType()) {
                String[] networkSegment2 = new String[]{this.gloWhiteListIpForm.getStartIp(), this.gloWhiteListIpForm.getEndIp()};
                String[] networkSegment = IPUtil.getNetworkSegment((String)this.gloWhiteListIpForm.getStartIp(), (String)this.gloWhiteListIpForm.getEndIp());
                ipaddrs = networkSegment.length;
                if (null != bIpList && !bIpList.isEmpty() && null != (resultStr = this.checkWhiteIpInBlackList(bIpList, networkSegment2))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
                    return;
                }
                if (null != wIpList && !wIpList.isEmpty() && null != (resultStr = this.checkIpInWhiteList(wIpList, networkSegment2))) {
                    this.responseResult(resultStr);
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
                    return;
                }
                this.subList = new ArrayList<GloWhiteListForm>();
                for (String ipaddress : networkSegment) {
                    this.gloWhiteListForm = new GloWhiteListForm();
                    String[] ipMask = ipaddress.split("/");
                    this.gloWhiteListForm.setWhitelistIp(ipMask[0]);
                    this.gloWhiteListForm.setMask(Integer.valueOf(ipMask[1]));
                    if (this.gloWhiteListForm.getMask() < 8) {
                        this.responseResult("ip range larger");
                        return;
                    }
                    this.gloWhiteListForm.setDeviceId(String.valueOf(this.deviceId));
                    this.subList.add(this.gloWhiteListForm);
                }
                this.gloWhiteListIpForm.setGloWhiteListForms(this.subList);
            }
            int blistNums = this.gloBlackListService.queryAllBlackCount(this.deviceId);
            int wlistNums = this.gloWhiteListService.queryAllWhiteCount(this.deviceId);
            if (blistNums + wlistNums + ipaddrs >= 40960) {
                this.responseResult("toMuch");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
                return;
            }
            String deviceName = this.getDeviceName(this.deviceId);
            String[] detailPara = null;
            detailPara = this.gloWhiteListIpForm.getMaskType() == 1 ? new String[]{this.gloWhiteListIpForm.getStartIp() + "-" + this.gloWhiteListIpForm.getEndIp()} : new String[]{this.gloWhiteListIpForm.getWhitelistIp() + "/" + this.gloWhiteListIpForm.getIntMask()};
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add", detailPara);
            this.logger.info((Object)("add newIpWhiteList : " + this.getcleanedMessage(this.gloWhiteListIpForm.getWhitelistIp()) + " successfully"));
            this.gloWhiteListService.saveWhiteListIp(this.gloWhiteListIpForm);
        }
        catch (Exception e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.button.create.whitelist", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.add.failed", null);
            this.logger.error((Object)e.getMessage());
        }
        UpdateDeployState.setDeployBypassState(String.valueOf(this.deviceId));
        this.responseResult("success");
    }

    private boolean checkBlackAndWhiteListService() {
        if (null == this.gloBlackListService) {
            this.responseResult("failure");
        }
        if (null == this.gloWhiteListService) {
            this.responseResult("failure");
        }
        return true;
    }

    private String checkIpInWhiteList(List<GloWhiteListIpInfo> wIpList, String[] subNetRange) {
        for (GloWhiteListIpInfo gloListIpInfo : wIpList) {
            String[] subNetRange2;
            String[] destNetRange;
            if (!(gloListIpInfo.getMaskType() == 0 ? IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getWhitelistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange) : gloListIpInfo.getMaskType() == 1 && IPUtil4Atic.isCrossIpRange((String[])(subNetRange2 = new String[]{gloListIpInfo.getStartIp(), gloListIpInfo.getEndIp()}), (String[])subNetRange))) continue;
            return "exist in whitelist";
        }
        return null;
    }

    private String checkWhiteIpInBlackList(List<GloBlackListIpInfo> bIpList, String[] subNetRange) {
        for (GloBlackListIpInfo gloListIpInfo : bIpList) {
            String[] subNetRange2;
            String[] destNetRange;
            if (!(gloListIpInfo.getMaskType() == 0 ? IPUtil4Atic.isCrossIpRange((String[])(destNetRange = IPUtil.getSubnetRange((String)gloListIpInfo.getBlacklistIp(), (int)gloListIpInfo.getIntMask())), (String[])subNetRange) : gloListIpInfo.getMaskType() == 1 && IPUtil4Atic.isCrossIpRange((String[])(subNetRange2 = new String[]{gloListIpInfo.getStartIp(), gloListIpInfo.getEndIp()}), (String[])subNetRange))) continue;
            return "exist in blacklist";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkWhiteIpAndMask() {
        boolean maskResult;
        if (this.gloWhiteListIpForm.getMaskType() == 0) {
            if (null == this.gloWhiteListIpForm.getIntMask()) {
                return false;
            }
            this.gloWhiteListIpForm.setWhitelistIp(this.gloWhiteListIpForm.getWhitelistIp().trim());
            String ip = this.gloWhiteListIpForm.getWhitelistIp();
            if (IPUtil.isIpv4((String)ip)) {
                if (this.gloWhiteListIpForm.getIntMask() < 8) return false;
                if (this.gloWhiteListIpForm.getIntMask() <= 32) return true;
                return false;
            }
            if (!IPUtil.isIpv6((String)ip)) return false;
            if (this.gloWhiteListIpForm.getIntMask() < 8) return false;
            if (this.gloWhiteListIpForm.getIntMask() <= 128) return true;
            return false;
        }
        if (this.gloWhiteListIpForm.getMaskType() != 1) return false;
        this.gloWhiteListIpForm.setStartIp(this.gloWhiteListIpForm.getStartIp().trim());
        this.gloWhiteListIpForm.setEndIp(this.gloWhiteListIpForm.getEndIp().trim());
        if (!IPUtil.isIpv4((String)this.gloWhiteListIpForm.getStartIp()) || !IPUtil.isIpv4((String)this.gloWhiteListIpForm.getEndIp())) {
            if (!IPUtil.isIpv6((String)this.gloWhiteListIpForm.getStartIp())) return false;
            if (!IPUtil.isIpv6((String)this.gloWhiteListIpForm.getEndIp())) {
                return false;
            }
        }
        boolean bl = maskResult = false;
        if (maskResult) {
            return false;
        }
        if (IPUtil.compareTo((String)this.gloWhiteListIpForm.getStartIp(), (String)this.gloWhiteListIpForm.getEndIp()) != 1) return true;
        return false;
    }

    private void fillGloWhiteListIpForm(GloWhiteListIpForm form) {
        if (form != null && form.getMaskType() == 0) {
            int mask = form.getIntMask();
            String startIp = CommonUtil.getMaskStartIp(form.getWhitelistIp(), mask);
            String endIp = CommonUtil.getMaskEndIp(form.getWhitelistIp(), mask);
            form.setStartIp(startIp);
            form.setEndIp(endIp);
        } else if (null != form) {
            form.setIntMask(1);
        }
    }

    public void deleteWhiteListIp() {
        this.gloWhiteListIpForm = this.gloWhiteListService.findByIpListId(this.pkid);
        String deviceName = this.getDeviceName(this.deviceId);
        String[] detailPara = null;
        if (null == this.gloWhiteListIpForm) {
            return;
        }
        detailPara = this.gloWhiteListIpForm.getMaskType() == 1 ? new String[]{this.gloWhiteListIpForm.getStartIp() + "-" + this.gloWhiteListIpForm.getEndIp()} : new String[]{this.gloWhiteListIpForm.getWhitelistIp() + "/" + this.gloWhiteListIpForm.getIntMask()};
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.whitelist", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.oplog.del", detailPara);
        this.gloWhiteListService.deleteWhiteListIp(this.pkid);
        this.responseResult("success");
        UpdateDeployState.setDeployBypassState(String.valueOf(this.deviceId));
    }

    public void deleteBathWhiteListIp() {
        this.getOperateLog().info("com.hs.vsm.secservice.neglobal.button.delete.whitelist", "lego.dic.module.neGlobalApp");
        String deviceName = this.getDeviceName(this.deviceId);
        if (null != this.gloWhiteListService) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < this.getPkids().length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId((long)this.pkids[i]);
                bo.setTargetName(deviceName);
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.gloWhiteListService.batchDelGloWhiteList2(batchOpList);
            StringBuffer names = new StringBuffer();
            for (BatchOperation bo : this.batchOperationResult.getResult()) {
                names.append(bo.getTargetName()).append(',');
            }
            this.logger.info((Object)("delete ipWhiteList : " + this.getcleanedMessage(names.toString())));
        }
        this.bathResult(this.batchOperationResult);
        UpdateDeployState.setDeployBypassState(String.valueOf(this.deviceId));
    }

    public GloBlackListIpForm getGloBlackListIpForm() {
        return this.gloBlackListIpForm;
    }

    public void setGloBlackListIpForm(GloBlackListIpForm gloBlackListIpForm) {
        this.gloBlackListIpForm = gloBlackListIpForm;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public GloBlackListForm getGloBlackListForm() {
        return this.gloBlackListForm;
    }

    public void setGloBlackListForm(GloBlackListForm gloBlackListForm) {
        this.gloBlackListForm = gloBlackListForm;
    }

    public List<GloBlackListIpForm> getBlackListIpFormList() {
        return this.blackListIpFormList;
    }

    public void setBlackListIpFormList(List<GloBlackListIpForm> blackListIpFormList) {
        this.blackListIpFormList = blackListIpFormList;
    }

    public IGloBlackListService getGloBlackListService() {
        return this.gloBlackListService;
    }

    public void setGloBlackListService(IGloBlackListService gloBlackListService) {
        this.gloBlackListService = gloBlackListService;
    }

    public List<GloBlackListForm> getZifList() {
        return this.zifList;
    }

    public void setZifList(List<GloBlackListForm> zifList) {
        this.zifList = zifList;
    }

    public Long getPkid() {
        return this.pkid;
    }

    public void setPkid(Long pkid) {
        this.pkid = pkid;
    }

    public int[] getPkids() {
        if (null != this.pkids) {
            return (int[])this.pkids.clone();
        }
        return new int[0];
    }

    public void setPkids(int[] pkids) {
        this.pkids = (int[])(null != pkids ? (int[])pkids.clone() : null);
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public GloWhiteListIpForm getGloWhiteListIpForm() {
        return this.gloWhiteListIpForm;
    }

    public void setGloWhiteListIpForm(GloWhiteListIpForm gloWhiteListIpForm) {
        this.gloWhiteListIpForm = gloWhiteListIpForm;
    }

    public GloWhiteListForm getGloWhiteListForm() {
        return this.gloWhiteListForm;
    }

    public void setGloWhiteListForm(GloWhiteListForm gloWhiteListForm) {
        this.gloWhiteListForm = gloWhiteListForm;
    }

    public List<GloBlackListIpForm> getWhiteListIpFormList() {
        return this.whiteListIpFormList;
    }

    public void setWhiteListIpFormList(List<GloBlackListIpForm> whiteListIpFormList) {
        this.whiteListIpFormList = whiteListIpFormList;
    }

    public List<GloWhiteListForm> getSubList() {
        return this.subList;
    }

    public void setSubList(List<GloWhiteListForm> subList) {
        this.subList = subList;
    }

    public static long getSerialVersionUID() {
        return -8414047553472489336L;
    }

    public Long getWid() {
        return this.wid;
    }

    public void setWid(Long wid) {
        this.wid = wid;
    }
}

