/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.neglobal.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.BaseCommonUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.service.SysOptLogImpl;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.neglobal.action.ExportThread;
import com.hs.vsm.neglobal.util.UpdateDeployState;
import com.hs.vsm.secservice.ddos.policy.util.CSVReader;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.ddos.service.ZoneServiceServiceImpl;
import com.hs.vsm.secservice.ddos.util.PropertyNeglobalUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.module.ddos.form.ExportZoneConditionForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloCdnIpListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.AticInstallUtil;
import com.huawei.atic.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class ImportAndExportAction
extends BaseAction {
    public static final String EXPORT = "atic.bis.policy.exportZone";
    private static final long serialVersionUID = 2212426292223304616L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private IGloBlackListService gloBlackListService;
    private IGloWhiteListService gloWhiteListService;
    private IGloDomainWhiteListService gloDomainWhiteListService;
    private IGloCdnIpListService gloCdnIpListService;
    private IAticDeviceService aticDeviceService;
    private String deviceId;
    private String domainFileName;
    private String domainListFileName;
    private String fileName;
    private String iplistFileName;
    private String downFileName;
    private String idStr;
    private String domainIds;
    private int zoneCount;
    private String deviceIp;
    private Integer startNum;
    private Integer endNum;
    private String dimension;
    private String exportContentStr;
    private Long progressBarId;
    private List<LangPair> selectExportContentByDeviceList;
    private boolean superSize;

    public String showImportBlackList() {
        this.logger.info((Object)"prepare to import blacklist info.");
        if (this.deviceId.contains(",")) {
            String[] deviceIdTemp = this.deviceId.split(",");
            this.deviceId = deviceIdTemp[0];
        }
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.deviceId.trim()));
        BisUtil.checkUserSecurity(deviceList);
        if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
            return "newImport";
        }
        return "success";
    }

    public String showImportCdnIpList() {
        this.logger.info((Object)"prepare to import cdnIpList info.");
        if (this.deviceId.contains(",")) {
            String[] deviceIdTemp = this.deviceId.split(",");
            this.deviceId = deviceIdTemp[0];
        }
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.deviceId.trim()));
        BisUtil.checkUserSecurity(deviceList);
        return "success";
    }

    private boolean checkFileNameAndSize() {
        int iLast;
        String ipDomainFileNameTemp = this.iplistFileName.trim();
        String logoType = ipDomainFileNameTemp.substring((iLast = ipDomainFileNameTemp.lastIndexOf(".")) + 1, ipDomainFileNameTemp.length());
        if (!"csv".equalsIgnoreCase(logoType)) {
            this.responseResult(this.getText("com.hs.vsm.secservice.neglobal.import.fileType.tip.csv"));
            return false;
        }
        File csvFile = new File(this.fileName);
        if (csvFile.exists() && csvFile.length() > 0x100000L) {
            this.responseResult(this.getText("atic.ip.domain.title.import.fileTooBig"));
            return false;
        }
        return true;
    }

    private boolean checkDomainFileNameAndSize() {
        int iLast;
        String ipDomainFileNameTemp = this.domainListFileName.trim();
        String logoType = ipDomainFileNameTemp.substring((iLast = ipDomainFileNameTemp.lastIndexOf(".")) + 1, ipDomainFileNameTemp.length());
        if (!"csv".equalsIgnoreCase(logoType)) {
            this.responseResult(this.getText("com.hs.vsm.secservice.neglobal.import.fileType.tip.csv"));
            return false;
        }
        File csvFile = new File(this.domainFileName);
        if (csvFile.exists() && csvFile.length() > 0x100000L) {
            this.responseResult(this.getText("atic.ip.domain.title.import.fileTooBig"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCdnIpList() {
        if (Locker.getInstance().isImportProxyIpFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportProxyIpFlag(true);
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        try {
            if (!this.checkFileNameAndSize()) {
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.failed", null);
                return;
            }
            CSVReader reader = new CSVReader(this.fileName);
            List cdnIplist = reader.getList();
            if (cdnIplist.size() - 1 > 256) {
                this.responseResult("importToMuch");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.failed", null);
                return;
            }
            int i = 0;
            for (String line : cdnIplist) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                BatchOperation bo = new BatchOperation();
                if (line == null || "".equals(line)) continue;
                bo.setOptDetail(line);
                batchOpList.add(bo);
            }
            reader.csvClose();
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            if (this.gloCdnIpListService.queryCountCdnIpByDeviceId(Long.valueOf(this.deviceId)) + batchOpList.size() > 256) {
                this.responseResult("exceedMaxValue");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.failed", null);
                return;
            }
            this.batchOperationResult = this.gloCdnIpListService.importSaveCdnIpList(batchOpList, this.deviceId);
            Locker.getInstance().setImportProxyIpFlag(false);
            String moduleName = "com.hs.vsm.secservice.neglobal.proxyIpList.title.import";
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
            String deviceName = aticDevice.getName();
            String detail = "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.success";
            String[] detailPara = new String[]{String.valueOf(this.batchOperationResult.getSucceedCount()), String.valueOf(this.batchOperationResult.getFailCount())};
            this.optImportStaticBWlist(this.batchOperationResult, moduleName, deviceName, detail, detailPara);
            this.bathResult(this.batchOperationResult);
        }
        catch (IOException e) {
            Locker.getInstance().setImportProxyIpFlag(false);
            this.logger.error((Object)"import proxyIpList is error");
            this.responseResult(e.toString());
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.import.oplog.failed", null);
            return;
        }
        finally {
            UpdateDeployState.setDeployCdnIplistState(this.deviceId);
            Locker.getInstance().setImportProxyIpFlag(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBlackList() {
        if (Locker.getInstance().isImportBlackAndWhiteFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportBlackAndWhiteFlag(true);
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        try {
            if (!this.checkFileNameAndSize()) {
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
                return;
            }
            CSVReader reader = new CSVReader(this.fileName);
            List ipBlacklistIps = reader.getList();
            if (ipBlacklistIps.size() - 1 > 1000) {
                this.responseResult("importToMuch");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
                return;
            }
            int i = 0;
            for (String line : ipBlacklistIps) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                BatchOperation bo = new BatchOperation();
                if (line == null || "".equals(line)) continue;
                bo.setOptDetail(line);
                batchOpList.add(bo);
            }
            reader.csvClose();
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
                if (this.getAllBlackAndWhiteNum() + batchOpList.size() > 40960) {
                    this.responseResult("exceedMaxValue");
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
                    return;
                }
                this.batchOperationResult = this.gloBlackListService.importSaveNewBlackList(batchOpList, this.deviceId);
            } else {
                if (this.getAllBlackAndWhiteNum() + batchOpList.size() > 20000) {
                    this.responseResult("exceedMaxValueForV1R1");
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
                    return;
                }
                this.batchOperationResult = this.gloBlackListService.saveBlackList(batchOpList, this.deviceId);
            }
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
            String moduleName = "com.hs.vsm.secservice.neglobal.blacklist.title.import";
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
            String deviceName = aticDevice.getName();
            String detail = "com.hs.vsm.secservice.neglobal.blacklist.ip.import.oplog.success";
            String[] detailPara = new String[]{String.valueOf(this.batchOperationResult.getSucceedCount()), String.valueOf(this.batchOperationResult.getFailCount())};
            this.optImportStaticBWlist(this.batchOperationResult, moduleName, deviceName, detail, detailPara);
            this.bathResult(this.batchOperationResult);
        }
        catch (IOException e) {
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
            this.logger.error((Object)"import blacklist is error");
            this.responseResult(e.toString());
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
            return;
        }
        finally {
            UpdateDeployState.setDeployBlistState(this.deviceId);
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
        }
    }

    private int getDomainWhiteNum() {
        int blistNums = this.gloDomainWhiteListService.queryAllWhiteCount(Long.valueOf(this.deviceId));
        return blistNums;
    }

    private int getAllBlackAndWhiteNum() {
        int blistNums = this.gloBlackListService.queryAllBlackCount(Long.valueOf(this.deviceId));
        int wlistNums = this.gloWhiteListService.queryAllWhiteCount(Long.valueOf(this.deviceId));
        return blistNums + wlistNums;
    }

    private void optImportStaticBWlist(BatchOperationResult batchOperationResult, String moduleName, String deviceName, String detail, String[] detailPara) {
        SysOptLog sysOptLog = new SysOptLog();
        sysOptLog.setOperation(moduleName);
        sysOptLog.setModule("lego.dic.module.neGlobalApp");
        sysOptLog.setLevel(SysoplogLevel.normal.getValue());
        sysOptLog.setResult(batchOperationResult.getFailCount() == 0 ? 1 : 0);
        sysOptLog.setTarget(deviceName);
        sysOptLog.setDetail(detail);
        sysOptLog.setDetailPara(detailPara);
        User user = (User)this.getSession().getAttribute("currentUser");
        sysOptLog.setOperator(user.getUserName());
        sysOptLog.setTerminalIp(this.fetchRequest().getRemoteAddr());
        sysOptLog.setDate(new Date());
        ISysOptLog service = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        service.writeOptLog(sysOptLog);
    }

    public void exportCdnIpList() {
        if (Locker.getInstance().isImportProxyIpFlag()) {
            this.responseResult("571990");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.export.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportProxyIpFlag(true);
        try {
            String exportFilePath = "";
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.deviceId.trim()));
            BisUtil.checkUserSecurity(deviceList);
            exportFilePath = this.initExportFile("proxyIpList");
            List<GloCdnIpListForm> newList = this.getCdnIpList();
            this.writeCdnIpListToExportFile(newList, exportFilePath);
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? exportFilePath.split("/") : exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.export", "lego.dic.module.neGlobalApp", null, true, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.export.oplog.success", null);
        }
        catch (IOException e) {
            Locker.getInstance().setImportProxyIpFlag(false);
            this.logger.error((Object)"export proxyIpList error : ", (Throwable)e);
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.proxyIpList.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.proxyIpList.ip.export.oplog.failed", null);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        finally {
            Locker.getInstance().setImportProxyIpFlag(false);
        }
    }

    public void exportIpBlackList() {
        if (Locker.getInstance().isImportBlackAndWhiteFlag()) {
            this.responseResult("571990");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportBlackAndWhiteFlag(true);
        try {
            String exportFilePath = "";
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.deviceId.trim()));
            BisUtil.checkUserSecurity(deviceList);
            if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
                exportFilePath = this.initExportFile("newIpblacklist");
                List<GloBlackListIpForm> newList = this.getNewExportBlackList();
                this.writeNewIpBlacklistToExportFile(newList, exportFilePath);
            } else {
                exportFilePath = this.initExportFile("ipblacklist");
                List<GloBlackListForm> gloList = this.getExportBlackList();
                this.writeIpBlacklistToExportFile(gloList, exportFilePath);
            }
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? exportFilePath.split("/") : exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (IOException e) {
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
            this.logger.error((Object)"export IpBlacklist error : ", (Throwable)e);
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.blacklist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.blacklist.ip.export.oplog.failed", null);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        finally {
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
        }
    }

    private List<GloBlackListForm> getExportBlackList() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        List<GloBlackListForm> blacklistForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                blacklistForms = this.gloBlackListService.getByIds(this.idStr);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.select.success", null);
            this.logger.info((Object)("export IpBlacklist to memory, the export-IpBlacklist : " + this.getcleanedMessage(this.idStr)));
        } else {
            blacklistForms = this.gloBlackListService.queryByPage(this.createBlackQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.all.success", null);
            this.logger.info((Object)"export IpBlacklist to memory, the export-IpBlacklist : all");
        }
        return blacklistForms;
    }

    private List<GloCdnIpListForm> getCdnIpList() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        List<GloCdnIpListForm> gCdnIpListForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                gCdnIpListForms = this.gloCdnIpListService.getByIdList(this.idStr);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.select.success", null);
            this.logger.info((Object)("export IpBlacklist to memory, the export-IpBlacklist : " + this.getcleanedMessage(this.idStr)));
        } else {
            gCdnIpListForms = this.gloCdnIpListService.queryByPage(this.createCdnIpQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.all.success", null);
            this.logger.info((Object)"export IpBlacklist to memory, the export-IpBlacklist : all");
        }
        return gCdnIpListForms;
    }

    private List<GloBlackListIpForm> getNewExportBlackList() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        List<GloBlackListIpForm> blacklistForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                blacklistForms = this.gloBlackListService.getByIdList(this.idStr);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.select.success", null);
            this.logger.info((Object)("export IpBlacklist to memory, the export-IpBlacklist : " + this.getcleanedMessage(this.idStr)));
        } else {
            blacklistForms = this.gloBlackListService.queryByPageNew(this.createBlackQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.blacklist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.blacklist.export.all.success", null);
            this.logger.info((Object)"export IpBlacklist to memory, the export-IpBlacklist : all");
        }
        return blacklistForms;
    }

    private Map<String, String> createCdnIpQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("deviceId", this.deviceId);
        queryMap.put("ipAddress", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private Map<String, String> createBlackQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("deviceId", this.deviceId);
        queryMap.put("blacklistIp", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private void closeInStream(CSVReader inStream) {
        if (null != inStream) {
            try {
                inStream.csvClose();
            }
            catch (IOException e) {
                this.logger.error((Object)"close inputStream error", (Throwable)e);
            }
            finally {
                inStream = null;
            }
        }
    }

    private void closeOutStream(BufferedWriter outStream) {
        if (null != outStream) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"close outStream error", (Throwable)e);
            }
            finally {
                outStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIpBlacklistToExportFile(List<GloBlackListForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List ipBlacklists = reader.getList();
            for (String line : ipBlacklists) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloBlackListForm ipBlacklistForm = gloList.get(i);
                    fw.write(ipBlacklistForm.getBlacklistIp() + "," + System.getProperty("line.separator", "/n"));
                }
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCdnIpListToExportFile(List<GloCdnIpListForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List cdnIplist = reader.getList();
            for (String line : cdnIplist) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloCdnIpListForm gCdnIpListForm = gloList.get(i);
                    if (gCdnIpListForm.getMaskType() == 0) {
                        fw.write(gCdnIpListForm.getIpAddress() + "/" + gCdnIpListForm.getMask() + System.getProperty("line.separator", "/n"));
                        continue;
                    }
                    if (gCdnIpListForm.getMaskType() != 1) continue;
                    fw.write(gCdnIpListForm.getStartIp() + "-" + gCdnIpListForm.getEndIp() + System.getProperty("line.separator", "/n"));
                }
                this.logger.info((Object)"write ipBlacklist to export-file");
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewIpBlacklistToExportFile(List<GloBlackListIpForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List ipBlacklists = reader.getList();
            for (String line : ipBlacklists) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloBlackListIpForm ipBlacklistForm = gloList.get(i);
                    if (ipBlacklistForm.getMaskType() == 0) {
                        fw.write(ipBlacklistForm.getBlacklistIp() + "/" + ipBlacklistForm.getIntMask() + System.getProperty("line.separator", "/n"));
                        continue;
                    }
                    if (ipBlacklistForm.getMaskType() != 1) continue;
                    fw.write(ipBlacklistForm.getStartIp() + "-" + ipBlacklistForm.getEndIp() + System.getProperty("line.separator", "/n"));
                }
                this.logger.info((Object)"write ipBlacklist to export-file");
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    private String initExportFile(String source) throws IOException {
        String exportFilePath = this.getExportFilePath(source);
        if (source.equalsIgnoreCase("ipblacklist")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.blacklist.file.template.name");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        } else if (source.equalsIgnoreCase("ipwhitelist")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.whitelist.file.template.name");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        } else if (source.equalsIgnoreCase("newIpblacklist")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.blacklist.file.template.name.new");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        } else if (source.equalsIgnoreCase("newIpwhitelist")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.whitelist.file.template.name.new");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        } else if (source.equalsIgnoreCase("proxyIpList")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.cdniplist.file.template.name");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        } else if (source.equalsIgnoreCase("domainWhiteList")) {
            String templateFilePath = "";
            templateFilePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template" + File.separator + this.getText("com.hs.vsm.secservice.neglobal.domainwhitelist.file.template.name");
            ZoneUtil.copyCsvFile((String)templateFilePath, (String)exportFilePath);
        }
        return exportFilePath;
    }

    private String getExportFilePath(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess((String)exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        Long dateTime = System.currentTimeMillis();
        String exportFolderName = "";
        if (source.contains("ipblacklist")) {
            exportFolderName = "ipblacklist_" + dateTime + ".csv";
        } else if (source.contains("ipwhitelist")) {
            exportFolderName = "ipwhitelist_" + dateTime + ".csv";
        } else if (source.contains("newIpblacklist")) {
            exportFolderName = "newIpblacklist_" + dateTime + ".csv";
        } else if (source.contains("newIpwhitelist")) {
            exportFolderName = "newIpwhitelist_" + dateTime + ".csv";
        } else if (source.contains("proxyIpList")) {
            exportFolderName = "proxyIpList_" + dateTime + ".csv";
        } else if (source.contains("domainWhiteList")) {
            exportFolderName = "domainWhiteList_" + dateTime + ".csv";
        }
        return exportFolderPath + File.separator + exportFolderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadNameFile() {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        String onlyFileName = this.downFileName;
        this.downFileName = exportFolderPath + File.separator + this.downFileName;
        try {
            if (!AticUtil.checkFileName((String)onlyFileName, (String)"csv") && !AticUtil.checkFileName((String)onlyFileName, (String)"")) {
                AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                return;
            }
            if (!AticUtil.checkFilePath((String)exportFolderPath, (String)this.downFileName)) {
                AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
                return;
            }
            this.downloadFile(this.getResponse());
        }
        catch (Exception e) {
            AticUtil.redirectLogin((HttpServletRequest)this.fetchRequest(), (HttpServletResponse)this.getResponse());
        }
        finally {
            AticUtil.deleteTempFile((String)this.downFileName);
        }
    }

    public void downLoadTemplate() {
        this.logger.info((Object)"prepare to downLoad template.");
        String fileNameTmp = "";
        if ("ipBlacklist.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.blacklist.file.template.name");
        } else if ("ipWhitelist.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.whitelist.file.template.name");
        } else if ("newIpBlacklist.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.blacklist.file.template.name.new");
        } else if ("newIpWhitelist.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.whitelist.file.template.name.new");
        } else if ("proxyIpList.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.cdniplist.file.template.name");
        } else if ("domainWhite.xls".equals(this.downFileName)) {
            fileNameTmp = this.getText("com.hs.vsm.secservice.neglobal.domainwhitelist.file.template.name");
        } else {
            this.fetchRequest().getSession().invalidate();
            return;
        }
        String templatePath = this.getSession().getServletContext().getRealPath("") + File.separator + "template";
        this.downFileName = templatePath + File.separator + fileNameTmp;
        this.logger.info((Object)("downLoadTemplate downFileName: " + this.downFileName));
        if (!AticUtil.checkFilePath((String)templatePath, (String)this.downFileName)) {
            this.fetchRequest().getSession().invalidate();
            return;
        }
        this.downloadFile(this.getResponse());
    }

    private void downloadFile(HttpServletResponse response) {
        String downloadFileName = "";
        try {
            downloadFileName = new String(this.getDownFileName().getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"downloadFile", (Throwable)e);
            return;
        }
        response.setContentType("application/x-download");
        if (downloadFileName.contains("ipBlacklist") || downloadFileName.contains("ipblacklist")) {
            response.addHeader("Content-Disposition", "attachment;filename=ipBlacklist.csv");
        } else if (downloadFileName.contains("ipWhitelist") || downloadFileName.contains("ipwhitelist")) {
            response.addHeader("Content-Disposition", "attachment;filename=ipWhitelist.csv");
        } else if (downloadFileName.toLowerCase(Locale.ENGLISH).contains("domainwhitelist")) {
            response.addHeader("Content-Disposition", "attachment;filename=domainWhitelist.csv");
        } else if (downloadFileName.contains("newIpBlacklist") || downloadFileName.contains("newIpblacklist")) {
            response.addHeader("Content-Disposition", "attachment;filename=newIpBlacklist.csv");
        } else if (downloadFileName.contains("newIpWhitelist") || downloadFileName.contains("newIpwhitelist")) {
            response.addHeader("Content-Disposition", "attachment;filename=newIpWhitelist.csv");
        } else if (downloadFileName.contains("proxyIpList") || downloadFileName.contains("proxyIplist")) {
            response.addHeader("Content-Disposition", "attachment;filename=proxyIplist.csv");
        } else {
            this.exportNeGlobal(downloadFileName, response);
        }
        response.setCharacterEncoding("UTF-8");
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            this.closeInputStream(fileInput);
            this.closeInputStream(bis);
            this.closeOutputStream(bos);
        }
        catch (IOException e) {
            try {
                this.logger.error((Object)"downloadFile", (Throwable)e);
                throw new LegoSecurityException(206L);
            }
            catch (Throwable throwable) {
                this.closeInputStream(fileInput);
                this.closeInputStream(bis);
                this.closeOutputStream(bos);
                throw throwable;
            }
        }
    }

    private void exportNeGlobal(String downloadFileName, HttpServletResponse response) {
        if (!downloadFileName.contains("policy-device")) {
            throw new LegoSecurityException(206L);
        }
        String[] args = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        args = 1 == version ? downloadFileName.split("/") : downloadFileName.split("\\\\");
        String device = args[args.length - 1];
        String deviceXml = "attachment;filename=" + device;
        response.addHeader("Content-Disposition", deviceXml);
    }

    public void validateStartAndEndNum() {
        if (!this.validateStartAndEndNum4Back()) {
            this.responseResult("error");
            return;
        }
    }

    public boolean validateStartAndEndNum4Back() {
        if (null == this.startNum || null == this.endNum) {
            return false;
        }
        if (this.startNum < 1 || this.startNum > this.zoneCount) {
            return false;
        }
        if (this.endNum < 1 || this.endNum > this.zoneCount) {
            return false;
        }
        if (this.startNum > this.endNum) {
            return false;
        }
        return this.endNum - this.startNum <= 999;
    }

    private void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                input = null;
            }
            finally {
                input = null;
            }
        }
    }

    private void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                output = null;
            }
            finally {
                output = null;
            }
        }
    }

    public String showImportWhiteDomainList() {
        this.logger.info((Object)"prepare to import WhiteDomain info.");
        if (this.deviceId.contains(",")) {
            String[] deviceIdTemp = this.deviceId.split(",");
            this.deviceId = deviceIdTemp[0];
        }
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.deviceId.trim()));
        BisUtil.checkUserSecurity(deviceList);
        return "success";
    }

    public String showImportWhiteList() {
        this.logger.info((Object)"prepare to import blacklist info.");
        if (this.deviceId.contains(",")) {
            String[] deviceIdTemp = this.deviceId.split(",");
            this.deviceId = deviceIdTemp[0];
        }
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.deviceId.trim()));
        BisUtil.checkUserSecurity(deviceList);
        if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
            return "newImport";
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDomainWhiteList() {
        if (null == this.aticDeviceService || null == this.gloDomainWhiteListService) {
            this.logger.error((Object)"aticDeviceService or gloDomainWhiteListService or aticDevice is null");
            this.responseResult(this.getText("common.atic.operate.error"));
            return;
        }
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        int limitValue = 2000;
        if (null == aticDevice || !PropertyNeglobalUtil.checkVersion((String)aticDevice.getVersion()) || BaseCommonUtil.isNullOrEmpty((String)aticDevice.getDeviceModel()) || !aticDevice.getDeviceModel().startsWith("AntiDDoS")) {
            this.logger.error((Object)"import domain whitelist,but device version is error");
            this.responseResult(this.getText("atic.user.domain.device.version.error"));
            return;
        }
        if (aticDevice.getDeviceModel().startsWith("AntiDDoS8")) {
            limitValue = 10000;
        }
        if (Locker.getInstance().isImportDomainWhiteFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.ip.import.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportDomainWhiteFlag(true);
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        try {
            if (!this.checkDomainFileNameAndSize()) {
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.ip.import.oplog.failed", null);
                return;
            }
            CSVReader reader = new CSVReader(this.domainFileName);
            List whites = reader.getList();
            LinkedHashMap<String, String> link = new LinkedHashMap<String, String>();
            for (String line : whites) {
                if (line == null || (line = line.replaceAll(",", "").trim().toLowerCase(Locale.ENGLISH)).isEmpty()) continue;
                link.put(line, line);
            }
            if (link.isEmpty()) {
                this.logger.error((Object)"domain file is empty");
                this.responseResult(this.getText("com.hs.vsm.secservice.neglobal.domainwhitelist.importfile.empty"));
                return;
            }
            if (link.size() > 1000) {
                this.responseResult(this.getText("com.hs.vsm.secservice.neglobal.domainwhitelist.import.too.much"));
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.import.oplog.failed", null);
                return;
            }
            Collection cl = link.values();
            if (this.getDomainWhiteNum() + cl.size() > limitValue) {
                String[] detailPara = new String[]{String.valueOf(limitValue)};
                this.responseResult(this.getText("com.hs.vsm.secservice.neglobal.domainwhitelist.import.over.weight", detailPara));
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.import.oplog.failed", null);
                return;
            }
            for (String str : cl) {
                BatchOperation bo = new BatchOperation();
                bo.setOptDetail(str);
                batchOpList.add(bo);
            }
            reader.csvClose();
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            this.batchOperationResult = this.gloDomainWhiteListService.saveWhiteList(batchOpList, this.deviceId);
            String moduleName = "com.hs.vsm.secservice.neglobal.domainwhitelist.title.import";
            String deviceName = aticDevice.getName();
            String detail = "com.hs.vsm.secservice.neglobal.domainwhitelist.import.oplog.success";
            String[] detailPara = new String[]{String.valueOf(this.batchOperationResult.getSucceedCount()), String.valueOf(this.batchOperationResult.getFailCount())};
            this.optImportStaticBWlist(this.batchOperationResult, moduleName, deviceName, detail, detailPara);
            UpdateDeployState.setDomainDeployState(this.deviceId);
            this.bathResult(this.batchOperationResult);
        }
        catch (IOException e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.import.oplog.failed", null);
            this.logger.error((Object)"import domain whitelist is error", (Throwable)e);
            this.responseResult(this.getText("common.atic.operate.error"));
            return;
        }
        finally {
            Locker.getInstance().setImportDomainWhiteFlag(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importWhiteList() {
        if (Locker.getInstance().isImportBlackAndWhiteFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportBlackAndWhiteFlag(true);
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        try {
            if (!this.checkFileNameAndSize()) {
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
                return;
            }
            CSVReader reader = new CSVReader(this.fileName);
            List ipWhitelistIps = reader.getList();
            if (ipWhitelistIps.size() - 1 > 1000) {
                this.responseResult("importToMuch");
                this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
                return;
            }
            int i = 0;
            for (String line : ipWhitelistIps) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                BatchOperation bo = new BatchOperation();
                if (line == null || "".equals(line)) continue;
                bo.setOptDetail(line);
                batchOpList.add(bo);
            }
            reader.csvClose();
            AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
                if (this.getAllBlackAndWhiteNum() + batchOpList.size() > 40960) {
                    this.responseResult("exceedMaxValue");
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
                    return;
                }
                this.batchOperationResult = this.gloWhiteListService.importSaveNewWhiteList(batchOpList, this.deviceId);
            } else {
                if (this.getAllBlackAndWhiteNum() + batchOpList.size() > 20000) {
                    this.responseResult("exceedMaxValueForV1R1");
                    this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
                    return;
                }
                this.batchOperationResult = this.gloWhiteListService.saveWhiteList(batchOpList, this.deviceId);
            }
            String moduleName = "com.hs.vsm.secservice.neglobal.whitelist.title.import";
            String deviceName = aticDevice.getName();
            String detail = "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.success";
            String[] detailPara = new String[]{String.valueOf(this.batchOperationResult.getSucceedCount()), String.valueOf(this.batchOperationResult.getFailCount())};
            this.optImportStaticBWlist(this.batchOperationResult, moduleName, deviceName, detail, detailPara);
            this.bathResult(this.batchOperationResult);
        }
        catch (IOException e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.import", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.import.oplog.failed", null);
            this.logger.error((Object)"import whitelist is error");
            this.responseResult(e.toString());
            return;
        }
        finally {
            UpdateDeployState.setDeployBypassState(this.deviceId);
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
        }
    }

    public void exportWhiteDomainList() {
        if (Locker.getInstance().isImportDomainWhiteFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.ip.export.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportDomainWhiteFlag(true);
        try {
            String exportFilePath = "";
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.deviceId.trim()));
            BisUtil.checkUserSecurity(deviceList);
            exportFilePath = this.initExportFile("domainWhiteList");
            List<GloDomainWhiteListForm> gloList = this.getExportWhiteDomainList();
            this.writeDomainWhitelistToExportFile(gloList, exportFilePath);
            String fName = exportFilePath.substring(exportFilePath.lastIndexOf(File.separator) + 1, exportFilePath.length());
            this.responseResult(fName);
        }
        catch (IOException e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.domainwhitelist.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.ip.export.oplog.failed", null);
            Locker.getInstance().setImportDomainWhiteFlag(false);
            this.logger.error((Object)"export domainwhitelist;ist error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        finally {
            Locker.getInstance().setImportDomainWhiteFlag(false);
        }
    }

    public void exportWhiteList() {
        if (Locker.getInstance().isImportBlackAndWhiteFlag()) {
            this.responseResult("731046");
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.export.oplog.failed", null);
            return;
        }
        Locker.getInstance().setImportBlackAndWhiteFlag(true);
        try {
            List<Serializable> gloList;
            String exportFilePath = "";
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                this.deviceId = deviceIdTemp[0];
            }
            ArrayList<Long> deviceList = new ArrayList<Long>();
            deviceList.add(Long.valueOf(this.deviceId.trim()));
            BisUtil.checkUserSecurity(deviceList);
            if (CommonUtil.isV5R1C20OrAfterVersion((Long)Long.valueOf(this.deviceId.trim()))) {
                exportFilePath = this.initExportFile("newIpwhitelist");
                gloList = this.getExportNewWhiteList();
                this.writeNewIpWhitelistToExportFile(gloList, exportFilePath);
            } else {
                exportFilePath = this.initExportFile("ipwhitelist");
                gloList = this.getExportWhiteList();
                this.writeIpWhitelistToExportFile(gloList, exportFilePath);
            }
            String[] args = null;
            int version = AticInstallUtil.getInstance().getAticInstallOS();
            args = 1 == version ? exportFilePath.split("/") : exportFilePath.split("\\\\");
            this.responseResult(args[args.length - 1]);
        }
        catch (IOException e) {
            this.getOperateLog().normal("com.hs.vsm.secservice.neglobal.whitelist.title.export", "lego.dic.module.neGlobalApp", null, false, "com.hs.vsm.secservice.neglobal.whitelist.ip.export.oplog.failed", null);
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
            this.logger.error((Object)"export IpWhitel;ist error : ", (Throwable)e);
            throw new LegoCheckedException(570697L, (Throwable)e);
        }
        finally {
            Locker.getInstance().setImportBlackAndWhiteFlag(false);
        }
    }

    private List<GloWhiteListForm> getExportWhiteList() {
        List<GloWhiteListForm> whitelistForms = null;
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                whitelistForms = this.gloWhiteListService.getByIds(this.idStr);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.whitelist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.export.select.success", null);
            this.logger.info((Object)("export IpWhitelist to memory, the export-IpWhitelist : " + this.getcleanedMessage(this.idStr)));
        } else {
            whitelistForms = this.gloWhiteListService.queryByPage(this.createWhiteQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.whitelist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.export.all.success", null);
            this.logger.info((Object)"export IpWhitelist to memory, the export-IpWhitelist : all");
        }
        return whitelistForms;
    }

    private List<GloDomainWhiteListForm> getExportWhiteDomainList() {
        List<GloDomainWhiteListForm> forms = null;
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        if (null != this.domainIds) {
            if (!"".equals(this.domainIds)) {
                this.domainIds = this.domainIds.substring(0, this.domainIds.length() - 1);
                forms = this.gloDomainWhiteListService.getByIds(this.domainIds);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.domainwhitelist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.domainwhitelist.export.select.success", null);
            this.logger.info((Object)("export domainWhitelist to memory, the export-domainWhitelist : " + this.getcleanedMessage(this.domainIds)));
        } else {
            forms = this.gloDomainWhiteListService.queryByPage(this.createDomainWhiteQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.domainwhitelist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.export.all.success", null);
            this.logger.info((Object)"export domainWhitelist to memory, the export-domainWhitelist : all");
        }
        return forms;
    }

    private Map<String, String> createDomainWhiteQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("deviceId", this.deviceId);
        queryMap.put("domainWhite", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    private List<GloWhiteListIpForm> getExportNewWhiteList() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.parseLong(this.deviceId));
        BisUtil.checkUserSecurity(deviceList);
        AticDevice aticDevice = this.aticDeviceService.getDeviceByMoid(Long.parseLong(this.deviceId));
        String deviceName = aticDevice.getName();
        List<GloWhiteListIpForm> whiteIplistForms = null;
        if (null != this.idStr) {
            if (!"".equals(this.idStr)) {
                this.idStr = this.idStr.substring(0, this.idStr.length() - 1);
                whiteIplistForms = this.gloWhiteListService.getByIdList(this.idStr);
            }
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.whitelist.export.select", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.export.select.success", null);
            this.logger.info((Object)("export IpWhitelist to memory, the export-IpWhitelist : " + this.getcleanedMessage(this.idStr)));
        } else {
            whiteIplistForms = this.gloWhiteListService.queryByPageNew(this.createWhiteQueryAllMap(), 0, Integer.MAX_VALUE).getData();
            this.getOperateLog().info("com.hs.vsm.secservice.neglobal.whitelist.export.all", "lego.dic.module.neGlobalApp", deviceName, false, "com.hs.vsm.secservice.neglobal.whitelist.export.all.success", null);
            this.logger.info((Object)"export IpWhitelist to memory, the export-IpWhitelist : all");
        }
        return whiteIplistForms;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private Map<String, String> createWhiteQueryAllMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("deviceId", this.deviceId);
        queryMap.put("whitelistIp", null);
        queryMap.put("sortName", null);
        queryMap.put("sortType", null);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        return queryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDomainWhitelistToExportFile(List<GloDomainWhiteListForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List domainWhitelists = reader.getList();
            for (String line : domainWhitelists) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloDomainWhiteListForm form = gloList.get(i);
                    fw.write(form.getDomainWhite() + "," + System.getProperty("line.separator", "/n"));
                }
                this.logger.info((Object)"write domainWhitelist to export-file");
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIpWhitelistToExportFile(List<GloWhiteListForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List ipWhitelists = reader.getList();
            for (String line : ipWhitelists) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloWhiteListForm ipWhitelistForm = gloList.get(i);
                    fw.write(ipWhitelistForm.getWhitelistIp() + "," + System.getProperty("line.separator", "/n"));
                }
                this.logger.info((Object)"write ipWhitelist to export-file");
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNewIpWhitelistToExportFile(List<GloWhiteListIpForm> gloList, String exportFilePath) throws IOException {
        CSVReader reader = new CSVReader(exportFilePath);
        BufferedWriter fw = new BufferedWriter((Writer)new FileWriterWithEncoding(exportFilePath, System.getProperty("file.encoding")));
        try {
            List ipWhitelists = reader.getList();
            for (String line : ipWhitelists) {
                fw.write(line + System.getProperty("line.separator", "/n"));
            }
            if (null != gloList && !gloList.isEmpty()) {
                int j = gloList.size();
                for (int i = 0; i < j; ++i) {
                    GloWhiteListIpForm whitelistIp = gloList.get(i);
                    if (whitelistIp.getMaskType() == 0) {
                        fw.write(whitelistIp.getWhitelistIp() + "/" + whitelistIp.getIntMask() + System.getProperty("line.separator", "/n"));
                        continue;
                    }
                    if (whitelistIp.getMaskType() != 1) continue;
                    fw.write(whitelistIp.getStartIp() + "-" + whitelistIp.getEndIp() + System.getProperty("line.separator", "/n"));
                }
                this.logger.info((Object)"write ipWhitelist to export-file");
            }
        }
        finally {
            this.closeOutStream(fw);
            this.closeInStream(reader);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public IGloBlackListService getGloBlackListService() {
        return this.gloBlackListService;
    }

    public void setGloBlackListService(IGloBlackListService gloBlackListService) {
        this.gloBlackListService = gloBlackListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getIplistFileName() {
        return this.iplistFileName;
    }

    public void setIplistFileName(String iplistFileName) {
        this.iplistFileName = iplistFileName;
    }

    public String getIdStr() {
        return this.idStr;
    }

    public void setIdStr(String idStr) {
        this.idStr = idStr;
    }

    public void selectExportByDeviceValateCount() {
        IZoneServiceService zoneServiceService = (IZoneServiceService)ServiceContext.getInstance().getService("zoneServiceService", ZoneServiceServiceImpl.class);
        List list = zoneServiceService.queryByDeviceId(Long.valueOf(Long.parseLong(this.deviceId)));
        HashSet<Long> idSet = new HashSet<Long>();
        for (ZoneServiceForm form : list) {
            idSet.add(form.getZoneId());
        }
        if (idSet.size() > 1000) {
            this.zoneCount = list.size();
            this.responseResult("" + this.zoneCount);
        } else {
            this.responseResult("success");
        }
    }

    public String selectExportContentByDevice() {
        ArrayList<Long> deviceList = new ArrayList<Long>();
        deviceList.add(Long.valueOf(this.idStr));
        BisUtil.checkUserSecurity(deviceList);
        this.initSelectExportContentByDeviceList();
        return "success";
    }

    public String showProgressExportPolicy() {
        return "success";
    }

    public void initSelectExportContentByDeviceList() {
        this.selectExportContentByDeviceList = new ArrayList<LangPair>();
        LangPair pair1 = new LangPair(this.getText("atic.zone.export.by.zone.global.policy"), "globalPolicy");
        LangPair pair2 = new LangPair(this.getText("atic.zone.export.by.zone.ip.location"), "ipLocation");
        LangPair pair3 = new LangPair(this.getText("atic.zone.export.by.zone.filter"), "filter");
        LangPair pair4 = new LangPair(this.getText("atic.zone.export.by.zone.defense.policy"), "defensePolicy");
        this.selectExportContentByDeviceList.add(pair1);
        this.selectExportContentByDeviceList.add(pair2);
        this.selectExportContentByDeviceList.add(pair3);
        this.selectExportContentByDeviceList.add(pair4);
    }

    public void exportByDevice() {
        ArrayList<Long> zoneIds = new ArrayList<Long>();
        ArrayList<Long> deviceIds = new ArrayList<Long>();
        this.dealExport(zoneIds, deviceIds, "policy-device");
    }

    private void dealExport(List<Long> zoneIds, List<Long> deviceIds, String tempFileName) {
        String logType = "";
        String[] str = null;
        logType = "lego.dic.module.neGlobalApp";
        AticDevice device = this.aticDeviceService.getDeviceByIp(this.deviceIp);
        str = null != device ? new String[]{device.getName(), this.deviceIp} : new String[]{};
        try {
            String exportFilePath = this.getExportFilePathForExportZone(tempFileName);
            ImportForm form = new ImportForm();
            String fmt = "yyyy-MM-dd H:m:s";
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            Date date = new Date();
            String time = sdf.format(date);
            String paraKey = "lego.lab.com.about.red.versionval";
            String systemVersion = this.getText(paraKey);
            if (!AticUtil.isNull((String)systemVersion) && !systemVersion.equals(paraKey)) {
                form.setSystemVersion(systemVersion.split(this.getText("atic.public.punctuation.colon2"))[1].trim());
            } else {
                form.setSystemVersion("ATIC");
            }
            form.setDimension(this.dimension);
            form.setTime(time);
            ExportZoneConditionForm conditionForm = new ExportZoneConditionForm();
            conditionForm.setZoneIds(zoneIds);
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(Long.parseLong(this.deviceId));
            conditionForm.setDeviceIds(idList);
            conditionForm.setExportFilePath(exportFilePath);
            conditionForm.setExportSelectedContent(this.exportContentStr);
            conditionForm.setDeviceId(Long.valueOf(Long.parseLong(this.deviceId)));
            conditionForm.setDimension(this.dimension);
            ExportThread task = new ExportThread(form, conditionForm, this.progressBarId);
            task.setStartNum(this.startNum);
            task.setEndNum(this.endNum);
            task.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            task.start();
            while (!task.isEnd()) {
                try {
                    Thread.sleep(2000L);
                    this.logger.info((Object)"wait all task run over");
                }
                catch (InterruptedException e) {
                    this.logger.info((Object)e);
                }
            }
            this.getOperateLog().normal(EXPORT, logType, this.deviceIp, false, "atic.zone.export.device.success.log", str);
        }
        catch (LegoCheckedException e) {
            this.getOperateLog().normal(EXPORT, logType, this.deviceIp, false, "atic.zone.export.device.failed.log", str);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
    }

    public void exportByDeviceGetFileName() {
        String exportFilePath = this.getExportFilePathForExportZone("policy-device");
        String[] args = null;
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        args = 1 == version ? exportFilePath.split("/") : exportFilePath.split("\\\\");
        this.responseResult(args[args.length - 1]);
    }

    private String getExportFilePathForExportZone(String source) {
        String exportFolderPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        boolean isCreateExportFolderSuccess = ZoneUtil.isCreateFolderSuccess((String)exportFolderPath);
        if (!isCreateExportFolderSuccess) {
            throw new LegoCheckedException(0L);
        }
        String exportFolderName = "";
        exportFolderName = source.contains("zone") ? "policy-zone.xml" : "policy-device-" + this.deviceIp + ".xml";
        return exportFolderPath + File.separator + exportFolderName;
    }

    public boolean validateDomainIds(String parameterName) {
        HttpServletRequest request = this.fetchRequest();
        String idStrTemp = request.getParameter(parameterName);
        if (null == this.domainIds) {
            return true;
        }
        String[] ids = idStrTemp.split(",");
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateIdString(String parameterName) {
        HttpServletRequest request = this.fetchRequest();
        String idStrTemp = request.getParameter(parameterName);
        if (null == this.idStr) {
            return true;
        }
        String[] ids = idStrTemp.split(",");
        for (int i = 0; i < ids.length; ++i) {
            long id = 0L;
            try {
                id = Long.parseLong(ids[i]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (id > 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateDeviceId() {
        if (AticUtil.isNull((String)this.deviceId)) {
            return false;
        }
        long parseDeviceId = 0L;
        try {
            if (this.deviceId.contains(",")) {
                String[] deviceIdTemp = this.deviceId.split(",");
                parseDeviceId = Long.parseLong(deviceIdTemp[0]);
            } else if (StringUtils.isNotBlank((CharSequence)this.deviceId)) {
                parseDeviceId = Long.parseLong(this.deviceId);
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return parseDeviceId >= 0L;
    }

    public boolean validateSuperSize() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String size = request.getParameter("superSize");
        if (null == size) {
            return true;
        }
        return "true".equals(size) || "false".equals(size);
    }

    public IGloCdnIpListService getGloCdnIpListService() {
        return this.gloCdnIpListService;
    }

    public void setGloCdnIpListService(IGloCdnIpListService gloCdnIpListService) {
        this.gloCdnIpListService = gloCdnIpListService;
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public int getZoneCount() {
        return this.zoneCount;
    }

    public void setZoneCount(int zoneCount) {
        this.zoneCount = zoneCount;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Integer getStartNum() {
        return this.startNum;
    }

    public void setStartNum(Integer startNum) {
        this.startNum = startNum;
    }

    public Integer getEndNum() {
        return this.endNum;
    }

    public void setEndNum(Integer endNum) {
        this.endNum = endNum;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getExportContentStr() {
        return this.exportContentStr;
    }

    public void setExportContentStr(String exportContentStr) {
        this.exportContentStr = exportContentStr;
    }

    public Long getProgressBarId() {
        return this.progressBarId;
    }

    public void setProgressBarId(Long progressBarId) {
        this.progressBarId = progressBarId;
    }

    public List<LangPair> getSelectExportContentByDeviceList() {
        return this.selectExportContentByDeviceList;
    }

    public void setSelectExportContentByDeviceList(List<LangPair> selectExportContentByDeviceList) {
        this.selectExportContentByDeviceList = selectExportContentByDeviceList;
    }

    public boolean isSuperSize() {
        return this.superSize;
    }

    public void setSuperSize(boolean superSize) {
        this.superSize = superSize;
    }

    public IGloDomainWhiteListService getGloDomainWhiteListService() {
        return this.gloDomainWhiteListService;
    }

    public void setGloDomainWhiteListService(IGloDomainWhiteListService gloDomainWhiteListService) {
        this.gloDomainWhiteListService = gloDomainWhiteListService;
    }

    public String getDomainFileName() {
        return this.domainFileName;
    }

    public void setDomainFileName(String domainFileName) {
        this.domainFileName = domainFileName;
    }

    public String getDomainIds() {
        return this.domainIds;
    }

    public void setDomainIds(String domainIds) {
        this.domainIds = domainIds;
    }

    public String getDomainListFileName() {
        return this.domainListFileName;
    }

    public void setDomainListFileName(String domainListFileName) {
        this.domainListFileName = domainListFileName;
    }
}

