/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.neglobal.action;

import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.form.LocationCustomForm;
import com.hs.atic.sdk.bis.service.IFoundDefaultIdService;
import com.hs.atic.sdk.bis.service.ILocationCustomService;
import com.hs.atic.sdk.bis.service.IVpnService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.sdk.zone.util.ProgressManage;
import com.hs.atic.sdk.zone.util.ProgressState;
import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.CheckImportXml;
import com.hs.atic.zone.util.ImportZoneConstant;
import com.hs.atic.zone.util.ImportZoneUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.vsm.neglobal.util.CheckImportXml4NE;
import com.hs.vsm.neglobal.util.ImportUtil;
import com.hs.vsm.secservice.ddos.policy.beans.ZonePolicyParamsBean;
import com.hs.vsm.secservice.ddos.policy.util.ZoneUtil;
import com.hs.vsm.secservice.ddos.util.PropertyNeglobalUtil;
import com.hs.vsm.secservice.neglobal.model.GloCdnIpListInfo;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.common.util.VsmUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.HttpFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlackWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneDeviceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneIpLocationForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZonePolicyApplyForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneWhiteForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IBlackWhiteListService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZonePolicyApplyService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneServiceService;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListIpForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportData;
import com.hs.vsm.secservice.sdk.module.neglobal.form.ImportForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloCdnIpListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ImportThread
extends Thread {
    private static ReentrantLock lock = new ReentrantLock();
    private String importType;
    private boolean isEnd;
    private int totalRow = 0;
    private ProgressState progressState = null;
    private BatchOperationResult operationResult;
    private List<BatchOperation> frontOperationList = new ArrayList<BatchOperation>();
    private List<String> importFailedZoneNameList = new ArrayList<String>();
    private boolean importZoneByDeviceIsSucess = true;
    private IZonePolicyApplyService zonePolicyApplyService;
    private IZoneService zoneService;
    private IZoneServiceService zoneServiceService;
    private IAticDeviceService aticDeviceService;
    private ImportData importData;
    private ImportForm importForm;
    private User currentUser;
    private IBlackWhiteListService blackWhiteListService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);

    public ImportThread(String importType) {
        this.importType = importType;
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        this.zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        this.zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        this.zoneServiceService = (IZoneServiceService)ServiceContext.getInstance().getService("zoneServiceService", IZoneServiceService.class);
        this.blackWhiteListService = (IBlackWhiteListService)ServiceContext.getInstance().getService("blackWhiteListService", IBlackWhiteListService.class);
    }

    public ImportThread(String importType, User currentUser) {
        this.importType = importType;
        this.currentUser = currentUser;
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        this.zoneService = (IZoneService)ServiceContext.getInstance().getService("zoneService", IZoneService.class);
        this.zonePolicyApplyService = (IZonePolicyApplyService)ServiceContext.getInstance().getService("zonePolicyApplyService", IZonePolicyApplyService.class);
        this.zoneServiceService = (IZoneServiceService)ServiceContext.getInstance().getService("zoneServiceService", IZoneServiceService.class);
        this.blackWhiteListService = (IBlackWhiteListService)ServiceContext.getInstance().getService("blackWhiteListService", IBlackWhiteListService.class);
    }

    private List<HttpFilterForm> checkFilterKey(List<HttpFilterForm> httpFilterFormList, FilterForm filterForm) {
        if (null == httpFilterFormList || httpFilterFormList.isEmpty()) {
            return null;
        }
        List<HttpFilterForm> illegalList = this.iLLegalHttpFilterFormList(httpFilterFormList, filterForm);
        if (!illegalList.isEmpty()) {
            this.importZoneByDeviceIsSucess = false;
            httpFilterFormList.removeAll(illegalList);
        }
        return httpFilterFormList;
    }

    private List<HttpFilterForm> iLLegalHttpFilterFormList(List<HttpFilterForm> httpFilterFormList, FilterForm filterForm) {
        ArrayList<HttpFilterForm> illegalList = new ArrayList<HttpFilterForm>();
        for (HttpFilterForm httpFilterForm : httpFilterFormList) {
            if (AticUtil.isNull((String)httpFilterForm.getFilterContent()) && AticUtil.isNull((String)httpFilterForm.getFilterKey())) continue;
            if (!CheckImportXml.filterValidate((FilterForm)filterForm, (HttpFilterForm)httpFilterForm, this.frontOperationList, httpFilterFormList, (String)this.importData.getFilterString())) {
                illegalList.add(httpFilterForm);
                continue;
            }
            if (CheckImportXml.isTooMuchForFilter(httpFilterFormList, (String)httpFilterForm.getFilterKey())) continue;
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + httpFilterForm.getFilterKey() + ":" + httpFilterForm.getFilterContent(), 631036L, this.frontOperationList);
            illegalList.add(httpFilterForm);
        }
        return illegalList;
    }

    private boolean checkImportType() {
        if (!this.importType.equals(this.importForm.getDimension())) {
            if ("device".equals(this.importType)) {
                this.importZoneByDeviceIsSucess = false;
            }
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(this.importForm.getDimension());
            batchOperation.setErrorCode(571981L);
            this.endProgressBar(batchOperation);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        lock.lock();
        try {
            this.logger.info((Object)("ImportZonePolicyThread int the run(),importType=" + this.importType));
            Long importZonePolicyStartTime = System.currentTimeMillis();
            this.importForm = this.importData.getImportForm();
            try {
                if (this.checkImportType()) {
                    if ("device".equals(this.importType)) {
                        if (this.checkDeviceIp()) {
                            AticDevice aDevice = this.aticDeviceService.getDeviceByIp(this.importForm.getDeviceIp());
                            if (null != aDevice && 1 == aDevice.getDeviceType()) {
                                this.initProgressBarByGlobal(aDevice);
                                this.importAbnormalDefence(aDevice);
                                this.importGloProxyIpList(aDevice);
                                this.importGloBlackAndWhiteList(aDevice);
                                this.importDomainWhiteList(aDevice);
                                this.importIpLocation();
                                this.importFilter();
                                this.importZone();
                                this.importGlobalFilter(aDevice);
                            } else {
                                this.importZoneByDeviceIsSucess = false;
                                this.logger.error((Object)"Imported device does not exist");
                                BatchOperation batchOperation = new BatchOperation();
                                batchOperation.setTargetName(this.importForm.getDeviceName() + "(IP:" + this.importForm.getDeviceIp() + ")");
                                batchOperation.setErrorCode(572063L);
                                this.frontOperationList.clear();
                                this.endProgressBar(batchOperation);
                                this.operationResult = this.parserImportOperationResult();
                                this.importData.getSession().setAttribute("operationResult", (Object)this.operationResult);
                                this.isEnd = true;
                            }
                        }
                    } else if (this.checkImportZoneLength()) {
                        this.initProgressBarByZone();
                        this.importZone();
                    }
                    IFoundDefaultIdService defaultIdService = (IFoundDefaultIdService)ServiceContext.getInstance().getService("foundDefaultIdService", IFoundDefaultIdService.class);
                    defaultIdService.refreshUserDefBizData();
                }
                this.operationResult = this.parserImportOperationResult();
                if (null != this.importData.getSession()) {
                    this.importData.getSession().setAttribute("operationResult", (Object)this.operationResult);
                    this.progressState.next();
                }
                this.isEnd = true;
            }
            catch (RuntimeException e) {
                if ("device".equals(this.importType)) {
                    this.importZoneByDeviceIsSucess = false;
                }
                this.logger.error((Object)"import zone error : ", (Throwable)e);
                BatchOperation batchOperation = new BatchOperation();
                batchOperation.setTargetName(this.importForm.getDeviceName());
                batchOperation.setErrorCode(570698L);
                this.frontOperationList.clear();
                this.endProgressBar(batchOperation);
                this.operationResult = this.parserImportOperationResult();
                this.importData.getSession().setAttribute("operationResult", (Object)this.operationResult);
                this.isEnd = true;
            }
            finally {
                Locker.getInstance().setImportFlag(false);
                this.logger.info((Object)("The ImportZonePolicyThread run() end times is  " + (System.currentTimeMillis() - importZonePolicyStartTime) + "ms"));
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void importGloProxyIpList(AticDevice aDevice) {
        this.logger.info((Object)"Import the gloProxyIpList");
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        FWDefenceAbnormalForm abnormalForm = iFWDefenceAbnormalService.queryByDeviceId(aDevice.getMoId());
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        IGloCdnIpListService gloCdnIpListService = (IGloCdnIpListService)ServiceContext.getInstance().getService("gloCdnIpListService", IGloCdnIpListService.class);
        List<GloCdnIpListInfo> proxyIpList = gloCdnIpListService.queryByDeviceId(aDevice.getMoId());
        ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
        if (null != proxyIpList && !proxyIpList.isEmpty()) {
            for (GloCdnIpListInfo proxyIp : proxyIpList) {
                if (proxyIp.getDeleteFlag().booleanValue()) continue;
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(proxyIp.getPkid().longValue());
                bo.setOptDetail(proxyIp.getIpAddress());
                boList.add(bo);
            }
        }
        gloCdnIpListService.batchDelGloCdnIpList(boList);
        long startTime = System.currentTimeMillis();
        if (null == this.importForm.getProxyIpFormList() || this.importForm.getProxyIpFormList().isEmpty()) {
            return;
        }
        try {
            int proxyIpNum = 0;
            int totalProxyIpNum = this.importForm.getProxyIpFormList().size();
            ArrayList<GloCdnIpListForm> gForms = new ArrayList<GloCdnIpListForm>();
            for (GloCdnIpListForm proxyIpForm : this.importForm.getProxyIpFormList()) {
                if (!this.isSaveProxyIpList(aDevice, proxyIpForm)) {
                    this.progressState.next();
                    --totalProxyIpNum;
                    continue;
                }
                boolean flag = false;
                for (GloCdnIpListForm proxyIp : gForms) {
                    String[] ipRange = new String[]{proxyIp.getStartIp(), proxyIp.getEndIp()};
                    if (!IPUtil.isInIpRange((String[])ipRange, (String)proxyIpForm.getStartIp()) && !IPUtil.isInIpRange((String[])ipRange, (String)proxyIpForm.getEndIp())) continue;
                    flag = true;
                    break;
                }
                if (!flag) {
                    proxyIpForm.setDeviceId(aDevice.getMoId());
                    if (!CheckImportXml.checkProxyIpNum((int)gForms.size(), this.frontOperationList, (String)this.importData.getProxyIpString())) {
                        this.progressState.next(totalProxyIpNum - proxyIpNum);
                        break;
                    }
                    gloCdnIpListService.saveGloCdnIpList(proxyIpForm);
                    gForms.add(proxyIpForm);
                    ImportUtil.setProxyIpListDeployState(abnormalForm);
                } else {
                    this.logger.error((Object)("To add the list already exists in the proxyIp list.The proxyIp = " + proxyIpForm.getIpAddress() + "/" + proxyIpForm.getMask()));
                    ImportUtil.recordErrorMessg(proxyIpForm.getIpAddress() + "/" + proxyIpForm.getMask(), 570813L, this.frontOperationList);
                }
                this.progressState.next();
                ++proxyIpNum;
            }
            iFWDefenceAbnormalService.save(abnormalForm);
        }
        catch (LegoCheckedException e) {
            this.logger.info((Object)("Save the saveGloCdnIpList error.LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getWhiteLiString(), e.getErrorCode(), this.frontOperationList);
        }
        this.logger.info((Object)("Import proxyIp list to spend time is " + (System.currentTimeMillis() / 1000L - startTime / 1000L) + "s"));
    }

    private boolean isSaveProxyIpList(AticDevice aDevice, GloCdnIpListForm proxyIpForm) {
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return false;
        }
        if (ImportUtil.isNullProxyIp(proxyIpForm)) {
            return false;
        }
        if (!ImportUtil.isOkProxyIpForm(this.importData, this.frontOperationList, aDevice, proxyIpForm)) {
            this.importZoneByDeviceIsSucess = false;
            return false;
        }
        return true;
    }

    private boolean checkDeviceIp() {
        if (null == this.importForm.getDeviceIp()) {
            return true;
        }
        if (!IPUtil.isIpv4((String)this.importForm.getDeviceIp())) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(this.importForm.getDeviceIp());
            batchOperation.setErrorCode(572010L);
            this.endProgressBar(batchOperation);
            return false;
        }
        return true;
    }

    private void endProgressBar(BatchOperation batchOperation) {
        this.frontOperationList.add(batchOperation);
        int totalStep = 2;
        this.totalRow = 1;
        this.logger.info((Object)("importZone totalStep:=" + totalStep));
        this.progressState = ProgressManage.getInstance().createProgress(totalStep, this.importData.getProgressBarId().longValue());
        this.logger.info((Object)("Progress bar for import policy creation.The Progress is " + this.progressState));
        this.progressState.next();
    }

    private boolean checkImportZoneLength() {
        if (this.importForm.getZoneFormList().size() > 1000) {
            this.logger.info((Object)("Zone object over 1000,Zone'size = " + this.importForm.getZoneFormList().size()));
            this.operationError(this.importData.getImportString(), 572002L);
            return false;
        }
        return true;
    }

    private void operationError(String targetName, long errorCode) {
        BatchOperation batchOperation = new BatchOperation();
        batchOperation.setTargetName(targetName);
        batchOperation.setErrorCode(errorCode);
        this.endProgressBar(batchOperation);
    }

    private boolean needImportZone(ZonePolicyApplyForm appForm, ZoneInfoForm zoneInfoForm, boolean isCreate) {
        if (zoneInfoForm.getZoneType() == 1 && this.importForm.isNeedPolicy() && isCreate) {
            for (ZoneDeviceForm zoneDeviceForm : appForm.getZoneDeviceForms()) {
                if (!this.zonePolicyApplyService.isDeviceRelDefaultZone(zoneDeviceForm.getDeviceId()).booleanValue()) continue;
                this.logger.info((Object)("Save the default zone object error,zone's name = " + appForm.getZoneInfoForm().getZoneName() + ". The associated device list cannot contain devices associated with the default Zone, because each device can be associated with only one default Zone."));
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + appForm.getZoneInfoForm().getZoneDesc(), 572014L, this.frontOperationList);
                return false;
            }
        }
        return true;
    }

    private void importZone() {
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("importZone() start time is " + startTime));
        if ("device".equals(this.importType) && !this.importForm.isNeedPolicy()) {
            return;
        }
        this.progressState.next();
        if (null != this.importForm.getZoneFormList() && !this.importForm.getZoneFormList().isEmpty()) {
            int frontSize = this.frontOperationList.size();
            for (ZonePolicyApplyForm xmlPolicyForm : this.importForm.getZoneFormList()) {
                if (ImportUtil.checkIsTaskCancled(this.importData)) {
                    return;
                }
                startTime = System.currentTimeMillis();
                this.logger.info((Object)("importZone start time is " + startTime + "ms"));
                ZoneInfoForm zoneInfoForm = xmlPolicyForm.getZoneInfoForm();
                if (null == zoneInfoForm) {
                    this.logger.info((Object)"zoneInfoForm is null");
                    continue;
                }
                ZoneInfoForm dbInfoForm = this.zoneService.getZoneByName(zoneInfoForm.getZoneName());
                if (null != dbInfoForm) {
                    zoneInfoForm.setZoneId(dbInfoForm.getZoneId());
                }
                if (ImportUtil.checkZoneInfoBasicInformation(zoneInfoForm, xmlPolicyForm, this.frontOperationList, this.importData)) {
                    try {
                        ArrayList<ZoneDeviceForm> temDevList = new ArrayList<ZoneDeviceForm>();
                        HashSet<String> temDevIpSet = new HashSet<String>();
                        for (ZoneDeviceForm zDeviceForm : xmlPolicyForm.getZoneDeviceForms()) {
                            if (!this.checkDeviceExist(zDeviceForm, xmlPolicyForm.getZoneInfoForm().getZoneDesc())) continue;
                            if ("device".equals(this.importType)) {
                                if (!zDeviceForm.getDeviceIp().equals(this.importForm.getDeviceIp())) continue;
                                temDevList.add(zDeviceForm);
                                break;
                            }
                            if (temDevIpSet.contains(zDeviceForm.getDeviceIp())) continue;
                            temDevIpSet.add(zDeviceForm.getDeviceIp());
                            temDevList.add(zDeviceForm);
                        }
                        xmlPolicyForm.setZoneDeviceForms(temDevList);
                        if (this.needImportZone(xmlPolicyForm, zoneInfoForm, null == dbInfoForm)) {
                            this.importZonePolicy(zoneInfoForm, xmlPolicyForm, dbInfoForm);
                        }
                    }
                    catch (LegoCheckedException e) {
                        this.progressState.next();
                    }
                }
                if (frontSize < this.frontOperationList.size()) {
                    this.importFailedZoneNameList.add(xmlPolicyForm.getZoneInfoForm().getZoneDesc());
                    frontSize = this.frontOperationList.size();
                }
                this.progressState.next();
                this.logger.info((Object)("The importzone end times is  " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
    }

    private boolean checkVpnExist(ZoneDeviceForm zDeviceForm, String zoneName) {
        IVpnService service = (IVpnService)ServiceContext.getInstance().getService("vpnServiceImpl", IVpnService.class);
        if (service.isVpnExist(zDeviceForm.getDeviceId(), zDeviceForm.getVpnName())) {
            return true;
        }
        this.logger.info((Object)("There is no association with the device VPN target ATIC. The vpnName=" + zDeviceForm.getVpnName() + ",The deviceId=" + zDeviceForm.getDeviceIp()));
        ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp() + "/" + zDeviceForm.getVpnName(), 572020L, this.frontOperationList);
        return false;
    }

    private void parserZonePolicyLocation(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.importForm.isNeedLocation()) {
            return;
        }
        Map<String, IpLocation> locationMap = ImportUtil.ipLocationMap(this.importForm.isNeedLocation());
        if (null != xmlPolicyForm.getZoneIpLocationList() && !xmlPolicyForm.getZoneIpLocationList().isEmpty()) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            for (ZoneIpLocationForm zoneIpLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                if (AticUtil.isNull((String)zoneIpLocationForm.getLocationNameEn())) continue;
                tempList.add(zoneIpLocationForm);
            }
            xmlPolicyForm.setZoneIpLocationList(tempList);
            if (xmlPolicyForm.getZoneIpLocationList().size() >= 2) {
                int defalutNum = 0;
                ZoneIpLocationForm defaultForm = null;
                tempList = new ArrayList();
                HashMap<String, ZoneIpLocationForm> ipLocationMap = new HashMap<String, ZoneIpLocationForm>();
                String regex4Location = "^(?!(?i)null$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\-|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\w/\\w|\\!|\\:|\\;|\\?|\\.|\\(|\\)|\\,|\\'|\\r|\\n]*$";
                List<String> ipLocationNameList = ImportUtil.ipLocationNameList(xmlPolicyForm.getZoneIpLocationList());
                if (!ipLocationNameList.isEmpty() && !ipLocationNameList.contains("OtherLocation".toLowerCase(Locale.getDefault()))) {
                    this.logger.info((Object)("When the position strategy is not empty, the number of the location policies must be greater than or equal to 2, which must be a default name for the \u2018OtherLocation\u2019 position strategy" + this.importForm.getZoneFormList().size()));
                    ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList());
                    return;
                }
                for (ZoneIpLocationForm zoneIpLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                    if (!ImportUtil.checkIsTaskCancled(this.importData)) {
                        ++this.totalRow;
                        if (AticUtil.isNull((String)zoneIpLocationForm.getLocationNameEn())) continue;
                        if (!zoneIpLocationForm.getLocationNameEn().matches(regex4Location)) {
                            this.logger.info((Object)("The zoneIpLocation name is error. The name is " + zoneIpLocationForm.getLocationNameEn()));
                            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572044L, this.frontOperationList);
                            continue;
                        }
                        if (zoneIpLocationForm.getLocationAction() != 1 && zoneIpLocationForm.getLocationAction() != 2 && zoneIpLocationForm.getLocationAction() != 3) {
                            this.logger.info((Object)("The zoneIpLocation action is error. The action is " + zoneIpLocationForm.getLocationAction()));
                            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572033L, this.frontOperationList);
                            continue;
                        }
                        if (zoneIpLocationForm.getLocationAction() == 3 && !CheckImportXml.isRange10240((String)String.valueOf(zoneIpLocationForm.getLocationLimit()))) {
                            this.logger.info((Object)("The zoneIpLocation limit is error. The limit is " + zoneIpLocationForm.getLocationNameEn() + ":" + zoneIpLocationForm.getLocationLimit()));
                            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572034L, this.frontOperationList);
                            continue;
                        }
                        if ("OtherLocation".equalsIgnoreCase(zoneIpLocationForm.getLocationNameEn())) {
                            ++defalutNum;
                            defaultForm = new ZoneIpLocationForm();
                            defaultForm.setLocationNameEn("OtherLocation");
                            defaultForm.setLocationAction(zoneIpLocationForm.getLocationAction());
                            defaultForm.setLocationLimit(zoneIpLocationForm.getLocationLimit());
                            defaultForm.setLocationId(ImportZoneConstant.OTHER_LOCATION_ID.longValue());
                        }
                        if (null != locationMap.get(zoneIpLocationForm.getLocationNameEn())) {
                            zoneIpLocationForm.setLocationNameZh(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getLocationNameZh());
                            zoneIpLocationForm.setShortName(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getShortName());
                            zoneIpLocationForm.setLocationId(locationMap.get(zoneIpLocationForm.getLocationNameEn()).getLocationId());
                            ipLocationMap.put(zoneIpLocationForm.getLocationNameEn(), zoneIpLocationForm);
                            continue;
                        }
                        if ("OtherLocation".equalsIgnoreCase(zoneIpLocationForm.getLocationNameEn())) continue;
                        this.logger.info((Object)("The location of the object associated with the object is not present on the target ATIC.The locationName=" + zoneIpLocationForm.getLocationNameEn()));
                        ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + zoneIpLocationForm.getLocationNameEn(), 572019L, this.frontOperationList);
                        continue;
                    }
                    return;
                }
                if (defalutNum != 1) {
                    this.logger.info((Object)("When the position strategy is not empty, the number of the  location policies must be greater than or equal to 2, which must be a default name for the OtherLocation\u2019 position strategy" + this.importForm.getZoneFormList().size()));
                    ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList());
                }
                if (ipLocationMap.isEmpty()) {
                    xmlPolicyForm.setZoneIpLocationList(new ArrayList());
                } else {
                    if (null != defaultForm) {
                        defaultForm.setLocationNameZh("OtherLocation");
                        defaultForm.setShortName("Other");
                        defaultForm.setLocationId(ImportZoneConstant.OTHER_LOCATION_ID.longValue());
                        tempList.add(defaultForm);
                    } else {
                        this.logger.error((Object)"defaultForm is null");
                    }
                    if (!ipLocationMap.isEmpty()) {
                        for (Map.Entry entry : ipLocationMap.entrySet()) {
                            tempList.add(entry.getValue());
                        }
                    }
                    xmlPolicyForm.setZoneIpLocationList(tempList);
                }
            } else if (!xmlPolicyForm.getZoneIpLocationList().isEmpty() && xmlPolicyForm.getZoneIpLocationList().size() < 2) {
                this.logger.info((Object)("When the position strategy is not empty, the number of the location policies must be greater than or equal to 2, which must be a default name for the \u2018OtherLocation\u2019 position strategy" + this.importForm.getZoneFormList().size()));
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572032L, this.frontOperationList);
                xmlPolicyForm.setZoneIpLocationList(new ArrayList());
            }
        }
        if (null != xmlPolicyForm.getZoneIpLocationList() && !xmlPolicyForm.getZoneIpLocationList().isEmpty()) {
            for (ZoneIpLocationForm ipLocationForm : xmlPolicyForm.getZoneIpLocationList()) {
                ipLocationForm.setZoneId(zoneInfoId);
            }
        }
        if (null != dbPolicyForm) {
            dbPolicyForm.setZoneIpLocationList(xmlPolicyForm.getZoneIpLocationList());
        }
    }

    private void importZonePolicy(ZoneInfoForm xmlInfoForm, ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm dbInfoForm) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The importZonePolicy() start time is  " + startTime + "ms"));
        String servicePort = "";
        if (null != dbInfoForm) {
            if (dbInfoForm.getZoneType().equals(xmlInfoForm.getZoneType())) {
                this.undateZoneBasicInfo(dbInfoForm, xmlInfoForm);
                this.updateZonePolicy(dbInfoForm, xmlPolicyForm, servicePort);
            } else {
                this.logger.info((Object)("The same name already exists, but the protocol is different.The zone name is " + ImportThread.getcleanedMessage(dbInfoForm.getZoneDesc())));
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572035L, this.frontOperationList);
            }
        } else {
            this.createZone(xmlPolicyForm, servicePort);
        }
        this.logger.info((Object)("The importZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void updateZonePolicy(ZoneInfoForm dbInfoForm, ZonePolicyApplyForm xmlPolicyForm, String servicePort) {
        Long zoneInfoId = dbInfoForm.getZoneId();
        this.logger.info((Object)("importType zoneInfoId=" + zoneInfoId));
        ZonePolicyApplyForm policyApplyForm = this.zonePolicyApplyService.queryByZoneId(zoneInfoId);
        if (null != policyApplyForm) {
            if (this.importForm.isNeedMode()) {
                if (CheckImportXml.checkDefenseMode((ZonePolicyApplyForm)xmlPolicyForm, this.frontOperationList, (String)this.importData.getZoneString())) {
                    this.saveZonePolicyUpdate(policyApplyForm, xmlPolicyForm, dbInfoForm, zoneInfoId, servicePort);
                }
            } else {
                this.saveZonePolicyUpdate(policyApplyForm, xmlPolicyForm, dbInfoForm, zoneInfoId, servicePort);
            }
        }
    }

    private void undateZoneBasicInfo(ZoneInfoForm infoForm, ZoneInfoForm zoneInfoForm) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The undateZone() start time is  " + startTime + "ms"));
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        if (this.importForm.isNeedIp()) {
            ZoneInfoForm zInfoForm = this.zoneService.getById(infoForm.getZoneId());
            List zoneListIpForms = zInfoForm.getZoneListIpFormList();
            List zonePortMapForms = zInfoForm.getZonePortMapFormList();
            if (null != zoneListIpForms) {
                this.zoneService.deleteListIpAndIpState(zoneListIpForms);
            }
            if (null != zonePortMapForms) {
                this.zoneService.deletePortMapAndMapState(zonePortMapForms);
            }
            infoForm.setZoneListIpFormList(zoneInfoForm.getZoneListIpFormList());
            infoForm.setZonePortMapFormList(zoneInfoForm.getZonePortMapFormList());
        }
        infoForm.setZoneDesc(zoneInfoForm.getZoneDesc());
        infoForm.setContact(zoneInfoForm.getContact());
        infoForm.setTelephone(zoneInfoForm.getTelephone());
        infoForm.setMobile(zoneInfoForm.getMobile());
        if (!AticUtil.isNull((String)zoneInfoForm.getIndustry())) {
            infoForm.setIndustry(zoneInfoForm.getIndustry());
        } else {
            infoForm.setIndustry("Gaming");
        }
        infoForm.setAddress(zoneInfoForm.getAddress());
        infoForm.setPost(zoneInfoForm.getPost());
        infoForm.setEmail(zoneInfoForm.getEmail());
        infoForm.setRemark(zoneInfoForm.getRemark());
        this.logger.info((Object)("The undateZone() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void createZone(ZonePolicyApplyForm xmlPolicyForm, String servicePort) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The createZone() start time is " + startTime));
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        try {
            ZoneInfoForm nZoneInfoForm = xmlPolicyForm.getZoneInfoForm();
            nZoneInfoForm.setZoneId(null);
            if (this.importForm.isNeedMode()) {
                if (CheckImportXml.checkDefenseMode((ZonePolicyApplyForm)xmlPolicyForm, this.frontOperationList, (String)this.importData.getZoneString())) {
                    this.saveZonePolicyCreate(xmlPolicyForm, nZoneInfoForm, servicePort);
                }
            } else {
                xmlPolicyForm.setDivertMode(Integer.valueOf(0));
                xmlPolicyForm.setDefendMode(Integer.valueOf(0));
                xmlPolicyForm.setDynamicBlackMode(Integer.valueOf(0));
                this.saveZonePolicyCreate(xmlPolicyForm, nZoneInfoForm, servicePort);
            }
        }
        catch (LegoCheckedException e) {
            Locker.getInstance().setImportFlag(false);
            this.logger.info((Object)("Save zone error,zoneInfo.name = " + xmlPolicyForm.getZoneInfoForm().getZoneName() + ", LegoCheckedException,e=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), e.getErrorCode(), this.frontOperationList);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        this.logger.info((Object)("The createZone() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void saveZonePolicyCreate(ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm nZoneInfoForm, String servicePort) {
        long startTime = System.currentTimeMillis();
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        Object[] params = new Object[]{null, this.logger, xmlPolicyForm.getZoneInfoForm().getZoneListIpFormList(), nZoneInfoForm, this.importData.getUserId(), this.logger, xmlPolicyForm.getZoneInfoForm().getZonePortMapFormList()};
        Long zoneInfoId = ZoneUtil.saveZoneInfoAndIp((Object[])params);
        ZoneUtil.saveFaultSeverityRule((long)zoneInfoId, (FaultSeverityRuleForm)xmlPolicyForm.getFaultSeverityRuleForm());
        ZoneUtil.saveFaultSeverityRule((long)zoneInfoId, (FaultSeverityRuleForm)xmlPolicyForm.getOutboundFaultSeverityRuleForm());
        String deviceIds = "";
        Map<Object, Object> zoneDevMap = new HashMap();
        if (this.importForm.isNeedPolicy()) {
            this.parserZoneDeviceVPN(xmlPolicyForm, zoneInfoId);
            zoneDevMap = ImportUtil.getZoneDeviceMap(xmlPolicyForm.getZoneDeviceForms());
        } else {
            xmlPolicyForm.setZoneDeviceForms(new ArrayList());
        }
        this.logger.info((Object)("zoneInfoForm.deviceId : " + deviceIds));
        this.parserZonePolicyLocation(xmlPolicyForm, null, zoneInfoId);
        this.parserZonePolicyBlackList(xmlPolicyForm, null, zoneInfoId);
        this.parserZonePolicyWhiteList(xmlPolicyForm, null, zoneInfoId);
        if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && null != xmlPolicyForm.getFilterNameList() && !xmlPolicyForm.getFilterNameList().isEmpty() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            if (null != xmlPolicyForm.getFilterNameList() && !xmlPolicyForm.getFilterNameList().isEmpty()) {
                this.parserZoneFilter(xmlPolicyForm, filterService, true);
            }
        } else if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            this.logger.info((Object)"The protection object is not associated with the device, and the associated filter is not imported.");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
            xmlPolicyForm.setFilterNameList(new ArrayList());
            xmlPolicyForm.setFilterIdList(new ArrayList());
        }
        if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && null != xmlPolicyForm.getOutboundFilterNameList() && !xmlPolicyForm.getOutboundFilterNameList().isEmpty() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            if (null != xmlPolicyForm.getOutboundFilterNameList() && !xmlPolicyForm.getOutboundFilterNameList().isEmpty()) {
                this.parserZoneFilter(xmlPolicyForm, filterService, false);
            }
        } else if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            this.logger.info((Object)"The protection object is not associated with the device, and the associated filter is not imported.");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
            xmlPolicyForm.setOutboundFilterNameList(new ArrayList());
            xmlPolicyForm.setOutboundFilterIdList(new ArrayList());
        }
        xmlPolicyForm.setZoneId(zoneInfoId);
        xmlPolicyForm.setZoneInfoForm(this.zoneService.getById(zoneInfoId));
        xmlPolicyForm.setAbnormalState("NORMAL");
        xmlPolicyForm.setDeployState("UNDEPLOY");
        ZoneUtil.saveZonePolicy((ZonePolicyApplyForm)xmlPolicyForm);
        this.logger.info((Object)("The saveZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
        if (null != xmlPolicyForm.getZoneServices() && this.importForm.isNeedPolicy() && null != xmlPolicyForm.getZoneDeviceForms() && !xmlPolicyForm.getZoneDeviceForms().isEmpty() && !AticUtil.isNull((String)((ZoneDeviceForm)xmlPolicyForm.getZoneDeviceForms().get(0)).getDeviceIp())) {
            List zoneServiceFormList = xmlPolicyForm.getZoneServices();
            ImportUtil.removeAllSameNameService(zoneServiceFormList, this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.frontOperationList);
            if (null == zoneServiceFormList || zoneServiceFormList.isEmpty()) {
                return;
            }
            for (ZoneServiceForm serviceForm : zoneServiceFormList) {
                if (ImportUtil.checkIsTaskCancled(this.importData)) {
                    return;
                }
                ++this.totalRow;
                Integer portListLimit = 0;
                ArrayList<String> servicePort1 = new ArrayList<String>();
                ArrayList<Integer> portListLimit1 = new ArrayList<Integer>();
                servicePort1.add(servicePort);
                portListLimit1.add(portListLimit);
                servicePort = (String)servicePort1.get(0);
                portListLimit = (Integer)portListLimit1.get(0);
                serviceForm.setZoneId(zoneInfoId);
                try {
                    if (!AticUtil.isNull((String)serviceForm.getDeviceIp())) {
                        if (null != zoneDevMap.get(serviceForm.getDeviceIp())) {
                            serviceForm.setDeviceId(((ZoneDeviceForm)zoneDevMap.get(serviceForm.getDeviceIp())).getDeviceId());
                            String[] parmas = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importData.getPolicyString(), this.importData.getZoneString()};
                            if (!CheckImportXml.checkPolicyItem((ZoneServiceForm)serviceForm, (List)xmlPolicyForm.getZoneServices(), this.frontOperationList, (String[])parmas) || !"DEFAULT".equals(serviceForm.getProtocol()) && !CheckImportXml.checkServiceProtocalAndPort((ZoneServiceForm)serviceForm, (ZonePolicyApplyForm)xmlPolicyForm, this.frontOperationList, (String)this.importData.getZoneString(), (String)this.importData.getPolicyString())) continue;
                            serviceForm.setZoneId(zoneInfoId);
                            serviceForm.setDeployState(Boolean.valueOf(false));
                            Object[] parameters = new Object[]{this.logger, serviceForm, portListLimit, null != serviceForm.getPortList() ? serviceForm.getPortList().split(";") : new String[]{}, servicePort, null != serviceForm.getIpList() ? serviceForm.getIpList().split(";") : new String[]{}};
                            ZoneUtil.saveZoneService((Object[])parameters, (User)this.currentUser);
                            continue;
                        }
                        ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceForm.getServiceName(), 572017L, this.frontOperationList);
                        continue;
                    }
                    serviceForm.setDeployState(Boolean.valueOf(false));
                    Object[] parameters = new Object[]{this.logger, serviceForm, portListLimit, serviceForm.getPortList().split(";"), servicePort, serviceForm.getIpList().split(";")};
                    ZoneUtil.saveZoneService((Object[])parameters, (User)this.currentUser);
                }
                catch (LegoCheckedException e) {
                    this.logger.info((Object)("saveZoneService error, serviceForm.name = " + ImportThread.getcleanedMessage(serviceForm.getServiceName()) + ", LegoCheckedException=" + ImportThread.getcleanedMessage(e.getMessage())));
                    ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceForm.getServiceName(), e.getErrorCode(), this.frontOperationList);
                }
            }
        } else if (this.importForm.isNeedPolicy() && xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572028L, this.frontOperationList);
        }
        this.logger.info((Object)("The saveZonePolicyCreate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void parserZoneDeviceVPN(ZonePolicyApplyForm xmlPolicyForm, long zoneInfoId) {
        if (!this.importForm.isNeedPolicy()) {
            return;
        }
        if (null != xmlPolicyForm.getZoneDeviceForms() && !xmlPolicyForm.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zDeviceForm : xmlPolicyForm.getZoneDeviceForms()) {
                ++this.totalRow;
                if (!AticUtil.isNull((String)zDeviceForm.getVpnName())) {
                    if (!this.checkVpnExist(zDeviceForm, xmlPolicyForm.getZoneInfoForm().getZoneDesc())) {
                        zDeviceForm.setVpnName("");
                    }
                } else {
                    zDeviceForm.setVpnName("");
                }
                zDeviceForm.setZoneId(Long.valueOf(zoneInfoId));
            }
        }
    }

    private List<Long> getDeviceIdList(ZonePolicyApplyForm policyApplyForm) {
        ArrayList<Long> deviceIdList = new ArrayList<Long>();
        if (null != policyApplyForm && null != policyApplyForm.getZoneDeviceForms() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            for (ZoneDeviceForm zdForm : policyApplyForm.getZoneDeviceForms()) {
                deviceIdList.add(zdForm.getDeviceId());
            }
        }
        return deviceIdList;
    }

    private void parserZoneMode(ZonePolicyApplyForm policyApplyForm, ZonePolicyApplyForm appForm) {
        if (!this.importForm.isNeedMode()) {
            return;
        }
        policyApplyForm.setDivertMode(appForm.getDivertMode());
        policyApplyForm.setDefendMode(appForm.getDefendMode());
        policyApplyForm.setDynamicBlackMode(appForm.getDynamicBlackMode());
        policyApplyForm.setZoneLimitEnable(appForm.getZoneLimitEnable());
        policyApplyForm.setZoneLimitRate(appForm.getZoneLimitRate());
        policyApplyForm.setIpLimitEnable(appForm.getIpLimitEnable());
        policyApplyForm.setIpLimit(appForm.getIpLimit());
        policyApplyForm.setBtwEnable(appForm.getBtwEnable());
        policyApplyForm.setCncEnable(appForm.getCncEnable());
        policyApplyForm.setWebEnable(appForm.getWebEnable());
        policyApplyForm.setDosEnable(appForm.getDosEnable());
        policyApplyForm.setAuditEnable(appForm.getAuditEnable());
        policyApplyForm.setIpReputationEnable(appForm.getIpReputationEnable());
        policyApplyForm.setIpReputationAlarmThreshold(appForm.getIpReputationAlarmThreshold());
        policyApplyForm.setNewDestSessionLimitEnable(appForm.getNewDestSessionLimitEnable());
        policyApplyForm.setDestSessionLimit(appForm.getDestSessionLimit());
        policyApplyForm.setFilterDropThreshold(appForm.getFilterDropThreshold());
        policyApplyForm.setBlackholeEnable(appForm.getBlackholeEnable());
        policyApplyForm.setBlackholeType(appForm.getBlackholeType());
        policyApplyForm.setBlackholeThreshold(appForm.getBlackholeThreshold());
        policyApplyForm.setGlobalFilterEnable(appForm.getGlobalFilterEnable());
        policyApplyForm.setOutBoundFilterDropThreshold(appForm.getOutBoundFilterDropThreshold());
        policyApplyForm.setOutBoundFilterAction(appForm.getOutBoundFilterAction());
        policyApplyForm.setOutBoundFilterLimit(appForm.getOutBoundFilterLimit());
        policyApplyForm.setOutBoundNextHop(appForm.getOutBoundNextHop());
    }

    private void parserZoneFilter(ZonePolicyApplyForm policyApplyForm, ZonePolicyApplyForm appForm) {
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && null != appForm.getFilterNameList() && !appForm.getFilterNameList().isEmpty() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            if (null != appForm.getFilterNameList() && !appForm.getFilterNameList().isEmpty()) {
                this.parserZoneFilter(appForm, filterService, true);
            }
            policyApplyForm.setFilterPreferenceList(appForm.getFilterPreferenceList());
            policyApplyForm.setFilterIdList(appForm.getFilterIdList());
            policyApplyForm.setFilterNameList(appForm.getFilterNameList());
        }
        if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && null != appForm.getOutboundFilterNameList() && !appForm.getOutboundFilterNameList().isEmpty() && !policyApplyForm.getZoneDeviceForms().isEmpty()) {
            if (null != appForm.getOutboundFilterNameList() && !appForm.getOutboundFilterNameList().isEmpty()) {
                this.parserZoneFilter(appForm, filterService, false);
            }
            policyApplyForm.setOutboundFilterPreferenceList(appForm.getOutboundFilterPreferenceList());
            policyApplyForm.setOutboundFilterIdList(appForm.getOutboundFilterIdList());
            policyApplyForm.setOutboundFilterNameList(appForm.getOutboundFilterNameList());
        } else if (this.importForm.isNeedFilter() && this.importForm.isNeedPolicy() && policyApplyForm.getZoneDeviceForms().isEmpty()) {
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + appForm.getZoneInfoForm().getZoneDesc(), 572031L, this.frontOperationList);
        }
    }

    private void saveZoneService(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm, long zoneInfoId, String servicePort) {
        List<Long> deviceIdList = this.getDeviceIdList(dbPolicyForm);
        Map<String, AticDevice> dbZoneDeviceMap = this.getZoneDeviceMap(dbPolicyForm);
        if (this.importForm.isNeedPolicy() && null != dbPolicyForm.getZoneDeviceForms() && !dbPolicyForm.getZoneDeviceForms().isEmpty()) {
            List dbZoneServiceList = this.zoneServiceService.queryZoneServicesByZoneId(dbPolicyForm.getZoneId(), deviceIdList);
            HashMap<String, ZoneServiceForm> dbZoneServiceMap = new HashMap<String, ZoneServiceForm>();
            if (null != dbZoneServiceList && !dbZoneServiceList.isEmpty()) {
                for (ZoneServiceForm serviceForm : dbZoneServiceList) {
                    dbZoneServiceMap.put(serviceForm.getServiceName() + "/" + serviceForm.getDeviceId(), serviceForm);
                }
            }
            if (null != xmlPolicyForm.getZoneServices() && !xmlPolicyForm.getZoneServices().isEmpty()) {
                List xmlZoneServiceFormList = xmlPolicyForm.getZoneServices();
                ImportUtil.removeAllSameNameService(xmlZoneServiceFormList, this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.frontOperationList);
                if (null == xmlZoneServiceFormList || xmlZoneServiceFormList.isEmpty()) {
                    return;
                }
                for (ZoneServiceForm xmlServiceForm : xmlZoneServiceFormList) {
                    if (ImportUtil.checkIsTaskCancled(this.importData)) {
                        return;
                    }
                    if (!this.validatePolicyBasicInfo(xmlServiceForm, xmlPolicyForm, ImportZoneConstant.getProtocoList())) continue;
                    ++this.totalRow;
                    try {
                        xmlServiceForm.setZoneId(Long.valueOf(zoneInfoId));
                        if ("DEFAULT".equals(xmlServiceForm.getProtocol()) && null == dbZoneDeviceMap.get(xmlServiceForm.getDeviceIp())) {
                            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + xmlServiceForm.getServiceName(), 572017L, this.frontOperationList);
                            continue;
                        }
                        if (!CheckImportXml.checkServiceProtocalAndPort((ZoneServiceForm)xmlServiceForm, (ZonePolicyApplyForm)xmlPolicyForm, this.frontOperationList, (String)this.importData.getZoneString(), (String)this.importData.getPolicyString())) continue;
                        ZonePolicyParamsBean zonePolicyParamsBean = new ZonePolicyParamsBean();
                        zonePolicyParamsBean.setDbZoneServiceMap(dbZoneServiceMap);
                        zonePolicyParamsBean.setXmlServiceForm(xmlServiceForm);
                        zonePolicyParamsBean.setXmlPolicyForm(xmlPolicyForm);
                        zonePolicyParamsBean.setServicePort(servicePort);
                        zonePolicyParamsBean.setZoneInfoId(Long.valueOf(zoneInfoId));
                        zonePolicyParamsBean.setDbZoneDeviceMap(dbZoneDeviceMap);
                        this.updateZonePolicySaveService(zonePolicyParamsBean);
                    }
                    catch (LegoCheckedException e) {}
                }
            }
        } else if (this.importForm.isNeedPolicy() && null != dbPolicyForm.getZoneDeviceForms() && dbPolicyForm.getZoneDeviceForms().isEmpty()) {
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), 572028L, this.frontOperationList);
        }
    }

    private void parserZoneDevice(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm) {
        List xmlZoneDeviceList;
        ArrayList<ZoneDeviceForm> dbZoneDeviceList = dbPolicyForm.getZoneDeviceForms();
        if (dbZoneDeviceList == null) {
            dbZoneDeviceList = new ArrayList<ZoneDeviceForm>();
        }
        if (null != (xmlZoneDeviceList = xmlPolicyForm.getZoneDeviceForms())) {
            for (ZoneDeviceForm xmlForm : xmlZoneDeviceList) {
                boolean isExisted = false;
                for (ZoneDeviceForm dbForm : dbZoneDeviceList) {
                    if (!dbForm.getDeviceIp().equals(xmlForm.getDeviceIp())) continue;
                    isExisted = true;
                    break;
                }
                if (isExisted) continue;
                dbZoneDeviceList.add(xmlForm);
            }
        }
    }

    private void saveZonePolicyUpdate(ZonePolicyApplyForm dbPolicyForm, ZonePolicyApplyForm xmlPolicyForm, ZoneInfoForm dbInfoForm, long zoneInfoId, String servicePort) {
        long startTime = System.currentTimeMillis();
        this.logger.info((Object)("The saveZonePolicyUpdate() start time is " + startTime));
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        this.parserZoneDevice(dbPolicyForm, xmlPolicyForm);
        this.parserZoneDeviceVPN(xmlPolicyForm, zoneInfoId);
        this.parserZoneMode(dbPolicyForm, xmlPolicyForm);
        this.parserZoneFilter(dbPolicyForm, xmlPolicyForm);
        this.parserZonePolicyLocation(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        this.parserZonePolicyBlackList(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        this.parserZonePolicyWhiteList(xmlPolicyForm, dbPolicyForm, zoneInfoId);
        try {
            Object[] params = new Object[]{dbInfoForm.getZoneId(), this.logger, dbInfoForm.getZoneListIpFormList(), dbInfoForm, this.importData.getUserId(), this.logger, dbInfoForm.getZonePortMapFormList()};
            ZoneUtil.saveZoneInfoAndIp((Object[])params);
            ZoneUtil.saveFaultSeverityRule((long)zoneInfoId, (FaultSeverityRuleForm)xmlPolicyForm.getFaultSeverityRuleForm());
            ZoneUtil.saveFaultSeverityRule((long)zoneInfoId, (FaultSeverityRuleForm)xmlPolicyForm.getOutboundFaultSeverityRuleForm());
            if (this.importForm.isNeedFilter() || this.importForm.isNeedLocation() || this.importForm.isNeedMode() || this.importForm.isNeedPolicy()) {
                ZoneUtil.saveZonePolicy((ZonePolicyApplyForm)dbPolicyForm);
                this.logger.info((Object)("The saveZonePolicy() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (LegoCheckedException e) {
            Locker.getInstance().setImportFlag(false);
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc(), e.getErrorCode(), this.frontOperationList);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        this.saveZoneService(dbPolicyForm, xmlPolicyForm, zoneInfoId, servicePort);
        this.logger.info((Object)("The saveZonePolicyUpdate() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private void parserZonePolicyWhiteList(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.importForm.isNeedPolicy()) {
            return;
        }
        if (this.importForm.isNeedPolicy() && null != xmlPolicyForm.getZoneWhiteFormList() && !xmlPolicyForm.getZoneWhiteFormList().isEmpty()) {
            List zoneWhiteFormList = xmlPolicyForm.getZoneWhiteFormList();
            int importSize = zoneWhiteFormList.size();
            if (importSize > 1000) {
                ImportZoneUtil.recordErrorMessg((String)(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc()), (long)631080L, this.frontOperationList);
                return;
            }
            String zoneStringAndZoneDesc = this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc();
            ArrayList<ZoneBlackWhiteForm> zoneBlackWhiteFormList = new ArrayList<ZoneBlackWhiteForm>();
            for (ZoneWhiteForm zoneWhiteForm : zoneWhiteFormList) {
                ZoneBlackWhiteForm zoneBlackWhiteForm = new ZoneBlackWhiteForm();
                VsmUtil.getInstance().copyProperties((Object)zoneWhiteForm, (Object)zoneBlackWhiteForm);
                zoneBlackWhiteFormList.add(zoneBlackWhiteForm);
            }
            this.blackWhiteListService.importSaveBlackWhiteList(zoneBlackWhiteFormList, this.frontOperationList, zoneStringAndZoneDesc, Long.valueOf(zoneInfoId));
            if (null != dbPolicyForm) {
                dbPolicyForm.setZoneWhiteFormList(xmlPolicyForm.getZoneWhiteFormList());
            }
        }
    }

    private void parserZonePolicyBlackList(ZonePolicyApplyForm xmlPolicyForm, ZonePolicyApplyForm dbPolicyForm, long zoneInfoId) {
        if (!this.importForm.isNeedPolicy()) {
            return;
        }
        if (this.importForm.isNeedPolicy() && null != xmlPolicyForm.getZoneBlackWhiteFormList() && !xmlPolicyForm.getZoneBlackWhiteFormList().isEmpty()) {
            List zoneBlackWhiteFormList = xmlPolicyForm.getZoneBlackWhiteFormList();
            int importSize = zoneBlackWhiteFormList.size();
            if (importSize > 1000) {
                ImportZoneUtil.recordErrorMessg((String)(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc()), (long)631080L, this.frontOperationList);
                return;
            }
            String zoneStringAndZoneDesc = this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneDesc();
            this.blackWhiteListService.importSaveBlackWhiteList(zoneBlackWhiteFormList, this.frontOperationList, zoneStringAndZoneDesc, Long.valueOf(zoneInfoId));
            if (null != dbPolicyForm) {
                dbPolicyForm.setZoneBlackWhiteFormList(xmlPolicyForm.getZoneBlackWhiteFormList());
            }
        }
    }

    private void parserZoneFilter(ZonePolicyApplyForm xmlPolicyForm, IFilterService filterService, boolean isInbound) {
        Long inboundPreferrenceDefault = ImportZoneConstant.FILTER_PREFERENCE_DEFAULT;
        Long outboundPreferrenceDefault = ImportZoneConstant.OUTBOUND_FILTER_PREFERENCE_DEFAULT;
        ArrayList<Long> filterIdList = new ArrayList<Long>();
        ArrayList<Long> filterPreferenceList = new ArrayList<Long>();
        ArrayList<String> temNameList = new ArrayList<String>();
        List filterNameList = null;
        filterNameList = isInbound ? xmlPolicyForm.getFilterNameList() : xmlPolicyForm.getOutboundFilterNameList();
        for (String filterName : filterNameList) {
            ++this.totalRow;
            if (AticUtil.isNull((String)filterName)) continue;
            FilterForm filterForm = filterService.queryByName(filterName);
            if (null != filterForm) {
                filterForm.setFilterId(filterForm.getFilterId());
                if (isInbound) {
                    filterPreferenceList.add(inboundPreferrenceDefault);
                    inboundPreferrenceDefault = inboundPreferrenceDefault + ImportZoneConstant.FILTER_PREFERENCE_DEFAULT;
                } else {
                    filterPreferenceList.add(outboundPreferrenceDefault);
                    outboundPreferrenceDefault = outboundPreferrenceDefault + ImportZoneConstant.OUTBOUND_FILTER_PREFERENCE;
                }
                temNameList.add(filterForm.getFilterName());
                filterIdList.add(filterForm.getPkid());
                continue;
            }
            this.logger.info((Object)("The filter object associated with the protection object is not present on the ATIC.The filter name = " + filterName));
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + xmlPolicyForm.getZoneInfoForm().getZoneName() + "/" + filterName, 572018L, this.frontOperationList);
        }
        if (isInbound) {
            xmlPolicyForm.setFilterPreferenceList(filterPreferenceList);
            xmlPolicyForm.setFilterIdList(filterIdList);
            xmlPolicyForm.setFilterNameList(temNameList);
        } else {
            xmlPolicyForm.setOutboundFilterPreferenceList(filterPreferenceList);
            xmlPolicyForm.setOutboundFilterIdList(filterIdList);
            xmlPolicyForm.setOutboundFilterNameList(temNameList);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateZonePolicySaveService(ZonePolicyParamsBean zonePolicyParamsBean) {
        dbZoneServiceMap = zonePolicyParamsBean.getDbZoneServiceMap();
        xmlServiceForm = zonePolicyParamsBean.getXmlServiceForm();
        xmlPolicyForm = zonePolicyParamsBean.getXmlPolicyForm();
        servicePort = zonePolicyParamsBean.getServicePort();
        zoneInfoId = zonePolicyParamsBean.getZoneInfoId();
        dbZoneDeviceMap = zonePolicyParamsBean.getDbZoneDeviceMap();
        startTime = System.currentTimeMillis();
        portListLimit = 0;
        this.logger.info((Object)("The updateZonePolicySaveService() start time is " + startTime));
        if (!AticUtil.isNull((String)xmlServiceForm.getDeviceIp())) {
            aticDevice = (AticDevice)dbZoneDeviceMap.get(xmlServiceForm.getDeviceIp());
            if (null != aticDevice) {
                xmlServiceForm.setDeviceId(Long.valueOf(aticDevice.getMoId()));
                xmlServiceForm.setDeviceName(aticDevice.getName());
                dbZoneServiceForm = (ZoneServiceForm)dbZoneServiceMap.get(xmlServiceForm.getServiceName() + "/" + xmlServiceForm.getDeviceId());
                try {
                    if (null != dbZoneServiceForm) {
                        params = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importData.getPolicyString(), this.importData.getZoneString()};
                        if (!CheckImportXml.checkPolicyItem((ZoneServiceForm)xmlServiceForm, (List)xmlPolicyForm.getZoneServices(), this.frontOperationList, (String[])params)) ** GOTO lbl109
                        dbZoneServiceForm.setDeviceId(xmlServiceForm.getDeviceId());
                        dbZoneServiceForm.setDeviceName(xmlServiceForm.getDeviceName());
                        dbZoneServiceForm.setProtocol(xmlServiceForm.getProtocol());
                        dbZoneServiceForm.setProtocolNum(xmlServiceForm.getProtocolNum());
                        dbZoneServiceForm.setIpList(xmlServiceForm.getIpList());
                        dbZoneServiceForm.setPortList(xmlServiceForm.getPortList());
                        dbZoneServiceForm.setDescription(xmlServiceForm.getDescription());
                        tcpTemPolicyForm = xmlServiceForm.getTcpDefendPolicyForm();
                        if (null != tcpTemPolicyForm) {
                            if (null != dbZoneServiceForm.getTcpDefendPolicyForm()) {
                                tcpTemPolicyForm.setId(dbZoneServiceForm.getTcpDefendPolicyForm().getId());
                                tcpTemPolicyForm.setServiceId(dbZoneServiceForm.getTcpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setTcpDefendPolicyForm(tcpTemPolicyForm);
                        }
                        if (null != (udpTempForm = xmlServiceForm.getUdpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getUdpDefendPolicyForm()) {
                                udpTempForm.setId(dbZoneServiceForm.getUdpDefendPolicyForm().getId());
                                udpTempForm.setServiceId(dbZoneServiceForm.getUdpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setUdpDefendPolicyForm(udpTempForm);
                        }
                        if (null != (icmTempForm = xmlServiceForm.getIcmpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getIcmpDefendPolicyForm()) {
                                icmTempForm.setId(dbZoneServiceForm.getIcmpDefendPolicyForm().getId());
                                icmTempForm.setServiceId(dbZoneServiceForm.getIcmpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setIcmpDefendPolicyForm(icmTempForm);
                        }
                        if (null != (httpTempForm = xmlServiceForm.getHttpDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getHttpDefendPolicyForm()) {
                                httpTempForm.setId(dbZoneServiceForm.getHttpDefendPolicyForm().getId());
                                httpTempForm.setServiceId(dbZoneServiceForm.getHttpDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setHttpDefendPolicyForm(httpTempForm);
                        }
                        if (null != (dnsTemPolicyForm = xmlServiceForm.getDnsDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getDnsDefendPolicyForm()) {
                                dnsTemPolicyForm.setId(dbZoneServiceForm.getDnsDefendPolicyForm().getId());
                                dnsTemPolicyForm.setServiceId(dbZoneServiceForm.getDnsDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setDnsDefendPolicyForm(dnsTemPolicyForm);
                        }
                        if (null != (httpsTemPolicyForm = xmlServiceForm.getHttpsDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getHttpsDefendPolicyForm()) {
                                httpsTemPolicyForm.setId(dbZoneServiceForm.getHttpsDefendPolicyForm().getId());
                                httpsTemPolicyForm.setServiceId(dbZoneServiceForm.getHttpsDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setHttpsDefendPolicyForm(httpsTemPolicyForm);
                        }
                        if (null != (sipTemPolicyForm = xmlServiceForm.getSipDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getSipDefendPolicyForm()) {
                                sipTemPolicyForm.setId(dbZoneServiceForm.getSipDefendPolicyForm().getId());
                                sipTemPolicyForm.setServiceId(dbZoneServiceForm.getSipDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setSipDefendPolicyForm(sipTemPolicyForm);
                        }
                        if (null != (otPolicyForm = xmlServiceForm.getOtherDefendPolicyForm())) {
                            if (null != dbZoneServiceForm.getOtherDefendPolicyForm()) {
                                otPolicyForm.setId(dbZoneServiceForm.getOtherDefendPolicyForm().getId());
                                otPolicyForm.setServiceId(dbZoneServiceForm.getOtherDefendPolicyForm().getServiceId());
                            }
                            dbZoneServiceForm.setOtherDefendPolicyForm(otPolicyForm);
                        }
                        if (null != (topNStudyForm = xmlServiceForm.getTopNStudyForm())) {
                            if (null != dbZoneServiceForm.getTopNStudyForm()) {
                                topNStudyForm.setId(dbZoneServiceForm.getTopNStudyForm().getId());
                                topNStudyForm.setServiceId(dbZoneServiceForm.getTopNStudyForm().getServiceId());
                            }
                            dbZoneServiceForm.setTopNStudyForm(topNStudyForm);
                        }
                        servicePort1 = new ArrayList<String>();
                        portListLimit1 = new ArrayList<Integer>();
                        servicePort1.add(servicePort);
                        portListLimit1.add(portListLimit);
                        servicePort = (String)servicePort1.get(0);
                        portListLimit = (Integer)portListLimit1.get(0);
                        dbZoneServiceForm.setDeployState(Boolean.valueOf(false));
                        parameters = new Object[]{this.logger, dbZoneServiceForm, portListLimit, dbZoneServiceForm.getPortList().split(";"), servicePort, dbZoneServiceForm.getIpList().split(";")};
                        ZoneUtil.saveZoneService((Object[])parameters, (User)this.currentUser);
                    }
                    xmlServiceForm.setZoneId(zoneInfoId);
                    servicePort1 = new ArrayList<String>();
                    portListLimit1 = new ArrayList<Integer>();
                    servicePort1.add(servicePort);
                    portListLimit1.add(portListLimit);
                    xmlServiceForm.setDeployState(Boolean.valueOf(false));
                    params = new String[]{xmlPolicyForm.getZoneInfoForm().getZoneDesc(), this.importData.getPolicyString(), this.importData.getZoneString()};
                    if (!CheckImportXml.checkPolicyItem((ZoneServiceForm)xmlServiceForm, (List)xmlPolicyForm.getZoneServices(), this.frontOperationList, (String[])params)) ** GOTO lbl109
                    checkProtocalAndPort = true;
                    if (!"DEFAULT".equals(xmlServiceForm.getProtocol()) && !CheckImportXml.checkServiceProtocalAndPort((ZoneServiceForm)xmlServiceForm, (ZonePolicyApplyForm)xmlPolicyForm, this.frontOperationList, (String)this.importData.getZoneString(), (String)this.importData.getPolicyString())) {
                        checkProtocalAndPort = false;
                    }
                    if (!checkProtocalAndPort) ** GOTO lbl109
                    parameters = new Object[]{this.logger, xmlServiceForm, portListLimit1.get(0), xmlServiceForm.getPortList().split(";"), servicePort1.get(0), xmlServiceForm.getIpList().split(";")};
                    ZoneUtil.saveZoneService((Object[])parameters, (User)this.currentUser);
                }
                catch (LegoCheckedException e) {
                    Locker.getInstance().setImportFlag(false);
                    serviceName = "";
                    serviceName = null == dbZoneServiceForm ? xmlServiceForm.getServiceName() : dbZoneServiceForm.getServiceName();
                    ImportUtil.recordErrorMessg(xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + serviceName, e.getErrorCode(), this.frontOperationList);
                    throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
                }
            } else {
                ImportUtil.recordErrorMessg(xmlPolicyForm.getZoneInfoForm().getZoneDesc() + "/" + xmlServiceForm.getServiceName(), 572017L, this.frontOperationList);
            }
        }
lbl109:
        // 8 sources

        this.logger.info((Object)("The updateZonePolicySaveService() used times is " + (System.currentTimeMillis() - startTime) + "ms"));
    }

    private BatchOperationResult parserImportOperationResult() {
        if (this.importData.isRestful()) {
            return new BatchOperationResult();
        }
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
            for (BatchOperation batchOperation : this.frontOperationList) {
                batchOpList.add(batchOperation);
            }
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        batchOperationResult.setResult(batchOpList);
        batchOperationResult.setFailCount(batchOpList.size());
        batchOperationResult.setTotalCount(this.totalRow);
        batchOperationResult.setSucceedCount(this.totalRow - batchOpList.size());
        StringBuffer sb = new StringBuffer();
        if ("zone".equals(this.importType)) {
            Object zoneNames;
            if (null != this.importFailedZoneNameList && !this.importFailedZoneNameList.isEmpty()) {
                for (String zoneName : this.importFailedZoneNameList) {
                    sb = sb.append(zoneName + ",");
                }
                zoneNames = sb.toString();
                if (((String)zoneNames).endsWith(",")) {
                    zoneNames = ((String)zoneNames).substring(0, ((String)zoneNames).length() - 1);
                }
                this.processOpeLog((String)zoneNames, false);
            } else if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
                this.processOpeLog(sb.toString(), false);
            } else {
                for (ZonePolicyApplyForm zApplyForm : this.importForm.getZoneFormList()) {
                    sb = sb.append(zApplyForm.getZoneInfoForm().getZoneDesc() + ",");
                }
                zoneNames = sb.toString();
                if (((String)zoneNames).endsWith(",")) {
                    zoneNames = ((String)zoneNames).substring(0, ((String)zoneNames).length() - 1);
                }
                this.processOpeLog((String)zoneNames, true);
            }
        }
        if ("device".equals(this.importType)) {
            if (!this.importZoneByDeviceIsSucess) {
                this.processOpeLog(this.importForm.getDeviceIp(), false);
            } else if (null != this.importFailedZoneNameList && !this.importFailedZoneNameList.isEmpty()) {
                for (String zoneName : this.importFailedZoneNameList) {
                    sb = sb.append(zoneName + ",");
                }
                this.processOpeLog(sb.toString(), false);
            } else if (null != this.frontOperationList && !this.frontOperationList.isEmpty()) {
                this.processOpeLog(sb.toString(), false);
            } else {
                this.processOpeLog(this.importForm.getDeviceIp(), true);
            }
        }
        return batchOperationResult;
    }

    private Map<String, AticDevice> getZoneDeviceMap(ZonePolicyApplyForm policyApplyForm) {
        HashMap<String, AticDevice> zoneDevMap = new HashMap<String, AticDevice>();
        if (null != policyApplyForm && null != policyApplyForm.getZoneDeviceForms()) {
            for (ZoneDeviceForm zoneDeviceForm : policyApplyForm.getZoneDeviceForms()) {
                AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(zoneDeviceForm.getDeviceIp());
                if (null == aticDevice) continue;
                zoneDevMap.put(aticDevice.getIpAddress(), aticDevice);
            }
        }
        return zoneDevMap;
    }

    private boolean checkDeviceExist(ZoneDeviceForm zDeviceForm, String zoneName) {
        if (!this.importForm.isNeedPolicy()) {
            return false;
        }
        if (AticUtil.isNull((String)zDeviceForm.getDeviceIp())) {
            this.logger.info((Object)("Devices associated with the object are not present on the target ATIC.The deviceIp=" + zDeviceForm.getDeviceIp()));
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName, 572040L, this.frontOperationList);
            return false;
        }
        if (IPUtil.isIpv4((String)zDeviceForm.getDeviceIp())) {
            AticDevice aticDevice = this.aticDeviceService.getDeviceByIp(zDeviceForm.getDeviceIp());
            if (null != aticDevice) {
                zDeviceForm.setDeviceId(Long.valueOf(aticDevice.getMoId()));
            }
            if (null == aticDevice) {
                this.logger.info((Object)("Devices associated with the object are not present on the target ATIC.The deviceIp=" + zDeviceForm.getDeviceIp()));
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp(), 572006L, this.frontOperationList);
                return false;
            }
        } else {
            this.logger.info((Object)("Device IP format error..The deviceIp=" + zDeviceForm.getDeviceIp()));
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + zDeviceForm.getDeviceIp(), 572041L, this.frontOperationList);
            return false;
        }
        return true;
    }

    private boolean validateServiceName(ZoneServiceForm serviceForm) {
        String serviceName;
        if (null == serviceForm.getServiceName() || serviceForm.getServiceName().isEmpty()) {
            return false;
        }
        if (!serviceForm.getServiceName().matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$") && !"DEFAULT".equals(serviceForm.getProtocol())) {
            return false;
        }
        return !"DEFAULT".equals(serviceForm.getProtocol()) || (serviceName = serviceForm.getServiceName().replace(".", "")).matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$");
    }

    private boolean validatePolicyBasicInfo(ZoneServiceForm serviceForm, ZonePolicyApplyForm appForm, List<String> protocoList) {
        String zoneName = appForm.getZoneInfoForm().getZoneDesc();
        if (!this.validateServiceName(serviceForm)) {
            this.logger.info((Object)"import filter  failed, the error  is : name is wrong");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName(), 572037L, this.frontOperationList);
            return false;
        }
        if ("DEFAULT".equals(serviceForm.getProtocol())) {
            if (!(AticUtil.isNull((String)serviceForm.getDescription()) && AticUtil.isNull((String)serviceForm.getPortList()) && AticUtil.isNull((String)serviceForm.getIpList()))) {
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDescription() + " ;portList: " + serviceForm.getPortList() + " ;ipList: " + serviceForm.getIpList(), 572043L, this.frontOperationList);
                return false;
            }
            serviceForm.setDescription("");
            serviceForm.setPortList("");
            serviceForm.setIpList("");
        } else {
            if (!(Integer.valueOf("0").equals(serviceForm.getPortType()) || Integer.valueOf("1").equals(serviceForm.getPortType()) || Integer.valueOf("2").equals(serviceForm.getPortType()))) {
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getPortType(), 733034L, this.frontOperationList);
                return false;
            }
            if (!AticUtil.isNull((String)serviceForm.getPortList())) {
                return true;
            }
        }
        if (null != serviceForm.getDescription() && !serviceForm.getDescription().matches("^[\\w|\\-|\\!|\\@|\\#|\\$|\\^|\\.|\\+|\\}|\\ |\\{]{0,64}$")) {
            this.logger.info((Object)"import filter  failed, the error  is : Description is wrong");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDescription(), 572038L, this.frontOperationList);
            return false;
        }
        if (!protocoList.contains(serviceForm.getProtocol())) {
            this.logger.info((Object)"import filter  failed, the error  is : Protocol is wrong");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getProtocol(), 572039L, this.frontOperationList);
            return false;
        }
        if (!AticUtil.isNull((String)serviceForm.getDeviceIp())) {
            if (!IPUtil.isIpv4((String)serviceForm.getDeviceIp())) {
                this.logger.info((Object)"import filter  failed, the error  is : deviceIp is wrong");
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + serviceForm.getDeviceIp(), 572041L, this.frontOperationList);
                return false;
            }
        } else {
            this.logger.info((Object)"import filter  failed, the error  is : deviceIp is null");
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName(), 572040L, this.frontOperationList);
            return false;
        }
        if (!AticUtil.isNull((String)serviceForm.getIpList())) {
            String[] ipAddrs;
            for (String ipAddr : ipAddrs = serviceForm.getIpList().split(";")) {
                if (IPUtil.isIpv4((String)ipAddr) || IPUtil.isIpv6((String)ipAddr)) continue;
                this.logger.info((Object)"import filter  failed, the error  is : ipList is wrong");
                ImportUtil.recordErrorMessg(this.importData.getZoneString() + zoneName + "/" + serviceForm.getServiceName() + "/" + ipAddr, 572010L, this.frontOperationList);
                return false;
            }
        }
        return true;
    }

    private void processOpeLog(String target, boolean isSuccess) {
        ISysOptLog sysOptLogMgr = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule(this.importData.getSysTargetString());
        sysOptLogLego.setOperation(this.importData.getImportTargetString());
        sysOptLogLego.setOperator(this.importData.getOperator());
        if (!ZoneUtil.isNull((String)target) && target.length() > 255) {
            try {
                target = ZoneUtil.substring((String)target, (int)252, (String)"UTF-8") + "...";
            }
            catch (UnsupportedEncodingException e1) {
                this.logger.info((Object)e1);
            }
        }
        if (!ZoneUtil.isNull((String)target)) {
            sysOptLogLego.setTarget(target);
        } else {
            sysOptLogLego.setTarget("--");
        }
        sysOptLogLego.setResult(isSuccess ? 1 : 0);
        sysOptLogLego.setDetail(isSuccess ? this.importData.getImportResultSucess() : this.importData.getImportResultFailed());
        sysOptLogLego.setTerminalIp(this.importData.getRemoteAddr());
        sysOptLogMgr.writeOptLog(sysOptLogLego);
    }

    private boolean validatelFilterAction(FilterForm filterForm) {
        if (null == filterForm.getFilterAction()) {
            this.logger.info((Object)("import filterbaseinfo  failed, the error filter action is : " + filterForm.getFilterAction()));
            ImportUtil.recordErrorMessg(this.importData.getZoneString() + this.importData.getFilterString() + filterForm.getFilterName(), 572047L, this.frontOperationList);
            return false;
        }
        if (!ImportUtil.checkFilterAction(filterForm)) {
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + filterForm.getFilterName(), 572003L, this.frontOperationList);
            return false;
        }
        return true;
    }

    private void initProgressBarByZone() {
        int totalStep = 0;
        if (null != this.importForm.getZoneFormList() && !this.importForm.getZoneFormList().isEmpty()) {
            totalStep += this.importForm.getZoneFormList().size() + 1;
        }
        this.logger.info((Object)("importZone totalStep:=" + totalStep));
        this.totalRow = ++totalStep;
        this.progressState = ProgressManage.getInstance().createProgress(totalStep, this.importData.getProgressBarId().longValue());
        this.logger.info((Object)("Progress bar for import policy creation.The Progress is " + this.progressState));
    }

    private void initProgressBarByGlobal(AticDevice aDevice) {
        List<GloDomainWhiteListForm> listDomain;
        int totalStep = ImportUtil.calTotalSetp(this.importForm) + 1;
        if (PropertyNeglobalUtil.checkVersion((String)aDevice.getVersion()) && null != (listDomain = this.importForm.getDomainWhiteListFormList()) && !listDomain.isEmpty()) {
            if (!aDevice.getDeviceModel().startsWith("AntiDDoS8") && listDomain.size() > 2000) {
                listDomain = listDomain.subList(0, 2000);
                this.importForm.setDomainWhiteListFormList(listDomain);
            }
            totalStep += listDomain.size();
        }
        this.totalRow = totalStep;
        this.progressState = ProgressManage.getInstance().createProgress(totalStep, this.importData.getProgressBarId().longValue());
        this.logger.info((Object)("Progress bar for import policy creation.The Progress is " + this.progressState));
    }

    private void importAbnormalDefence(AticDevice aDevice) {
        this.logger.info((Object)"In the importAbnormalDefence");
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        if (null != this.importForm.getAbnormalForm()) {
            this.importForm.getAbnormalForm().setDeviceId(aDevice.getMoId());
            this.importForm.getAbnormalForm().setDeviceName(this.importForm.getDeviceName());
            if (CheckImportXml4NE.checkGlobalPolicy(this.importForm.getAbnormalForm(), this.frontOperationList, this.importData.getAbnormalString())) {
                try {
                    FWDefenceAbnormalForm abnormalForm = ImportUtil.prepareAbnormal(this.importForm, aDevice);
                    iFWDefenceAbnormalService.save(abnormalForm);
                }
                catch (LegoCheckedException e) {
                    this.importZoneByDeviceIsSucess = false;
                    this.logger.info((Object)("Save basic attack defense error.LegoCheckedException=" + e.getMessage()));
                    ImportUtil.recordErrorMessg(this.importData.getAbnormalString(), e.getErrorCode(), this.frontOperationList);
                }
            } else {
                this.importZoneByDeviceIsSucess = false;
            }
        }
        this.progressState.next();
    }

    private void importDomainWhiteList(AticDevice aDevice) {
        this.logger.info((Object)"In the importDomainWhiteList");
        if (!PropertyNeglobalUtil.checkVersion((String)aDevice.getVersion())) {
            this.logger.info((Object)"import DomainWhite,but device version is error");
            return;
        }
        List<GloDomainWhiteListForm> domainWhiteList = this.importForm.getDomainWhiteListFormList();
        if (null == domainWhiteList || domainWhiteList.isEmpty()) {
            this.logger.info((Object)" import domain whiteList,but domainWhiteList isEmpty");
            return;
        }
        ImportUtil.deletedomainWhiteList(String.valueOf(aDevice.getMoId()));
        this.importDomainWhiteBlackList(aDevice);
    }

    private void importGloBlackAndWhiteList(AticDevice aDevice) {
        this.logger.info((Object)"In the importGloBlackAndWhiteList");
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        FWDefenceAbnormalForm abnormalForm = iFWDefenceAbnormalService.queryByDeviceId(aDevice.getMoId());
        boolean onlySupportIp = false;
        if (aDevice.getVersion().contains("V500R001C00") || aDevice.getVersion().contains("V100R001")) {
            onlySupportIp = true;
        }
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        List<BatchOperation> boWhiteList = ImportUtil.prepareDeleWhite(aDevice, onlySupportIp);
        ImportUtil.deleteWhiteList(onlySupportIp, boWhiteList);
        List<BatchOperation> boBlackList = ImportUtil.prepareDeleBlackList(aDevice, onlySupportIp);
        ImportUtil.deleteBlackList(onlySupportIp, boBlackList);
        this.importBlackListIpForm(aDevice, onlySupportIp, abnormalForm);
        this.importWhiteBlackList(onlySupportIp, aDevice, abnormalForm);
    }

    private void importDomainWhiteBlackList(AticDevice aDevice) {
        this.logger.info((Object)"In the importWhiteBlackList");
        long startTime = System.currentTimeMillis();
        IGloDomainWhiteListService gervice = (IGloDomainWhiteListService)ServiceContext.getInstance().getService("gloDomainWhiteListService", IGloDomainWhiteListService.class);
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        List<GloDomainWhiteListForm> gwf = this.importForm.getDomainWhiteListFormList();
        int limitValue = 2000;
        if (aDevice.getDeviceModel().startsWith("AntiDDoS8")) {
            limitValue = 10000;
        }
        Long deviceId = aDevice.getMoId();
        if (null == gwf || gwf.isEmpty()) {
            return;
        }
        try {
            int i;
            FWDefenceAbnormalForm abnormalForm = iFWDefenceAbnormalService.queryByDeviceId(deviceId);
            int num = gwf.size();
            GloDomainWhiteListForm wm = null;
            int remainder = 0;
            boolean mark = false;
            for (i = 0; i < num; ++i) {
                if (gervice.queryAllWhiteCount(deviceId) >= limitValue) {
                    remainder = num - i;
                    break;
                }
                wm = gwf.get(i);
                wm.setDeviceId(String.valueOf(deviceId));
                gervice.saveGloDomainWhiteByWhite(wm);
                mark = true;
                this.progressState.next();
            }
            if (mark) {
                ImportUtil.setDomainWhiteListDeployState(abnormalForm);
            }
            for (i = 0; i < remainder; ++i) {
                this.progressState.next();
            }
            iFWDefenceAbnormalService.save(abnormalForm);
        }
        catch (LegoCheckedException e) {
            this.logger.info((Object)("Save the domain white error.LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getDomainWhiteLiString(), e.getErrorCode(), this.frontOperationList);
        }
        this.logger.info((Object)("Import domain white list to spend time is " + (System.currentTimeMillis() / 1000L - startTime / 1000L) + "s"));
    }

    private void importWhiteBlackList(boolean onlySupportIp, AticDevice aDevice, FWDefenceAbnormalForm abnormalForm) {
        this.logger.info((Object)"In the importWhiteBlackList");
        long startTime = System.currentTimeMillis();
        IGloWhiteListService gloWhiteListService = (IGloWhiteListService)ServiceContext.getInstance().getService("gloWhiteListService", IGloWhiteListService.class);
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        if (null == this.importForm.getWhiteListIpFormList() || this.importForm.getWhiteListIpFormList().isEmpty()) {
            return;
        }
        try {
            for (GloWhiteListIpForm whiteListIpForm : this.importForm.getWhiteListIpFormList()) {
                if (!this.isSaveWhiteList(aDevice, onlySupportIp, whiteListIpForm)) {
                    this.progressState.next();
                    continue;
                }
                whiteListIpForm.setDeviceId(aDevice.getMoId());
                whiteListIpForm.setDeleteFlag(0);
                if (!CheckImportXml4NE.checkBlackAndWhiteListIpNum(String.valueOf((Object)aDevice.getMoId()), this.frontOperationList, this.importData.getWhiteLiString())) break;
                if (onlySupportIp) {
                    GloWhiteListForm gloWhiteListForm = this.getGloWhiteListForm(whiteListIpForm);
                    gloWhiteListService.saveGloWhiteList(gloWhiteListForm);
                } else {
                    gloWhiteListService.saveWhiteListIp(whiteListIpForm);
                }
                ImportUtil.setWhiteListDeployState(abnormalForm);
                this.progressState.next();
            }
            iFWDefenceAbnormalService.save(abnormalForm);
        }
        catch (LegoCheckedException e) {
            this.logger.info((Object)("Save the whiteList error.LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getWhiteLiString(), e.getErrorCode(), this.frontOperationList);
        }
        this.logger.info((Object)("Import white list to spend time is " + (System.currentTimeMillis() / 1000L - startTime / 1000L) + "s"));
    }

    private boolean isSaveWhiteList(AticDevice aDevice, boolean onlySupportIp, GloWhiteListIpForm whiteListIpForm) {
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return false;
        }
        if (ImportUtil.isNullWhiteListIp(whiteListIpForm)) {
            return false;
        }
        if (onlySupportIp) {
            if (!CheckImportXml.isWhiteAndBlackList((String)whiteListIpForm.getWhitelistIp(), (String)String.valueOf((Object)aDevice.getMoId()), this.frontOperationList, (String)this.importData.getBlackLiString(), (String)this.importData.getWhiteLiString())) {
                this.importZoneByDeviceIsSucess = false;
                return false;
            }
        } else if (!ImportUtil.isOkWhiteListIpForm(this.importData, this.frontOperationList, aDevice, whiteListIpForm)) {
            this.importZoneByDeviceIsSucess = false;
            return false;
        }
        return true;
    }

    private GloWhiteListForm getGloWhiteListForm(GloWhiteListIpForm whiteListIpForm) {
        GloWhiteListForm gloWhiteListForm = new GloWhiteListForm();
        gloWhiteListForm.setWhitelistIp(whiteListIpForm.getWhitelistIp());
        gloWhiteListForm.setDeployState("UNDEPLOY");
        gloWhiteListForm.setDeviceId(String.valueOf(whiteListIpForm.getDeviceId()));
        return gloWhiteListForm;
    }

    private void importBlackListIpForm(AticDevice aDevice, boolean onlySupportIp, FWDefenceAbnormalForm abnormalForm) throws LegoCheckedException {
        this.logger.info((Object)"In the importBlackListIpForm");
        long start = System.currentTimeMillis();
        IFWDefenceAbnormalService iFWDefenceAbnormalService = (IFWDefenceAbnormalService)ServiceContext.getInstance().getService("iFWDefenceAbnormalService", IFWDefenceAbnormalService.class);
        if (null == this.importForm.getBlackListIpFormList() || this.importForm.getBlackListIpFormList().isEmpty()) {
            return;
        }
        try {
            for (GloBlackListIpForm blackListIpForm : this.importForm.getBlackListIpFormList()) {
                if (ImportUtil.checkIsTaskCancled(this.importData)) {
                    return;
                }
                blackListIpForm.setDeviceId(aDevice.getMoId());
                blackListIpForm.setDeleteFlag(0);
                if (!this.isOkSaveBlackList(blackListIpForm, onlySupportIp, aDevice)) {
                    this.progressState.next();
                    continue;
                }
                if (!CheckImportXml4NE.checkBlackAndWhiteListIpNum(String.valueOf((Object)aDevice.getMoId()), this.frontOperationList, this.importData.getBlackLiString())) break;
                this.saveBlackList(onlySupportIp, blackListIpForm);
                ImportUtil.setBlackListDeployState(abnormalForm);
                this.progressState.next();
            }
            iFWDefenceAbnormalService.save(abnormalForm);
        }
        catch (LegoCheckedException e) {
            this.logger.info((Object)("Save the blackList error.LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getBlackLiString() + this.importData.getBlackLiString(), e.getErrorCode(), this.frontOperationList);
        }
        this.logger.info((Object)("Import black list to spend time is " + (System.currentTimeMillis() / 1000L - start / 1000L) + "s"));
    }

    private void saveBlackList(boolean onlySupportIp, GloBlackListIpForm blackListIpForm) {
        IGloBlackListService gloBlackListService = (IGloBlackListService)ServiceContext.getInstance().getService("gloBlackListService", IGloBlackListService.class);
        if (onlySupportIp) {
            GloBlackListForm gloBlackListForm = this.getGloBlackListForm(blackListIpForm);
            gloBlackListService.saveGloBlackList(gloBlackListForm);
        } else {
            gloBlackListService.saveBlackListIp(blackListIpForm);
        }
    }

    private boolean isOkSaveBlackList(GloBlackListIpForm blackListIpForm, boolean onlySupportIp, AticDevice aDevice) {
        this.logger.info((Object)"In the isOkSaveBlackList");
        if (ImportUtil.isNullBlackListIp(blackListIpForm)) {
            return false;
        }
        if (onlySupportIp) {
            if (!CheckImportXml.isWhiteAndBlackList((String)blackListIpForm.getBlacklistIp(), (String)String.valueOf((Object)aDevice.getMoId()), this.frontOperationList, (String)this.importData.getBlackLiString(), (String)this.importData.getBlackLiString())) {
                this.importZoneByDeviceIsSucess = false;
                return false;
            }
        } else if (!ImportUtil.isOkBlackListIpForm(blackListIpForm, this.importData, this.frontOperationList, aDevice)) {
            this.importZoneByDeviceIsSucess = false;
            return false;
        }
        return true;
    }

    private GloBlackListForm getGloBlackListForm(GloBlackListIpForm blackListIpForm) {
        GloBlackListForm gloBlackListForm = null;
        gloBlackListForm = new GloBlackListForm();
        gloBlackListForm.setBlacklistIp(blackListIpForm.getBlacklistIp());
        gloBlackListForm.setDeviceId(String.valueOf(blackListIpForm.getDeviceId()));
        gloBlackListForm.setDeployState("UNDEPLOY");
        return gloBlackListForm;
    }

    private boolean isImportIpLocation() {
        this.logger.info((Object)"In the isImportIpLocation");
        if (!this.importForm.isNeedLocation()) {
            return false;
        }
        if (null == this.importForm.getLocationFormList() || this.importForm.getLocationFormList().isEmpty()) {
            return false;
        }
        if (!ImportUtil.checkIpLocationNum(this.importForm, this.importData)) {
            this.importZoneByDeviceIsSucess = false;
            ImportUtil.recordErrorMessg(this.importData.getImportString(), 572016L, this.frontOperationList);
            this.totalRow = this.progressState.getTotalStep() - this.importForm.getLocationFormList().size() + 1;
            this.progressState.setCurrentStep(this.progressState.getCurrentStep() + this.importForm.getLocationFormList().size());
        }
        return true;
    }

    private void importIpLocation() {
        this.logger.info((Object)"In the importIpLocation");
        long startTime = System.currentTimeMillis();
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return;
        }
        ILocationCustomService locationCustomService = (ILocationCustomService)ServiceContext.getInstance().getService("locationCustomService", ILocationCustomService.class);
        if (this.isImportIpLocation()) {
            List<LocationCustomForm> xmlLocationCusFormList = this.importForm.getLocationFormList();
            List<LocationCustomForm> sameNameLocationCusFormList = ImportUtil.getSameNameIpLocation(xmlLocationCusFormList, this.importData.getIplocationString(), this.frontOperationList);
            xmlLocationCusFormList.removeAll(sameNameLocationCusFormList);
            this.progressState.next(sameNameLocationCusFormList.size());
            for (LocationCustomForm locationForm : xmlLocationCusFormList) {
                if (null == locationForm.getLocationName() || locationForm.getLocationName().isEmpty()) {
                    this.progressState.next();
                    continue;
                }
                if (ImportUtil.checkIsTaskCancled(this.importData)) {
                    return;
                }
                ImportUtil.prepareLocationIpList(locationForm.getLocationIpList(), this.importData, this.frontOperationList);
                if (!this.chechkIpLocation(locationForm)) {
                    this.progressState.next();
                    continue;
                }
                LocationCustomForm cusForm = ImportUtil.prepareLocationCusForm(locationForm, locationForm.getLocationIpList(), this.importData, this.frontOperationList);
                try {
                    locationCustomService.saveLocationCustom(cusForm);
                }
                catch (LegoCheckedException e) {
                    this.logger.info((Object)("saveLoctionCustom error,locationCustom'name=" + locationForm.getLocationName() + ". LegoCheckedException=" + e.getMessage()));
                    ImportUtil.recordErrorMessg(locationForm.getLocationName(), e.getErrorCode(), this.frontOperationList);
                }
                this.progressState.next();
            }
            this.logger.info((Object)("Import ipLocation to spend time is" + (System.currentTimeMillis() / 1000L - startTime / 1000L) + "s"));
        }
    }

    private boolean chechkIpLocation(LocationCustomForm locationForm) {
        this.logger.info((Object)"In the chechkIpLocation");
        if (!ImportUtil.checkIpLocationNameAndIpAddr(locationForm, this.importData, this.frontOperationList)) {
            this.importZoneByDeviceIsSucess = false;
            return false;
        }
        if (!ImportUtil.checkLocationIpList(locationForm, this.importData, this.frontOperationList)) {
            this.importZoneByDeviceIsSucess = false;
            return false;
        }
        return CheckImportXml.checkIpConflict((LocationCustomForm)locationForm, this.frontOperationList, (String)this.importData.getIplocationString());
    }

    private boolean checkFilterNameAndType(FilterForm filterForm) {
        this.logger.info((Object)"In the checkFilterNameAndType");
        if (!filterForm.getFilterName().matches("^(?!default$)(?!null$)(?!sig.*$)(?!admin$)[a-zA-Z]{1}\\w*$")) {
            this.importZoneByDeviceIsSucess = false;
            this.logger.info((Object)"import filter  failed, the error  is : name is null");
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + filterForm.getFilterName(), 572037L, this.frontOperationList);
            return false;
        }
        String filterType = filterForm.getFilterType();
        if (filterType == null || !CheckImportXml.getFilterTypelist().contains(filterType.trim())) {
            this.importZoneByDeviceIsSucess = false;
            this.logger.info((Object)"import filter  failed, the error  is : filterType is wrong");
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + filterForm.getFilterName() + " /" + filterType, 670728L, this.frontOperationList);
            return false;
        }
        return true;
    }

    private void importFilter() {
        if (!this.isImportFilter()) {
            return;
        }
        Map<String, FilterForm> filterFormMap = ImportUtil.getFilterFormMap();
        FilterForm dbForm = null;
        List<FilterForm> xmlFilterFormList = this.importForm.getFilterFormList();
        List<FilterForm> sameNameFilterFormList = ImportUtil.getSameNameFilter(xmlFilterFormList, this.importData.getFilterString(), this.frontOperationList);
        xmlFilterFormList.removeAll(sameNameFilterFormList);
        this.progressState.next(sameNameFilterFormList.size());
        for (FilterForm filterForm : xmlFilterFormList) {
            if (ImportUtil.checkIsTaskCancled(this.importData)) {
                return;
            }
            if (null != filterForm && !this.checkFilterForm(filterForm)) {
                this.importZoneByDeviceIsSucess = false;
                this.progressState.next();
                continue;
            }
            if (null != filterForm && null != (dbForm = filterFormMap.get(filterForm.getFilterName()))) {
                filterForm.setFilterId(dbForm.getFilterId());
                if (!this.checkUpdateFilterForm(dbForm, filterForm)) {
                    this.progressState.next();
                    continue;
                }
            }
            if (null != filterForm) {
                List<HttpFilterForm> saveList = this.checkFilterKey(filterForm.getHttpFilterFormList(), filterForm);
                filterForm.setHttpFilterFormList(saveList);
                this.saveFilterForm(filterForm);
            }
            this.progressState.next();
        }
    }

    private boolean isImportFilter() {
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return false;
        }
        if (!this.importForm.isNeedFilter()) {
            return false;
        }
        return null != this.importForm.getFilterFormList() && !this.importForm.getFilterFormList().isEmpty();
    }

    private boolean isImportGlobalFilter() {
        if (ImportUtil.checkIsTaskCancled(this.importData)) {
            return false;
        }
        if (!this.importForm.isNeedFilter()) {
            return false;
        }
        return null != this.importForm.getGlobalFilterFormList() && !this.importForm.getGlobalFilterFormList().isEmpty();
    }

    private void saveFilterForm(FilterForm filterForm) {
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        try {
            if (null != filterForm.getFilterId()) {
                Map<String, FilterForm> filterFormMap = ImportUtil.getFilterFormMap();
                FilterForm dbForm = filterFormMap.get(filterForm.getFilterName());
                ImportUtil.updateFilterForm(dbForm, filterForm);
            } else {
                Integer filterIdValue = filterService.calculationFilterId();
                filterForm.setFilterId(filterIdValue);
                filterService.create((Object)filterForm);
            }
        }
        catch (LegoCheckedException e) {
            this.importZoneByDeviceIsSucess = false;
            this.logger.info((Object)("save filter error, filter.name = " + filterForm.getFilterName() + ". LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + filterForm.getFilterName(), e.getErrorCode(), this.frontOperationList);
        }
    }

    private boolean checkFilterForm(FilterForm filterForm) {
        if (!this.checkFilterNameAndType(filterForm)) {
            return false;
        }
        if (!this.validatelFilterAction(filterForm)) {
            return false;
        }
        return CheckImportXml4NE.checkFilterAlter(filterForm, this.importData, this.frontOperationList);
    }

    private boolean checkUpdateFilterForm(FilterForm dbForm, FilterForm filterForm) {
        if (!dbForm.getCrc().equals(filterForm.getCrc())) {
            if (!dbForm.getFilterType().equals(filterForm.getFilterType())) {
                this.importZoneByDeviceIsSucess = false;
                this.logger.info((Object)("Filters with the same name and protocol type.filter'name = " + filterForm.getFilterName() + ", filter'type + " + filterForm.getFilterType()));
                ImportUtil.recordErrorMessg(this.importData.getFilterString() + dbForm.getFilterName(), 572004L, this.frontOperationList);
                return false;
            }
        } else {
            this.logger.info((Object)("Did not do any changes, not import. The filter name = " + filterForm.getFilterName() + ", and filter type + " + filterForm.getFilterType()));
            return false;
        }
        return true;
    }

    private void importGlobalFilter(AticDevice aDevice) {
        if (!this.isImportGlobalFilter()) {
            return;
        }
        FilterForm dbForm = null;
        Map<String, FilterForm> filterFormMap = ImportUtil.getFilterFormMap();
        List<FilterForm> xmlGlobalFilterFormList = this.importForm.getGlobalFilterFormList();
        List<FilterForm> sameNameFilterFormList = ImportUtil.getSameNameFilter(xmlGlobalFilterFormList, this.importData.getFilterString(), this.frontOperationList);
        xmlGlobalFilterFormList.removeAll(sameNameFilterFormList);
        for (FilterForm filterForm : xmlGlobalFilterFormList) {
            if (ImportUtil.checkIsTaskCancled(this.importData)) {
                return;
            }
            if (!this.checkFilterForm(filterForm)) {
                this.importZoneByDeviceIsSucess = false;
                continue;
            }
            dbForm = filterFormMap.get(filterForm.getFilterName());
            if (null != dbForm) {
                filterForm.setFilterId(dbForm.getFilterId());
                if (!this.checkUpdateFilterForm(dbForm, filterForm)) continue;
            }
            List<HttpFilterForm> saveList = this.checkFilterKey(filterForm.getHttpFilterFormList(), filterForm);
            filterForm.setHttpFilterFormList(saveList);
            ArrayList<Long> deviceIds = new ArrayList<Long>();
            deviceIds.add(aDevice.getMoId());
            filterForm.setDeviceIdList(deviceIds);
            this.saveGlobalFilterForm(filterForm);
        }
    }

    private void saveGlobalFilterForm(FilterForm filterForm) {
        IFilterService filterService = (IFilterService)ServiceContext.getInstance().getService("filterService", IFilterService.class);
        try {
            if (null != filterForm.getFilterId()) {
                Map<String, FilterForm> filterFormMap = ImportUtil.getFilterFormMap();
                FilterForm dbForm = filterFormMap.get(filterForm.getFilterName());
                dbForm.setImportGlobalFilter(Boolean.valueOf(true));
                dbForm.setEditGloFilter(true);
                dbForm.setGlobalFilterConfig(true);
                ImportUtil.updateFilterForm(dbForm, filterForm);
            } else {
                Integer filterIdValue = filterService.calculationFilterId();
                filterForm.setFilterId(filterIdValue);
                filterForm.setDirection(1);
                filterForm.setImportGlobalFilter(Boolean.valueOf(true));
                filterForm.setEditGloFilter(false);
                filterForm.setGlobalFilterConfig(true);
                filterService.create((Object)filterForm);
            }
        }
        catch (LegoCheckedException e) {
            this.importZoneByDeviceIsSucess = false;
            this.logger.info((Object)("save filter error, filter.name = " + filterForm.getFilterName() + ". LegoCheckedException=" + e.getMessage()));
            ImportUtil.recordErrorMessg(this.importData.getFilterString() + filterForm.getFilterName(), e.getErrorCode(), this.frontOperationList);
        }
    }

    public boolean isIsEnd() {
        return this.isEnd;
    }

    public void setEnd(boolean isEndStr) {
        this.isEnd = isEndStr;
    }

    public ImportData getImportData() {
        return this.importData;
    }

    public void setImportData(ImportData importData) {
        this.importData = importData;
    }
}

