/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.common;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.List;
import java.util.Locale;

public class CommonUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private static IAticDeviceService aticDeviceService;

    public static String getMaskEndIp(String ip, int mask) {
        String[] subnetRange = IPUtil.getSubnetRange((String)ip, (int)mask);
        return subnetRange[1];
    }

    public static String getMaskStartIp(String ip, int mask) {
        String[] subnetRange = IPUtil.getSubnetRange((String)ip, (int)mask);
        return subnetRange[0];
    }

    public static boolean lock(Long deviceId) {
        boolean flag = false;
        flag = Locker.getInstance().lock(deviceId, 1);
        return flag;
    }

    public static Boolean checkCmdResult(List<String> list) {
        logger.info((Object)("cmdResult:" + CommonUtil.getcleanedMessage(list.toString())));
        Boolean flag = true;
        if (list.toString().toLowerCase(Locale.ENGLISH).contains("error")) {
            flag = false;
        }
        if (AticUtil.judgmentEcho((String)list.toString())) {
            flag = false;
        }
        return flag;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static void execSaveCmds(long moid, List<String> cmds) throws LegoCheckedException {
        logger.info((Object)"enter execSaveCmds");
        try {
            logger.info((Object)("to deploy:" + CommonUtil.getcleanedMessage(cmds.toString())));
            CommonUtil.getAticDeviceService().execNoResultCmd(cmds, moid);
        }
        catch (LegoCheckedException legoExcp) {
            logger.error((Object)legoExcp);
            throw new LegoCheckedException(630005L, (Throwable)legoExcp);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        logger.info((Object)"leave execSaveCmds");
    }

    private static IAticDeviceService getAticDeviceService() {
        if (null == aticDeviceService) {
            aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        }
        return aticDeviceService;
    }
}

