/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.neglobal.model.GloCdnIpListInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GloCdnIpListDao
extends CommonDaoImpl {
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from GloCdnIpListInfo where (1=1) and deleteFlag = false ";
        String hql4Count = "select count(*) as rowCount ";
        String deviceId = conditionMap.get("deviceId");
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ? ";
            queryMap.put(0, deviceId);
        }
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            if (sortName.equalsIgnoreCase("ipAddress")) {
                sortName = "ipAddress";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public int queryCountByDeviceId(Long deviceId) {
        String hql4Count = "select count(*) as rowCount from GloCdnIpListInfo where deleteFlag = false and deviceId = ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(deviceId));
        Long count = this.getTotalCount(hql4Count, queryMap);
        return count.intValue();
    }

    public List<GloCdnIpListInfo> queryByDeviceId(Long deviceId) {
        String hql = "from GloCdnIpListInfo deleteFlag = false and deviceId = ? ";
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        queryMap.put(0, String.valueOf(deviceId));
        List result = this.findByHql(hql, queryMap);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public List<GloCdnIpListInfo> getByIpLists(String id) {
        if (null == id) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        String[] ids = id.split(",");
        StringBuffer hql = new StringBuffer();
        hql.append("from GloCdnIpListInfo where pkid in (");
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        for (int i = 0; i < ids.length; ++i) {
            params.put(i, ids[i]);
            if (0 == i) {
                hql.append("?");
                continue;
            }
            hql.append(",?");
        }
        hql.append(")");
        List result = this.findByHql(hql.toString(), params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    public List<GloCdnIpListInfo> getByIp(String cdnIp, String deviceId) {
        if (AticUtil.isNull((String)cdnIp)) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String hql = "from GloCdnIpListInfo where deviceId = ?  and ipAddress = ? and deleteFlag= false ";
        params.put(0, deviceId);
        params.put(1, cdnIp);
        this.logger.info((Object)("query cdnIp data hql :" + hql));
        List result = this.findByHql(hql, params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    public List<GloCdnIpListInfo> initDeployData(String deviceId) {
        if (AticUtil.isNull((String)deviceId)) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String hql = "from GloCdnIpListInfo where deviceId = ?  and deployState != 'SUCCESS' and deleteFlag= false ";
        params.put(0, deviceId);
        this.logger.info((Object)("query cdnIp data hql :" + hql));
        List result = this.findByHql(hql, params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    public List<GloCdnIpListInfo> initUndoDeployData(String deviceId) {
        if (AticUtil.isNull((String)deviceId)) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String hql = "from GloCdnIpListInfo where deviceId = ?  and deployState = 'SUCCESS' and deleteFlag= true ";
        params.put(0, deviceId);
        this.logger.info((Object)("query cdnIp data hql :" + hql));
        List result = this.findByHql(hql, params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    public void deleteFlagData(Long pkId) {
        String hql = "delete from GloCdnIpListInfo where pkid = ? and deleteFlag = true ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{pkId});
    }

    public List<GloCdnIpListInfo> getByIp(String deviceId) {
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String hql = "from GloCdnIpListInfo where deviceId = ? and deleteFlag= false ";
        params.put(0, deviceId);
        this.logger.info((Object)("query cdnIp data hql :" + hql));
        List result = this.findByHql(hql, params);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloCdnIpListInfo>();
        }
        return result;
    }

    public GloCdnIpListInfo get(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloCdnIpListInfo where pkid = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List cdnIpList = this.findByHql(hql, param);
        if (cdnIpList == null || cdnIpList.isEmpty()) {
            return null;
        }
        return (GloCdnIpListInfo)cdnIpList.get(0);
    }

    public void updateFlag(long id) {
        String hql = "update GloCdnIpListInfo set deleteFlag = true where pkid = ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void deleteCdnIpById(Long id) {
        String hql = "delete from GloCdnIpListInfo where pkid =  ? ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void clearAllIpListData(Long deviceId) {
        String hql = "delete from GloCdnIpListInfo where deviceId = ? and deployState != 'SUCCESS' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public void updateFlagByDeviceId(Long deviceId) {
        String hql = "update GloCdnIpListInfo set deleteFlag = true where deviceId = ? and deployState = 'SUCCESS' ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceId});
    }

    public List<GloCdnIpListInfo> queryByDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloCdnIpListInfo where deviceId = ? order by pkid asc";
        this.logger.info((Object)("query cdn proxy ip hql :" + hql));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }
}

