/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.vsm.secservice.neglobal.model.GloDomainWhiteListInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GloDomainWhiteListDAO
extends CommonDaoImpl {
    public void remove(long id) {
        String hql = "delete from GloDomainWhiteListInfo where dwid = ? ";
        HashMap<Integer, Long> mapParam = new HashMap<Integer, Long>(1);
        mapParam.put(0, id);
        this.deleteBatch(hql, mapParam);
    }

    public GloDomainWhiteListInfo get(Long id) {
        if (id == null) {
            return null;
        }
        String hql = "from GloDomainWhiteListInfo where dwid = ? ";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, id.toString());
        List blackList = this.findByHql(hql, param);
        if (blackList == null || blackList.isEmpty()) {
            return null;
        }
        return (GloDomainWhiteListInfo)blackList.get(0);
    }

    public List<GloDomainWhiteListInfo> getByWhiteAndDeviceId(String white, String deviceId) {
        if (AticUtil.isNull((String)white)) {
            return new ArrayList<GloDomainWhiteListInfo>();
        }
        if (deviceId.contains(",")) {
            String[] getDeviceId = deviceId.split(",");
            deviceId = getDeviceId[0];
        }
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String hql = "from GloDomainWhiteListInfo where deviceId = ? and domainWhite = ? ";
        param.put(0, deviceId);
        param.put(1, white);
        this.logger.info((Object)("query whitelist domain hql : " + hql));
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloDomainWhiteListInfo>();
        }
        return result;
    }

    public List<GloDomainWhiteListInfo> getByIds(String id) {
        if (AticUtil.isNull((String)id)) {
            return new ArrayList<GloDomainWhiteListInfo>();
        }
        String[] ids = id.split(",");
        StringBuffer hql = new StringBuffer();
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        hql.append("from GloDomainWhiteListInfo where dwid in (");
        for (int i = 0; i < ids.length; ++i) {
            param.put(i, ids[i]);
            if (0 == i) {
                hql.append("?");
                continue;
            }
            hql.append(",?");
        }
        hql.append(")");
        List result = this.findByHql(hql.toString(), param);
        if (result == null || result.isEmpty()) {
            return new ArrayList<GloDomainWhiteListInfo>();
        }
        return result;
    }

    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String domainWhite;
        Paging page = new Paging();
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        String hql = "from GloDomainWhiteListInfo where (1=1) and deleteFlag = '0' ";
        String hql4Count = "select count(*) as rowCount ";
        int index = 0;
        String deviceId = conditionMap.get("deviceId");
        if (null != deviceId && !"".equals(deviceId)) {
            hql = hql + " and deviceId = ? ";
            queryMap.put(index++, deviceId);
        }
        if (!AticUtil.isNull((String)(domainWhite = conditionMap.get("domainWhite")))) {
            hql = hql + " and domainWhite like ? ";
            queryMap.put(index, "%" + domainWhite.trim() + "%");
        }
        hql4Count = hql4Count + hql;
        int count = this.getCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (this.checkParams(sortName, sortType)) {
            if (sortName.equalsIgnoreCase("domainWhite")) {
                sortName = "domainWhite";
            }
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count);
        page.setData(result);
        return page;
    }

    private boolean checkParams(String name, String type) {
        String regular;
        return !AticUtil.isNull((String)type) && !AticUtil.isNull((String)name) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name) && (type.trim().equalsIgnoreCase("desc") || type.trim().equalsIgnoreCase("asc"));
    }

    public List<GloDomainWhiteListInfo> queryByDeviceId(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloDomainWhiteListInfo where deviceId = ?  and (deployState <> 'SUCCESS'  or deleteFlag ='1') order by dwid asc ";
        this.logger.info((Object)("query need deploy domain whitelist hql : " + hql));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void updateFlag(long id) {
        String hql = "update GloDomainWhiteListInfo set deleteFlag = '1' where dwid = ?  ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public int updateFlagByDeviceId(String deviceid) {
        String hql = "update GloDomainWhiteListInfo set deleteFlag = '1' where deviceId = ? and deployState = 'SUCCESS' ";
        return this.getHibernateTemplate().bulkUpdate(hql, new Object[]{deviceid});
    }

    public void deleteFlagData(long id) {
        String hql = "delete from GloDomainWhiteListInfo where dwid = ? and deleteFlag = '1' ";
        HashMap<Integer, Long> mapParam = new HashMap<Integer, Long>(1);
        mapParam.put(0, id);
        this.deleteBatch(hql, mapParam);
    }

    public List<GloDomainWhiteListInfo> queryAllWhitelists(String deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloDomainWhiteListInfo where deviceId = ?  order by dwid asc";
        this.logger.info((Object)("query nGloDomainWhiteListInfo hql : " + hql));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public int queryAllWhiteCount(String deviceId) {
        if (deviceId == null) {
            return 0;
        }
        String hql = "select count(*) as rowCount from GloDomainWhiteListInfo where deviceId = ? and deleteFlag ='0'";
        this.logger.info((Object)("query need delete deleteFlag=0 domainWhite hql : " + hql));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        return this.getCount(hql, param);
    }

    public int queryAllWhiteCounts(String deviceId) {
        if (deviceId == null) {
            return 0;
        }
        String hql = "select count(*) as rowCount from GloDomainWhiteListInfo where deviceId = ? ";
        this.logger.info((Object)("query need domainWhite hql : " + hql));
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId);
        return this.getCount(hql, param);
    }

    public int clearAllDomainWhiteListData(String deviceid) {
        String hql = "delete from GloDomainWhiteListInfo where deviceId= ? and deployState != 'SUCCESS'";
        HashMap<Integer, String> mapParam = new HashMap<Integer, String>(1);
        mapParam.put(0, deviceid);
        return this.deleteBatch(hql, mapParam);
    }

    public List<GloDomainWhiteListInfo> queryAllDomainList(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        String hql = "from GloDomainWhiteListInfo where deviceId = ? and deleteFlag = ? order by pkid asc";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, deviceId.toString());
        param.put(1, "0");
        List result = this.findByHql(hql, param);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public void removeAllDomainWhite(long deviceId) {
        if (deviceId < 0L) {
            return;
        }
        String hql = "delete from  GloDomainWhiteListInfo where deviceId = ? ";
        HashMap<Integer, String> mapParam = new HashMap<Integer, String>(1);
        mapParam.put(0, String.valueOf(deviceId));
        this.deleteBatch(hql, mapParam);
    }

    public void updateBatchGloDomainWhiteListInfo(List<GloDomainWhiteListForm> formList, String status) {
        if (null == formList || formList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE t_vsm_neconf_domain_whitelist SET deploy_state = '" + status + "' WHERE ");
        this.sql(formList, sql);
        this.logger.info((Object)("updateBatchGloDomainWhiteListInfo SQL : " + sql.toString()));
        try {
            this.currentSession().createNativeQuery(sql.toString()).executeUpdate();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    public void deleteBatchUndoDeployData(List<GloDomainWhiteListForm> formList) {
        if (null == formList || formList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer("DELETE FROM t_vsm_neconf_domain_whitelist WHERE ");
        this.sql(formList, sql);
        this.logger.info((Object)("deleteBatchUndoDeployData SQL : " + sql.toString()));
        try {
            this.currentSession().createNativeQuery(sql.toString()).executeUpdate();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private void sql(List<GloDomainWhiteListForm> formList, StringBuffer sql) {
        for (GloDomainWhiteListForm gloDomainWhiteListInfo : formList) {
            Long pkid;
            if (null == gloDomainWhiteListInfo || null == (pkid = gloDomainWhiteListInfo.getDwid())) continue;
            if (!sql.toString().trim().endsWith("WHERE")) {
                sql.append(" OR ");
            }
            sql.append(" pkid = " + pkid);
        }
    }

    private int getCount(String hql, Map<Integer, String> param) {
        List lis = this.findByHql(hql, param);
        int count = 0;
        if (null != lis && lis.size() > 0) {
            count = Integer.parseInt(lis.get(0).toString());
        }
        return count;
    }
}

