/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.service.SysOptLogImpl;
import com.hs.vsm.secservice.ddos.common.CmdUtil;
import com.hs.vsm.secservice.neglobal.common.CmdDevCapManager;
import com.hs.vsm.secservice.neglobal.common.CommonUtil;
import com.hs.vsm.secservice.neglobal.dao.FWDefenceAbnormalDAO;
import com.hs.vsm.secservice.neglobal.model.FWDefenceAbnormalInfo;
import com.hs.vsm.secservice.sdk.common.util.CrcUtil;
import com.hs.vsm.secservice.sdk.common.util.Locker;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.parents.servcice.IFWDefenceAbnormalParentService;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import com.huawei.atic.secservice.ddos.service.impl.DdosDevCapabilityServiceImpl;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FWDefenceAbnormalServiceImpl
implements IFWDefenceAbnormalService,
IFWDefenceAbnormalParentService {
    private static final String LARGE_UDP = "LARGE_UDP";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private FWDefenceAbnormalDAO dao;
    private AticDeviceDao aticDeviceDao;
    private ICommonUtilService commonUtilService;

    public FWDefenceAbnormalDAO getDao() {
        return this.dao;
    }

    public synchronized AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public synchronized void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }

    public void setDao(FWDefenceAbnormalDAO dao) {
        this.dao = dao;
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"enter queryByPage");
        Paging page = this.dao.queryByPage(queryMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<FWDefenceAbnormalForm> formList = new ArrayList<FWDefenceAbnormalForm>();
        for (FWDefenceAbnormalInfo info : infoList) {
            FWDefenceAbnormalForm form = new FWDefenceAbnormalForm();
            AticUtil.copyProperties((Object)info, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        this.logger.info((Object)"leave queryByPage");
        return page;
    }

    public BatchOperationResult deleteInBatch(List<BatchOperation> boList) {
        return null;
    }

    public void delete(Long id) {
        this.dao.delete(id);
    }

    public FWDefenceAbnormalForm query(Long id) {
        FWDefenceAbnormalInfo info = this.dao.get(id);
        if (null == info) {
            return null;
        }
        FWDefenceAbnormalForm form = new FWDefenceAbnormalForm();
        AticUtil.copyProperties((Object)info, (Object)form);
        return form;
    }

    public void save(FWDefenceAbnormalForm form) {
        this.logger.info((Object)"enter save");
        Long crc = CrcUtil.getCrcValue((String)form.getCalcCrcString());
        this.logger.info((Object)("crc : " + crc + ", crcString : " + form.getCalcCrcString()));
        Long initCrc = CrcUtil.getCrcValue((String)"0");
        form.setCurrentCrc(crc);
        if (form.getDeployedCrc() != null && form.getDeployedCrc().equals(crc) && !form.getDeployedCrc().equals(initCrc)) {
            form.setDeployState("SUCCESS");
        } else if (form.getDeployedCrc() == CrcUtil.getCrcValue((String)"0")) {
            form.setDeployState("UNDEPLOY");
        } else {
            form.setDeployState("PART_DEPLOY");
        }
        FWDefenceAbnormalInfo info = new FWDefenceAbnormalInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.dao.saveOrUpdate(info);
        this.logger.info((Object)"leave save");
    }

    public void update(FWDefenceAbnormalForm form) {
        this.logger.info((Object)"enter update");
        FWDefenceAbnormalInfo info = new FWDefenceAbnormalInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.dao.update(info);
        this.logger.info((Object)"leave update");
    }

    public Long create(FWDefenceAbnormalForm form) {
        Long pkid = null;
        if (null != form) {
            Long crc = CrcUtil.getCrcValue((String)form.getCalcCrcString());
            form.setCurrentCrc(crc);
            form.setDeployState("UNDEPLOY");
            FWDefenceAbnormalInfo info = new FWDefenceAbnormalInfo();
            AticUtil.copyProperties((Object)form, (Object)info);
            this.dao.saveOrUpdate(info);
            pkid = info.getId();
            form.setId(pkid);
        }
        return pkid;
    }

    public void delete(FWDefenceAbnormalForm form) {
        FWDefenceAbnormalInfo info = new FWDefenceAbnormalInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.dao.delete(info);
    }

    public void createOrUpdate(FWDefenceAbnormalForm form) {
        this.save(form);
    }

    @Override
    public FWDefenceAbnormalForm queryByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        FWDefenceAbnormalInfo info = this.dao.queryByDeviceId(deviceId);
        if (null == info) {
            return null;
        }
        FWDefenceAbnormalForm form = new FWDefenceAbnormalForm();
        AticUtil.copyProperties((Object)info, (Object)form);
        this.logger.info((Object)"leave queryByDeviceId");
        return form;
    }

    public void createByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter createByDeviceId");
        FWDefenceAbnormalForm form = this.queryByDeviceId(deviceId);
        AticDevice device = this.getAticDeviceDao().getDeviceByMoid(deviceId.longValue());
        if (null == form && device != null && device.getDeviceType() == 1) {
            FWDefenceAbnormalForm newForm = new FWDefenceAbnormalForm();
            String params = "FRAGGLE:0:-:-:-:-,ICMP_REDIRECT:0:-:-:-:-,ICMP_UNREACHABLE:0:-:-:-:-,WINNUKE:0:-:-:-:-,LAND:0:-:-:-:-,PING_OF_DEATH:0:-:-:-:-,ROUTE_RECORD:0:-:-:-:-,SMURF:0:-:-:-:-,SOURCE_ROUTE:0:-:-:-:-,TCP_FLAG:0:-:-:-:-,TEARDROP:0:-:-:-:-,LARGE_ICMP:0:4000:Bytes:28:65535,TIME_STAMP:0:-:-:-:-,TRACERT:0:-:-:-:-";
            String deviceType = this.commonUtilService.getDDoSVersion(device.getIpAddress());
            if ("4".equals(deviceType)) {
                params = "FRAGGLE:0:-:-:-:-,ICMP_REDIRECT:0:-:-:-:-,ICMP_UNREACHABLE:0:-:-:-:-,WINNUKE:0:-:-:-:-,LAND:0:-:-:-:-,PING_OF_DEATH:0:-:-:-:-,ROUTE_RECORD:0:-:-:-:-,SMURF:0:-:-:-:-,SOURCE_ROUTE:0:-:-:-:-,TCP_FLAG:0:-:-:-:-,TEARDROP:0:-:-:-:-,LARGE_ICMP:0:4000:Bytes:28:65535,TIME_STAMP:0:-:-:-:-,TRACERT:0:-:-:-:-,LARGE_UDP:0:4000:Bytes:28:65535";
            }
            newForm.setParams(params);
            newForm.setDeviceId(deviceId);
            Long crc = CrcUtil.getCrcValue((String)newForm.getCalcCrcString());
            this.logger.info((Object)("crc : " + crc + " , crcString : " + newForm.getCalcCrcString()));
            newForm.setCurrentCrc(crc);
            newForm.setDeployState("UNDEPLOY");
            this.create(newForm);
        }
        this.logger.info((Object)"leave createByDeviceId");
    }

    @Override
    public void refreshByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter refreshByDeviceId");
        AticDevice device = this.getAticDeviceDao().getDeviceByMoid(deviceId.longValue());
        if (null != device) {
            String deviceType = this.commonUtilService.getDDoSVersion(device.getIpAddress());
            FWDefenceAbnormalForm form = this.queryByDeviceId(deviceId);
            if (null == form) {
                this.logger.error((Object)"form is null");
                return;
            }
            if ("4".equals(deviceType) && !form.getParams().contains(LARGE_UDP)) {
                form.setParams(form.getParams() + ",LARGE_UDP:1:4000:Bytes:28:65535");
                this.save(form);
            }
        }
    }

    @Override
    public void deleteByDeviceId(List<Long> deviceIdList) {
        this.logger.info((Object)"enter deleteByDeviceId");
        for (Long deviceId : deviceIdList) {
            FWDefenceAbnormalInfo info = this.dao.queryByDeviceId(deviceId);
            this.dao.delete(info);
        }
        this.logger.info((Object)"leave deleteByDeviceId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> deploy(FWDefenceAbnormalForm abnormalForm) {
        FWDefenceAbnormalServiceImpl fWDefenceAbnormalServiceImpl = this;
        synchronized (fWDefenceAbnormalServiceImpl) {
            if (null == abnormalForm) {
                return null;
            }
            this.logger.info((Object)"enter deploy ");
            this.logger.info((Object)("to deploy device id:" + abnormalForm.getDeviceId()));
            HashMap<Long, String> result = new HashMap<Long, String>();
            HashMap<Long, String> errorDetail = new HashMap<Long, String>();
            if (abnormalForm.getId() == null) {
                this.logger.error((Object)("failed to deploy device :" + abnormalForm.getDeviceId()));
                throw new LegoCheckedException("com.hs.vsm.secservice.neglobal.dnsagent.notExist");
            }
            if (!"SUCCESS".equals(abnormalForm.getDeployState())) {
                this.deployOneDevice(abnormalForm, result, errorDetail);
            } else {
                this.deployHelloCmd(abnormalForm, result, errorDetail);
            }
            this.updateDeployStatus(abnormalForm, result, errorDetail);
            this.logger.info((Object)"leave deploy ");
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> deploySaveCmd(List<Long> deviceIdList, User currentUser) {
        FWDefenceAbnormalServiceImpl fWDefenceAbnormalServiceImpl = this;
        synchronized (fWDefenceAbnormalServiceImpl) {
            this.logger.info((Object)"enter deploySaveCmd ");
            this.logger.info((Object)("to deploy device list:" + deviceIdList));
            HashMap<Long, String> result = new HashMap<Long, String>();
            HashMap<Long, String> errorDetail = new HashMap<Long, String>();
            String saveErrorMsgKey = "--";
            List<FWDefenceAbnormalForm> formList = this.initDeployData(deviceIdList);
            long deviceId = 0L;
            Boolean isLockOK = null;
            long recentSaveTime = System.currentTimeMillis();
            for (FWDefenceAbnormalForm form : formList) {
                form.setRecentSaveTime(recentSaveTime);
                deviceId = form.getDeviceId();
                isLockOK = CommonUtil.lock(deviceId);
                try {
                    if (isLockOK.booleanValue()) {
                        ArrayList<String> cmds = new ArrayList<String>();
                        cmds.add("save" + System.getProperty("line.separator") + "y");
                        this.logger.info((Object)("to save config cmds: " + this.getcleanedMessage(((Object)cmds).toString())));
                        CommonUtil.execSaveCmds(deviceId, cmds);
                        result.put(deviceId, "SUCCESS");
                        saveErrorMsgKey = "--";
                        this.saveOperationLog(true, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), "");
                        continue;
                    }
                    this.logger.error((Object)("failed to lock device :" + deviceId));
                    result.put(deviceId, "PART_SUCCESS");
                    saveErrorMsgKey = "lego.err.630007";
                    this.saveOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), saveErrorMsgKey);
                }
                catch (LegoCheckedException legoException) {
                    this.logger.error((Object)legoException);
                    result.put(deviceId, "PART_SUCCESS");
                    saveErrorMsgKey = "lego.err." + legoException.getErrorCode();
                    this.saveOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), saveErrorMsgKey);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    result.put(deviceId, "PART_SUCCESS");
                    saveErrorMsgKey = "lego.err.630005";
                    this.saveOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), saveErrorMsgKey);
                }
                finally {
                    errorDetail.put(deviceId, saveErrorMsgKey);
                    if (!isLockOK.booleanValue()) continue;
                    Locker.getInstance().unlock(Long.valueOf(deviceId), 1);
                }
            }
            this.updateSaveStatus(formList, result, errorDetail);
            this.logger.info((Object)"leave deploySaveCmd ");
            return errorDetail;
        }
    }

    private void saveOperationLog(boolean sucess, User currentUser, String deviceName, String failReason) {
        ISysOptLog sysOptLogMgr = null;
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            sysOptLogMgr = (ISysOptLog)context.getService("sysLogService", SysOptLogImpl.class);
        }
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.neGlobalApp");
        sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.save.config");
        sysOptLogLego.setTarget(deviceName);
        sysOptLogLego.setOperator(currentUser.getUserName());
        if (sucess) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.save.config.success");
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail(failReason);
        }
        sysOptLogLego.setTerminalIp(currentUser.getIpAdr());
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    private List<String> doTranslate4Deploy(FWDefenceAbnormalForm form) {
        this.logger.info((Object)"enter doTranslate4Deploy");
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.addAll(this.doTranslate4Undeploy(form));
        String[] ipList = form.getParams().toLowerCase(Locale.ENGLISH).split(",");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        for (int i = 0; i < ipList.length; ++i) {
            CmdParam largeIcmp;
            String defend = ipList[i];
            CmdParam cmd = new CmdParam();
            cmd.setCmdID(defend.split(":")[0]);
            String defendEnable = defend.split(":")[1];
            if (defendEnable.equals("1")) {
                cmdParams.add(cmd);
            }
            if ("large_icmp".equals(defend.split(":")[0]) && "1".equals(defend.split(":")[1])) {
                largeIcmp = new CmdParam();
                largeIcmp.setCmdID("large_icmp_maxrate");
                largeIcmp.getParams().put("maxLength", defend.split(":")[2]);
                cmdParams.add(largeIcmp);
            }
            if (!"large_udp".equals(defend.split(":")[0]) || !"1".equals(defend.split(":")[1])) continue;
            largeIcmp = new CmdParam();
            largeIcmp.setCmdID("large_udp_maxrate");
            largeIcmp.getParams().put("maxLength", defend.split(":")[2]);
            cmdParams.add(largeIcmp);
        }
        if (this.isSupportBlackhole(form.getDeviceId())) {
            CmdParam blackholeMode = new CmdParam();
            blackholeMode.setCmdID("blackhole_mode");
            if (1 == form.getBlackholeMode()) {
                blackholeMode.getParams().put("undo", "undo");
            }
            cmdParams.add(blackholeMode);
        }
        CmdParam pcapParam = new CmdParam();
        pcapParam.setCmdID("pcap_length");
        if (1 == form.getPcapMode()) {
            pcapParam.getParams().put("lengthStr", "header");
        }
        if (2 == form.getPcapMode()) {
            pcapParam.getParams().put("lengthStr", "all");
        }
        if (3 == form.getPcapMode()) {
            pcapParam.getParams().put("lengthStr", form.getPcapLength().toString());
        }
        cmdParams.add(pcapParam);
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
        if (null != form.getSslDecryption()) {
            if (1 == form.getSslDecryption()) {
                CmdParam sslDecryption1 = new CmdParam();
                sslDecryption1.setCmdID("ssl_decryption1_do");
                cmdParams.add(sslDecryption1);
                CmdParam sslDecryption2 = new CmdParam();
                sslDecryption2.setCmdID("ssl_decryption2_do");
                cmdParams.add(sslDecryption2);
                CmdParam sslDecryption3 = new CmdParam();
                sslDecryption3.setCmdID("ssl_decryption3_do");
                cmdParams.add(sslDecryption3);
                CmdParam sslDecryption4 = new CmdParam();
                sslDecryption4.setCmdID("ssl_decryption4_do");
                cmdParams.add(sslDecryption4);
                CmdParam sslDecryption5 = new CmdParam();
                sslDecryption5.setCmdID("ssl_decryption5_do");
                cmdParams.add(sslDecryption5);
                CmdParam sslDecryption6 = new CmdParam();
                sslDecryption6.setCmdID("ssl_decryption6_do");
                cmdParams.add(sslDecryption6);
            } else {
                CmdParam sslDecryptionUnDo1 = new CmdParam();
                sslDecryptionUnDo1.setCmdID("ssl_decryption1_undo");
                cmdParams.add(sslDecryptionUnDo1);
                CmdParam sslDecryptionUnDo2 = new CmdParam();
                sslDecryptionUnDo2.setCmdID("ssl_decryption2_undo");
                cmdParams.add(sslDecryptionUnDo2);
                CmdParam sslDecryptionUnDo3 = new CmdParam();
                sslDecryptionUnDo3.setCmdID("ssl_decryption3_undo");
                cmdParams.add(sslDecryptionUnDo3);
                CmdParam sslDecryptionUnDo4 = new CmdParam();
                sslDecryptionUnDo4.setCmdID("ssl_decryption4_undo");
                cmdParams.add(sslDecryptionUnDo4);
            }
            CmdParam sslDecryption0 = new CmdParam();
            sslDecryption0.setCmdID("ssl_decryption_return");
            cmdParams.add(sslDecryption0);
        }
        List toDeployCmds = tool.doTranslate(cmdFileDir, "dfn_abnormal", cmdParams);
        this.logger.info((Object)"leave doTranslate4Deploy");
        cmds.addAll(toDeployCmds);
        return cmds;
    }

    private boolean isSupportBlackhole(Long deviceId) {
        DeviceTypeInfo devTypeInfo = CmdUtil.getDevTypeInfo((long)deviceId);
        Set supportAttr = DdosDevCapabilityServiceImpl.getInstance().getAllSupportedAttr(devTypeInfo);
        return supportAttr.contains("isSupportBlackhole");
    }

    private List<FWDefenceAbnormalForm> initDeployData(List<Long> deviceIdList) {
        this.logger.info((Object)"enter initDeployData");
        ArrayList<FWDefenceAbnormalForm> list = new ArrayList<FWDefenceAbnormalForm>();
        for (Long deviceId : deviceIdList) {
            FWDefenceAbnormalForm form = this.queryByDeviceId(deviceId);
            list.add(form);
        }
        this.logger.info((Object)"leave initDeployData");
        return list;
    }

    @Override
    public Boolean lockDevice(Long deviceId) {
        Boolean flag = CommonUtil.lock(deviceId);
        return flag;
    }

    @Override
    public void unlockDevice(Long deviceId) {
        Locker.getInstance().unlock(deviceId, 1);
    }

    @Override
    public void saveDeployState(FWDefenceAbnormalForm form) {
        this.logger.info((Object)"enter update abnormaldfn deployState");
        FWDefenceAbnormalInfo info = new FWDefenceAbnormalInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.dao.saveOrUpdate(info);
        this.logger.info((Object)"leave update abnormaldfn deployState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployOneDevice(FWDefenceAbnormalForm form, Map<Long, String> result, Map<Long, String> errorDetail) {
        this.logger.info((Object)"enter deployOnDevice ");
        String errorMsgKey = "--";
        Long deviceId = form.getDeviceId();
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.addAll(this.doTranslate4Deploy(form));
            this.logger.info((Object)("to deploy cmds: " + this.getcleanedMessage(((Object)cmds).toString())));
            List cmdResult = CmdUtil.execCmds((long)form.getDeviceId(), cmds);
            Boolean isDeployOK = true;
            if (null != cmdResult) {
                isDeployOK = CommonUtil.checkCmdResult(cmdResult);
            }
            if (isDeployOK.booleanValue()) {
                result.put(form.getDeviceId(), "SUCCESS");
            } else {
                boolean undoMmark = true;
                boolean doMmark = true;
                result.put(form.getDeviceId(), "PART_SUCCESS");
                errorMsgKey = "lego.err.630006";
                if (null != cmdResult && cmdResult.size() > 0) {
                    StringBuffer errorBuffer = new StringBuffer();
                    String error = "";
                    for (int i = 0; i < cmdResult.size(); ++i) {
                        error = ((String)cmdResult.get(i)).toLowerCase(Locale.ENGLISH);
                        if (!error.contains("error")) continue;
                        errorBuffer.append((String)cmds.get(i));
                        if (((String)cmds.get(i)).trim().equals("profile type decryption name https") && i < cmdResult.size() - 1 && "detect type inbound".equals(((String)cmds.get(i + 1)).trim())) {
                            doMmark = false;
                        }
                        if (!error.contains("decryption-policy") && !error.contains("undo rule name https") && !error.contains("undo profile type decryption name https")) break;
                        undoMmark = false;
                        break;
                    }
                    if (undoMmark) {
                        result.put(form.getDeviceId(), "PART_SUCCESS");
                        errorMsgKey = doMmark ? "lego.err.630006:" + errorBuffer.toString() : "lego.err.632003";
                    } else {
                        result.put(form.getDeviceId(), "SUCCESS");
                    }
                }
            }
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)"legoException", (Throwable)legoException);
            result.put(form.getDeviceId(), "PART_SUCCESS");
            errorMsgKey = "lego.err." + legoException.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error((Object)"unexpected exception", (Throwable)e);
            result.put(form.getDeviceId(), "PART_SUCCESS");
            errorMsgKey = "lego.err.630005";
        }
        finally {
            errorDetail.put(deviceId, errorMsgKey);
        }
        this.logger.info((Object)"leave deployOneDevice ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deployHelloCmd(FWDefenceAbnormalForm form, Map<Long, String> result, Map<Long, String> errorDetail) {
        String errorMsgKey = "--";
        Long deviceId = form.getDeviceId();
        try {
            List cmds = null;
            ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
            CmdParam cmdParam = new CmdParam();
            cmdParam.setCmdID("system");
            cmdParams.add(cmdParam);
            CommandAPI tool = new CommandAPI();
            String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
            cmds = tool.doTranslate(cmdFileDir, "dns_agent", cmdParams);
            this.logger.info((Object)"deploy hello cmd Begin");
            List cmdResult = CmdUtil.execCmds((long)form.getDeviceId(), (List)cmds);
            this.logger.info((Object)("cmdResult result :" + this.getcleanedMessage(cmdResult.toString())));
            Boolean isDeployOK = CommonUtil.checkCmdResult(cmdResult);
            if (isDeployOK.booleanValue()) {
                result.put(form.getDeviceId(), "SUCCESS");
            } else {
                result.put(form.getDeviceId(), "PART_SUCCESS");
                errorMsgKey = "lego.err.630006";
            }
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)legoException);
            result.put(form.getDeviceId(), "PART_SUCCESS");
            errorMsgKey = "lego.err." + legoException.getErrorCode();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            result.put(form.getDeviceId(), "PART_SUCCESS");
            errorMsgKey = "lego.err.630005";
        }
        finally {
            errorDetail.put(deviceId, errorMsgKey);
        }
        this.logger.info((Object)"leave deployHelloCmd ");
    }

    public String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void updateDeployStatus(FWDefenceAbnormalForm form, Map<Long, String> result, Map<Long, String> errorDetail) {
        this.logger.info((Object)"enter updateDeployStatus ");
        this.logger.info((Object)("FWDefenceAbnormalForm: " + form));
        this.logger.info((Object)("result: " + this.getcleanedMessage(result.toString())));
        this.logger.info((Object)("errorDetail: " + this.getcleanedMessage(errorDetail.toString())));
        Long deviceId = form.getDeviceId();
        String deployState = result.get(deviceId);
        form.setDeployState(deployState);
        form.setErrorMsgKey(errorDetail.get(deviceId));
        if ("SUCCESS".equals(deployState)) {
            form.setDeployedCrc(form.getCurrentCrc());
        }
        this.update(form);
        this.logger.info((Object)"leave updateDeployStatus ");
    }

    private void updateSaveStatus(List<FWDefenceAbnormalForm> list, Map<Long, String> result, Map<Long, String> errorDetail) {
        this.logger.info((Object)"enter updateSaveStatus ");
        this.logger.info((Object)("List<FWDefenceAbnormalForm>: " + this.getcleanedMessage(list.toString())));
        this.logger.info((Object)("result: " + this.getcleanedMessage(result.toString())));
        this.logger.info((Object)("errorDetail: " + this.getcleanedMessage(errorDetail.toString())));
        Long deviceId = null;
        String deployState = "";
        for (FWDefenceAbnormalForm form : list) {
            deviceId = form.getDeviceId();
            deployState = result.get(deviceId);
            form.setErrorMsgKey(errorDetail.get(deviceId));
            if ("SUCCESS".equals(deployState)) {
                form.setDeployedCrc(form.getCurrentCrc());
            }
            this.update(form);
        }
        this.logger.info((Object)"leave updateSaveStatus ");
    }

    private List<String> doTranslate4Undeploy(FWDefenceAbnormalForm form) {
        this.logger.info((Object)"enter doTranslate4Undeploy ");
        List cmds = null;
        String[] ipList = form.getParams().toLowerCase(Locale.ENGLISH).split(",");
        ArrayList<CmdParam> cmdParams = new ArrayList<CmdParam>();
        CmdParam systemCmd = new CmdParam();
        systemCmd.setCmdID("system");
        cmdParams.add(systemCmd);
        for (int i = 0; i < ipList.length; ++i) {
            String defend = ipList[i];
            if (ipList[i].length() != 0) {
                CmdParam cmd = new CmdParam();
                cmd.setCmdID(defend.split(":")[0]);
                cmd.getParams().put("undo", "undo");
                cmdParams.add(cmd);
            }
            if (!"large_icmp".equals(defend.split(":")[0])) continue;
            CmdParam largeIcmp = new CmdParam();
            largeIcmp.setCmdID("large_icmp_maxrate");
            largeIcmp.getParams().put("undo", "undo");
            cmdParams.add(largeIcmp);
        }
        if (this.isSupportBlackhole(form.getDeviceId())) {
            CmdParam blackholeMode = new CmdParam();
            blackholeMode.setCmdID("blackhole_mode");
            blackholeMode.getParams().put("undo", "undo");
            cmdParams.add(blackholeMode);
        }
        CommandAPI tool = new CommandAPI();
        String cmdFileDir = CmdDevCapManager.getInstance().getCmdDevCapaFileDir(form.getDeviceId());
        cmds = tool.doTranslate(cmdFileDir, "dfn_abnormal", cmdParams);
        this.logger.info((Object)"leave doTranslate4Undeploy ");
        return cmds;
    }

    @Override
    public List<Long> queryAllNeedDeployDeviceId() {
        return this.dao.queryAllNeedDeployDeviceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> startLocationCmd(List<Long> deviceIdList, User currentUser) {
        FWDefenceAbnormalServiceImpl fWDefenceAbnormalServiceImpl = this;
        synchronized (fWDefenceAbnormalServiceImpl) {
            this.logger.info((Object)"enter startLocationCmd ");
            this.logger.info((Object)("to start location statistic deploy device list:" + deviceIdList));
            HashMap<Long, String> errorDetail = new HashMap<Long, String>();
            List<FWDefenceAbnormalForm> formList = this.initNeedStartData(deviceIdList);
            String startErrorMsgKey = "--";
            long deviceId = 0L;
            Boolean isLockOK = null;
            for (FWDefenceAbnormalForm form : formList) {
                deviceId = form.getDeviceId();
                isLockOK = CommonUtil.lock(deviceId);
                try {
                    if (isLockOK.booleanValue()) {
                        ArrayList<String> cmds = new ArrayList<String>();
                        cmds.add("system");
                        cmds.add("anti-ddos source-ip geo-location statistic");
                        List cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                        if (AticUtil.judgmentEcho((String)cmdResult.toString())) {
                            this.logger.error((Object)"lego.err . The system is busy");
                            throw new LegoCheckedException(571217L);
                        }
                        if ("nosupport".equals(this.isSupportCmdResult(cmdResult))) {
                            startErrorMsgKey = "lego.err.731045";
                            continue;
                        }
                        startErrorMsgKey = "--";
                        form.setLocationSwitch(1);
                        this.update(form);
                        this.locationSwitchOperationLog(true, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                        continue;
                    }
                    this.logger.error((Object)("failed to lock device :" + deviceId));
                    startErrorMsgKey = "lego.err.630007";
                    form.setLocationSwitch(1);
                    this.locationSwitchOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    form.setLocationSwitch(1);
                    startErrorMsgKey = "lego.err.630005";
                    this.locationSwitchOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                    throw new LegoCheckedException(deviceId, (Throwable)e);
                }
                finally {
                    errorDetail.put(deviceId, startErrorMsgKey);
                    if (!isLockOK.booleanValue()) continue;
                    Locker.getInstance().unlock(Long.valueOf(deviceId), 1);
                }
            }
            this.logger.info((Object)"leave startLocationCmd ");
            return errorDetail;
        }
    }

    private void locationSwitchOperationLog(boolean sucess, User currentUser, String deviceName, FWDefenceAbnormalForm form) {
        ISysOptLog sysOptLogMgr = null;
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            sysOptLogMgr = (ISysOptLog)context.getService("sysLogService", SysOptLogImpl.class);
        }
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        sysOptLogLego.setModule("lego.dic.module.neGlobalApp");
        if (form.getLocationSwitch() == 1) {
            sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.start.location.traffic");
        } else if (form.getLocationSwitch() == 0) {
            sysOptLogLego.setOperation("com.hs.vsm.secservice.ddos.policy.operation.stop.location.traffic");
        }
        sysOptLogLego.setTarget(deviceName);
        sysOptLogLego.setOperator(currentUser.getUserName());
        if (sucess) {
            sysOptLogLego.setResult(1);
            if (form.getLocationSwitch() == 1) {
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.start.location.traffic.success");
            } else if (form.getLocationSwitch() == 0) {
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.stop.location.traffic.success");
            }
        } else {
            sysOptLogLego.setResult(0);
            if (form.getLocationSwitch() == 1) {
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.start.location.traffic.fail");
            } else if (form.getLocationSwitch() == 0) {
                sysOptLogLego.setDetail("com.hs.vsm.secservice.ddos.policy.operation.stop.location.traffic.fail");
            }
        }
        sysOptLogLego.setTerminalIp(currentUser.getIpAdr());
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    private String isSupportCmdResult(List<String> cmdResult) {
        for (String result : cmdResult) {
            if (!result.contains("Error: Unrecognized command found at")) continue;
            return "nosupport";
        }
        return "support";
    }

    private List<FWDefenceAbnormalForm> initNeedStartData(List<Long> deviceIdList) {
        this.logger.info((Object)"enter initNeedStartData");
        ArrayList<FWDefenceAbnormalForm> list = new ArrayList<FWDefenceAbnormalForm>();
        for (Long deviceId : deviceIdList) {
            FWDefenceAbnormalForm form = this.queryNeedStartDevice(deviceId);
            list.add(form);
        }
        this.logger.info((Object)"leave initNeedStartData");
        return list;
    }

    private List<FWDefenceAbnormalForm> initNeedStopData(List<Long> deviceIdList) {
        this.logger.info((Object)"enter initNeedStopData");
        ArrayList<FWDefenceAbnormalForm> list = new ArrayList<FWDefenceAbnormalForm>();
        for (Long deviceId : deviceIdList) {
            FWDefenceAbnormalForm form = this.queryNeedStopDevice(deviceId);
            list.add(form);
        }
        this.logger.info((Object)"leave initNeedStopData");
        return list;
    }

    public FWDefenceAbnormalForm queryNeedStartDevice(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        FWDefenceAbnormalInfo info = this.dao.isNeedStart(deviceId);
        if (null == info) {
            return null;
        }
        FWDefenceAbnormalForm form = new FWDefenceAbnormalForm();
        AticUtil.copyProperties((Object)info, (Object)form);
        this.logger.info((Object)"leave queryByDeviceId");
        return form;
    }

    public FWDefenceAbnormalForm queryNeedStopDevice(Long deviceId) {
        this.logger.info((Object)"enter queryByDeviceId");
        FWDefenceAbnormalInfo info = this.dao.isNeedStop(deviceId);
        if (null == info) {
            return null;
        }
        FWDefenceAbnormalForm form = new FWDefenceAbnormalForm();
        AticUtil.copyProperties((Object)info, (Object)form);
        this.logger.info((Object)"leave queryByDeviceId");
        return form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, String> stopLocationCmd(List<Long> deviceIdList, User currentUser) {
        FWDefenceAbnormalServiceImpl fWDefenceAbnormalServiceImpl = this;
        synchronized (fWDefenceAbnormalServiceImpl) {
            this.logger.info((Object)("to stop location traffic staticistic device list:" + deviceIdList));
            HashMap<Long, String> errorDetail = new HashMap<Long, String>();
            List<FWDefenceAbnormalForm> formList = this.initNeedStopData(deviceIdList);
            String startErrorMsgKey = "--";
            long deviceId = 0L;
            Boolean isLockOK = null;
            for (FWDefenceAbnormalForm form : formList) {
                deviceId = form.getDeviceId();
                isLockOK = CommonUtil.lock(deviceId);
                try {
                    if (isLockOK.booleanValue()) {
                        ArrayList<String> cmds = new ArrayList<String>();
                        cmds.add("system");
                        cmds.add("undo anti-ddos source-ip geo-location statistic");
                        List cmdResult = CmdUtil.execCmds((long)deviceId, cmds);
                        if (AticUtil.judgmentEcho((String)cmdResult.toString())) {
                            this.logger.error((Object)"lego.err . The system is busy");
                            throw new LegoCheckedException(571217L);
                        }
                        if ("nosupport".equals(this.isSupportCmdResult(cmdResult))) {
                            startErrorMsgKey = "lego.err.731045";
                            continue;
                        }
                        startErrorMsgKey = "--";
                        form.setLocationSwitch(0);
                        this.update(form);
                        this.locationSwitchOperationLog(true, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                        continue;
                    }
                    this.logger.error((Object)("failed to lock device :" + deviceId));
                    startErrorMsgKey = "lego.err.630007";
                    form.setLocationSwitch(0);
                    this.locationSwitchOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                    startErrorMsgKey = "lego.err.630005";
                    form.setLocationSwitch(0);
                    this.locationSwitchOperationLog(false, currentUser, this.aticDeviceDao.getDeviceByMoid(deviceId).getName(), form);
                    throw new LegoCheckedException(deviceId, (Throwable)e);
                }
                finally {
                    errorDetail.put(deviceId, startErrorMsgKey);
                    if (!isLockOK.booleanValue()) continue;
                    Locker.getInstance().unlock(Long.valueOf(deviceId), 1);
                }
            }
            this.logger.info((Object)"leave startLocationCmd ");
            return errorDetail;
        }
    }

    @Override
    public void updateFilterErrorMsg(String errorCode, String filterErrorParam, Long deviceId) {
        this.dao.updateFilterErrorMsg(errorCode, filterErrorParam, deviceId);
    }

    public ICommonUtilService getCommonUtilService() {
        return this.commonUtilService;
    }

    public void setCommonUtilService(ICommonUtilService commonUtilService) {
        this.commonUtilService = commonUtilService;
    }
}

