/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service;

import com.hs.atic.util.AticUtil;
import com.hs.atic.zone.util.ZoneUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.BaseCommonUtil;
import com.hs.vsm.secservice.ddos.util.PropertyNeglobalUtil;
import com.hs.vsm.secservice.neglobal.dao.GloDomainWhiteListDAO;
import com.hs.vsm.secservice.neglobal.model.GloDomainWhiteListInfo;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloDomainWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.resource.dao.AticDeviceDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GloDomainWhiteListServiceImpl
implements IGloDomainWhiteListService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private GloDomainWhiteListDAO gDomainWhiteListDAO;
    private AticDeviceDao aticDeviceDao;

    public GloDomainWhiteListDAO getgDomainWhiteListDAO() {
        return this.gDomainWhiteListDAO;
    }

    public void setgDomainWhiteListDAO(GloDomainWhiteListDAO dAO) {
        this.gDomainWhiteListDAO = dAO;
    }

    @Override
    public BatchOperationResult batchDelGloDomainWhiteList(List<BatchOperation> gloList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == gloList || gloList.isEmpty()) {
            return result;
        }
        for (BatchOperation bo : gloList) {
            try {
                GloDomainWhiteListForm gloDomainWhiteListForm = this.findById(bo.getTargetId());
                if (null == gloDomainWhiteListForm) {
                    this.logger.error((Object)(" make deltetFlag domainWhitelist : " + GloDomainWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                    ++fail;
                    bo.setErrorCode(570816L);
                    continue;
                }
                String[] detailPara = null;
                detailPara = new String[]{gloDomainWhiteListForm.getDomainWhite()};
                this.updateFlag(bo.getTargetId(), gloDomainWhiteListForm);
                bo.setOptDetail("com.hs.vsm.secservice.neglobal.whitelist.domain.oplog.del");
                bo.setDetailParam(detailPara);
                this.logger.info((Object)("make deltetFlag domainWhitelist : " + GloDomainWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + "successfully."));
            }
            catch (Exception e) {
                ++fail;
                bo.setErrorCode(570817L);
                this.logger.error((Object)("make deltetFlag domainWhitelist : " + GloDomainWhiteListServiceImpl.getcleanedMessage(bo.getTargetName()) + " failed"), (Throwable)e);
            }
        }
        result.setResult(gloList);
        result.setFailCount(fail);
        result.setTotalCount(gloList.size());
        result.setSucceedCount(gloList.size() - fail);
        this.logger.info((Object)("batch make deltetFlag domainWhitelist result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public void delById(Long id) {
        this.gDomainWhiteListDAO.remove(id);
    }

    @Override
    public void updateFlag(Long id, GloDomainWhiteListForm gloDomainWhiteListForm) {
        if (gloDomainWhiteListForm.getDeployState().equalsIgnoreCase("SUCCESS")) {
            this.gDomainWhiteListDAO.updateFlag(id);
        } else {
            this.gDomainWhiteListDAO.remove(id);
        }
    }

    @Override
    public GloDomainWhiteListForm findById(Long id) {
        GloDomainWhiteListInfo gloInfo = this.gDomainWhiteListDAO.get(id);
        GloDomainWhiteListForm form = (GloDomainWhiteListForm)AticUtil.copyProperties((Object)gloInfo, (Object)new GloDomainWhiteListForm());
        this.logger.info((Object)("find domainWhite by id : " + id));
        return form;
    }

    @Override
    public List<GloDomainWhiteListForm> findExist(String domainWhite, String deviceId) {
        List<GloDomainWhiteListInfo> whitelist = this.gDomainWhiteListDAO.getByWhiteAndDeviceId(domainWhite, deviceId);
        if (whitelist.isEmpty()) {
            return null;
        }
        ArrayList<GloDomainWhiteListForm> formList = new ArrayList<GloDomainWhiteListForm>();
        for (GloDomainWhiteListInfo gInfo : whitelist) {
            GloDomainWhiteListForm form = new GloDomainWhiteListForm();
            AticUtil.copyProperties((Object)gInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public List<GloDomainWhiteListForm> getByIds(String ids) {
        List<GloDomainWhiteListInfo> gloWhiteListInfos = this.gDomainWhiteListDAO.getByIds(ids);
        ArrayList<GloDomainWhiteListForm> formList = new ArrayList<GloDomainWhiteListForm>();
        for (GloDomainWhiteListInfo gloWhiteListInfo : gloWhiteListInfos) {
            GloDomainWhiteListForm form = new GloDomainWhiteListForm();
            AticUtil.copyProperties((Object)gloWhiteListInfo, (Object)form);
            formList.add(form);
        }
        return formList;
    }

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        this.logger.info((Object)"domainwhitelist enter queryByPage");
        Paging page = this.gDomainWhiteListDAO.queryByPage(queryMap, start, pageSize);
        List list = page.getData();
        ArrayList<GloDomainWhiteListForm> formList = new ArrayList<GloDomainWhiteListForm>();
        for (GloDomainWhiteListInfo info : list) {
            GloDomainWhiteListForm form = new GloDomainWhiteListForm();
            AticUtil.copyProperties((Object)info, (Object)form);
            formList.add(form);
        }
        page.setData(formList);
        this.logger.info((Object)"domainwhitelist leave queryByPage");
        return page;
    }

    @Override
    public void saveGloDomainWhite(GloDomainWhiteListForm form) {
        GloDomainWhiteListInfo info = (GloDomainWhiteListInfo)AticUtil.copyProperties((Object)form, (Object)new GloDomainWhiteListInfo());
        this.gDomainWhiteListDAO.saveOrUpdate(info);
    }

    @Override
    public void saveGloDomainWhiteByWhite(GloDomainWhiteListForm form) {
        List<GloDomainWhiteListInfo> list = this.gDomainWhiteListDAO.getByWhiteAndDeviceId(form.getDomainWhite(), form.getDeviceId());
        if (list.isEmpty()) {
            GloDomainWhiteListInfo info = (GloDomainWhiteListInfo)AticUtil.copyProperties((Object)form, (Object)new GloDomainWhiteListInfo());
            this.gDomainWhiteListDAO.saveOrUpdate(info);
        } else {
            GloDomainWhiteListInfo info = list.get(0);
            info.setDeleteFlag("0");
            this.gDomainWhiteListDAO.saveOrUpdate(info);
            int num = list.size();
            for (int i = 1; i < num; ++i) {
                this.gDomainWhiteListDAO.delete(list.get(i));
            }
        }
    }

    @Override
    public Map<String, List<GloDomainWhiteListForm>> getdomainWhiteMap(Long deviceId) {
        HashMap<String, List<GloDomainWhiteListForm>> map = new HashMap<String, List<GloDomainWhiteListForm>>();
        if (null == deviceId || deviceId < 0L) {
            this.logger.info((Object)("domain deploy : deviceId is null" + deviceId));
            return map;
        }
        try {
            AticDevice at = this.aticDeviceDao.getDeviceByMoid(deviceId.longValue());
            if (!PropertyNeglobalUtil.checkVersion((String)at.getVersion())) {
                this.logger.info((Object)("domain deploy : Version is Error ,deviceId : " + deviceId));
                return map;
            }
            List<GloDomainWhiteListInfo> infos = this.initDeployData(deviceId);
            if (infos.isEmpty()) {
                this.logger.info((Object)("domain deploy : domainWhiteList is Empty ,deviceId : " + deviceId));
                return map;
            }
            ArrayList<GloDomainWhiteListForm> delList = new ArrayList<GloDomainWhiteListForm>();
            ArrayList<GloDomainWhiteListForm> formList = new ArrayList<GloDomainWhiteListForm>();
            ArrayList<GloDomainWhiteListInfo> invalid = new ArrayList<GloDomainWhiteListInfo>();
            for (GloDomainWhiteListInfo glo : infos) {
                if (!BaseCommonUtil.isDomain((String)glo.getDomainWhite())) {
                    invalid.add(glo);
                    continue;
                }
                GloDomainWhiteListForm form = new GloDomainWhiteListForm();
                AticUtil.copyProperties((Object)glo, (Object)form);
                if ("1".equals(glo.getDeleteFlag())) {
                    delList.add(form);
                    continue;
                }
                formList.add(form);
            }
            if (!invalid.isEmpty()) {
                this.gDomainWhiteListDAO.deleteAll(invalid);
            }
            if (formList.isEmpty() && delList.size() == this.gDomainWhiteListDAO.queryAllWhiteCounts(String.valueOf(deviceId))) {
                map.put("AllDel", new ArrayList());
            } else {
                map.put("delList", delList);
                map.put("formList", formList);
            }
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("domain deploy : Error ,deviceId : " + deviceId));
        }
        return map;
    }

    @Override
    public void removeAllDomainWhite(Long deviceId) {
        this.gDomainWhiteListDAO.removeAllDomainWhite(deviceId);
    }

    @Override
    public void deleteAllDomainWhite(List<Long> moidList) {
        if (null == moidList || moidList.isEmpty()) {
            return;
        }
        for (Long moid : moidList) {
            this.gDomainWhiteListDAO.removeAllDomainWhite(moid);
        }
    }

    @Override
    public List<GloDomainWhiteListInfo> initDeployData(Long deviceId) {
        this.logger.info((Object)"enter Domain initDeployData");
        List<GloDomainWhiteListInfo> infos = this.queryByDeviceId(deviceId);
        if (infos == null) {
            infos = new ArrayList<GloDomainWhiteListInfo>();
        }
        this.logger.info((Object)"leave initDeployData");
        return infos;
    }

    @Override
    public List<GloDomainWhiteListInfo> queryByDeviceId(Long deviceId) {
        this.logger.info((Object)"enter GloDomainWhiteListInfo queryByDeviceId");
        List<GloDomainWhiteListInfo> list = this.gDomainWhiteListDAO.queryByDeviceId(String.valueOf(deviceId));
        if (null == list) {
            return null;
        }
        this.logger.info((Object)"leave GloDomainWhiteListInfo queryByDeviceId");
        return list;
    }

    @Override
    public void updateDeployStatus(GloDomainWhiteListForm form) {
        this.logger.info((Object)"enter domain update");
        GloDomainWhiteListInfo info = new GloDomainWhiteListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gDomainWhiteListDAO.update(info);
        this.logger.info((Object)"leave domain update");
    }

    @Override
    public void updateBatchDeployStatus(List<GloDomainWhiteListForm> formList, String status) {
        this.logger.info((Object)"enter domain update batch");
        this.gDomainWhiteListDAO.updateBatchGloDomainWhiteListInfo(formList, status);
        this.logger.info((Object)"leave domain update batch");
    }

    @Override
    public void deleteBatchUndoDeployData(List<GloDomainWhiteListForm> formList) {
        this.logger.info((Object)"enter domain delete batch");
        this.gDomainWhiteListDAO.deleteBatchUndoDeployData(formList);
        this.logger.info((Object)"leave domain delete batch");
    }

    @Override
    public void deleteUndoDeployData(GloDomainWhiteListForm form) {
        this.logger.info((Object)"enter Domain update");
        GloDomainWhiteListInfo info = new GloDomainWhiteListInfo();
        AticUtil.copyProperties((Object)form, (Object)info);
        this.gDomainWhiteListDAO.deleteFlagData(form.getDwid());
        this.logger.info((Object)"leave Domain update");
    }

    @Override
    public BatchOperationResult saveWhiteList(List<BatchOperation> batchOpList, String deviceId) {
        this.logger.info((Object)"entry saveImport DomainWhiteList");
        BatchOperationResult result = new BatchOperationResult();
        List<GloDomainWhiteListInfo> wList = null;
        int fail = 0;
        GloDomainWhiteListInfo old = null;
        BatchOperation bo = null;
        String data = null;
        int j = batchOpList.size();
        for (int i = 0; i < j; ++i) {
            bo = batchOpList.get(i);
            data = bo.getOptDetail().trim();
            if (!BaseCommonUtil.isDomain((String)data)) {
                ++fail;
                bo.setErrorCode(570818L);
                bo.setTargetName(data);
                this.logger.error((Object)("domain Whitelist data error:" + data));
                continue;
            }
            old = this.oldDomainWhiteList(wList, data);
            if (null == old) {
                old = new GloDomainWhiteListInfo();
                old.setDeviceId(deviceId);
                old.setDomainWhite(data);
                old.setDeployState("UNDEPLOY");
                old.setDeleteFlag("0");
            }
            this.gDomainWhiteListDAO.saveOrUpdate(old);
        }
        result.setResult(batchOpList);
        result.setFailCount(fail);
        result.setTotalCount(batchOpList.size());
        result.setSucceedCount(batchOpList.size() - fail);
        this.logger.info((Object)"leave saveImport DomainWhiteList");
        return result;
    }

    private GloDomainWhiteListInfo oldDomainWhiteList(List<GloDomainWhiteListInfo> wList, String domain) {
        if (null != wList && !wList.isEmpty()) {
            for (GloDomainWhiteListInfo wInfo : wList) {
                if (!domain.trim().equals(wInfo.getDomainWhite())) continue;
                wInfo.setDeleteFlag("0");
                return wInfo;
            }
        }
        return null;
    }

    @Override
    public int queryAllWhiteCount(Long deviceId) {
        this.logger.info((Object)("enter query All Domai nWhite Count by deviceId :" + deviceId));
        return this.gDomainWhiteListDAO.queryAllWhiteCount(String.valueOf(deviceId));
    }

    @Override
    public List<GloDomainWhiteListForm> queryAllWhitelist(Long deviceId) {
        List<GloDomainWhiteListInfo> dlist = this.gDomainWhiteListDAO.queryAllDomainList(deviceId);
        ArrayList<GloDomainWhiteListForm> lisitForm = new ArrayList<GloDomainWhiteListForm>();
        if (null != dlist && !dlist.isEmpty()) {
            for (GloDomainWhiteListInfo gnfo : dlist) {
                GloDomainWhiteListForm fom = new GloDomainWhiteListForm();
                ZoneUtil.copyProperties((Object)gnfo, (Object)fom);
                lisitForm.add(fom);
            }
        }
        return lisitForm;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public BatchOperationResult delAllGloWhiteList(String deviceid) {
        int numDel = this.gDomainWhiteListDAO.clearAllDomainWhiteListData(deviceid);
        int numUp = this.gDomainWhiteListDAO.updateFlagByDeviceId(deviceid);
        BatchOperationResult bt = new BatchOperationResult();
        bt.setTotalCount(numDel + numUp);
        return bt;
    }

    public AticDeviceDao getAticDeviceDao() {
        return this.aticDeviceDao;
    }

    public void setAticDeviceDao(AticDeviceDao aticDeviceDao) {
        this.aticDeviceDao = aticDeviceDao;
    }
}

