/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.neglobal.service.deploy;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.neglobal.service.deploy.CreateGlobalDeployParam;
import com.hs.vsm.secservice.neglobal.service.deploy.GlobalDeployData;
import com.hs.vsm.secservice.neglobal.service.deploy.GlobalDeployThread;
import com.hs.vsm.secservice.sdk.common.util.ProgressBar;
import com.hs.vsm.secservice.sdk.common.util.ProgressMgr;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterDeviceZoneInfoService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.neglobal.form.FWDefenceAbnormalForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloBlackListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloCdnIpListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.form.GloWhiteListForm;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IFWDefenceAbnormalService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloBlackListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloCdnIpListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloDomainWhiteListService;
import com.hs.vsm.secservice.sdk.module.neglobal.service.IGloWhiteListService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GlobalDeployCtrl {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_NEGLOBAL);
    private IFWDefenceAbnormalService fwDefenceAbnormalService;
    private IGloBlackListService gloBlackListService;
    private IGloWhiteListService gloWhiteListService;
    private IGloDomainWhiteListService gloDomainWhiteListService;
    private IGloCdnIpListService gloCdnIpListService;
    private IAticDeviceService aticDeviceService;
    private IFilterDeviceZoneInfoService filterDeviceZoneInfoService;
    private IFilterService filterService;

    public void doDeploy(Long deviceId, Long progressBarId, Map<Long, String> result, Map<Long, String> errorDetail) {
        this.logger.info((Object)("to deploy device id:" + deviceId + ", progressBarId" + progressBarId));
        GlobalDeployData deployData = new GlobalDeployData();
        ProgressBar progressBar = ProgressMgr.getInstance().createProgressBar(100, progressBarId.longValue());
        deployData.setDeviceId(deviceId);
        deployData.setProgressBar(progressBar);
        deployData.setProgressBarId(progressBarId);
        deployData.setResult(result);
        deployData.setErrorDetai(errorDetail);
        this.initData(deployData);
        CreateGlobalDeployParam createGlobalDeployParam = new CreateGlobalDeployParam();
        createGlobalDeployParam.setDeviceId(deviceId);
        createGlobalDeployParam.setProgressBar(progressBar);
        createGlobalDeployParam.setResult(deployData.getResult());
        createGlobalDeployParam.setErrorDetail(deployData.getErrorDetai());
        createGlobalDeployParam.setForm(deployData.getForm());
        createGlobalDeployParam.setListBlackForms(deployData.getListBlackForms());
        createGlobalDeployParam.setListWhiteForms(deployData.getListWhiteForms());
        createGlobalDeployParam.setCdnIpListForms(deployData.getCdnIpListForms());
        createGlobalDeployParam.setUndoCdnIpListForms(deployData.getUndoCdnIpListForms());
        createGlobalDeployParam.setListFilterForms(deployData.getListFilterForms());
        createGlobalDeployParam.setFilterService(this.filterService);
        createGlobalDeployParam.setFilterDeviceZoneInfoService(this.filterDeviceZoneInfoService);
        createGlobalDeployParam.setAbnormalService(this.fwDefenceAbnormalService);
        createGlobalDeployParam.setBlackListService(this.gloBlackListService);
        createGlobalDeployParam.setGloWhiteListService(this.gloWhiteListService);
        createGlobalDeployParam.setGloCdnIpListService(this.gloCdnIpListService);
        createGlobalDeployParam.setGloDomainWhiteListService(this.gloDomainWhiteListService);
        createGlobalDeployParam.setAticDeviceService(this.aticDeviceService);
        createGlobalDeployParam.setProgressBarId(deployData.getProgressBarId());
        GlobalDeployThread task = new GlobalDeployThread(createGlobalDeployParam);
        deployData.getThreadPool().submit(task);
        deployData.getThreadPool().shutdown();
        this.logger.info((Object)"leave doDeploy in the GloBalDeployCtrl");
        try {
            if (deployData.getThreadPool().awaitTermination(30L, TimeUnit.MINUTES)) {
                this.logger.info((Object)"zone deploy thread execute finished.");
            }
        }
        catch (InterruptedException e1) {
            this.logger.error((Object)"zone deploy thread execute timeout.", (Throwable)e1);
        }
    }

    private void initData(GlobalDeployData deployData) {
        FWDefenceAbnormalForm form = this.fwDefenceAbnormalService.queryByDeviceId(deployData.getDeviceId());
        List<GloBlackListForm> listBlackForms = this.gloBlackListService.initDeployData(deployData.getDeviceId());
        List<GloWhiteListForm> listWhiteForms = this.gloWhiteListService.initDeployData(deployData.getDeviceId());
        List<GloCdnIpListForm> cdnIpListForms = this.gloCdnIpListService.initDeployData(deployData.getDeviceId());
        List<GloCdnIpListForm> undoCdnIpListForms = this.gloCdnIpListService.initUndoDeployData(deployData.getDeviceId());
        List<FilterForm> filterForms = this.getNeedDeployFilterData(deployData.getDeviceId());
        deployData.setForm(form);
        deployData.setListBlackForms(listBlackForms);
        deployData.setListWhiteForms(listWhiteForms);
        deployData.setListFilterForms(filterForms);
        deployData.setCdnIpListForms(cdnIpListForms);
        deployData.setUndoCdnIpListForms(undoCdnIpListForms);
        int totalStep = this.calcTotalStep(deployData) + 1;
        this.logger.info((Object)("initData totalStep:" + totalStep));
        deployData.getProgressBar().setTotalStep(totalStep);
        ThreadPoolExecutor threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        deployData.setThreadPool(threadPool);
        this.logger.info((Object)"leave initData");
    }

    private List<FilterForm> getNeedDeployFilterData(Long deviceId) {
        return new ArrayList<FilterForm>();
    }

    private int calcTotalStep(GlobalDeployData deployData) {
        int totalStep = 0;
        if (null != deployData.getForm()) {
            ++totalStep;
        }
        if (null != deployData.getListBlackForms() && !deployData.getListBlackForms().isEmpty()) {
            totalStep += deployData.getListBlackForms().size();
        }
        if (null != deployData.getListWhiteForms() && !deployData.getListWhiteForms().isEmpty()) {
            totalStep += deployData.getListWhiteForms().size();
        }
        if (null != deployData.getUndoCdnIpListForms() && !deployData.getUndoCdnIpListForms().isEmpty()) {
            totalStep += deployData.getUndoCdnIpListForms().size();
        }
        if (null != deployData.getCdnIpListForms() && !deployData.getCdnIpListForms().isEmpty()) {
            totalStep += deployData.getCdnIpListForms().size();
        }
        if (null != deployData.getListFilterForms() && !deployData.getListFilterForms().isEmpty()) {
            totalStep += deployData.getListFilterForms().size();
        }
        return totalStep;
    }

    public IGloCdnIpListService getGloCdnIpListService() {
        return this.gloCdnIpListService;
    }

    public void setGloCdnIpListService(IGloCdnIpListService gloCdnIpListService) {
        this.gloCdnIpListService = gloCdnIpListService;
    }

    public IGloDomainWhiteListService getGloDomainWhiteListService() {
        return this.gloDomainWhiteListService;
    }

    public void setGloDomainWhiteListService(IGloDomainWhiteListService gloDomainWhiteListService) {
        this.gloDomainWhiteListService = gloDomainWhiteListService;
    }

    public IFWDefenceAbnormalService getFwDefenceAbnormalService() {
        return this.fwDefenceAbnormalService;
    }

    public void setFwDefenceAbnormalService(IFWDefenceAbnormalService fwDefenceAbnormalService) {
        this.fwDefenceAbnormalService = fwDefenceAbnormalService;
    }

    public IGloBlackListService getGloBlackListService() {
        return this.gloBlackListService;
    }

    public void setGloBlackListService(IGloBlackListService gloBlackListService) {
        this.gloBlackListService = gloBlackListService;
    }

    public IGloWhiteListService getGloWhiteListService() {
        return this.gloWhiteListService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public void setGloWhiteListService(IGloWhiteListService gloWhiteListService) {
        this.gloWhiteListService = gloWhiteListService;
    }

    public IFilterDeviceZoneInfoService getFilterDeviceZoneInfoService() {
        return this.filterDeviceZoneInfoService;
    }

    public void setFilterDeviceZoneInfoService(IFilterDeviceZoneInfoService filterDeviceZoneInfoService) {
        this.filterDeviceZoneInfoService = filterDeviceZoneInfoService;
    }

    public IFilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(IFilterService filterService) {
        this.filterService = filterService;
    }
}

