/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor;

import com.hs.lego.monitor.thread.LegoServerMonitorThread;
import com.hs.lego.monitor.util.MonitorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegoMonitor {
    private static transient Logger logger = LoggerFactory.getLogger(LegoMonitor.class);

    public static void main(String[] args) {
        logger.info("############   Monitoring start.");
        MonitorUtil.setMonitorPid();
        boolean defaultSwitch = LegoMonitor.getDefaultSwitch(args);
        LegoServerMonitorThread ismServerMonitor = new LegoServerMonitorThread();
        ismServerMonitor.setDefaultSwitch(defaultSwitch);
        ((Thread)ismServerMonitor).start();
        logger.info("############   Monitoring end.");
    }

    private static boolean getDefaultSwitch(String[] args) {
        boolean defaultSwitch = true;
        if (1 != args.length) {
            return defaultSwitch;
        }
        if (args[0].trim().equals("off")) {
            defaultSwitch = false;
        } else if (args[0].trim().equals("on")) {
            defaultSwitch = true;
        }
        return defaultSwitch;
    }

    public static void stop(String[] args) {
        logger.info("############   Monitoring shutdown.");
        LegoMonitor.systemExit();
    }

    private static void systemExit() {
        System.exit(0);
    }
}

