/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor.thread;

import com.hs.lego.monitor.thread.IMonitor;
import com.hs.lego.monitor.util.LegoUtil;
import com.hs.lego.monitor.util.MonitorUtil;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegoServerMonitorThread
extends Thread
implements IMonitor {
    private static Logger logger = LoggerFactory.getLogger(LegoServerMonitorThread.class);
    private boolean defaultSwitch = true;
    private boolean isCanStartMonitor = true;
    private Object monitorLock = new Object();
    private final boolean runningFlag = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("----------- Start LEGO monitor ------------");
        Thread.currentThread().setName("LEGO monitor");
        while (true) {
            LegoUtil.sleep(100L);
            logger.info("After sleep 100");
            try {
                Object object = this.monitorLock;
                synchronized (object) {
                    if (!this.defaultSwitch || !this.isCanStartMonitor) {
                        logger.info("Cannot start monitor continue");
                        continue;
                    }
                }
                MonitorUtil.monitorLegoServer();
                MonitorUtil.monitorDatabase();
            }
            catch (Exception e) {
                logger.error("Monitoring ism server has error happened.", (Throwable)e);
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                String errorMsg = "Having error happened when monitoring ism server.";
                logger.error(errorMsg, (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultSwitch(boolean defaultSwitch) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.defaultSwitch = defaultSwitch;
        }
        logger.info("After setDefaultSwitch.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMonitor() {
        Object object = this.monitorLock;
        synchronized (object) {
            this.defaultSwitch = true;
        }
        logger.info("after startMonitor().");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMonitor(long delay) {
        logger.info("startMonitor method begin");
        Object object = this.monitorLock;
        synchronized (object) {
            logger.info("In startMonitor method");
            this.defaultSwitch = true;
            this.isCanStartMonitor = false;
            logger.info("Set isCanStartMonitor to false.");
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LegoServerMonitorThread.this.monitorLock;
                    synchronized (object) {
                        LegoServerMonitorThread.this.isCanStartMonitor = true;
                        logger.info("Set isCanStartMonitor to true.");
                    }
                }
            }, delay);
        }
        logger.info("Start ism server monitor after " + delay + " ms.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitor() {
        Object object = this.monitorLock;
        synchronized (object) {
            this.defaultSwitch = false;
        }
        logger.info("Stop ism server monitor.");
    }
}

