/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor.util;

import com.hs.lego.core.sdk.util.EncryptData;
import com.hs.lego.monitor.util.IPUtil;
import com.huawei.atic.util.CertFileUtil;
import java.io.File;
import java.util.Properties;

class EncryptUtil {
    private String aticRmiServiceIp = "127.0.0.1";

    private EncryptUtil() {
        this.init();
    }

    private void init() {
        String certPath = CertFileUtil.getInstance().getCertPath();
        Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties(certPath);
        EncryptUtil.judgeAndSetSystemProperty("javax.net.ssl.keyStore", properties.getProperty("keystore.mc.path", certPath + File.separator + "mc_keystore"));
        EncryptUtil.judgeEncryptAndSetSystemProperty("javax.net.ssl.keyStorePassword", properties.getProperty("keystore.mc.password"));
        EncryptUtil.judgeAndSetSystemProperty("javax.net.ssl.trustStore", properties.getProperty("truststore.mc.path", certPath + File.separator + "mc_truststore"));
        EncryptUtil.judgeEncryptAndSetSystemProperty("javax.net.ssl.trustStorePassword", properties.getProperty("truststore.mc.password"));
        this.aticRmiServiceIp = IPUtil.getInstance().getIp();
        if (null == this.aticRmiServiceIp || this.aticRmiServiceIp.isEmpty()) {
            this.aticRmiServiceIp = "127.0.0.1";
        }
        System.setProperty("java.rmi.server.hostname", this.aticRmiServiceIp);
    }

    private static void judgeAndSetSystemProperty(String key, String defaultValue) {
        if (EncryptUtil.isEmpty(System.getProperty(key))) {
            System.setProperty(key, defaultValue);
        }
    }

    private static void judgeEncryptAndSetSystemProperty(String key, String defaultValue) {
        if (EncryptUtil.isEmpty(System.getProperty(key))) {
            System.setProperty(key, EncryptData.getInstanse().decryptInitdata(defaultValue));
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static EncryptUtil getInstance() {
        return EncryptUtilHolder.encryptUtil;
    }

    public String getAticRmiServiceIp() {
        return this.aticRmiServiceIp;
    }

    private static class EncryptUtilHolder {
        private static EncryptUtil encryptUtil = new EncryptUtil();

        private EncryptUtilHolder() {
        }
    }
}

