/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegoUtil {
    private static transient Logger logger = LoggerFactory.getLogger(LegoUtil.class);

    public static void closeSocket(Socket socket) {
        try {
            if (null != socket) {
                socket.close();
            }
        }
        catch (Exception e) {
            logger.error("Closing socket has error happened.", (Throwable)e);
        }
    }

    public static void closeServerSocket(ServerSocket socket) {
        try {
            if (null != socket) {
                socket.close();
            }
        }
        catch (Exception e) {
            logger.error("Closing server socket has error happened.", (Throwable)e);
        }
    }

    public static void closeInputStream(InputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (Exception e) {
            logger.error("Closing input stream has error happened.", (Throwable)e);
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (Exception e) {
            logger.error("Closing output stream has error happened.", (Throwable)e);
        }
    }

    public static void closeReader(Reader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.error("Closing reader has error happened.", (Throwable)e);
        }
    }

    public static void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            logger.error("Sleeping has error happened.", (Throwable)e);
        }
    }
}

