/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor.util;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.sdk.system.service.DatabaseStatusService;
import com.hs.lego.monitor.model.Program;
import com.hs.lego.monitor.util.EncryptUtil;
import com.hs.lego.monitor.util.LegoUtil;
import com.hs.lego.monitor.util.PropUtil;
import com.hs.vsm.productUtil.FileUtil;
import com.hs.vsm.productUtil.ProductSvc;
import com.hs.vsm.productUtil.ServerUtil;
import com.hs.vsm.productUtil.ServiceProgram;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtil {
    private static final String CMD_STR_START_LEGO_WEB_SVR = "cmd /c sc start LEGOWebSrv";
    private static final String MONITORPID = "monitorpid";
    private static final String PID_CONF = "pid.conf";
    private static final String SERVICE_NAME = "databaseStatusService";
    private static final int COUNTER_FOUR = 4;
    private static final int COUNTER_TWO = 2;
    private static int legoHttpPort = 80;
    private static int httpRetryTimes = 12;
    private static String legoForeendName = "legowebsrv.exe";
    private static int aticRmiServicePort = 11098;
    private static String aticRmiServiceIp = "127.0.0.1";
    private static transient Logger logger = LoggerFactory.getLogger(MonitorUtil.class);
    private static String httpPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execCommand(String command) {
        logger.info("Exec: " + command);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            logger.error("Executing command has error happened.", (Throwable)e);
        }
        try {
            if (null == process) {
                return;
            }
            process.waitFor();
            InputStream inStream = process.getInputStream();
            InputStreamReader inStreamReader = new InputStreamReader(inStream, "utf-8");
            BufferedReader bufReader = new BufferedReader(inStreamReader);
            String commandLine = null;
            try {
                commandLine = bufReader.readLine();
                while (null != commandLine) {
                    commandLine = bufReader.readLine();
                    if (null == commandLine) continue;
                    logger.info(commandLine);
                }
            }
            catch (IOException e) {
                logger.error("Executing task list command has error happened.", (Throwable)e);
            }
            finally {
                LegoUtil.closeReader(bufReader);
                LegoUtil.closeReader(inStreamReader);
                LegoUtil.closeInputStream(inStream);
                process.destroy();
            }
        }
        catch (InterruptedException e) {
            logger.error("Executing command has error happened.", (Throwable)e);
        }
        catch (UnsupportedEncodingException e1) {
            logger.error("Executing command has error happened.", (Throwable)e1);
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
    }

    public static String getHttpPort() {
        String encoding = "ISO-8859-1";
        String installFilePath = "legoInstalled.xml";
        String httpPorts = String.valueOf(legoHttpPort);
        SAXReader saxReader = new SAXReader();
        saxReader.setEncoding(encoding);
        File installFile = new File(installFilePath);
        try {
            Document tagdocument = saxReader.read(installFile);
            List httpPortEles = tagdocument.selectNodes("/install/httport");
            for (Object object : httpPortEles) {
                Element ele = (Element)object;
                httpPorts = ele.getTextTrim();
            }
            logger.info("The http prot is : " + httpPorts);
        }
        catch (DocumentException e) {
            logger.error("getHttpPort has error happened.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("getHttpPort has error happened.", (Throwable)e);
        }
        return httpPorts;
    }

    public static Program findProgramByNames(String name) {
        logger.info("Begin findProgramByNames. the name is " + name);
        if (null == name) {
            return null;
        }
        List<Program> programs = MonitorUtil.taskList();
        for (Program pg : programs) {
            if (!pg.getName().equals(name)) continue;
            return pg;
        }
        return null;
    }

    @Deprecated
    public static Program findProgramByPorts(int ... ports) {
        logger.info("Begin findProgramByPorts.");
        if (null == ports || 0 == ports.length) {
            return null;
        }
        StringBuffer command = new StringBuffer();
        command.append("cmd /c netstat -aon | findstr \"LISTENING\" | findstr \"");
        for (int i = 0; i < ports.length; ++i) {
            int port = ports[i];
            command.append(port);
            if (i + 1 == ports.length) continue;
            command.append(" | ");
        }
        command.append("\"");
        Program program = MonitorUtil.getProgramByPorts(command.toString(), ports);
        if (null == program) {
            return null;
        }
        Program returnedValue = null;
        List<Program> programs = MonitorUtil.taskList();
        for (Program pg : programs) {
            if (pg.getPid() != program.getPid()) continue;
            returnedValue = program;
            returnedValue.setName(pg.getName());
            break;
        }
        logger.info("End findProgramByPorts.");
        return returnedValue;
    }

    public static boolean isStartedLegoSystem(String url) {
        boolean isStartedSuccess = false;
        isStartedSuccess = MonitorUtil.testHttpConnection(url);
        return isStartedSuccess;
    }

    public static void killProgramByPid(int ... programPids) {
        logger.info("Kill Program...");
        if (null == programPids || 0 == programPids.length) {
            return;
        }
        StringBuffer command = new StringBuffer();
        command.append("taskkill");
        for (int programPid : programPids) {
            command.append(" /PID " + programPid);
        }
        command.append(" /F");
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command.toString());
        }
        catch (IOException e) {
            logger.error("Killing program by process id has error happened." + MonitorUtil.printIntArray(programPids), (Throwable)e);
        }
        int exitValue = -1;
        try {
            if (null != process) {
                exitValue = process.waitFor();
            }
        }
        catch (InterruptedException e) {
            logger.error("Killing program by process id has error happened." + MonitorUtil.printIntArray(programPids), (Throwable)e);
        }
        logger.info("Killing program by process id successed. Names:" + MonitorUtil.printIntArray(programPids) + ",ExitValue:" + exitValue);
    }

    public static void monitorLegoServer() {
        LegoUtil.sleep(120000L);
        logger.info("Begin monitorvsm-Server.");
        List<String> plist = FileUtil.returnSvcList();
        for (int i = 0; i < plist.size(); ++i) {
            ServiceProgram sp = ServerUtil.getServiceBySvcname(plist.get(i));
            if (sp.getServiceName() == null || sp.isState()) continue;
            logger.info("The service is stopped:" + sp.getServiceName());
            ProductSvc.startAllService(sp);
        }
        logger.info("Begin monitorLegoServer.");
        Program foreendPg = MonitorUtil.findProgramByNames(legoForeendName);
        logger.info("foreendPg \uff1a " + foreendPg);
        if (null != foreendPg) {
            logger.info("**********  monitorLegoWebServer succ ! *************");
            logger.info("foreendPg id \uff1a " + foreendPg.getPid());
            return;
        }
        logger.info("One or more service is down, so restart LEGO.");
        MonitorUtil.startLegoSystem();
    }

    public static void startLegoSystem() {
        String url;
        logger.info("Start LEGO system...");
        PropUtil.cleanStartStatusFlag();
        String commandFre = CMD_STR_START_LEGO_WEB_SVR;
        MonitorUtil.execCommand(commandFre);
        boolean isStartedSuccess = false;
        int counter = 0;
        LegoUtil.sleep(30000L);
        while (!(isStartedSuccess = MonitorUtil.isStartedLegoSystem(url = "http://127.0.0.1:" + httpPort)) && httpRetryTimes > ++counter) {
            try {
                if (2 >= counter) {
                    Thread.sleep(20000L);
                    continue;
                }
                if (4 >= counter) {
                    Thread.sleep(10000L);
                    continue;
                }
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error("Starting LEGO has error happened.", (Throwable)e);
            }
        }
        if (isStartedSuccess) {
            logger.info("Starting LEGO successed.");
        } else {
            logger.info("HTTP test failed , starting LEGO failed.");
        }
    }

    public static List<Program> taskList() {
        String command = "cmd /c tasklist /fo csv";
        List<Program> programs = MonitorUtil.execTaskListCmd(command);
        return programs;
    }

    public static boolean testHttpConnection(String urlStr) {
        logger.error("Begin testHttpConnection, urlStr: " + urlStr);
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            logger.error("Testing http connection has error happened.", (Throwable)e);
            return false;
        }
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            logger.error("Testing http connection has error happened.", (Throwable)e);
            return false;
        }
        connection.setConnectTimeout(5000);
        try {
            connection.connect();
        }
        catch (IOException e) {
            logger.error("Testing http connection has error happened.", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Program> execTaskListCmd(String command) {
        ArrayList<Program> programs = new ArrayList<Program>();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            logger.error("Executing task list command has error happened.", (Throwable)e);
        }
        if (null == process) {
            return programs;
        }
        InputStream inStream = process.getInputStream();
        InputStreamReader inStreamReader = null;
        try {
            inStreamReader = new InputStreamReader(inStream, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error("Executing task list command has error happened.", (Throwable)e1);
            return programs;
        }
        BufferedReader bufReader = new BufferedReader(inStreamReader);
        String commandLine = null;
        try {
            commandLine = bufReader.readLine();
            while (null != commandLine) {
                Program program = MonitorUtil.parseTasklistCmdLine(commandLine);
                commandLine = bufReader.readLine();
                if (null == program) continue;
                programs.add(program);
            }
        }
        catch (IOException e) {
            logger.error("Executing task list command has error happened.", (Throwable)e);
        }
        finally {
            LegoUtil.closeReader(bufReader);
            LegoUtil.closeReader(inStreamReader);
            LegoUtil.closeInputStream(inStream);
            process.destroy();
        }
        return programs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Program getProgramByPorts(String command, int ... ports) {
        logger.info("Begin getProgramByPorts.the cmd : " + command);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            logger.error("Getting program by ports has error happened. Ports:" + Arrays.toString(ports), (Throwable)e);
        }
        if (null == process) {
            return null;
        }
        InputStream inStream = process.getInputStream();
        InputStreamReader inStreamReader = null;
        try {
            inStreamReader = new InputStreamReader(inStream, "utf-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error("Executing task list command has error happened.", (Throwable)e1);
            return null;
        }
        BufferedReader bufReader = new BufferedReader(inStreamReader);
        Program program = null;
        String listeningCmdLine = null;
        try {
            listeningCmdLine = bufReader.readLine();
            while (null != listeningCmdLine) {
                program = MonitorUtil.parseListeningCmdLine(listeningCmdLine, ports);
                if (null != program) {
                    logger.info("listeningCmdLine-program is not null.");
                    break;
                }
                listeningCmdLine = bufReader.readLine();
            }
        }
        catch (IOException e) {
            logger.error("Getting program by ports has error happened. Ports:" + Arrays.toString(ports), (Throwable)e);
        }
        finally {
            LegoUtil.closeReader(bufReader);
            LegoUtil.closeReader(inStreamReader);
            LegoUtil.closeInputStream(inStream);
            process.destroy();
        }
        logger.info("End getProgramByPorts.");
        return program;
    }

    private static boolean isMatchedByPort(int port, int ... ports) {
        boolean isFound = false;
        for (int portId : ports) {
            if (portId != port) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    private static Program parseTasklistCmdLine(String commandLine) {
        if (null == commandLine || 0 == commandLine.trim().length() || commandLine.contains("PID") || commandLine.contains("=") || commandLine.contains("System")) {
            return null;
        }
        Program program = new Program();
        try {
            String trimedCmdLine = commandLine.trim();
            int subStartLocation = 1;
            int subEndLocation = trimedCmdLine.length() - 1;
            trimedCmdLine = trimedCmdLine.substring(subStartLocation, subEndLocation);
            String[] strArray = trimedCmdLine.split("\",\"");
            program.setName(strArray[0]);
            program.setPid(Integer.parseInt(strArray[1]));
            return program;
        }
        catch (Exception e) {
            String errorMsg = "Parsing command line has error happened. CommandLine:" + commandLine;
            logger.error(errorMsg, (Throwable)e);
            return null;
        }
    }

    private static Program parseListeningCmdLine(String listeningCmdLine, int ... ports) {
        logger.info("parseListeningCmdLine listeningCmdLine is: " + listeningCmdLine);
        if (null == listeningCmdLine || 0 == listeningCmdLine.length()) {
            return null;
        }
        Program program = new Program();
        try {
            String[] strArray = listeningCmdLine.trim().split("[ ]+");
            String[] ipPort = strArray[1].trim().split(":");
            int port = Integer.parseInt(ipPort[1]);
            logger.info("prot is : " + port);
            if (!MonitorUtil.isMatchedByPort(port, ports)) {
                logger.info("isMatchedByPort return false: " + listeningCmdLine);
                return null;
            }
            int pid = Integer.parseInt(strArray[4]);
            program.setPid(pid);
            program.addPort(port);
            return program;
        }
        catch (RuntimeException e) {
            String errorMsg = "Parsing command line has error happened. CommandLine:" + listeningCmdLine + ",Ports:" + MonitorUtil.printIntArray(ports);
            logger.info(errorMsg);
            return null;
        }
        catch (Exception e) {
            String errorMsg = "Parsing command line has error happened. CommandLine:" + listeningCmdLine + ",Ports:" + MonitorUtil.printIntArray(ports);
            logger.info(errorMsg);
            return null;
        }
    }

    private static String printIntArray(int ... intArray) {
        StringBuffer buf = new StringBuffer();
        for (int it : intArray) {
            buf.append(it);
            buf.append(",");
        }
        return buf.toString();
    }

    public static void shutDownSystem() {
        logger.info("Begin shutDownSystem.");
        Program foreendPg = MonitorUtil.findProgramByPorts(Integer.parseInt(httpPort));
        int mPid = MonitorUtil.getMonitorPid();
        logger.info("foreendPg: " + foreendPg);
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        if (null != foreendPg) {
            logger.info("foreendPg pid \uff1a " + foreendPg.getPid());
            pidList.add(foreendPg.getPid());
        }
        logger.info("monitor pid \uff1a " + mPid);
        pidList.add(mPid);
        int[] pids = new int[pidList.size()];
        for (int i = 0; i < pidList.size(); ++i) {
            pids[i] = (Integer)pidList.get(i);
        }
        MonitorUtil.killProgramByPid(pids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setMonitorPid() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        Long pid = Long.parseLong(processName.split("@")[0]);
        Properties pro = new Properties();
        FileOutputStream fileOutput = null;
        File flagFile = null;
        try {
            flagFile = new File(PID_CONF);
            fileOutput = new FileOutputStream(flagFile);
            pro.setProperty(MONITORPID, String.valueOf(pid));
            pro.store(fileOutput, "monitor pid");
            logger.info("##### setMonitorPid succ the pid is" + pid);
        }
        catch (RuntimeException e) {
            logger.error("setMonitorPid error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("setMonitorPid error", (Throwable)e);
        }
        finally {
            if (null != fileOutput) {
                try {
                    fileOutput.close();
                }
                catch (IOException e) {
                    logger.error("setMonitorPid close error", (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMonitorPid() {
        Properties pro = new Properties();
        FileInputStream fileInput = null;
        File flagFile = null;
        try {
            flagFile = new File(PID_CONF);
            fileInput = new FileInputStream(flagFile);
            pro.load(fileInput);
            String pid = (String)pro.get(MONITORPID);
            int n = Integer.parseInt(pid);
            return n;
        }
        catch (RuntimeException e) {
            logger.error("getMonitorPid error", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("getMonitorPid error", (Throwable)e);
        }
        finally {
            if (null != fileInput) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    logger.error("fileInput close error", (Throwable)e);
                }
            }
        }
        return 0;
    }

    public static void monitorDatabase() {
        logger.info("begin to check the database status.");
        int fail = 0;
        DatabaseStatusService databaseStatusService = null;
        for (int i = 0; i < 3; ++i) {
            LegoUtil.sleep(30000L);
            databaseStatusService = (DatabaseStatusService)MonitorUtil.retreiveAticRmiService(SERVICE_NAME);
            if (null != databaseStatusService) break;
        }
        if (null == databaseStatusService) {
            logger.error("cannot get the databaseStatusService instance, so restart LEGO.");
            MonitorUtil.restartService();
        }
        int status = -1;
        for (int j = 0; j < 3; ++j) {
            try {
                if (databaseStatusService == null) {
                    logger.error(" check database status failed");
                    ++fail;
                    LegoUtil.sleep(30000L);
                    continue;
                }
                status = databaseStatusService.checkDatabaseStatus();
                if (status <= -1) continue;
                break;
            }
            catch (Exception e) {
                logger.error(" check database status failed. exception:" + e.toString());
                ++fail;
                LegoUtil.sleep(30000L);
            }
        }
        if (fail > 2) {
            logger.error(" check database status failed for more than 3 times.");
            MonitorUtil.restartService();
        }
        if (-1 == status) {
            logger.info("cannot get the database data, so restart LEGO.");
            MonitorUtil.restartService();
        } else {
            logger.info("check the database status finished and the status is OK.");
        }
    }

    public static void restartService() {
        Program foreendPg = MonitorUtil.findProgramByNames(legoForeendName);
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        if (null != foreendPg) {
            pidList.add(foreendPg.getPid());
        }
        int[] pids = new int[pidList.size()];
        for (int i = 0; i < pidList.size(); ++i) {
            pids[i] = (Integer)pidList.get(i);
        }
        MonitorUtil.killProgramByPid(pids);
        LegoUtil.sleep(10000L);
        MonitorUtil.startLegoSystem();
    }

    public static Object retreiveAticRmiService(String serviceName) {
        try {
            Registry registry = LocateRegistry.getRegistry(aticRmiServiceIp, aticRmiServicePort, new ClientSocketFactory(true));
            return registry.lookup(serviceName);
        }
        catch (Throwable e) {
            logger.error("when get Rmi Service " + serviceName + " error happend . port is " + aticRmiServicePort, e);
            return null;
        }
    }

    static {
        try {
            legoForeendName = PropUtil.getInstance().getValue("LEGO_FORE_END_SERVER_NAME").trim();
            httpPort = MonitorUtil.getHttpPort();
            legoHttpPort = Integer.parseInt(PropUtil.getInstance().getValue("LEGO_HTTP_PORT"));
            aticRmiServicePort = Integer.parseInt(PropUtil.getInstance().getValue("ATIC_RMI_SERVICE_PORT"));
            httpRetryTimes = Integer.parseInt(PropUtil.getInstance().getValue("LEGO_HTTP_SERVER_RETRY_TIMES"));
            aticRmiServiceIp = EncryptUtil.getInstance().getAticRmiServiceIp();
        }
        catch (Exception ex) {
            logger.error("Init the constants error", (Throwable)ex);
        }
    }
}

