/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.monitor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropUtil {
    private static final String INSTALL_CONFIG_FILE_NAME = "legoInstalled.xml";
    private static final String PROPERTIES_FILE_PATH = "/legoMonitor.properties";
    private static final String INSTALL_RUNTIME_PATH = "Runtime";
    private static final String INSTALL_LEGORUNTIME_PATH = "LegoRuntime";
    private static final String START_FLAG_CONF = "startStatus.falg";
    private static final String START_STATUS = "start.status";
    private static transient Logger logger = LoggerFactory.getLogger(PropUtil.class);
    private static PropUtil sInstance = null;
    private static HashMap<String, String> sPropertiesMap = new HashMap();
    private static String installPath = null;

    PropUtil() {
        this.init();
    }

    public static synchronized PropUtil getInstance() {
        if (sInstance == null) {
            sInstance = new PropUtil();
        }
        return sInstance;
    }

    public String getValue(String key) {
        return sPropertiesMap.get(key);
    }

    private void init() {
        this.initPropertiesKeyValue(PROPERTIES_FILE_PATH);
    }

    private void initPropertiesKeyValue(String filePath) {
        Set<Map.Entry<Object, Object>> entrySet = this.getEntrySet(filePath);
        if (null != entrySet) {
            for (Map.Entry<Object, Object> entry : entrySet) {
                String servKey = (String)entry.getKey();
                String servValue = (String)entry.getValue();
                sPropertiesMap.put(servKey, servValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Map.Entry<Object, Object>> getEntrySet(String filePath) {
        InputStream inStream = PropUtil.class.getResourceAsStream(filePath);
        Properties serviceProp = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = null;
        try {
            serviceProp.load(inStream);
            entrySet = serviceProp.entrySet();
        }
        catch (Throwable e) {
            logger.error("getEntrySet error", e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error("IO exception when get EntrySet", (Throwable)e);
                }
            }
        }
        return entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStartStatus() {
        Properties pro = new Properties();
        FileInputStream fileInput = null;
        File flagFile = null;
        String statusFlagFile = PropUtil.getRuntimePath() + INSTALL_RUNTIME_PATH + File.separator + INSTALL_LEGORUNTIME_PATH + File.separator + "data" + File.separator + START_FLAG_CONF;
        logger.info("getStartStatus, statusFlagFile ");
        try {
            String status;
            flagFile = new File(statusFlagFile);
            if (!flagFile.exists()) {
                logger.error("flagFile is not exist");
                String string = null;
                return string;
            }
            fileInput = new FileInputStream(flagFile);
            pro.load(fileInput);
            String string = status = (String)pro.get(START_STATUS);
            return string;
        }
        catch (Exception e) {
            logger.error("getStartStatus error", (Throwable)e);
        }
        finally {
            if (null != fileInput) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    logger.error("getStartStatus fileInput.close error", (Throwable)e);
                }
            }
        }
        return null;
    }

    public static void cleanStartStatusFlag() {
        String statusFlagFile = PropUtil.getRuntimePath() + INSTALL_RUNTIME_PATH + File.separator + INSTALL_LEGORUNTIME_PATH + File.separator + "data" + File.separator + START_FLAG_CONF;
        logger.info("cleanStartStatusFlag, statusFlagFile ");
        try {
            File flagFile = new File(statusFlagFile);
            if (!flagFile.exists()) {
                logger.info("flagFile is not exists.");
                return;
            }
            flagFile.setWritable(true);
            if (!flagFile.delete()) {
                logger.info("flagFile.delete error");
            }
            logger.info("cleanStartStatusFlag succ.");
        }
        catch (Exception e) {
            logger.error("flagFile.delete error", (Throwable)e);
        }
    }

    public static String getRuntimePath() {
        if (null != installPath) {
            return installPath;
        }
        String fileName = INSTALL_CONFIG_FILE_NAME;
        SAXReader sax = new SAXReader();
        try {
            Document document = sax.read(new File(fileName));
            Element installElement = (Element)document.selectSingleNode("/install/installpath");
            String installPathStr = installElement.attribute("path").getValue();
            if (installPathStr != null) {
                boolean isSpLinux = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("/");
                boolean isSpWindows = installPathStr.substring(installPathStr.length() - 1, installPathStr.length()).equals("\\");
                if (!isSpLinux && !isSpWindows) {
                    installPathStr = installPathStr + File.separator;
                }
                installPath = installPathStr;
            }
        }
        catch (Exception e) {
            logger.error("getRuntimePath error. ", (Throwable)e);
        }
        return installPath;
    }
}

