/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.productUtil;

import com.hs.lego.monitor.model.Program;
import com.hs.lego.monitor.util.LegoUtil;
import com.hs.lego.monitor.util.MonitorUtil;
import com.hs.vsm.productUtil.ServerUtil;
import com.hs.vsm.productUtil.ServiceProgram;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductSvc {
    private static Logger logger = LoggerFactory.getLogger(ProductSvc.class);
    private static final int CHECK_LEGO_STARTED_COUNTER = 12;
    private static final int COUNTER_FOUR = 4;
    private static final int COUNTER_TWO = 2;

    private static void namingMonitor() {
        Program pro;
        while ((pro = MonitorUtil.findProgramByPorts(9999)) != null) {
            logger.info("The NS's port Occupied.");
            MonitorUtil.killProgramByPid(pro.getPid());
            LegoUtil.sleep(10000L);
        }
        while (ServerUtil.chekServerState("ELOGSERVICE")) {
            logger.info("The NS is stopped,kill elogSVC.");
            ProductSvc.stopServie("ELOGSERVICE");
            LegoUtil.sleep(10000L);
        }
        LegoUtil.sleep(20000L);
        ProductSvc.startServie("NamingService");
        int counter = 0;
        LegoUtil.sleep(60000L);
        while ((pro = MonitorUtil.findProgramByPorts(9999)) == null && 12 > ++counter) {
            try {
                if (2 >= counter) {
                    Thread.sleep(20000L);
                    continue;
                }
                if (4 >= counter) {
                    Thread.sleep(10000L);
                    continue;
                }
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error("Starting NamingService has error happened.", (Throwable)e);
            }
        }
        logger.info("NamingService start success.");
        ProductSvc.startAllService(ServerUtil.getServiceBySvcname("ELOGSERVICE"));
    }

    private static void eLogMonitor() {
        Program pro;
        logger.info("elogPort:10092");
        while ((pro = MonitorUtil.findProgramByPorts(10092)) != null) {
            logger.info("The eLogSVC's port Occupied.");
            MonitorUtil.killProgramByPid(pro.getPid());
            LegoUtil.sleep(10000L);
        }
        ProductSvc.startServie("ELOGSERVICE");
        int counter = 0;
        LegoUtil.sleep(60000L);
        while ((pro = MonitorUtil.findProgramByPorts(10092)) == null && 12 > ++counter) {
            try {
                if (2 >= counter) {
                    Thread.sleep(20000L);
                    continue;
                }
                if (4 >= counter) {
                    Thread.sleep(10000L);
                    continue;
                }
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.error("Starting eLogService has error happened.", (Throwable)e);
            }
        }
        logger.info("ELOGSERVICE start success.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findELogOrNamingPorts(String port) {
        String paths = AticInstallUtil.getInstance().getAticInstallPath();
        logger.info("findELogOrNamingPorts in and The paths is " + paths);
        File file = new File(paths + File.separator + "elogconfig.properties");
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getPath());
        }
        catch (FileNotFoundException e) {
            String errorMessage = "FileInputStream is fault,The path is : " + file.getPath();
            logger.error(errorMessage, (Throwable)e);
        }
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            String errorMessage = "The path is not find";
            logger.error(errorMessage, (Throwable)e);
        }
        finally {
            ProductSvc.closeInputStream(in);
        }
        String elogSvcOrNamingSvcPort = p.getProperty(port);
        logger.info("findNamingOrELogPort success ! The Port is " + elogSvcOrNamingSvcPort);
        return elogSvcOrNamingSvcPort;
    }

    public static void startAllService(ServiceProgram sp) {
        int counter;
        logger.info("Start the Service..:" + sp.getServiceName());
        if (sp.getServiceName().equals("DDOSCOLLECTORSVC")) {
            if (ServerUtil.serverExist("mysqlservice")) {
                ProductSvc.startAllService(ServerUtil.getServiceBySvcname("mysqlservice"));
            } else {
                counter = 0;
                while (!ServerUtil.chekServerState("DDOSCOLLECTORSVC")) {
                    ProductSvc.startServie("DDOSCOLLECTORSVC");
                    LegoUtil.sleep(5000L);
                    if (12 > ++counter) continue;
                    logger.error("Starting DDOSCOLLECTORSVC has error happened.");
                    return;
                }
            }
        }
        if (sp.getServiceName().equals("mysqlservice")) {
            counter = 0;
            while (ServerUtil.chekServerState("DDOSCOLLECTORSVC")) {
                ProductSvc.stopServie("DDOSCOLLECTORSVC");
                LegoUtil.sleep(5000L);
                if (12 > ++counter) continue;
                logger.error("stop DDOSCOLLECTORSVC has error happened.");
                return;
            }
            LegoUtil.sleep(10000L);
            counter = 0;
            while (!ServerUtil.chekServerState(sp.getServiceName())) {
                ProductSvc.startServie(sp.getServiceName());
                LegoUtil.sleep(5000L);
                if (12 > ++counter) continue;
                logger.error("Starting " + sp.getServiceName() + " has error happened.");
                return;
            }
            logger.info("mysqlservice start success.");
            LegoUtil.sleep(10000L);
            counter = 0;
            while (!ServerUtil.chekServerState("DDOSCOLLECTORSVC")) {
                ProductSvc.startServie("DDOSCOLLECTORSVC");
                LegoUtil.sleep(5000L);
                if (12 > ++counter) continue;
                logger.error("Starting DDOSCOLLECTORSVC has error happened.");
                return;
            }
            logger.info("DDOSCOLLECTORSVC start success.");
        }
        if (sp.getServiceName().equals("LogCollector")) {
            counter = 0;
            while (!ServerUtil.chekServerState(sp.getServiceName())) {
                ProductSvc.startServie(sp.getServiceName());
                LegoUtil.sleep(5000L);
                if (12 > ++counter) continue;
                logger.error("Starting " + sp.getServiceName() + " has error happened.");
                return;
            }
            logger.info("LogCollector start success.");
            LegoUtil.sleep(10000L);
            counter = 0;
            while (!ServerUtil.chekServerState("WMIReceiverMgr")) {
                ProductSvc.startServie("WMIReceiverMgr");
                if (12 > ++counter) continue;
                logger.error("Starting WMIReceiverMgr has error happened.");
                return;
            }
            logger.info("WMIReceiverMgr start success.");
        }
        if (sp.getServiceName().equals("WMIReceiverMgr")) {
            ProductSvc.startAllService(ServerUtil.getServiceBySvcname("LogCollector"));
        }
        if (sp.getServiceName().equals("NamingService")) {
            ProductSvc.namingMonitor();
        }
        if (sp.getServiceName().equals("ELOGSERVICE")) {
            ProductSvc.eLogMonitor();
        }
    }

    private static void closeInputStream(InputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.error("close InputStream IOException:", (Throwable)e);
            }
            finally {
                input = null;
            }
        }
    }

    private static void startServie(String serviceName) {
        String cmd = "cmd /c sc start " + serviceName;
        logger.info(cmd);
        MonitorUtil.execCommand(cmd);
    }

    private static void stopServie(String serviceName) {
        String cmd = "cmd /c sc stop " + serviceName;
        logger.info(cmd);
        MonitorUtil.execCommand(cmd);
    }
}

