/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.productUtil;

import com.hs.vsm.productUtil.ServiceProgram;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtil {
    private static Logger logger = LoggerFactory.getLogger(ServerUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProgram getServiceBySvcname(String serverName) {
        ServiceProgram svcpram = new ServiceProgram();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        InputStream inStream = null;
        InputStreamReader inStreamReader = null;
        BufferedReader bufReader = null;
        try {
            process = ServerUtil.getProcess(runtime);
            if (null == process) {
                ServiceProgram serviceProgram = svcpram;
                return serviceProgram;
            }
            inStream = process.getInputStream();
            if (null == inStream) {
                ServiceProgram serviceProgram = svcpram;
                return serviceProgram;
            }
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String sName = null;
            String pName = null;
            block21: while (null != (sName = bufReader.readLine())) {
                if (!sName.trim().startsWith("SERVICE_NAME") || !sName.trim().endsWith(serverName)) continue;
                svcpram.setServiceName(sName.trim().split(":")[1].trim());
                while (null != (pName = bufReader.readLine())) {
                    if ((pName = pName.trim()).startsWith("DISPLAY_NAME")) {
                        svcpram.setDisplayName(pName.split(":")[1].trim());
                    }
                    if (!pName.startsWith("STATE")) continue;
                    ServerUtil.chooseState(pName, svcpram);
                    continue block21;
                }
            }
        }
        catch (RuntimeException e) {
            logger.error("ServerUtil.getServiceBySvcname<RuntimeCMD>::", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("ServerUtil.getServiceBySvcname<RuntimeCMD>::", (Throwable)e);
        }
        finally {
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
                if (null != inStreamReader) {
                    inStreamReader.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                logger.error("ServerUtil.getServiceBySvcname<IO>::", (Throwable)e);
            }
            if (null != process) {
                process.destroy();
            }
        }
        return svcpram;
    }

    private static Process getProcess(Runtime runtime) {
        Process process = null;
        if (System.getProperty("os.name").contains("Windows")) {
            try {
                process = runtime.exec("cmd /c sc query state= all");
            }
            catch (IOException e) {
                logger.error("runtime run exec is error", (Throwable)e);
            }
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceProgram getServiceByDispname(String displayName) {
        ServiceProgram svcpram = new ServiceProgram();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        InputStream inStream = null;
        InputStreamReader inStreamReader = null;
        BufferedReader bufReader = null;
        try {
            process = ServerUtil.getProcess(runtime);
            if (null == process) {
                ServiceProgram serviceProgram = svcpram;
                return serviceProgram;
            }
            inStream = process.getInputStream();
            if (null == inStream) {
                ServiceProgram serviceProgram = svcpram;
                return serviceProgram;
            }
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String sName = null;
            String pName = null;
            String state = null;
            while (null != (pName = bufReader.readLine())) {
                if (pName.trim().startsWith("DISPLAY_NAME") && pName.trim().endsWith(displayName) && null != sName) {
                    svcpram.setDisplayName(pName.trim().split(":")[1].trim());
                    svcpram.setServiceName(sName.trim().split(":")[1].trim());
                    while (null != (state = bufReader.readLine())) {
                        if (!state.trim().startsWith("STATE")) continue;
                        ServerUtil.chooseState(state, svcpram);
                        break;
                    }
                }
                sName = pName;
            }
        }
        catch (RuntimeException e) {
            logger.error("ServerUtil.getServiceBySvcname<RuntimeCMD>::", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("ServerUtil.getServiceByDispname<RuntimeCMD>::", (Throwable)e);
        }
        finally {
            try {
                if (null != bufReader) {
                    bufReader.close();
                }
                if (null != inStreamReader) {
                    inStreamReader.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                logger.error("ServerUtil.getServiceByDispname<IO>::", (Throwable)e);
            }
            if (null != process) {
                process.destroy();
            }
        }
        return svcpram;
    }

    private static void chooseState(String state, ServiceProgram svcpram) {
        if (state.endsWith("RUNNING")) {
            svcpram.setState(true);
        } else {
            svcpram.setState(false);
        }
    }

    public static boolean chekServerState(String serverName) {
        ServiceProgram sSProgram = ServerUtil.getServiceBySvcname(serverName);
        return sSProgram.isState();
    }

    public static boolean serverExist(String serverName) {
        ServiceProgram sSProgram = ServerUtil.getServiceBySvcname(serverName);
        return sSProgram.getServiceName() != null;
    }

    public static void deleteService(String serverName, String displayName) {
        ServiceProgram sSProgram = ServerUtil.getServiceBySvcname(serverName);
        ServiceProgram sDProgram = ServerUtil.getServiceByDispname(displayName);
        Runtime runtime = Runtime.getRuntime();
        String strCmd = null;
        try {
            if (sSProgram.getServiceName() != null && System.getProperty("os.name").contains("Windows")) {
                strCmd = "cmd /c sc delete " + serverName;
                logger.debug("ServerUtil.deleteService<ByServerName>::" + strCmd);
                runtime.exec(strCmd);
            }
            if (sDProgram.getServiceName() != null && System.getProperty("os.name").contains("Windows")) {
                strCmd = "cmd /c sc delete " + sDProgram.getServiceName();
                logger.debug("ServerUtil.deleteService<ByDisplayName>::" + strCmd);
                runtime.exec(strCmd);
            }
        }
        catch (Exception e) {
            logger.error("ServerUtil.deleteService<RuntimeCMD>::", (Throwable)e);
        }
    }
}

