/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.alarm.bis;

import com.hs.atic.alarm.entity.AlarmObjectBuffer;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.lego.nem.fault.sdk.model.LegoAlarm;
import com.hs.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.List;

public class AlarmCreateThread
extends Thread {
    private static final long SLEEP_TIME = 100L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private IFaultGenerateService faultGenerateService;
    private AlarmObjectBuffer alarmObjectBuffer;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    List<AticAlarmObject> data;
                    if (!(data = this.alarmObjectBuffer.getData()).isEmpty()) {
                        for (AticAlarmObject obj : data) {
                            this.generateEvent(obj);
                        }
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"create alarm error.", (Throwable)e);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"Thread.sleep.", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }

    private void generateEvent(AticAlarmObject alarmObject) {
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmObject.getAlarmId());
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmParam(alarmObject.getAlarmParam());
        if (null != alarmObject.getAlertLevel()) {
            alarm.setAlarmLevel(alarmObject.getAlertLevel());
        }
        if (alarmObject.getMoId() != null && !alarmObject.getMoName().isEmpty()) {
            alarm.setMoId(alarmObject.getMoId());
            alarm.setExtendMoId(alarmObject.getExtendMoId());
            alarm.setMoName(alarmObject.getMoName());
            alarm.setMoIp(alarmObject.getMoIp());
            if (alarmObject.getIsAlarm().booleanValue()) {
                alarm.setAlarmTime(alarmObject.getAlertTime());
                this.faultGenerateService.generateAlarm(alarm);
            } else {
                alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
                alarm.setClearUser("--");
                alarm.setAlarmTime(alarmObject.getAlertTime());
                alarm.setClearTime(alarmObject.getAlertTime());
                this.faultGenerateService.generateRestoreAlarm(alarm);
            }
        } else if (alarmObject.getIsAlarm().booleanValue()) {
            alarm.setAlarmTime(alarmObject.getAlertTime());
            this.faultGenerateService.generateAlarm(alarm);
        } else {
            alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
            alarm.setClearUser("--");
            alarm.setClearTime(alarmObject.getAlertTime());
            this.faultGenerateService.generateRestoreAlarm(alarm);
        }
    }

    public IFaultGenerateService getFaultGenerateService() {
        return this.faultGenerateService;
    }

    public void setFaultGenerateService(IFaultGenerateService faultGenerateService) {
        this.faultGenerateService = faultGenerateService;
    }

    public AlarmObjectBuffer getAlarmObjectBuffer() {
        return this.alarmObjectBuffer;
    }

    public void setAlarmObjectBuffer(AlarmObjectBuffer alarmObjectBuffer) {
        this.alarmObjectBuffer = alarmObjectBuffer;
    }
}

