/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.dao.impl;

import com.hs.lego.cbb.fault.dao.FaultStatisticDao;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultStatistic;
import java.util.ArrayList;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class FaultStatisticDaoImpl
extends HibernateDaoSupport
implements FaultStatisticDao {
    @Override
    public void addFault(Fault fault) {
        FaultStatistic faultStatistic = new FaultStatistic();
        faultStatistic.setFaultDefineId(fault.getFaultDefineId());
        faultStatistic.setFaultId(fault.getId());
        faultStatistic.setMoId(fault.getMoId());
        faultStatistic.setExtendMoId(fault.getExtendMoId());
        faultStatistic.setSeverity(fault.getSeverity());
        super.getHibernateTemplate().save((Object)faultStatistic);
    }

    @Override
    public void updateFault(Fault fault) {
        String hql = "update FaultStatistic set faultDefineId = ?, moId = ?, extendMoId = ?, severity = ? where faultId=?";
        super.getHibernateTemplate().bulkUpdate(hql, new Object[]{fault.getFaultDefineId(), fault.getMoId(), fault.getExtendMoId(), fault.getSeverity(), fault.getId()});
    }

    @Override
    public void clearFault(Fault fault) {
        String hql = "delete from FaultStatistic where faultId = ?";
        super.getHibernateTemplate().bulkUpdate(hql, new Object[]{fault.getId()});
    }

    @Override
    public long[] getStatistic(Long userid) {
        long[] faultData = new long[8];
        if (1L == userid) {
            faultData[0] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where severity=1", new Object[0]).get(0);
            faultData[1] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where severity=2", new Object[0]).get(0);
            faultData[2] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where severity=3", new Object[0]).get(0);
            faultData[3] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where severity=4", new Object[0]).get(0);
        } else {
            faultData[0] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where (moId in (select id.moId from UserRelMoInfo where id.userId=?)) and (extendMoId in (select id.moId from UserRelMoInfo where id.userId=?)  or extendMoId = 0 or extendMoId is null) and (severity=1)", new Object[]{userid, userid}).get(0);
            faultData[1] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where (moId in (select id.moId from UserRelMoInfo where id.userId=?)) and (extendMoId in (select id.moId from UserRelMoInfo where id.userId=?)  or extendMoId = 0 or extendMoId is null) and (severity=2)", new Object[]{userid, userid}).get(0);
            faultData[2] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where (moId in (select id.moId from UserRelMoInfo where id.userId=?)) and (extendMoId in (select id.moId from UserRelMoInfo where id.userId=?)  or extendMoId = 0 or extendMoId is null) and (severity=3)", new Object[]{userid, userid}).get(0);
            faultData[3] = (Long)this.getHibernateTemplate().find("select count(faultId) from FaultStatistic where (moId in (select id.moId from UserRelMoInfo where id.userId=?)) and (extendMoId in (select id.moId from UserRelMoInfo where id.userId=?)  or extendMoId = 0 or extendMoId is null) and (severity=4)", new Object[]{userid, userid}).get(0);
        }
        faultData[4] = faultData[0];
        faultData[5] = faultData[1];
        faultData[6] = faultData[2];
        faultData[7] = faultData[3];
        return faultData;
    }

    @Override
    public void deleteAllFault() {
        String hqlDelete = "delete from FaultStatistic";
        super.getHibernateTemplate().bulkUpdate(hqlDelete, new Object[0]);
    }

    @Override
    public void addAllFault() {
        String hqlSelect = "insert into FaultStatistic(faultId,faultDefineId,moId,extendMoId,severity) select id,faultDefineId,moId,extendMoId,severity from Fault where clearStatus=0";
        super.getHibernateTemplate().bulkUpdate(hqlSelect, new Object[0]);
    }

    @Override
    public void deleteAllAlarmsByMoIds(String moIds) {
        String[] ids = null;
        StringBuffer sbBuffer = new StringBuffer();
        ArrayList<Long> param = new ArrayList<Long>();
        if (null != moIds) {
            int i;
            ids = moIds.split(",");
            for (i = 0; i < ids.length; ++i) {
                param.add(Long.valueOf(ids[i]));
                if (0 == i) {
                    sbBuffer.append('?');
                    continue;
                }
                sbBuffer.append(",?");
            }
            for (i = 0; i < ids.length; ++i) {
                param.add(Long.valueOf(ids[i]));
            }
        }
        String faultStatisticHql = "delete from FaultStatistic where faultId in ( select id from Fault where (moId in (" + sbBuffer.toString() + ")) or (extendMoId in (" + sbBuffer.toString() + ")))";
        this.getHibernateTemplate().bulkUpdate(faultStatisticHql, param.toArray());
    }
}

