/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.dao.FaultDao;
import com.hs.lego.cbb.fault.util.FaultStatisticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class FaultDumpThread {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static int currentFaultStatus = 1;
    private static long sleepPeriod = 1000L;
    private long firstTimeDelay = 0L;
    private Timer timer = null;
    private FaultDao faultDao;
    private int currentFaultDumpThreshold = 100000;
    private int currentFaultStopDump = 80000;
    private int currentFaultDumpStep = 10000;
    private long dumpCheckPeriod = 1L;

    public void init() {
        this.initDumpProperties();
        this.caculateFirstTime();
        this.timer = new Timer(CurrentFaultDumper.class.getName());
        this.timer.schedule((TimerTask)new CurrentFaultDumper(), this.firstTimeDelay, this.dumpCheckPeriod * 60L * 60L * 1000L);
    }

    private void caculateFirstTime() {
        Date day = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String formatCurrentDayAndTime = format.format(day);
        String currentDay = formatCurrentDayAndTime.substring(0, 8);
        String currentHour = formatCurrentDayAndTime.substring(8, 10);
        String currentMunite = formatCurrentDayAndTime.substring(10, 12);
        try {
            this.firstTimeDelay = Integer.parseInt(currentMunite) < 14 ? format.parse(currentDay + currentHour + "1500").getTime() - day.getTime() : format.parse(currentDay + String.valueOf(Integer.parseInt(currentHour) + 1) + "1500").getTime() - day.getTime();
        }
        catch (ParseException e) {
            LOGGER.error((Object)e);
        }
        LOGGER.info((Object)("Task will be executed in " + this.firstTimeDelay + " ms later"));
    }

    private void configFaultDumpThreshold(Properties properties) {
        int startInt;
        String start = (String)properties.get("fault.dump.start");
        if (start != null && !start.isEmpty() && (startInt = Integer.parseInt(start)) > 100 && startInt < 500000) {
            this.currentFaultDumpThreshold = startInt;
        }
    }

    private void configFaultStopDump(Properties properties) {
        int stopInt;
        String stop = (String)properties.get("fault.dump.stop");
        if (stop != null && !stop.isEmpty() && (stopInt = Integer.parseInt(stop)) < this.currentFaultDumpThreshold) {
            this.currentFaultStopDump = stopInt;
        }
    }

    private void configFaultDumpStep(Properties properties) {
        int stepInt;
        String step = (String)properties.get("fault.dump.step");
        if (step != null && !step.isEmpty() && (stepInt = Integer.parseInt(step)) < this.currentFaultStopDump) {
            this.currentFaultDumpStep = stepInt;
        }
    }

    private void fixErrorConfig() {
        if (this.currentFaultStopDump > this.currentFaultDumpThreshold || this.currentFaultDumpStep > this.currentFaultStopDump) {
            this.currentFaultDumpThreshold = 100000;
            this.currentFaultStopDump = 80000;
            this.currentFaultDumpStep = 10000;
        }
    }

    private void configDumpCheckPeriod(Properties properties) {
        String period = (String)properties.get("fault.dump.period");
        if (period != null && !period.isEmpty()) {
            long periodLong = Long.parseLong(period);
            this.dumpCheckPeriod = periodLong <= 720L && periodLong >= 1L ? periodLong : 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDumpProperties() {
        InputStream in = null;
        try {
            URL resource = FaultDumpThread.class.getResource("/fault-dump.properties");
            if (resource == null) {
                LOGGER.error((Object)"cannot find the url fault-dump.properties");
                return;
            }
            in = resource.openStream();
            if (in == null) {
                return;
            }
            Properties properties = new Properties();
            properties.load(in);
            this.configFaultDumpThreshold(properties);
            this.configFaultStopDump(properties);
            this.configFaultDumpStep(properties);
            this.fixErrorConfig();
            this.configDumpCheckPeriod(properties);
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException error");
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"IOException error");
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.info((Object)"Failed to close thread fault dump properties file.");
                }
            }
        }
    }

    private void dumpAlarmToHistory() {
        Integer currentAlarmCount = this.getCurrentAlarmCount();
        int dumpSum = currentAlarmCount - this.currentFaultStopDump;
        int total = 0;
        while (dumpSum > 0) {
            total += dumpSum;
            try {
                LOGGER.info((Object)("dumpSum = " + dumpSum));
                this.dumpAlarmsByCount(dumpSum);
                currentAlarmCount = this.getCurrentAlarmCount();
                dumpSum = currentAlarmCount - this.currentFaultStopDump;
                if (dumpSum > 0) {
                    dumpSum = this.currentFaultDumpStep;
                    LOGGER.info((Object)("dumpSum = " + dumpSum + ", need another dump, count = " + this.currentFaultDumpStep));
                }
                TimeUnit.MILLISECONDS.sleep(sleepPeriod);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
                dumpSum = -1;
            }
        }
        FaultStatisticUtil.getInstance().synchroizeFaultFromDB();
        SimpleDateFormat localFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] args = new String[]{localFormat.format(new Date()), String.valueOf(total)};
        this.writeOptLog(args);
    }

    private void writeOptLog(String[] para) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.evtMgr.curtAlarm");
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.fault.current");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.fault.dump.current");
        oOptLog.setResult(1);
        oOptLog.setOperator("--");
        oOptLog.setTerminalIp("127.0.0.1");
        oOptLog.setDetailPara(para);
        oOptLog.setOperator("--");
        ServiceContext context = ServiceContext.getInstance();
        ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
        if (null != sysOptLog) {
            sysOptLog.writeOptLog(oOptLog);
        }
    }

    private void dumpAlarmsByCount(int dumpSum) {
        this.faultDao.dumpCurrentAlarmToHistory(dumpSum);
    }

    private Integer getCurrentAlarmCount() {
        long totalCount = this.faultDao.getCurrentAlarmTotalCount();
        String strTotalCount = String.valueOf(totalCount);
        Integer count = Integer.valueOf(strTotalCount);
        return count;
    }

    private boolean alarmNeedDump() {
        boolean isDump = false;
        Integer count = this.getCurrentAlarmCount();
        if (count >= this.currentFaultDumpThreshold) {
            isDump = true;
            LOGGER.info((Object)("Begin to dump current fault, current fault : " + count + ", threashold : " + this.currentFaultDumpThreshold));
        } else {
            LOGGER.info((Object)("No need to dump current fault, current fault : " + count + ", threashold : " + this.currentFaultDumpThreshold));
        }
        LOGGER.info((Object)("is Dump = " + isDump));
        return isDump;
    }

    public void setFaultDao(FaultDao faultDao) {
        this.faultDao = faultDao;
    }

    class CurrentFaultDumper
    extends TimerTask {
        CurrentFaultDumper() {
        }

        @Override
        public void run() {
            LOGGER.info((Object)"begin to check current fault dump process.");
            if (FaultDumpThread.this.alarmNeedDump()) {
                FaultDumpThread.this.dumpAlarmToHistory();
                LOGGER.info((Object)"success dump current fault to history.");
            }
        }
    }
}

