/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.List;

public final class FaultListener {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static FaultListener instance = new FaultListener();
    private static final int MAX = 10000;
    private final Object lock = new Object();
    private List<Fault> faults;

    private FaultListener() {
        this.init();
    }

    public static FaultListener getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            this.faults = new ArrayList<Fault>(10000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFault(Fault fault) {
        Object object = this.lock;
        synchronized (object) {
            if (this.faults.size() < 10000) {
                this.faults.add(fault);
            } else {
                LOGGER.error((Object)("over upper Limit. id=" + fault.getFaultDefineId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Fault> getFault() {
        Object object = this.lock;
        synchronized (object) {
            List<Fault> f = this.faults;
            this.faults = new ArrayList<Fault>(10000);
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Fault> getFaultWithoutClear() {
        Object object = this.lock;
        synchronized (object) {
            List<Fault> f = this.faults;
            return f;
        }
    }
}

