/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.dao.PageSizeDao;
import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.service.FaultListener;
import com.hs.lego.cbb.fault.service.NotifyListener;
import com.hs.lego.cbb.fault.util.ExtendAlert;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.fault.util.RemoteNotifyHelper;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.service.IEmailSendService;
import com.hs.lego.core.system.notify.sdk.service.IShortMsgSendService;
import com.hs.lego.nem.fault.resource.SubscriberUtil;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class NotifyScheduler {
    public static final int STATUS_CLEARED = 1;
    public static final int HUNDRED = 100;
    private static String companyName = "";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final String RETURN_LINE = "\r\n";
    private static final Object LOCK = new Object();
    private static final int ALARM_SEVERITY_WARNING = 1;
    private static final int ALARM_SEVERITY_MINOR = 2;
    private static final int ALARM_SEVERITY_MAJOR = 3;
    private IEmailSendService emailSendService;
    private ScheduledExecutorService scheduler = null;
    private IRemoteNotifyServerService remoteNotifyServerService;
    private PageSizeDao pageSizeDao;
    private StringBuilder emailTitle;
    private int time = 600;
    private IShortMsgSendService smsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = LOCK;
        synchronized (object) {
            this.time = this.initConf();
            if (this.time < 10 || this.time > 600) {
                this.time = 600;
            }
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        NotifyListener.getInstance().clearkExpired();
                        List<Fault> faults = FaultListener.getInstance().getFault();
                        if (null == faults || faults.isEmpty()) break block7;
                        try {
                            NotifyScheduler.this.sendSms(faults);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"error occur while send the alarm notify sms. Exception detailed: ", (Throwable)e);
                        }
                        finally {
                            NotifyScheduler.this.sendEmail(faults);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error occur while send the alarm notify email. Exception detailed: ", (Throwable)e);
                    }
                }
            }
        }, this.time, this.time, TimeUnit.SECONDS);
    }

    private int initConf() {
        int notifyTime = 600;
        if (null == this.pageSizeDao) {
            return notifyTime;
        }
        List<PageSizeConfig> list = this.pageSizeDao.findSysValue("notifyTime");
        if (list != null && !list.isEmpty()) {
            for (PageSizeConfig pageSizeConfig : list) {
                notifyTime = Integer.parseInt(pageSizeConfig.getSysValue());
            }
        }
        LOGGER.info((Object)("notifyTime is:" + notifyTime));
        return notifyTime;
    }

    private void sendSms(List<Fault> faults) {
        LOGGER.info((Object)"into sms procedure");
        ArrayList<ExtendAlert> copyBuffer = new ArrayList<ExtendAlert>();
        for (Fault fault : faults) {
            ExtendAlert alert = new ExtendAlert();
            if (null != fault.getClearStatus()) {
                alert.setClearStatus(fault.getClearStatus().byteValue());
            }
            if (null != fault.getClearTime()) {
                alert.setClearTime(fault.getClearTime().getTime());
            }
            if (null != fault.getClearUser() && !fault.getClearUser().isEmpty()) {
                alert.setClearUser(fault.getClearUser());
            }
            if (null != fault.getConfirmStatus()) {
                alert.setConfirmStatus(fault.getConfirmStatus().byteValue());
            }
            if (null != fault.getConfirmTime()) {
                alert.setConfirmTime(fault.getConfirmTime().getTime());
            }
            if (null != fault.getConfirmUser() && !fault.getConfirmUser().isEmpty()) {
                alert.setConfirmUser(fault.getConfirmUser());
            }
            if (null != fault.getCount()) {
                alert.setCount(fault.getCount());
            }
            if (null != fault.getModTime()) {
                alert.setModTime(fault.getModTime().getTime());
            }
            if (null != fault.getFaultDefineId()) {
                alert.setAlarmId(fault.getFaultDefineId());
                alert.setAlarmName(fault.getFaultDefineId() + ".alarm.name");
                alert.setAlarmDesc(fault.getFaultDefineId() + ".alarm.desc");
                alert.setAdvice(fault.getFaultDefineId() + ".alarm.advice");
            }
            if (null != fault.getFaultParam() && !fault.getFaultParam().isEmpty()) {
                alert.setAlarmParam(fault.getFaultParam());
            }
            if (null != fault.getId()) {
                alert.setUuid(String.valueOf(fault.getId()));
            }
            if (null != fault.getSeverity()) {
                alert.setSeverity(fault.getSeverity().byteValue());
            }
            if (null != fault.getSource()) {
                alert.setSource(fault.getSource());
            }
            if (null != fault.getMoId()) {
                alert.setMoId(fault.getMoId());
            }
            copyBuffer.add(alert);
        }
        List<RemoteNotifyRule> ruleList = RemoteNotifyHelper.getInstance().getRemoteNotifyRuleService().getAllRules();
        for (RemoteNotifyRule rule : ruleList) {
            if (!rule.isValidStatus()) {
                LOGGER.debug((Object)("notify rule is disabled,rule name:" + rule.getRuleName()));
                continue;
            }
            String phone = rule.getSmsPhone();
            if (null == phone || "".equals(phone)) {
                LOGGER.info((Object)("Sms address is empty,rule name:" + rule.getRuleName()));
                continue;
            }
            String[] phoneTo = phone.split("===");
            for (int i = 0; i < phoneTo.length; ++i) {
                int index = phoneTo[i].indexOf("###");
                phoneTo[i] = phoneTo[i].substring(0, index);
            }
            if (phoneTo.length <= 0) {
                LOGGER.info((Object)("Sms:" + phone));
                continue;
            }
            ArrayList<ExtendAlert> tempList = new ArrayList<ExtendAlert>();
            tempList.addAll(copyBuffer);
            while (!tempList.isEmpty()) {
                this.sendSms(rule, tempList, phoneTo);
            }
        }
    }

    private void sendSms(RemoteNotifyRule rule, List<ExtendAlert> copyBuffer, String[] phoneTo) {
        StringBuffer upperContent = new StringBuffer();
        String content = this.generateSmsContent(rule, copyBuffer, upperContent);
        LOGGER.info((Object)("Send Sms content:" + content));
        StringBuilder contentTemp = new StringBuilder(content);
        if ("".equals(content)) {
            LOGGER.info((Object)("Sms content is empty,rule name:" + rule.getRuleName()));
            return;
        }
        int smsMode = rule.getSmsMode();
        if (!"".equals(content) && null != this.smsService) {
            this.smsService.sendSms(contentTemp.toString(), phoneTo, smsMode);
        }
    }

    private String generateSmsContent(RemoteNotifyRule rule, List<ExtendAlert> alertList, StringBuffer upperContent) {
        StringBuilder builder = new StringBuilder();
        alertList = this.sortAlarmListByseverity(alertList);
        int alertCount = 0;
        for (ExtendAlert alert : alertList) {
            ++alertCount;
            boolean result = rule.contains(alert.getAlarmId(), alert.getSource(), alert.getClearStatus(), alert.getModTime(), alert.getClearTime(), alert.getMoId(), alert.getSeverity());
            if (!result || !rule.isIsClearEnable() && alert.getClearStatus() == 1) continue;
            builder.append(this.smsContent(alert, rule));
            upperContent.append(";");
        }
        ArrayList<ExtendAlert> tempList = new ArrayList<ExtendAlert>();
        if (alertCount < alertList.size()) {
            for (int i = alertCount; i < alertList.size(); ++i) {
                tempList.add(alertList.get(i));
            }
        }
        alertList.clear();
        alertList.addAll(tempList);
        return builder.toString();
    }

    private String smsContent(ExtendAlert alert, RemoteNotifyRule language) {
        StringBuilder builder = new StringBuilder();
        SimpleDateFormat siFormat = new SimpleDateFormat("HH:mm");
        Locale locale = language.getLanguage() == 1 ? new Locale("zh", "CN") : new Locale("en");
        String faultParam = FaultDefineUtil.getInstance().getFaultParam(alert.getAlarmId(), alert.getAlarmParam(), locale);
        alert.setAlarmParam(faultParam);
        if ("0x000803220001".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x000803220001.alarm.sms", language, smsParam) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x000803220001.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x000803220002".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x000803220002.alarm.sms", language, smsParam) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x000803220002.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x000803220003".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x000803220003.alarm.sms", language, smsParam) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x000803220003.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x000803220004".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x000803220004.alarm.sms", language, smsParam) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x000803220004.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240802".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240802.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240802.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240801".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (11 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[3], alarmParams[4], alarmParams[7]};
            StringBuilder smsDetail = new StringBuilder(this.getText("0x0000000803240801.alarm.sms", language, smsParam));
            String[] attackParams = new String[5];
            for (int i = 0; i < (alarmParams.length - 8) / 5; ++i) {
                attackParams[0] = alarmParams[8 + i * 5];
                attackParams[1] = alarmParams[8 + i * 5 + 1];
                attackParams[2] = alarmParams[8 + i * 5 + 2];
                attackParams[3] = alarmParams[8 + i * 5 + 3];
                attackParams[4] = alarmParams[8 + i * 5 + 4];
                smsDetail.append(this.getText("0x0000000803240801.alarm.sms.attack.detail.desc", language, attackParams));
            }
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240803".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240803.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240803.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240806".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240806.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240806.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240821".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240821.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240821.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240807".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240807.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240807.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240804".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (9 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[3]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240804.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240804.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240805".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240805.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240805.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240811".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            String[] smsParam = new String[]{alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText(alert.getAlarmName(), language) + this.getText("0x0000000803240811.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240811.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240812".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (11 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[3]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240812.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240812.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240813".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240813.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240813.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240814".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[3], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240814.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240814.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240827".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240827.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240827.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240828".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[3], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240828.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240828.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240829".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240829.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240829.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240830".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[3], alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240830.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240830.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240831".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240831.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240831.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240834".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240834.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240834.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240835".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240835.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240835.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240836".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[2], alarmParams[0]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240836.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240836.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240839".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[3], alarmParams[1], alarmParams[0], alarmParams[2]};
            StringBuilder smsDetail = new StringBuilder(this.getText("0x0000000803240839.alarm.sms", language, smsParam));
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("0x0000000803240839.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("0x0000000803240839.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240840".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[3], alarmParams[1], alarmParams[0], alarmParams[2]};
            StringBuilder smsDetail = new StringBuilder(this.getText("0x0000000803240840.alarm.sms", language, smsParam));
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("0x0000000803240840.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + smsDetail.toString() + this.getText("0x0000000803240840.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240816".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3], alarmParams[4], alarmParams[5]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240816.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240816.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240817".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1]};
            if (alert.getClearStatus() == 1) {
                builder.append(this.getText("0x0000000803240817.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                builder.append(this.getText("0x0000000803240817.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240818".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3]};
            if (alert.getClearStatus() == 1) {
                builder.append(this.getText("0x0000000803240818.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                builder.append(this.getText("0x0000000803240818.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240819".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (8 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                builder.append(this.getText("0x0000000803240819.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                builder.append(this.getText("0x0000000803240819.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240820".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (8 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            if (alert.getClearStatus() == 1) {
                builder.append(this.getText("0x0000000803240820.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.comma", language) + this.getText("lego.dic.clearstatus.cleared", language) + this.getText("lego.lab.fault.notify.fullstop", language));
            } else {
                builder.append(this.getText("0x0000000803240820.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
            }
        } else if ("0x0000000803240824".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (0 == alarmParams.length || 6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            if (alert.getClearStatus() == 1) {
                long clearTime = alert.getClearTime();
                String timeFormat = siFormat.format(clearTime);
                builder.append(timeFormat + this.getText("0x0000000803240824.alarm.sms", language, smsParam));
            } else {
                long modTime = alert.getModTime();
                String timeFormat = siFormat.format(modTime);
                builder.append(timeFormat + this.getText("0x0000000803240824.alarm.sms", language, smsParam));
            }
        } else if ("0x0000000803240825".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (0 == alarmParams.length || 6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            long modTime = alert.getModTime();
            String timeFormat = siFormat.format(modTime);
            builder.append(timeFormat + this.getText("0x0000000803240825.alarm.sms", language, smsParam));
        } else if ("0x0000000803240826".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (0 == alarmParams.length || 6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            long modTime = alert.getModTime();
            String timeFormat = siFormat.format(modTime);
            builder.append(timeFormat + this.getText("0x0000000803240826.alarm.sms", language, smsParam));
        } else if ("0x0000000803240877".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            builder.append(this.getText("0x0000000803240877.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
        } else if ("0x0000000803240878".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] smsParam = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            builder.append(this.getText("0x0000000803240878.alarm.sms", language, smsParam) + this.getText("lego.lab.fault.notify.fullstop", language));
        }
        return builder.toString();
    }

    private void sendEmail(List<Fault> faults) {
        ArrayList<ExtendAlert> copyBuffer = new ArrayList<ExtendAlert>();
        for (Fault fault : faults) {
            ExtendAlert alert = new ExtendAlert();
            if (null != fault.getClearStatus()) {
                alert.setClearStatus(fault.getClearStatus().byteValue());
            }
            if (null != fault.getClearTime()) {
                alert.setClearTime(fault.getClearTime().getTime());
            }
            if (null != fault.getClearUser() && !fault.getClearUser().isEmpty()) {
                alert.setClearUser(fault.getClearUser());
            }
            if (null != fault.getConfirmStatus()) {
                alert.setConfirmStatus(fault.getConfirmStatus().byteValue());
            }
            if (null != fault.getConfirmTime()) {
                alert.setConfirmTime(fault.getConfirmTime().getTime());
            }
            if (null != fault.getConfirmUser() && !fault.getConfirmUser().isEmpty()) {
                alert.setConfirmUser(fault.getConfirmUser());
            }
            if (null != fault.getCount()) {
                alert.setCount(fault.getCount());
            }
            if (null != fault.getModTime()) {
                alert.setModTime(fault.getModTime().getTime());
            }
            if (null != fault.getFaultDefineId()) {
                alert.setAlarmId(fault.getFaultDefineId());
                alert.setAlarmName(fault.getFaultDefineId() + ".alarm.name");
                alert.setAlarmDesc(fault.getFaultDefineId() + ".alarm.desc");
                alert.setAdvice(fault.getFaultDefineId() + ".alarm.advice");
            }
            if (null != fault.getFaultParam() && !fault.getFaultParam().isEmpty()) {
                alert.setAlarmParam(fault.getFaultParam());
            }
            if (null != fault.getId()) {
                alert.setUuid(String.valueOf(fault.getId()));
            }
            if (null != fault.getSeverity()) {
                alert.setSeverity(fault.getSeverity().byteValue());
            }
            if (null != fault.getSource()) {
                alert.setSource(fault.getSource());
            }
            if (null != fault.getMoId()) {
                alert.setMoId(fault.getMoId());
            }
            copyBuffer.add(alert);
        }
        List<RemoteNotifyRule> ruleList = RemoteNotifyHelper.getInstance().getRemoteNotifyRuleService().getAllRules();
        for (RemoteNotifyRule rule : ruleList) {
            if (!rule.isValidStatus()) {
                LOGGER.debug((Object)("notify rule is disabled,rule name:" + rule.getRuleName()));
                continue;
            }
            String address = rule.getEmailTo();
            if (null == address || "".equals(address)) {
                LOGGER.info((Object)("Email address is empty,rule name:" + rule.getRuleName()));
                continue;
            }
            String[] emailTo = address.split("===");
            for (int i = 0; i < emailTo.length; ++i) {
                int index = emailTo[i].indexOf("###");
                emailTo[i] = emailTo[i].substring(0, index);
            }
            if (emailTo.length <= 0) {
                LOGGER.info((Object)("Email:" + address));
                continue;
            }
            ArrayList<ExtendAlert> tempList = new ArrayList<ExtendAlert>();
            tempList.addAll(copyBuffer);
            while (!tempList.isEmpty()) {
                this.sendEmail(rule, tempList, emailTo);
            }
        }
    }

    private void sendEmail(RemoteNotifyRule rule, List<ExtendAlert> copyBuffer, String[] emailTo) {
        StringBuffer upperContent = new StringBuffer();
        String content = this.getEmailContext(rule, copyBuffer, upperContent);
        StringBuilder contentTemp = new StringBuilder(content);
        if ("".equals(content)) {
            LOGGER.info((Object)("Email content is empty,rule name:" + rule.getRuleName()));
            return;
        }
        contentTemp.append(this.getEmailSignature());
        if (null == this.emailSendService) {
            return;
        }
        this.emailSendService.sendEmail(this.emailTitle.toString(), contentTemp.toString(), emailTo);
        this.emailTitle = null;
    }

    private List<ExtendAlert> sortAlarmListByseverity(List<ExtendAlert> alertList) {
        BeanComparator comparator = new BeanComparator("severity");
        comparator = new ReverseComparator((Comparator)comparator);
        Collections.sort(alertList, comparator);
        return alertList;
    }

    private List<ExtendAlert> sortAlarmListByClean(List<ExtendAlert> alertList) {
        BeanComparator comparator = new BeanComparator("clearStatus");
        comparator = new ReverseComparator((Comparator)comparator);
        Collections.sort(alertList, comparator);
        return alertList;
    }

    private String getText(String key, RemoteNotifyRule rule) {
        String text = RemoteNotifyHelper.getInstance().getText(key, rule.getLanguage());
        if (null != text) {
            text = text.trim();
        }
        return text;
    }

    public String getText(String key, RemoteNotifyRule rule, String[] parameters) {
        String text;
        RemoteNotifyHelper remoteNotifyHelper = RemoteNotifyHelper.getInstance();
        if (null != parameters && 0 != parameters.length) {
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = remoteNotifyHelper.getText(parameters[i], rule.getLanguage());
            }
        }
        if (null != (text = remoteNotifyHelper.getText(key, rule.getLanguage(), parameters))) {
            text = text.trim();
        }
        return text;
    }

    private String buildBrief(ExtendAlert alert, RemoteNotifyRule rule) {
        StringBuilder brief = new StringBuilder();
        if ("0x0000000803240801".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (11 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String attackType = "";
            for (int i = 0; i < (alarmParams.length - 8) / 5; ++i) {
                attackType = 0 == i ? this.getText(alarmParams[8], rule) : attackType + "," + this.getText(alarmParams[8 + i * 5], rule);
            }
            String[] briefParms = new String[]{alarmParams[3], alarmParams[4], attackType, alarmParams[7]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240801.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240802".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240802.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240803".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[2], alarmParams[1]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240803.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240806".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[2], alarmParams[1]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240806.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240821".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[2], alarmParams[1]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240821.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240807".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240807.alarm.brief", rule, alarmParams) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240804".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (9 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240804.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240805".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240805.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240811".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (1 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240811.alarm.brief", rule, alarmParams) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240812".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (11 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240812.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240813".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240813.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240814".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[3], alarmParams[4]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240814.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240816".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240816.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240817".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240817.alarm.brief", rule, alarmParams) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240818".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240818.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240819".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (8 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240819.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240820".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (8 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240820.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240822".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (5 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3], alarmParams[4]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240822.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240823".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240823.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240824".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240824.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240825".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240825.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240826".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (6 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240826.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240827".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240827.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240828".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[3], alarmParams[4]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240828.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240829".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240829.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240830".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[3], alarmParams[4]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240830.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240831".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240831.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240834".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240834.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240835".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240835.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240836".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240836.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240837".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (5 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3], alarmParams[4]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240837.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240838".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (15 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3], alarmParams[4], alarmParams[5], alarmParams[6], alarmParams[7], alarmParams[8], alarmParams[9], alarmParams[10], alarmParams[11], alarmParams[12], alarmParams[13], alarmParams[14]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240838.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240841".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (15 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String paramTemp2 = "com.hs.atic.alart.collector.drop.log.level." + alarmParams[2];
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], paramTemp2, alarmParams[3], alarmParams[4], alarmParams[5], alarmParams[6]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240841.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240842".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (15 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String paramTemp2 = "com.hs.atic.alart.collector.drop.log.level." + alarmParams[2];
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], paramTemp2, alarmParams[3], alarmParams[4], alarmParams[5], alarmParams[6]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240842.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x000803220001".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x000803220001.alarm.brief", rule, alarmParams) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x000803220002".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x000803220002.alarm.brief", rule, alarmParams) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x000803220003".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x000803220003.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x000803220004".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (3 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[1], alarmParams[2]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x000803220004.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x000803220005".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (2 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x000803220005.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240877".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240877.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        } else if ("0x0000000803240878".equals(alert.getAlarmId())) {
            String alarmParam = alert.getAlarmParam();
            String[] alarmParams = alarmParam.split("###");
            if (4 > alarmParams.length) {
                LOGGER.error((Object)("Get " + alert.getAlarmId() + "alarmParams failed. AlarmParams:" + alarmParam));
                return "";
            }
            String[] briefParms = new String[]{alarmParams[0], alarmParams[1], alarmParams[2], alarmParams[3]};
            brief.append(this.getText(alert.getAlarmName(), rule) + this.getText("lego.lab.fault.notify.leftbraces", rule) + this.getText("0x0000000803240878.alarm.brief", rule, briefParms) + this.getText("lego.lab.fault.notify.rightbraces", rule));
        }
        return brief.toString();
    }

    private String getEmailContext(RemoteNotifyRule rule, List<ExtendAlert> alertList, StringBuffer upperContent) {
        StringBuilder builder = new StringBuilder();
        String newLine = RETURN_LINE;
        alertList = this.sortAlarmListByseverity(alertList);
        alertList = this.sortAlarmListByClean(alertList);
        int sendCount = 0;
        int alertCount = 0;
        int titleCount = 0;
        this.emailTitle = new StringBuilder(this.getText("lego.lab.fault.notify.emailTitle", rule));
        boolean isTitleAppend = true;
        int cleanStatus = 0;
        for (ExtendAlert alert : alertList) {
            if (0 == alertCount) {
                cleanStatus = alert.getClearStatus();
            }
            if (cleanStatus != alert.getClearStatus()) break;
            ++alertCount;
            boolean result = rule.contains(alert.getAlarmId(), alert.getSource(), alert.getClearStatus(), alert.getModTime(), alert.getClearTime(), alert.getMoId(), alert.getSeverity());
            if (!result || !rule.isIsClearEnable() && alert.getClearStatus() == 1) continue;
            ++sendCount;
            if (isTitleAppend) {
                String singleTitle = this.buildBrief(alert, rule);
                ++titleCount;
                if (100 > this.emailTitle.length() + singleTitle.length()) {
                    if (1 == titleCount) {
                        this.editEmailTitle(alert, rule);
                        this.emailTitle.append(singleTitle);
                    } else if (!"".equals(singleTitle)) {
                        this.emailTitle.append(this.getText("lego.lab.fault.notify.semicolon", rule) + singleTitle);
                    }
                } else {
                    if (1 == titleCount) {
                        this.editEmailTitle(alert, rule);
                        this.emailTitle.append(singleTitle.substring(0, 100 - this.emailTitle.length()));
                    }
                    this.emailTitle.append(this.getText("lego.lab.fault.notify.suspensionPoints", rule));
                    isTitleAppend = false;
                }
            }
            builder.append(RemoteNotifyHelper.getInstance().getNotifyContext(rule.getSendContent(), alert, rule.getLanguage(), upperContent));
            builder.append(newLine);
            builder.append(newLine);
            upperContent.append("<br>");
            if (sendCount < 100) continue;
            break;
        }
        ArrayList<ExtendAlert> tempList = new ArrayList<ExtendAlert>();
        if (alertCount < alertList.size()) {
            for (int i = alertCount; i < alertList.size(); ++i) {
                tempList.add(alertList.get(i));
            }
        }
        alertList.clear();
        alertList.addAll(tempList);
        return builder.toString();
    }

    private void editEmailTitle(ExtendAlert alert, RemoteNotifyRule rule) {
        this.emailTitle = alert.getClearStatus() == 1 ? new StringBuilder(this.getText("lego.fault.severity.title.clear", rule)) : (1 == alert.getSeverity() ? new StringBuilder(this.getText("lego.fault.severity.title.warning", rule)) : (2 == alert.getSeverity() ? new StringBuilder(this.getText("lego.fault.severity.title.minor", rule)) : (3 == alert.getSeverity() ? new StringBuilder(this.getText("lego.fault.severity.title.major", rule)) : new StringBuilder(this.getText("lego.fault.severity.title.critical", rule)))));
        if (null != companyName) {
            this.emailTitle.append(this.getText("atic.report.reportConfig.company", rule));
            this.emailTitle.append(this.getText("lego.lab.fault.notify.colon", rule));
            this.emailTitle.append(companyName);
            this.emailTitle.append("; ");
        }
    }

    private String getEmailSignature() {
        if (null == this.remoteNotifyServerService) {
            return "";
        }
        RemoteNotifyServer remoteNotifyServer = this.remoteNotifyServerService.getRemoteNotifyServer();
        String emailSignature = remoteNotifyServer.getEmailSignature();
        if (!SubscriberUtil.isNull(emailSignature)) {
            StringBuilder emailSignatureTemp = new StringBuilder();
            StringBuilder boundary = new StringBuilder();
            for (int i = 0; i <= 150; ++i) {
                boundary.append("-");
            }
            emailSignatureTemp.append(boundary.toString() + "\n" + emailSignature);
            return emailSignatureTemp.toString();
        }
        return "";
    }

    public IRemoteNotifyServerService getRemoteNotifyServerService() {
        return this.remoteNotifyServerService;
    }

    public void setRemoteNotifyServerService(IRemoteNotifyServerService remoteNotifyServerService) {
        this.remoteNotifyServerService = remoteNotifyServerService;
    }

    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public void setEmailSendService(IEmailSendService emailSendService) {
        this.emailSendService = emailSendService;
    }

    public IEmailSendService getEmailSendService() {
        return this.emailSendService;
    }

    public PageSizeDao getPageSizeDao() {
        return this.pageSizeDao;
    }

    public void setPageSizeDao(PageSizeDao pageSizeDao) {
        this.pageSizeDao = pageSizeDao;
    }

    public static String getCompanyName() {
        return companyName;
    }

    public static void setCompanyName(String companyName) {
        NotifyScheduler.companyName = companyName;
    }

    public IShortMsgSendService getSmsService() {
        return this.smsService;
    }

    public void setSmsService(IShortMsgSendService smsService) {
        this.smsService = smsService;
    }
}

