/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.service;

import com.hs.lego.cbb.fault.dao.NotifyDao;
import com.hs.lego.cbb.fault.sdk.model.FaultDefine;
import com.hs.lego.cbb.fault.sdk.model.NotifyRule;
import com.hs.lego.cbb.fault.sdk.model.NotifyRuleQueryCondition;
import com.hs.lego.cbb.fault.sdk.service.NotifyService;
import com.hs.lego.cbb.fault.service.NotifyListener;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NotifyServiceImpl
implements NotifyService {
    private NotifyDao notifyDao;

    @Override
    public Paging listNotifyRule(NotifyRuleQueryCondition condition) {
        return this.notifyDao.listNotifyRule(condition);
    }

    @Override
    public NotifyRule getNotifyRule(Long id) {
        return this.notifyDao.getNotifyRule(id);
    }

    @Override
    public List<FaultDefine> getFaultDefine() {
        return FaultDefineUtil.getInstance().getFaultDefine();
    }

    @Override
    public List<FaultDefine> getFaultDefine(Byte sourceType) {
        return FaultDefineUtil.getInstance().getFaultDefine(sourceType);
    }

    @Override
    public void addNotifyRule(NotifyRule rule) {
        if (rule.getStatus() == null) {
            rule.setStatus(NotifyRule.NotifyRuleStatus.ENABLED.getValue());
        }
        this.notifyDao.addNotifyRule(rule);
        NotifyListener.getInstance().add(rule);
    }

    @Override
    public void updateNotifyRule(NotifyRule rule) {
        Date now = new Date();
        if (now.before(rule.getEndTime()) && null != this.notifyDao.getNotifyRule(rule.getId()) && NotifyRule.NotifyRuleStatus.EXPIRED.getValue().equals(this.notifyDao.getNotifyRule(rule.getId()).getStatus())) {
            this.notifyDao.updateStatus(rule.getId(), NotifyRule.NotifyRuleStatus.ENABLED.getValue());
        }
        this.notifyDao.updateNotifyRule(rule);
        NotifyListener.getInstance().update(rule);
    }

    @Override
    public BatchOperationResult deleteNotifyRule(Long[] ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(this.notifyDao.deleteNotifyRule(id));
            resultList.add(batchOperation);
            NotifyListener.getInstance().delete(id);
        }
        result.setResult(resultList);
        result.setTotalCount(resultList.size());
        result.setSucceedCount(resultList.size());
        result.setFailCount(0);
        return result;
    }

    @Override
    public BatchOperationResult enableNotifyRule(Long[] ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(this.notifyDao.updateStatus(id, NotifyRule.NotifyRuleStatus.ENABLED.getValue()));
            resultList.add(batchOperation);
        }
        result.setResult(resultList);
        result.setTotalCount(resultList.size());
        result.setSucceedCount(resultList.size());
        result.setFailCount(0);
        return result;
    }

    @Override
    public BatchOperationResult disableNotifyRule(Long[] ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            BatchOperation batchOperation = new BatchOperation();
            batchOperation.setTargetName(this.notifyDao.updateStatus(id, NotifyRule.NotifyRuleStatus.DISABLED.getValue()));
            resultList.add(batchOperation);
        }
        result.setResult(resultList);
        result.setTotalCount(resultList.size());
        result.setSucceedCount(resultList.size());
        result.setFailCount(0);
        return result;
    }

    public void setNotifyDao(NotifyDao notifyDao) {
        this.notifyDao = notifyDao;
    }
}

