/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.fault.util;

import com.hs.lego.cbb.fault.dao.FaultDao;
import com.hs.lego.cbb.fault.util.ArrayDeepClone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class FaultStatisticUtil {
    private static final Object LOCK = new Object();
    private static FaultStatisticUtil instance = null;
    private long[] faultData = new long[8];
    private FaultDao faultDao;
    private ScheduledExecutorService scheduler = null;

    private FaultStatisticUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FaultStatisticUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new FaultStatisticUtil();
            }
            return instance;
        }
    }

    private void init() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FaultStatisticUtil.this.synchroizeFaultFromDB();
            }
        }, 1L, 300L, TimeUnit.SECONDS);
    }

    public void synchroizeFaultFromDB() {
        if (this.faultDao != null) {
            long[] data = this.faultDao.getFaultStatistic();
            System.arraycopy(data, 0, this.faultData, 0, data.length);
        }
    }

    public void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public void addFault(Byte severity) {
        int n = severity - 1;
        this.faultData[n] = this.faultData[n] + 1L;
        int n2 = severity + 3;
        this.faultData[n2] = this.faultData[n2] + 1L;
    }

    public void confirmFault(Byte severity) {
        if (this.faultData[severity + 3] > 0L) {
            int n = severity + 3;
            this.faultData[n] = this.faultData[n] - 1L;
        } else {
            this.faultData[severity.byteValue() + 3] = 0L;
        }
    }

    public void cancelConfirmFault(Byte severity) {
        int n = severity + 3;
        this.faultData[n] = this.faultData[n] + 1L;
    }

    public void clearFault(Byte severity) {
        if (this.faultData[severity - 1] > 0L) {
            int n = severity - 1;
            this.faultData[n] = this.faultData[n] - 1L;
        } else {
            this.faultData[severity.byteValue() - 1] = 0L;
        }
        if (this.faultData[severity + 3] > 0L) {
            int n = severity + 3;
            this.faultData[n] = this.faultData[n] - 1L;
        } else {
            this.faultData[severity.byteValue() + 3] = 0L;
        }
    }

    public void resetAllFault() {
        for (int i = 0; i < 8; ++i) {
            this.faultData[i] = 0L;
        }
    }

    public long[] getStatistic() {
        return (long[])ArrayDeepClone.deepClone(this.faultData);
    }

    public void setFaultDao(FaultDao faultDao) {
        this.faultDao = faultDao;
        this.init();
    }
}

