/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.resource;

import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ResDeleteSubscriber {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private IRemoteNotifyRuleService remoteNotifyRuleService = null;

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            this.logger.error((Object)"recv a null message object, message type: COMMAND_RES_DEL");
            return;
        }
        this.logger.info((Object)("receive COMMAND_RES_DEL message, moIds: " + msgObj.keySet()));
        Collection<ManagedObject> moList = msgObj.values();
        ArrayList<Long> tempList = new ArrayList<Long>();
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            this.deleteAlarmNority(topoMo);
            tempList.add(topoMo.getMoId());
        }
        this.deleteAlarmByMoID(tempList);
    }

    public void deleteAlarmByMoID(List<Long> moIdList) {
        this.logger.info((Object)("product call deleteAlarmAndEventByMoID,moId is " + moIdList.toString()));
        FaultService faultService = (FaultService)ServiceContext.getInstance().getService("faultService", FaultService.class);
        if (null != faultService) {
            faultService.deleteAllAlarmsByMoIds(moIdList);
        }
    }

    private void deleteAlarmNority(TopoObject topoMo) {
        long moId = topoMo.getMoId();
        if (moId == 0L) {
            this.logger.error((Object)"moId is 0, can not delete resource in notify or shield.");
        } else {
            boolean result2 = this.getRemoteNotifyRuleService().deleteResourceItem(String.valueOf(moId));
            this.getRemoteNotifyRuleService().refreshNotifyRuleMap();
            this.logger.info((Object)("delete a resource " + result2 + " in notify rule, moId: " + moId));
        }
    }

    private IRemoteNotifyRuleService getRemoteNotifyRuleService() {
        if (null == this.remoteNotifyRuleService) {
            this.remoteNotifyRuleService = (IRemoteNotifyRuleService)ServiceContext.getInstance().getService("remoteNotifyRuleService", IRemoteNotifyRuleService.class);
        }
        return this.remoteNotifyRuleService;
    }
}

