/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.resource;

import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.resource.SubscriberUtil;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.Map;
import java.util.Set;

public class ResOnlineSubscriber {
    private static final long SPECIAL_MOID = -1L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    public void onMessage(Map<Long, Integer> msgObj) {
        if (null == msgObj) {
            this.logger.error((Object)"recv a null message object, message type: COMMAND_RES_ONLINE");
            return;
        }
        Set<Long> moIds = msgObj.keySet();
        this.logger.info((Object)("recv a COMMAND_RES_ONLINE message, moIds: " + moIds));
        for (Long moId : moIds) {
            try {
                if (-1L == moId) continue;
                TopoObject mo = SubscriberUtil.getTopoObjectById(moId);
                LegoAlarm alarm = new LegoAlarm();
                alarm.setAlarmId("0x000803220005");
                alarm.setMoIp(mo.getIpAddress());
                alarm.setMoId(moId);
                alarm.setMoName(mo.getName());
                long alarmTime = System.currentTimeMillis();
                alarm.setAlarmTime(alarmTime);
                String[] param = new String[]{mo.getName(), mo.getIpAddress()};
                alarm.setAlarmParam(param);
                alarm.setAlarmLevel(FaultEnum.AlarmSeverity.CRITICAL);
                alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
                alarm.setClearTime(alarmTime);
                alarm.setClearUser("--");
                alarm.setMoUuid(mo.getUuid());
                alarm.setPortUuid(mo.getUuid());
                SubscriberUtil.getFaultGenerateService().generateRestoreAlarm(alarm);
            }
            catch (Exception e) {
                this.logger.error((Object)("generateAlarm failed in ResOnlineSubscriber of Fault Module, moId:" + moId), (Throwable)e);
            }
        }
    }
}

