/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.nem.fault.resource;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import java.util.Collection;
import java.util.Map;

public class ResUpdateSubscriber {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private IRemoteNotifyRuleService remoteNotifyRuleService = null;

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            this.logger.error((Object)"recv a null message object, message type: COMMAND_RES_UPDATE");
            return;
        }
        this.logger.info((Object)("receive COMMAND_RES_UPDATE message, moIds: " + msgObj.keySet()));
        Collection<ManagedObject> moList = msgObj.values();
        for (ManagedObject mo : moList) {
            if (!(mo instanceof TopoObject)) continue;
            TopoObject topoMo = (TopoObject)mo;
            this.updateAlarmNority(topoMo);
        }
    }

    public void updateAlarmNority(TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moIP = topoMo.getIpAddress();
        if (moId == 0L) {
            this.logger.error((Object)"moId is 0, can not update resource in notify.");
        } else {
            if (null == this.remoteNotifyRuleService) {
                this.remoteNotifyRuleService = (IRemoteNotifyRuleService)ServiceContext.getInstance().getService("remoteNotifyRuleService", IRemoteNotifyRuleService.class);
            }
            this.remoteNotifyRuleService.updateResourceItem(String.valueOf(moId), topoMo.getName(), moIP, topoMo.getMainType(), topoMo.getSubType());
        }
    }
}

