/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.hs.lego.nem.fault.sdk.service.IAlertNotifyService;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.webapp.vo.AudioListVO;
import java.util.ArrayList;
import java.util.List;

public class AlertAudioAction
extends BaseAction {
    private static final long serialVersionUID = -8657812788775446890L;
    private AlertAudioSetting setting = new AlertAudioSetting();
    private List<AudioListVO> audioList = new ArrayList<AudioListVO>();
    private IAlertNotifyService alertNotifyService;

    public String getAudioSetting() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        this.setting = this.alertNotifyService.getAudioSetting(currentUser.getUserID());
        if (null == this.setting) {
            this.setting = new AlertAudioSetting();
            this.audioList.add(new AudioListVO(4, this.getText("lego.lab.fault.alarmLevel.critical"), -1, false));
            this.audioList.add(new AudioListVO(3, this.getText("lego.lab.fault.alarmLevel.major"), -1, false));
            this.audioList.add(new AudioListVO(2, this.getText("lego.lab.fault.alarmLevel.minor"), -1, false));
            this.audioList.add(new AudioListVO(1, this.getText("lego.lab.fault.alarmLevel.warning"), -1, false));
        } else {
            this.audioList.add(new AudioListVO(4, this.getText("lego.lab.fault.alarmLevel.critical"), this.setting.getAudioCritical(), this.setting.isIsEnabledCritical()));
            this.audioList.add(new AudioListVO(3, this.getText("lego.lab.fault.alarmLevel.major"), this.setting.getAudioMajor(), this.setting.isIsEnabledMajor()));
            this.audioList.add(new AudioListVO(2, this.getText("lego.lab.fault.alarmLevel.minor"), this.setting.getAudioWarn(), this.setting.isIsEnabledWarn()));
            this.audioList.add(new AudioListVO(1, this.getText("lego.lab.fault.alarmLevel.warning"), this.setting.getAudioInfo(), this.setting.isIsEnabledInfo()));
        }
        return "success";
    }

    public String setAudioSetting() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        this.setting.setAlertUserId(currentUser.getUserID());
        if (this.setting.isIsEnabledCritical()) {
            this.setting.setAudioCritical(this.setting.getAudioCritical());
        } else {
            this.setting.setAudioCritical(-1);
        }
        if (this.setting.isIsEnabledMajor()) {
            this.setting.setAudioMajor(this.setting.getAudioMajor());
        } else {
            this.setting.setAudioMajor(-1);
        }
        if (this.setting.isIsEnabledWarn()) {
            this.setting.setAudioWarn(this.setting.getAudioWarn());
        } else {
            this.setting.setAudioWarn(-1);
        }
        if (this.setting.isIsEnabledInfo()) {
            this.setting.setAudioInfo(this.setting.getAudioInfo());
        } else {
            this.setting.setAudioInfo(-1);
        }
        this.setting.setIsEnabled(true);
        this.alertNotifyService.setAudioSetting(this.setting);
        this.getOperateLog().normal("lego.lab.fault.audio.sound.notification", "lego.dic.module.fault", "lego.lab.fault.audio.sound.soundnotification", true, "lego.lab.fault.audio.sound.notification", null);
        return "success";
    }

    public void modifyAudioStatus() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        long userId = currentUser.getUserID();
        boolean isEnabled = false;
        AlertAudioSetting audioSetting = this.alertNotifyService.getAudioSetting(userId);
        if (null != audioSetting) {
            isEnabled = audioSetting.isIsEnabled();
        }
        isEnabled = !isEnabled;
        this.alertNotifyService.modifyAudioStatus(userId, isEnabled);
        this.getOperateLog().normal("lego.lab.fault.notify.modifyvoice", "lego.dic.module.fault", "lego.lab.fault.notify.alarmsound", true, "lego.lab.fault.notify.modifyvoice", null);
        this.responseResult(String.valueOf(isEnabled));
    }

    public boolean validateSetting() {
        if (this.setting.isIsEnabledCritical() && (this.setting.getAudioCritical() > 2 || this.setting.getAudioCritical() <= 0)) {
            return false;
        }
        if (this.setting.isIsEnabledMajor() && (this.setting.getAudioMajor() > 2 || this.setting.getAudioMajor() <= 0)) {
            return false;
        }
        if (this.setting.isIsEnabledWarn() && (this.setting.getAudioWarn() > 2 || this.setting.getAudioWarn() <= 0)) {
            return false;
        }
        return !this.setting.isIsEnabledInfo() || this.setting.getAudioInfo() <= 2 && this.setting.getAudioInfo() > 0;
    }

    public AlertAudioSetting getSetting() {
        return this.setting;
    }

    public List<AudioListVO> getAudioList() {
        return this.audioList;
    }

    public IAlertNotifyService getAlertNotifyService() {
        return this.alertNotifyService;
    }

    public void setAlertNotifyService(IAlertNotifyService alertNotifyService) {
        this.alertNotifyService = alertNotifyService;
    }
}

