/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sp.sdk.service.ISpTypeService;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.hs.lego.nem.fault.sdk.model.NotifyResItem;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import com.hs.lego.ui.plat.common.constants.CustomSysConstant;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.webapp.action.NotifyRuleVO;
import com.hs.lego.ui.plat.fault.webapp.action.PhoneEmail;
import com.hs.lego.ui.plat.fault.webapp.action.Segment;
import com.hs.lego.ui.plat.fault.webapp.action.TemplatePair;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class BaseNotifyRuleAction
extends BaseAction {
    private static final long serialVersionUID = -3052657462016997222L;
    private RemoteNotifyRule remoteNotifyRulePO = new RemoteNotifyRule();
    private NotifyRuleVO notifyRuleVO = new NotifyRuleVO();
    private List<RemoteNotifyRule> remoteNotifyRuleList = new ArrayList<RemoteNotifyRule>();
    private List<LangPair> radioGroupList = new ArrayList<LangPair>();
    private List<TemplatePair> sendTypeGroupList = new ArrayList<TemplatePair>();
    private Long[] paramsContainer = new Long[0];
    private List<NotifyResItem> resourceList = new ArrayList<NotifyResItem>();
    private List<NotifyAlarmItem> alarmList = new ArrayList<NotifyAlarmItem>();
    private List<Segment> optionalField = new ArrayList<Segment>();
    private String[] selectiveField = null;
    private String[] emailList = new String[0];
    private List<PhoneEmail> emailListGrid = new ArrayList<PhoneEmail>();
    private String[] phoneList = new String[0];
    private List<PhoneEmail> phoneListGrid = new ArrayList<PhoneEmail>();
    private String[] deviceList = null;
    private String[] alarmTypeList = null;
    private String[] boxStr = new String[0];
    private List<TemplatePair> checkboxList = new ArrayList<TemplatePair>();
    private String sortField = null;
    private String sortType = null;
    private List<TemplatePair> sendContentList = new ArrayList<TemplatePair>();
    private List<TemplatePair> listEmailPath;
    private List<TemplatePair> listSmsPath;
    private boolean displaySendMethod = true;
    private String langLabel;
    private String langValue;
    private String startTime = null;
    private String endTime = null;
    private int expired = 0;
    private int id = 0;
    private int language = 1;
    private int level = 0;
    private String queryName = null;
    private String ruleName = null;
    private int ruleId = 0;
    private String editType = null;
    private String noexist = null;
    private int searchType = 1;
    private String moMainType = null;
    private String moSubType = null;
    private String selectedMo = null;
    private String queryRuleName = null;
    private IRemoteNotifyRuleService remoteNotifyRuleService;
    private ISpTypeService spTypeService;

    public boolean validateAlarmTypeList() {
        if (null != this.alarmTypeList && this.alarmTypeList.length > 0) {
            if (this.alarmTypeList.length > 100) {
                return false;
            }
            for (int i = 0; i < this.alarmTypeList.length; ++i) {
                if (this.alarmTypeList[i].matches("^\\d+###0x\\d+$") && this.alarmTypeList[i].length() <= 64) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateEmailList() {
        if (null != this.emailList && this.emailList.length > 0) {
            if (this.emailList.length > 100) {
                return false;
            }
            for (int i = 0; i < this.emailList.length; ++i) {
                if (null == this.emailList[i] || this.emailList[i].equals("")) {
                    return true;
                }
                if (this.emailList[i].matches("^[\\w.-]+@[\\w.-]+###[\\u4E00-\\u9FA5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\w|=|\\-|!|\\@|$|\\%|\\*|:|;|\\,|\\.|\\+|\\}|\\{|\\[|\\]|\\? ]*$") && this.emailList[i].length() <= 96) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validatePhoneList() {
        if (null != this.phoneList && this.phoneList.length > 0) {
            if (this.phoneList.length > 100) {
                return false;
            }
            for (int i = 0; i < this.phoneList.length; ++i) {
                if (null == this.phoneList[i] || this.phoneList[i].equals("")) {
                    return true;
                }
                if (this.phoneList[i].matches("^[\\+]?\\d+###[\\u4e00-\\u9fa5\\w|=|\\-|_|!|@|$|%|\\*|\\(|\\^|\\)|\\||:|;|\\,|\\.|\\+|\\}|\\{ ]*$") && this.phoneList[i].length() <= 64) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateParamsContainer() {
        if (null != this.paramsContainer && this.paramsContainer.length > 0) {
            if (this.paramsContainer.length > 100) {
                return false;
            }
            for (int i = 0; i < this.paramsContainer.length; ++i) {
                if (this.paramsContainer[i] >= 1L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateBoxStr() {
        if (null != this.boxStr && this.boxStr.length > 0) {
            if (this.boxStr.length > 100) {
                return false;
            }
            for (int i = 0; i < this.boxStr.length; ++i) {
                if (this.boxStr[i].matches("^[\\u4e00-\\u9fa5\\w-.\uff08\uff09  ]*$") && this.boxStr[i].length() <= 64) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateDeviceList() {
        if (null != this.deviceList && this.deviceList.length > 0) {
            if (this.deviceList.length > 100) {
                return false;
            }
            for (int i = 0; i < this.deviceList.length; ++i) {
                if (this.deviceList[i].matches("^[#\\u4e00-\\u9fa5\\w\\.\\- ]*$") && this.deviceList[i].length() <= 300) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateSelectiveField() {
        if (null != this.selectiveField && this.selectiveField.length > 0) {
            if (this.selectiveField.length > 8) {
                return false;
            }
            for (int i = 0; i < this.selectiveField.length; ++i) {
                if (this.selectiveField[i].matches("^[\u4e00-\u9fa5\\w ]*$") && this.selectiveField[i].length() <= 32) continue;
                return false;
            }
        }
        return true;
    }

    public String notifyRule() {
        String queryNameTemp = this.getQueryName();
        if (queryNameTemp == null) {
            queryNameTemp = "";
        }
        String start1 = String.valueOf(this.getStart());
        String pageSize1 = String.valueOf(this.getPageSize());
        if (start1.equals("")) {
            start1 = "0";
        }
        if (pageSize1.equals("")) {
            pageSize1 = "10";
        }
        this.fetchRequest().setAttribute("para", (Object)queryNameTemp);
        this.fetchRequest().setAttribute("start", (Object)start1);
        this.fetchRequest().setAttribute("pageSize", (Object)pageSize1);
        this.fetchRequest().setAttribute("noexist", (Object)this.getNoexist());
        this.notifyRuleVO.setRuleName(queryNameTemp);
        return "success";
    }

    public void checkUniqueNotifyName() {
        try {
            if (this.remoteNotifyRuleService.isExistRuleName(this.getRuleName())) {
                this.responseResult("exist");
                return;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"saveRule isExistRuleName error", (Throwable)e);
            return;
        }
    }

    public void checkNotifyEndTime() {
        String start = this.getStartTime();
        String end = this.getEndTime();
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setStartTimeStr(start);
        remoteNotifyRule.setEndTimeStr(end);
        try {
            this.remoteNotifyRuleService.checkRuleEndTime(remoteNotifyRule);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1565L) {
                this.responseResult("time");
            }
            throw e;
        }
    }

    public boolean validateTime() {
        String start = "";
        String end = "";
        if (null != this.getStartTime() && null != this.getEndTime()) {
            start = this.getStartTime();
            end = this.getEndTime();
        } else {
            start = this.remoteNotifyRulePO.getStartTimeStr();
            end = this.remoteNotifyRulePO.getEndTimeStr();
        }
        if (!this.checkEnter(start) || !this.checkEnter(end)) {
            return false;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setLenient(false);
        try {
            Date dF = null;
            Date dT = null;
            if (!"".equals(start)) {
                dF = df.parse(start);
            }
            if (!"".equals(end)) {
                dT = df.parse(end);
            }
            if (null != dF && null != dT && dF.after(dT)) {
                return false;
            }
        }
        catch (ParseException e) {
            this.log.error((Object)"validate Time ParseException error", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean checkEnter(String str) {
        return str.indexOf("\r") < 0 && str.indexOf("\n") < 0;
    }

    public void addNotifyRuleBase() {
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setLanguage(this.remoteNotifyRulePO.getLanguage());
        remoteNotifyRule.setRuleName(this.remoteNotifyRulePO.getRuleName());
        remoteNotifyRule.setIsClearEnable(true);
        remoteNotifyRule.setIsUseEnable(this.remoteNotifyRulePO.isIsUseEnable());
        remoteNotifyRule.setStartTimeStr(this.remoteNotifyRulePO.getStartTimeStr());
        remoteNotifyRule.setEndTimeStr(this.remoteNotifyRulePO.getEndTimeStr());
        remoteNotifyRule.setSmsMode(this.remoteNotifyRulePO.getSmsMode());
        remoteNotifyRule.setDescription(this.remoteNotifyRulePO.getDescription());
        this.addNotifyRule();
        for (int i = 0; i < this.alarmTypeList.length; ++i) {
            String[] alarmInfo = this.alarmTypeList[i].split("###");
            this.alarmTypeList[i] = this.alarmTypeList[i] + "###" + alarmInfo[1] + ".alarm.name";
        }
        try {
            this.remoteNotifyRuleService.addRule(remoteNotifyRule, this.emailList, this.phoneList, this.convertFromSegment(this.selectiveField), this.deviceList, this.alarmTypeList);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1556L) {
                super.responseResult("exist");
            } else if (e.getErrorCode() == 1538L) {
                super.responseResult("format");
            } else if (e.getErrorCode() == 1565L) {
                super.responseResult("time");
            } else if (e.getErrorCode() == 101L) {
                super.responseResult("database");
            }
            throw e;
        }
        catch (Exception e) {
            super.responseResult("error");
        }
        this.getOperateLog().normal("lego.lab.fault.log.notify.addrule", "lego.dic.module.fault", this.remoteNotifyRulePO.getRuleName());
    }

    private void addNotifyRule() {
        String remark;
        int index;
        int i;
        if (null != this.phoneList && this.phoneList.length > 0) {
            for (i = 0; i < this.phoneList.length; ++i) {
                String phone = this.phoneList[i];
                if ("".endsWith(phone)) continue;
                index = phone.indexOf("###");
                String tel = phone.substring(0, index);
                remark = phone.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.phoneList[i] = tel + "###" + remark;
            }
        }
        if (null != this.emailList && this.emailList.length > 0) {
            for (i = 0; i < this.emailList.length; ++i) {
                String email = this.emailList[i];
                if ("".endsWith(email)) continue;
                index = email.indexOf("###");
                String ml = email.substring(0, index);
                remark = email.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.emailList[i] = ml + "###" + remark;
            }
        }
    }

    public String getNotifyRuleList() {
        String queryNameTemp = this.getQueryName();
        String start1 = this.getStart() + "";
        String pageSize1 = this.getPageSize() + "";
        if (!start1.equals("")) {
            this.start = Integer.parseInt(start1);
        }
        if (!pageSize1.equals("")) {
            this.pageSize = Integer.parseInt(pageSize1);
        }
        this.notifyRuleVO.setRuleName(queryNameTemp);
        String orderByField = "ruleName";
        boolean orderByAscend = false;
        if (this.sortType != null && this.sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        if (this.sortField != null && !this.sortField.equalsIgnoreCase("alarmTimeStr")) {
            orderByField = this.sortField;
            if (this.sortField.equalsIgnoreCase("startTimeStr")) {
                orderByField = "startTime";
            } else if (this.sortField.equalsIgnoreCase("endTimeStr")) {
                orderByField = "endTime";
            }
        }
        Paging paging = this.remoteNotifyRuleService.getRuleAndCountByName(queryNameTemp, this.start, this.pageSize, orderByField, orderByAscend);
        this.total = paging.getCount();
        this.remoteNotifyRuleList = paging.getData();
        return "success";
    }

    public void startUse() {
        this.setUseStatus(false, true);
        this.getOperateLog().warning("lego.lab.fault.log.notify.start", "lego.dic.module.fault");
    }

    public void stopUse() {
        this.setUseStatus(false, false);
        this.getOperateLog().warning("lego.lab.fault.log.notify.stop", "lego.dic.module.fault");
    }

    public void deleteRules() {
        this.setUseStatus(true, false);
        this.getOperateLog().warning("lego.lab.fault.log.notify.deleterule", "lego.dic.module.fault");
    }

    public String queryNotifyPathSet() {
        return "success";
    }

    public void modifyNotifyPathSet() {
    }

    public String getNotifyQueryList() {
        String orderByField = "ruleName";
        boolean orderByAscend = false;
        if (this.sortType != null && this.sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        if (this.sortField != null && !this.sortField.equalsIgnoreCase("alarmTimeStr")) {
            orderByField = this.sortField;
            if (this.sortField.equalsIgnoreCase("startTimeStr")) {
                orderByField = "startTime";
            } else if (this.sortField.equalsIgnoreCase("endTimeStr")) {
                orderByField = "endTime";
            }
        }
        String name = this.notifyRuleVO.getRuleName();
        String searchTypeTemp = this.getSearchType() + "";
        Paging paging = null;
        paging = "2".equals(searchTypeTemp) ? this.remoteNotifyRuleService.getRuleAndCountByResName(name, this.start, this.pageSize, orderByField, orderByAscend) : this.remoteNotifyRuleService.getRuleAndCountByName(name, this.start, this.pageSize, orderByField, orderByAscend);
        this.total = paging.getCount();
        this.remoteNotifyRuleList = paging.getData();
        this.fetchRequest().setAttribute("searchType", (Object)searchTypeTemp);
        return "success";
    }

    public String notifyRuleDetail() {
        String smsPhone;
        String emailTo;
        this.notifyRuleVO = new NotifyRuleVO();
        this.sendTypeGroupList = new ArrayList<TemplatePair>();
        this.phoneListGrid = new ArrayList<PhoneEmail>();
        this.emailListGrid = new ArrayList<PhoneEmail>();
        String ruleIdTemp = this.getId() + "";
        String queryNameTemp = this.getQueryName();
        this.notifyRuleVO.setRuleName(queryNameTemp);
        try {
            this.remoteNotifyRulePO = this.remoteNotifyRuleService.getRuleByID(ruleIdTemp);
        }
        catch (Exception e) {
            throw new LegoCheckedException(201L);
        }
        String sendContent = this.remoteNotifyRulePO.getSendContent();
        if (sendContent != null) {
            String[] fields = sendContent.split(",");
            this.setVO(fields);
        }
        if ((emailTo = this.remoteNotifyRulePO.getEmailTo()) != null) {
            for (String email : this.emailList = emailTo.split("===")) {
                if (email == null || email.equals("")) continue;
                String[] tmpStr = email.split("###");
                String remark = "";
                if (tmpStr.length > 1) {
                    remark = tmpStr[1];
                }
                remark = remark.replaceAll("=k", "=");
                remark = remark.replaceAll("#k", "#");
                this.emailListGrid.add(new PhoneEmail(tmpStr[0], remark));
            }
        }
        if ((smsPhone = this.remoteNotifyRulePO.getSmsPhone()) != null) {
            for (String phone : this.phoneList = smsPhone.split("===")) {
                if (phone == null || phone.equals("")) continue;
                String[] tmpStr = phone.split("###");
                String remark = "";
                if (tmpStr.length > 1) {
                    remark = tmpStr[1];
                }
                remark = remark.replaceAll("=k", "=");
                remark = remark.replaceAll("#k", "#");
                this.phoneListGrid.add(new PhoneEmail(tmpStr[0], remark));
            }
        }
        this.fetchRequest().setAttribute("id", (Object)this.getId());
        this.fetchRequest().setAttribute("queryName", (Object)this.getQueryRuleName());
        this.fetchRequest().setAttribute("start", (Object)this.getStart());
        this.fetchRequest().setAttribute("pageSize", (Object)this.getPageSize());
        this.fetchRequest().setAttribute("alarmlocation", (Object)CustomSysConstant.getAlarmLocation());
        return "success";
    }

    public void exceedMaxNotifyRule() {
        int num = this.remoteNotifyRuleService.getAllRules().size();
        if (num >= 100) {
            String s = this.getText("lego.err.notifications");
            this.responseResult(s);
        }
    }

    public String popNotifyRuleForm() {
        this.generateRadioGroup();
        this.getNoticeSegment();
        this.generateAlarmLevelGroup();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        String startTimeStr = sdf.format(start);
        this.fetchRequest().setAttribute("startTimeStr", (Object)startTimeStr);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 1);
        Date end = calendar.getTime();
        String endTimeStr = sdf.format(end);
        this.fetchRequest().setAttribute("endTimeStr", (Object)endTimeStr);
        this.fetchRequest().setAttribute("systemMoShow", (Object)"true");
        this.fetchRequest().getSession().setAttribute("selectedMo", (Object)"");
        this.fetchRequest().setAttribute("alarmlocation", (Object)CustomSysConstant.getAlarmLocation());
        if (Locale.ENGLISH.equals(this.fetchRequest().getSession().getAttribute("WW_TRANS_I18N_LOCALE"))) {
            this.langLabel = "English";
            this.langValue = "en";
            this.remoteNotifyRulePO.setLanguage(2);
        } else {
            this.langLabel = this.getText("lego.lab.com.lang.zh");
            this.langValue = "zh_CN";
            this.remoteNotifyRulePO.setLanguage(1);
        }
        return "success";
    }

    public String[] convertFromSegment(String[] names) {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.alarmLevel"))) {
                fields.add("severity:" + this.getText("lego.lab.fault.alarmLevel"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.saveAlarm.name"))) {
                fields.add("alarmName:" + this.getText("lego.lab.fault.saveAlarm.name"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.dic.warningtype"))) {
                fields.add("alarmType:" + this.getText("lego.dic.warningtype"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.saveAlarm.alarmSource"))) {
                fields.add("source:" + this.getText("lego.lab.fault.saveAlarm.alarmSource"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.createTime"))) {
                fields.add("createTime:" + this.getText("lego.lab.fault.createTime"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.dic.clearstatus"))) {
                fields.add("clearStatus:" + this.getText("lego.dic.clearstatus"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.com.description"))) {
                fields.add("alarmDesc:" + this.getText("lego.lab.com.description"));
                continue;
            }
            if (!name.equalsIgnoreCase(this.getText("lego.lab.fault.location"))) continue;
            fields.add("location:" + this.getText("lego.lab.fault.location"));
        }
        String[] temp = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            temp[i] = (String)fields.get(i);
        }
        return temp;
    }

    public Segment[] convertFromFields(String fields) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        String[] field = fields.split(",");
        for (int i = 0; i < field.length; ++i) {
            String name = field[i].split(":")[0];
            if (name.equalsIgnoreCase("severity")) {
                segments.add(new Segment(this.getText("lego.lab.fault.alarmLevel")));
                continue;
            }
            if (name.equalsIgnoreCase("alarmName")) {
                segments.add(new Segment(this.getText("lego.lab.fault.saveAlarm.name")));
                continue;
            }
            if (name.equalsIgnoreCase("alarmType")) {
                segments.add(new Segment(this.getText("lego.dic.warningtype")));
                continue;
            }
            if (name.equalsIgnoreCase("source")) {
                segments.add(new Segment(this.getText("lego.lab.fault.saveAlarm.alarmSource")));
                continue;
            }
            if (name.equalsIgnoreCase("createTime")) {
                segments.add(new Segment(this.getText("lego.lab.fault.createTime")));
                continue;
            }
            if (name.equalsIgnoreCase("clearStatus")) {
                segments.add(new Segment(this.getText("lego.dic.clearstatus")));
                continue;
            }
            if (!name.equalsIgnoreCase("alarmDesc")) continue;
            segments.add(new Segment(this.getText("lego.lab.com.description")));
        }
        Segment[] temp = new Segment[segments.size()];
        for (int i = 0; i < segments.size(); ++i) {
            temp[i] = (Segment)segments.get(i);
        }
        return temp;
    }

    public String notifyBaseInfo() {
        String ruleIdTemp = this.getId() + "";
        this.remoteNotifyRulePO = this.remoteNotifyRuleService.getRuleByID(ruleIdTemp);
        String sendContent = this.remoteNotifyRulePO.getSendContent();
        if (sendContent != null) {
            String[] fields = sendContent.split(",");
            this.setVO(fields);
        }
        this.emailCheckFormat();
        this.phoneCheckFormat();
        this.generateRadioGroup();
        boolean useStatusDisable = this.isAuthority("lego.event.notify.start");
        this.fetchRequest().setAttribute("useStatusDisable", (Object)useStatusDisable);
        this.fetchRequest().setAttribute("alarmlocation", (Object)CustomSysConstant.getAlarmLocation());
        this.fetchRequest().setAttribute("language", (Object)this.getLanguage());
        return "success";
    }

    private void emailCheckFormat() {
        String emails = this.remoteNotifyRulePO.getEmailTo();
        if (emails != null && !emails.equals("")) {
            for (String email : this.emailList = emails.split("===")) {
                if (email != null && email.equals("") || null == email) continue;
                String[] emailArray = email.split("###");
                String remark = "";
                if (emailArray.length > 1) {
                    remark = emailArray[1];
                }
                remark = remark.replaceAll("=k", "=");
                remark = remark.replaceAll("#k", "#");
                this.emailListGrid.add(new PhoneEmail(emailArray[0], remark));
            }
        }
        if (!this.emailListGrid.isEmpty()) {
            this.fetchRequest().setAttribute("emailListGridSize", (Object)"none");
        } else {
            this.fetchRequest().setAttribute("emailListGridSize", (Object)"");
        }
    }

    private void phoneCheckFormat() {
        String phones = this.remoteNotifyRulePO.getSmsPhone();
        if (phones != null && !phones.equals("")) {
            for (String phone : this.phoneList = phones.split("===")) {
                if (phone != null && phone.equals("") || null == phone) continue;
                String[] phoneArray = phone.split("###");
                String remark = "";
                if (phoneArray.length > 1) {
                    remark = phoneArray[1];
                }
                remark = remark.replaceAll("=k", "=");
                remark = remark.replaceAll("#k", "#");
                this.phoneListGrid.add(new PhoneEmail(phoneArray[0], remark));
            }
        }
        if (!this.phoneListGrid.isEmpty()) {
            this.fetchRequest().setAttribute("phoneListGridSize", (Object)"none");
        } else {
            this.fetchRequest().setAttribute("phoneListGridSize", (Object)"");
        }
    }

    public void modifyNotifyBaseInfo() {
        this.remoteNotifyRuleService.modifyNotifyBaseInfo(String.valueOf(this.remoteNotifyRulePO.getId()), this.remoteNotifyRulePO.isIsUseEnable(), this.remoteNotifyRulePO.getStartTimeStr(), this.remoteNotifyRulePO.getEndTimeStr(), this.remoteNotifyRulePO.getDescription(), this.remoteNotifyRulePO.getLanguage(), this.setSendContent(this.notifyRuleVO));
        String ruleNameTemp = "";
        ruleNameTemp = this.getRuleName();
        this.getOperateLog().normal("lego.ver.notifyrule.amend", "lego.dic.module.fault", ruleNameTemp, true, "lego.lab.fault.log.notify.modifybaserule", null);
    }

    public void modifyNotifyObj() {
        String remark;
        int index;
        int i;
        if (this.phoneList.length > 0) {
            for (i = 0; i < this.phoneList.length; ++i) {
                String phone = this.phoneList[i];
                if ("".endsWith(phone)) continue;
                index = phone.indexOf("###");
                String tel = phone.substring(0, index);
                remark = phone.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.phoneList[i] = tel + "###" + remark;
            }
        }
        if (this.emailList.length > 0) {
            for (i = 0; i < this.emailList.length; ++i) {
                String email = this.emailList[i];
                if ("".endsWith(email)) continue;
                index = email.indexOf("###");
                String ml = email.substring(0, index);
                remark = email.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.emailList[i] = ml + "###" + remark;
            }
        }
        this.remoteNotifyRuleService.modifyNotifyObj(String.valueOf(this.remoteNotifyRulePO.getId()), this.remoteNotifyRulePO.getSmsMode(), this.phoneList, this.emailList);
        String ruleNameTemp = "";
        ruleNameTemp = this.getRuleName();
        this.getOperateLog().normal("lego.ver.notifyrule.amend", "lego.dic.module.fault", ruleNameTemp, true, "lego.lab.fault.log.notify.modifyobject", null);
    }

    public void createRule() {
        String remark;
        int index;
        int i;
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setLanguage(this.remoteNotifyRulePO.getLanguage());
        remoteNotifyRule.setRuleName(this.remoteNotifyRulePO.getRuleName());
        remoteNotifyRule.setIsClearEnable(true);
        remoteNotifyRule.setIsUseEnable(this.remoteNotifyRulePO.isIsUseEnable());
        remoteNotifyRule.setStartTimeStr(this.remoteNotifyRulePO.getStartTimeStr());
        remoteNotifyRule.setEndTimeStr(this.remoteNotifyRulePO.getEndTimeStr());
        remoteNotifyRule.setSmsMode(this.remoteNotifyRulePO.getSmsMode());
        remoteNotifyRule.setDescription(this.remoteNotifyRulePO.getDescription());
        if (null != this.phoneList && this.phoneList.length > 0) {
            for (i = 0; i < this.phoneList.length; ++i) {
                String phone = this.phoneList[i];
                if ("".endsWith(phone)) continue;
                index = phone.indexOf("###");
                String tel = phone.substring(0, index);
                remark = phone.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.phoneList[i] = tel + "###" + remark;
            }
        }
        if (null != this.emailList && this.emailList.length > 0) {
            for (i = 0; i < this.emailList.length; ++i) {
                String email = this.emailList[i];
                if ("".endsWith(email)) continue;
                index = email.indexOf("###");
                String ml = email.substring(0, index);
                remark = email.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.emailList[i] = ml + "###" + remark;
            }
        }
        try {
            this.remoteNotifyRuleService.addRule(remoteNotifyRule, this.emailList, this.phoneList, this.convertFromSegment(this.selectiveField), this.deviceList, this.alarmTypeList);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1556L) {
                super.responseResult("exist");
            } else if (e.getErrorCode() == 1538L) {
                super.responseResult("format");
            } else if (e.getErrorCode() == 1565L) {
                super.responseResult("time");
            } else if (e.getErrorCode() == 101L) {
                super.responseResult("database");
            }
            throw e;
        }
        catch (Exception e) {
            super.responseResult("error");
        }
        this.getOperateLog().normal("lego.lab.fault.log.notify.addrule", "lego.dic.module.fault", this.remoteNotifyRulePO.getRuleName());
    }

    public String popNotifyRes() {
        String idTemp = this.getRuleId() + "";
        long userId = this.getUserId();
        Paging paging = this.remoteNotifyRuleService.queryResourceItem(idTemp, "", -1, -1, "moName", true, userId);
        List list = paging.getData();
        StringBuilder moIds = new StringBuilder();
        moIds.append(",");
        for (NotifyResItem item : list) {
            moIds.append(item.getAlarmSource());
            moIds.append(",");
        }
        this.setQueryName(this.remoteNotifyRuleService.getRuleByID(idTemp).getRuleName());
        this.fetchRequest().setAttribute("ruleId", (Object)this.getRuleId());
        this.fetchRequest().setAttribute("moMainType", (Object)this.getMoMainType());
        this.fetchRequest().setAttribute("moSubType", (Object)this.getMoSubType());
        this.fetchRequest().setAttribute("editType", (Object)this.getEditType());
        this.fetchRequest().getSession().setAttribute("selectedMo", (Object)moIds.toString());
        return "success";
    }

    public void addResource() {
        String idTemp = this.getRuleId() + "";
        String queryNameTemp = this.getQueryName();
        this.remoteNotifyRuleService.addResource(idTemp, this.deviceList);
        this.getOperateLog().normal("lego.ver.notifyrule.amend", "lego.dic.module.fault", queryNameTemp, true, "lego.lab.com.resource.add", null);
    }

    public String popNotifyAlarm() {
        String idTemp = this.getRuleId() + "";
        Paging paging = this.remoteNotifyRuleService.queryAlarmItem(idTemp, "", -1, -1, "alarmName", true);
        List list = paging.getData();
        StringBuilder moIds = new StringBuilder();
        moIds.append(",");
        for (NotifyAlarmItem item : list) {
            moIds.append(item.getAlarmId());
            moIds.append("_");
            moIds.append(item.getAlarmLevel());
            moIds.append(",");
        }
        this.setQueryName(this.remoteNotifyRuleService.getRuleByID(idTemp).getRuleName());
        this.fetchRequest().setAttribute("ruleId", (Object)(this.getRuleId() + ""));
        this.fetchRequest().setAttribute("moMainType", (Object)this.getMoMainType());
        this.fetchRequest().setAttribute("moSubType", (Object)this.getMoSubType());
        this.fetchRequest().setAttribute("editType", (Object)this.getEditType());
        this.fetchRequest().getSession().setAttribute("selectedMo", (Object)moIds.toString());
        this.generateAlarmLevelGroup();
        this.fetchRequest().setAttribute("typeString", (Object)this.getEditType());
        return "success";
    }

    public void addAlarm() {
        String idTemp = this.getRuleId() + "";
        String queryNameTemp = "";
        queryNameTemp = this.getQueryName();
        for (int i = 0; i < this.alarmTypeList.length; ++i) {
            String[] alarmInfo = this.alarmTypeList[i].split("###");
            this.alarmTypeList[i] = this.alarmTypeList[i] + "###" + alarmInfo[1] + ".alarm.name";
        }
        this.remoteNotifyRuleService.addAlarm(idTemp, this.alarmTypeList);
        this.getOperateLog().normal("lego.ver.notifyrule.amend", "lego.dic.module.fault", queryNameTemp, true, "lego.lab.com.alarm.addType", null);
    }

    public void deleteResource() {
        if (null != this.paramsContainer && this.paramsContainer.length > 0) {
            ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
            int size = this.paramsContainer.length;
            String queryNameTemp = this.getQueryName();
            for (int i = 0; i < size; ++i) {
                BatchOperation tempBatch = new BatchOperation();
                tempBatch.setTargetId(this.paramsContainer[i].longValue());
                tempBatch.setTargetName(this.boxStr[i]);
                bathOprLst.add(tempBatch);
            }
            this.batchOperationResult = this.remoteNotifyRuleService.deleteResourceItem(bathOprLst);
            this.remoteNotifyRuleService.refreshNotifyRuleMap();
            if (this.batchOperationResult != null) {
                this.bathResult(this.batchOperationResult);
            }
            this.writeDelResOptLog(queryNameTemp);
        }
    }

    private void writeDelResOptLog(String queryNameTemp) {
        SysOptLog oOptLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        Date date = new Date();
        if (this.batchOperationResult.getFailCount() > 0) {
            for (BatchOperation alarm : this.batchOperationResult.getResult()) {
                if (alarm.getErrorCode() == 0L) continue;
                String[] targetPara = new String[]{alarm.getTargetName()};
                oOptLog.setDetailPara(targetPara);
                oOptLog.setResult(0);
                oOptLog.setDetail("lego.err.fault.delresourceFail");
                break;
            }
        } else {
            oOptLog.setResult(1);
            oOptLog.setDetail("lego.err.fault.delresource");
        }
        oOptLog.setDate(date);
        oOptLog.setTarget(queryNameTemp);
        oOptLog.setLevel(2);
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setModule("lego.dic.module.fault");
        oOptLog.setOperation("lego.ver.notifyrule.amend");
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysLogService.writeOptLog(oOptLog);
    }

    public void deleteAlarm() {
        if (null != this.paramsContainer && this.paramsContainer.length > 0) {
            ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
            int size = this.paramsContainer.length;
            String queryNameTemp = this.getQueryName();
            for (int i = 0; i < size; ++i) {
                BatchOperation tempBatch = new BatchOperation();
                tempBatch.setTargetId(this.paramsContainer[i].longValue());
                tempBatch.setTargetName(this.boxStr[i]);
                bathOprLst.add(tempBatch);
            }
            this.batchOperationResult = this.remoteNotifyRuleService.deleteAlarmItem(bathOprLst);
            this.remoteNotifyRuleService.refreshNotifyRuleMap();
            if (this.batchOperationResult != null) {
                this.bathResult(this.batchOperationResult);
            }
            this.writeDelAlarmOptLog(queryNameTemp);
        }
    }

    private void writeDelAlarmOptLog(String queryNameTemp) {
        SysOptLog oOptLog = new SysOptLog();
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        Date date = new Date();
        if (this.batchOperationResult.getFailCount() > 0) {
            for (BatchOperation alarm : this.batchOperationResult.getResult()) {
                if (alarm.getErrorCode() == 0L) continue;
                String[] targetPara = new String[]{alarm.getTargetName()};
                oOptLog.setDetailPara(targetPara);
                oOptLog.setDetail("lego.lab.com.alarm.deleteTypeFail");
                oOptLog.setResult(0);
                break;
            }
        } else {
            oOptLog.setResult(1);
            oOptLog.setDetail("lego.lab.com.alarm.deleteType");
        }
        oOptLog.setDate(date);
        oOptLog.setTarget(queryNameTemp);
        oOptLog.setLevel(2);
        oOptLog.setOperator(currentUser.getUserName());
        oOptLog.setModule("lego.dic.module.fault");
        oOptLog.setOperation("lego.ver.notifyrule.amend");
        oOptLog.setTerminalIp(currentUser.getIpAdr());
        oOptLog.setTargetLocal(Boolean.valueOf(true));
        ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysLogService.writeOptLog(oOptLog);
    }

    public String queryResource() {
        String orderByField = "moName";
        boolean orderByAscend = false;
        if (this.sortType != null && this.sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        if (this.sortField != null) {
            orderByField = this.sortField;
        }
        String ruleIdTemp = String.valueOf(this.getId());
        this.fetchRequest().setAttribute("id", (Object)ruleIdTemp);
        String name = this.notifyRuleVO.getResName();
        if (ruleIdTemp.equals("")) {
            return "success";
        }
        long userId = this.getUserId();
        Paging paging = this.remoteNotifyRuleService.queryResourceItem(ruleIdTemp, name, this.start, this.pageSize, orderByField, orderByAscend, userId);
        this.total = paging.getCount();
        this.resourceList = paging.getData();
        this.notifyRuleVO.setAlarmName(name);
        return "success";
    }

    private long getUserId() {
        long userId = -1L;
        User currentUser = this.getCurrentUser();
        if (!"true".equalsIgnoreCase(currentUser.getIsAdmin())) {
            userId = currentUser.getUserID();
        }
        return userId;
    }

    public String queryAlarm() {
        String orderByField = "alarmLevel";
        boolean orderByAscend = true;
        if (this.sortType != null && this.sortType.equalsIgnoreCase("asc")) {
            orderByAscend = true;
        }
        if (this.sortField != null) {
            orderByField = this.sortField;
        }
        String ruleIdTemp = this.getId() + "";
        String levelTemp = this.getLevel() + "";
        if (ruleIdTemp.equals("")) {
            return "success";
        }
        Paging paging = this.remoteNotifyRuleService.queryAlarmItem(ruleIdTemp, levelTemp, this.start, this.pageSize, orderByField, orderByAscend);
        this.total = paging.getCount();
        this.alarmList = paging.getData();
        return "success";
    }

    private void setVO(String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String[] fieldValue = fields[i].split(":");
            if (fieldValue[0].equalsIgnoreCase("entity")) {
                this.notifyRuleVO.setIsEntity(true);
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("alarmId")) {
                this.notifyRuleVO.setIsId(true);
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("severity")) {
                this.notifyRuleVO.setIsLevel(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel"), 1L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("alarmName")) {
                this.notifyRuleVO.setIsName(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.lab.fault.saveAlarm.name"), 2L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("alarmType")) {
                this.notifyRuleVO.setIsWaningType(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.dic.warningtype"), 3L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("source")) {
                this.notifyRuleVO.setIsSource(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.lab.fault.saveAlarm.alarmSource"), 4L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("createTime")) {
                this.notifyRuleVO.setIsCreateTime(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.lab.fault.createTime"), 5L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("clearStatus")) {
                this.notifyRuleVO.setIsClrStatus(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.dic.clearstatus"), 6L));
                continue;
            }
            if (fieldValue[0].equalsIgnoreCase("alarmDesc")) {
                this.notifyRuleVO.setIsDescription(true);
                this.sendContentList.add(new TemplatePair(this.getText("lego.lab.com.description"), 7L));
                continue;
            }
            if (!fieldValue[0].equalsIgnoreCase("location")) continue;
            this.notifyRuleVO.setIsLocation(true);
            this.sendContentList.add(new TemplatePair(this.getText("lego.lab.fault.location"), 8L));
        }
    }

    private String setSendContent(NotifyRuleVO notifyRuleVo) {
        String content;
        StringBuilder sendContent = new StringBuilder();
        if (notifyRuleVo.getIsLevel()) {
            sendContent.append("severity:" + this.getText("lego.lab.fault.alarmLevel"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsName()) {
            sendContent.append("alarmName:" + this.getText("lego.lab.fault.saveAlarm.name"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsWaningType()) {
            sendContent.append("alarmType:" + this.getText("lego.dic.warningtype"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsSource()) {
            sendContent.append("source:" + this.getText("lego.lab.fault.saveAlarm.alarmSource"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsCreateTime()) {
            sendContent.append("createTime:" + this.getText("lego.lab.fault.createTime"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsClrStatus()) {
            sendContent.append("clearStatus:" + this.getText("lego.dic.clearstatus"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsDescription()) {
            sendContent.append("alarmDesc:" + this.getText("lego.lab.com.description"));
            sendContent.append(",");
        }
        if (notifyRuleVo.getIsLocation()) {
            sendContent.append("location:" + this.getText("lego.lab.fault.location"));
            sendContent.append(",");
        }
        if (!(content = sendContent.toString()).equals("")) {
            return content.substring(0, content.length() - 1);
        }
        return sendContent.toString();
    }

    private void setUseStatus(boolean isDelete, boolean useStatus) {
        ArrayList<BatchOperation> bathOprList = new ArrayList<BatchOperation>();
        if (null == this.paramsContainer || this.paramsContainer.length <= 0) {
            return;
        }
        int length = this.paramsContainer.length;
        for (int i = 0; i < length; ++i) {
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(this.paramsContainer[i].longValue());
            tempBatch.setTargetName(this.boxStr[i]);
            bathOprList.add(tempBatch);
        }
        this.batchOperationResult = isDelete ? this.remoteNotifyRuleService.deleteRules(bathOprList) : this.remoteNotifyRuleService.setSwitchStatus(useStatus, bathOprList);
        if (this.batchOperationResult != null) {
            this.bathResult(this.batchOperationResult);
        }
    }

    private void getNoticeSegment() {
        this.optionalField.add(new Segment(this.getText("lego.lab.fault.alarmLevel")));
        this.optionalField.add(new Segment(this.getText("lego.lab.fault.saveAlarm.name")));
        this.optionalField.add(new Segment(this.getText("lego.dic.warningtype")));
        this.optionalField.add(new Segment(this.getText("lego.lab.fault.saveAlarm.alarmSource")));
        this.optionalField.add(new Segment(this.getText("lego.lab.fault.createTime")));
        this.optionalField.add(new Segment(this.getText("lego.dic.clearstatus")));
        this.optionalField.add(new Segment(this.getText("lego.lab.com.description")));
        this.optionalField.add(new Segment(this.getText("lego.lab.fault.location")));
    }

    public void generateRadioGroup() {
        this.radioGroupList.add(new LangPair(this.getText("lego.lab.com.enable"), "true"));
        this.radioGroupList.add(new LangPair(this.getText("lego.lab.com.disable"), "false"));
    }

    public void generateSmsModeGroup() {
        int flag = this.spTypeService.getSpType();
        if (flag != 0) {
            this.sendTypeGroupList.add(new TemplatePair(this.getText("lego.lab.fault.notify.unicom.sp"), 1L));
            this.displaySendMethod = true;
        } else {
            this.displaySendMethod = false;
        }
    }

    public String generateAlarmLevelGroup() {
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.critical"), 4L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.major"), 3L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.minor"), 2L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.warning"), 1L));
        return "success";
    }

    private User getCurrentUser() {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        return currentUser;
    }

    public RemoteNotifyRule getRemoteNotifyRulePO() {
        return this.remoteNotifyRulePO;
    }

    public void setRemoteNotifyRulePO(RemoteNotifyRule remoteNotifyRulePO) {
        this.remoteNotifyRulePO = remoteNotifyRulePO;
    }

    public NotifyRuleVO getNotifyRuleVO() {
        return this.notifyRuleVO;
    }

    public void setNotifyRuleVO(NotifyRuleVO notifyRuleVO) {
        this.notifyRuleVO = notifyRuleVO;
    }

    public List<RemoteNotifyRule> getRemoteNotifyRuleList() {
        return this.remoteNotifyRuleList;
    }

    public void setRemoteNotifyRuleList(List<RemoteNotifyRule> remoteNotifyRuleList) {
        this.remoteNotifyRuleList = remoteNotifyRuleList;
    }

    public Long[] getParamsContainer() {
        return (Long[])ArrayDeepClone.deepClone((Object)this.paramsContainer);
    }

    public void setParamsContainer(Long[] paramsContainer) {
        this.paramsContainer = (Long[])ArrayDeepClone.deepClone((Object)paramsContainer);
    }

    public String[] getBoxStr() {
        return (String[])ArrayDeepClone.deepClone((Object)this.boxStr);
    }

    public void setBoxStr(String[] boxStr) {
        this.boxStr = (String[])ArrayDeepClone.deepClone((Object)boxStr);
    }

    public List<NotifyResItem> getResourceList() {
        return this.resourceList;
    }

    public void setResourceList(List<NotifyResItem> resourceList) {
        this.resourceList = resourceList;
    }

    public List<NotifyAlarmItem> getAlarmList() {
        return this.alarmList;
    }

    public void setAlarmList(List<NotifyAlarmItem> alarmList) {
        this.alarmList = alarmList;
    }

    public List<TemplatePair> getCheckboxList() {
        return this.checkboxList;
    }

    public void setCheckboxList(List<TemplatePair> checkboxList) {
        this.checkboxList = checkboxList;
    }

    public List<Segment> getOptionalField() {
        return this.optionalField;
    }

    public void setOptionalField(List<Segment> optionalField) {
        this.optionalField = optionalField;
    }

    public String[] getSelectiveField() {
        return (String[])ArrayDeepClone.deepClone((Object)this.selectiveField);
    }

    public void setSelectiveField(String[] selectiveField) {
        this.selectiveField = (String[])ArrayDeepClone.deepClone((Object)selectiveField);
    }

    public String[] getEmailList() {
        return (String[])ArrayDeepClone.deepClone((Object)this.emailList);
    }

    public void setEmailList(String[] emailList) {
        this.emailList = (String[])ArrayDeepClone.deepClone((Object)emailList);
    }

    public String[] getPhoneList() {
        return (String[])ArrayDeepClone.deepClone((Object)this.phoneList);
    }

    public void setPhoneList(String[] phoneList) {
        this.phoneList = (String[])ArrayDeepClone.deepClone((Object)phoneList);
    }

    public String[] getDeviceList() {
        return (String[])ArrayDeepClone.deepClone((Object)this.deviceList);
    }

    public void setDeviceList(String[] deviceList) {
        this.deviceList = (String[])ArrayDeepClone.deepClone((Object)deviceList);
    }

    public String[] getAlarmTypeList() {
        return (String[])ArrayDeepClone.deepClone((Object)this.alarmTypeList);
    }

    public void setAlarmTypeList(String[] alarmTypeList) {
        this.alarmTypeList = (String[])ArrayDeepClone.deepClone((Object)alarmTypeList);
    }

    public List<LangPair> getRadioGroupList() {
        return this.radioGroupList;
    }

    public void setRadioGroupList(List<LangPair> radioGroupList) {
        this.radioGroupList = radioGroupList;
    }

    public List<TemplatePair> getSendTypeGroupList() {
        return this.sendTypeGroupList;
    }

    public void setSendTypeGroupList(List<TemplatePair> sendTypeGroupList) {
        this.sendTypeGroupList = sendTypeGroupList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public List<PhoneEmail> getEmailListGrid() {
        return this.emailListGrid;
    }

    public void setEmailListGrid(List<PhoneEmail> emailListGrid) {
        this.emailListGrid = emailListGrid;
    }

    public List<PhoneEmail> getPhoneListGrid() {
        return this.phoneListGrid;
    }

    public void setPhoneListGrid(List<PhoneEmail> phoneListGrid) {
        this.phoneListGrid = phoneListGrid;
    }

    public List<TemplatePair> getSendContentList() {
        return this.sendContentList;
    }

    public void setSendContentList(List<TemplatePair> sendContentList) {
        this.sendContentList = sendContentList;
    }

    public List<TemplatePair> getListEmailPath() {
        return this.listEmailPath;
    }

    public void setListEmailPath(List<TemplatePair> listEmailPath) {
        this.listEmailPath = listEmailPath;
    }

    public List<TemplatePair> getListSmsPath() {
        return this.listSmsPath;
    }

    public void setListSmsPath(List<TemplatePair> listSmsPath) {
        this.listSmsPath = listSmsPath;
    }

    public boolean isDisplaySendMethod() {
        return this.displaySendMethod;
    }

    public void setDisplaySendMethod(boolean displaySendMethod) {
        this.displaySendMethod = displaySendMethod;
    }

    public String getLangLabel() {
        return this.langLabel;
    }

    public void setLangLabel(String langLabel) {
        this.langLabel = langLabel;
    }

    public String getLangValue() {
        return this.langValue;
    }

    public void setLangValue(String langValue) {
        this.langValue = langValue;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public int getExpired() {
        return this.expired;
    }

    public void setExpired(int expired) {
        this.expired = expired;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleNameTemp) {
        this.ruleName = ruleNameTemp;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(int ruleId) {
        this.ruleId = ruleId;
    }

    public String getEditType() {
        return this.editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public String getNoexist() {
        return this.noexist;
    }

    public void setNoexist(String noexist) {
        this.noexist = noexist;
    }

    public int getSearchType() {
        return this.searchType;
    }

    public void setSearchType(int searchType) {
        this.searchType = searchType;
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public int getLanguage() {
        return this.language;
    }

    public void setLanguage(int language) {
        this.language = language;
    }

    public String getSelectedMo() {
        return this.selectedMo;
    }

    public void setSelectedMo(String selectedMo) {
        this.selectedMo = selectedMo;
    }

    public String getQueryRuleName() {
        return this.queryRuleName;
    }

    public void setQueryRuleName(String queryRuleName) {
        this.queryRuleName = queryRuleName;
    }

    public IRemoteNotifyRuleService getRemoteNotifyRuleService() {
        return this.remoteNotifyRuleService;
    }

    public void setRemoteNotifyRuleService(IRemoteNotifyRuleService remoteNotifyRuleService) {
        this.remoteNotifyRuleService = remoteNotifyRuleService;
    }

    public ISpTypeService getSpTypeService() {
        return this.spTypeService;
    }

    public void setSpTypeService(ISpTypeService spTypeService) {
        this.spTypeService = spTypeService;
    }
}

