/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.fault.util.ArrayDeepClone;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.util.ExportUtil;
import com.hs.lego.ui.plat.monitor.util.FileFactory;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FaultAction
extends BaseAction {
    private static final long serialVersionUID = -2248557199667735656L;
    private Long id;
    private Long[] ids;
    private Fault fault;
    private String faultDescForAbnormalAlarm;
    private String faultAdviceForIntelligentDefend;
    private Boolean currentFault = false;
    private String[] faultParams;
    private String displayName = null;
    private FaultService faultService;

    public FaultService getFaultService() {
        return this.faultService;
    }

    public void setFaultService(FaultService faultService) {
        this.faultService = faultService;
    }

    public Boolean getCurrentFault() {
        return this.currentFault;
    }

    public void setCurrentFault(Boolean currentFault) {
        this.currentFault = currentFault;
    }

    public String[] getFaultParams() {
        return (String[])ArrayDeepClone.deepClone(this.faultParams);
    }

    public void setFaultParams(String[] faultParams) {
        this.faultParams = (String[])ArrayDeepClone.deepClone(faultParams);
    }

    public String getFaultDescForAbnormalAlarm() {
        return this.faultDescForAbnormalAlarm;
    }

    public void setFaultDescForAbnormalAlarm(String faultDescForAbnormalAlarm) {
        this.faultDescForAbnormalAlarm = faultDescForAbnormalAlarm;
    }

    public String htmlEncode(String text) {
        if (null != text && !text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&#39;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }

    public String showCurtFault() {
        if (this.id == null) {
            return "error";
        }
        Byte clearStatus = 0;
        this.showFault(clearStatus);
        return "success";
    }

    public String showHisFault() {
        if (this.id == null) {
            return "error";
        }
        Byte clearStatus = 1;
        this.showFault(clearStatus);
        return "success";
    }

    private void showFault(Byte clearStatus) {
        Long[] selectIds = new Long[]{this.id};
        this.checkSelectFaultSecurity(selectIds);
        this.fault = this.faultService.getFault(this.id);
        this.faultParams = this.fault.getFaultParam().split("###");
        for (int i = 0; i < this.faultParams.length; ++i) {
            if (this.faultParams[i].contains(".")) {
                this.faultParams[i] = this.getText(this.faultParams[i]);
            }
            this.faultParams[i] = this.htmlEncode(this.getText(this.faultParams[i]));
        }
        String advice = this.getText(this.fault.getFaultDefineId() + ".alarm.advice");
        if (advice != null && advice.isEmpty()) {
            this.fault.setParamShaCode(advice);
        } else if (null != advice) {
            String[] advices;
            StringBuilder sb = new StringBuilder();
            sb.append("<div style='padding: 0px 10px;width: 100%;'>");
            sb.append("<table width='100%'border='0'>");
            for (String temp : advices = advice.split("<br>")) {
                sb.append("<tr><td style='padding:0px 4px;width:765px;word-wrap:break-word;line-height:28px'>");
                sb.append(temp);
                sb.append("</td></tr>");
            }
            sb.append("</table>");
            sb.append("</div>");
            this.fault.setParamShaCode(sb.toString());
        }
        this.sourceMonitorPro();
    }

    private void sourceMonitorPro() {
        this.faultDescForAbnormalAlarm = null;
        if ("0x0000000803240801".equals(this.fault.getFaultDefineId())) {
            if (null != this.fault.getFaultParam() && !"".equals(this.fault.getFaultParam())) {
                StringBuffer displayBf = new StringBuffer();
                if (this.faultParams.length > 11 && null != this.faultParams[11] && ("-".equals(this.faultParams[11]) || this.faultParams[11].matches("\\d*"))) {
                    String context = this.getText("0x0000000803240801.alarm.desc");
                    for (int i = 0; i < 8; ++i) {
                        context = context.replace("{" + i + "}", this.faultParams[i]);
                    }
                    displayBf.append(context);
                    for (int j = 0; j < (this.faultParams.length - 8) / 5; ++j) {
                        String judge = FaultDefineUtil.getInstance().getLocationName(this.faultParams[12 + j * 5]);
                        if (!"".equals(judge)) {
                            this.faultParams[12 + j * 5] = judge;
                        }
                        String attackDesc = this.getText("0x0000000803240801.alarm.attack.detail.desc");
                        attackDesc = attackDesc.replace("{0}", this.faultParams[8 + j * 5]);
                        attackDesc = attackDesc.replace("{1}", this.faultParams[9 + j * 5]);
                        attackDesc = attackDesc.replace("{2}", this.faultParams[10 + j * 5]);
                        attackDesc = attackDesc.replace("{3}", this.faultParams[11 + j * 5]);
                        attackDesc = attackDesc.replace("{4}", this.faultParams[12 + j * 5]);
                        displayBf.append(attackDesc);
                    }
                } else if ((this.faultParams.length - 8) % 3 == 0) {
                    String context = this.getText("0x0000000803240801.alarm.desc");
                    for (int i = 0; i < 8; ++i) {
                        context = context.replace("{" + i + "}", this.faultParams[i]);
                    }
                    displayBf.append(context);
                    for (int j = 0; j < (this.faultParams.length - 8) / 3; ++j) {
                        String attackDesc = this.getText("0x0000000803240801.alarm.attack.detail.desc");
                        attackDesc = attackDesc.replace("{0}", this.faultParams[8 + j * 3]);
                        attackDesc = attackDesc.replace("{1}", this.faultParams[9 + j * 3]);
                        attackDesc = attackDesc.replace("{2}", this.faultParams[10 + j * 3]);
                        attackDesc = attackDesc.replace("{3}", "--");
                        attackDesc = attackDesc.replace("{4}", "--");
                        displayBf.append(attackDesc);
                    }
                }
                this.setFaultDescForAbnormalAlarm(displayBf.toString());
            }
        } else if ("0x0000000803240839".equals(this.fault.getFaultDefineId()) || "0x0000000803240840".equals(this.fault.getFaultDefineId())) {
            this.intelligentDefendAlarmMessage();
        } else if ("0x0000000803240841".equals(this.fault.getFaultDefineId()) || "0x0000000803240842".equals(this.fault.getFaultDefineId())) {
            this.memoryAndLogLimitDefendAlarmMessage();
        }
    }

    private void memoryAndLogLimitDefendAlarmMessage() {
        if (null != this.fault.getFaultParam() && !"".equals(this.fault.getFaultParam())) {
            String paramTemp2 = "com.hs.atic.alart.collector.drop.log.level." + this.faultParams[2];
            this.faultParams[2] = this.getText(paramTemp2);
        }
    }

    private void intelligentDefendAlarmMessage() {
        if (null != this.fault.getFaultParam() && !"".equals(this.fault.getFaultParam())) {
            String context = this.getText(this.fault.getFaultDefineId() + ".alarm.desc");
            for (int i = 0; i < 4; ++i) {
                context = i == 0 ? context.replace("{" + i + "}", this.faultParams[3]) : (i == 2 ? context.replace("{" + i + "}", this.faultParams[0]) : (i == 3 ? context.replace("{" + i + "}", this.faultParams[2]) : context.replace("{" + i + "}", this.faultParams[i])));
            }
            String alarmAdvice = this.getText(this.fault.getFaultDefineId() + ".alarm.advice");
            alarmAdvice = alarmAdvice.replace("{0}", this.faultParams[0]);
            for (int j = 0; j < this.faultParams.length - 4; ++j) {
                if ("0x0000000803240840".equals(this.fault.getFaultDefineId())) {
                    if (j == this.faultParams.length - 5) {
                        alarmAdvice = alarmAdvice.replace("{1}", this.getZonePolicyForMissDefense(this.faultParams[4 + j]));
                        continue;
                    }
                    if ("--".equals(this.getZonePolicyForMissDefense(this.faultParams[4 + j]))) continue;
                    alarmAdvice = alarmAdvice.replace("{1}", this.getZonePolicyForMissDefense(this.faultParams[4 + j]));
                    break;
                }
                if (j == this.faultParams.length - 5) {
                    alarmAdvice = alarmAdvice.replace("{1}", this.getZonePolicyForFaultDefense(this.faultParams[4 + j]));
                    continue;
                }
                if ("--".equals(this.getZonePolicyForFaultDefense(this.faultParams[4 + j]))) continue;
                alarmAdvice = alarmAdvice.replace("{1}", this.getZonePolicyForFaultDefense(this.faultParams[4 + j]));
                break;
            }
            this.setFaultAdviceForIntelligentDefend(alarmAdvice);
            this.setFaultDescForAbnormalAlarm(context);
        }
    }

    private String getZonePolicyForMissDefense(String measure) {
        switch (measure) {
            case "synPps": {
                return "SYN";
            }
            case "ackPps": {
                return "ACK";
            }
            case "tcpIncreaseCon": {
                return this.getText("com.hs.atic.alart.intelligentDefend.tcpConnect");
            }
            case "tcpConcurCon": {
                return this.getText("com.hs.atic.alart.intelligentDefend.tcpConnect");
            }
            case "httpQps": {
                return "HTTP";
            }
            case "udpKbps": {
                return "UDP";
            }
            case "dnsRequestPps": {
                return "DNS";
            }
        }
        return "--";
    }

    private String getZonePolicyForFaultDefense(String measure) {
        switch (measure) {
            case "attackTypeSet_10": {
                return "SYN";
            }
            case "blackTypeSet_23": {
                return "SYN";
            }
            case "attackTypeSet_11": {
                return "ACK";
            }
            case "blackTypeSet_24": {
                return "ACK";
            }
            case "blackTypeSet_5": {
                return this.getText("com.hs.atic.alart.intelligentDefend.tcpConnect");
            }
            case "attackTypeSet_27": {
                return "HTTP";
            }
            case "blackTypeSet_15": {
                return "HTTP";
            }
            case "attackTypeSet_19": {
                return this.getText("com.hs.atic.alart.intelligentDefend.udpFingerprint");
            }
            case "attackTypeSet_45": {
                return this.getText("com.hs.atic.alart.intelligentDefend.dnsRequest");
            }
        }
        return "--";
    }

    private void checkSelectFaultSecurity(Long[] selectIds) {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if (isAdmin.booleanValue()) {
            return;
        }
        List queryFaultIds = (List)this.getSession().getAttribute("queryFaultIds");
        if (null == queryFaultIds || queryFaultIds.isEmpty()) {
            return;
        }
        for (int i = 0; i < selectIds.length; ++i) {
            if (queryFaultIds.contains(selectIds[i])) continue;
            this.log.info((Object)("yue quan operation,ids:" + selectIds[i]));
            throw new LegoCheckedException(630114L);
        }
    }

    public String confirmFault() {
        this.log.info((Object)"Begin FaultAction confirmFault function");
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (this.ids == null || this.ids.length == 0) {
            throw new LegoCheckedException(630114L);
        }
        this.checkSelectFaultSecurity(this.ids);
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            batchOpList.add(bo);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        try {
            BatchOperationResult result = this.faultService.confirmFault(batchOpList, currentUser.getUserName());
            this.setBatchOperationResult(result);
        }
        catch (Exception e) {
            this.log.error((Object)"faultService.clearAllFault error", (Throwable)e);
            this.responseResult("350");
            return null;
        }
        this.getOperateLog().normal("lego.lab.fault.confirmStatus", "lego.dic.module.fault");
        return null;
    }

    public String cancelConfirmFault() {
        this.log.info((Object)"Begin FaultAction cancelConfirmFault function");
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (this.ids == null || this.ids.length == 0) {
            throw new LegoCheckedException(630114L);
        }
        this.checkSelectFaultSecurity(this.ids);
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            batchOpList.add(bo);
        }
        try {
            BatchOperationResult result = this.faultService.cancelConfirmFault(batchOpList);
            this.setBatchOperationResult(result);
        }
        catch (Exception e) {
            this.log.error((Object)"faultService.clearAllFault error", (Throwable)e);
            this.responseResult("350");
            return null;
        }
        this.getOperateLog().normal("lego.lab.com.unconfirmaction", "lego.dic.module.fault");
        return null;
    }

    public String clearFault() {
        this.log.info((Object)"Begin FaultAction clearFault function");
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        if (this.ids == null || this.ids.length == 0) {
            throw new LegoCheckedException(630114L);
        }
        this.checkSelectFaultSecurity(this.ids);
        for (int i = 0; i < this.ids.length; ++i) {
            BatchOperation bo = new BatchOperation();
            bo.setTargetId(this.ids[i].longValue());
            batchOpList.add(bo);
        }
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        BatchOperationResult result = this.faultService.clearFault(batchOpList, currentUser.getUserName());
        this.setBatchOperationResult(result);
        this.getOperateLog().normal("lego.lab.fault.clearStatus", "lego.dic.module.fault");
        return null;
    }

    public String exportCurtFault() {
        Boolean current = true;
        this.exportFault(current);
        return null;
    }

    public String exportHisFault() {
        Boolean current = false;
        this.exportFault(current);
        return null;
    }

    private void exportFault(Boolean current) {
        this.currentFault = current;
        this.log.info((Object)"Begin FaultAction exportFault function");
        if (this.ids == null || this.ids.length == 0) {
            throw new LegoCheckedException(630114L);
        }
        this.checkSelectFaultSecurity(this.ids);
        FileUtil fileUtil = ExportUtil.getInstance().export(this, this.getSession(), this.getResponse(), this.faultService.listFault(this.ids, null, null), this.currentFault);
        if (this.currentFault.booleanValue()) {
            this.getOperateLog().normal("lego.lab.fault.exportCurrent", "lego.dic.module.fault", "lego.lab.fault.alarm", true, "lego.lab.fault.alarm.export", null);
        } else {
            this.getOperateLog().normal("lego.lab.fault.exportPast", "lego.dic.module.fault", "lego.lab.fault.alarm", true, "lego.lab.fault.alarm.export", null);
        }
        if (null != fileUtil) {
            String displayNameTemp = fileUtil.getDownFileName();
            this.responseResult(displayNameTemp);
        }
    }

    public void downloadCurtExport() {
        this.downloadExport();
    }

    public void downloadHisExport() {
        this.downloadExport();
    }

    private void downloadExport() {
        FileUtil fileUtil = FileFactory.getFileUtil("excel");
        String displayNameTemp = this.getDisplayName();
        String downloadPath = this.getSession().getServletContext().getRealPath("") + File.separator + "export";
        if (null != fileUtil) {
            String downloadFileName = downloadPath + File.separator + displayNameTemp + "." + fileUtil.getStrExtend();
            fileUtil.setDownFileName(displayNameTemp);
            fileUtil.setWriteFileName(downloadFileName);
            fileUtil.downloadFile(this.getResponse());
        }
    }

    public boolean checkFileName(int a) {
        String fileName = this.getDisplayName();
        if (fileName.length() > 64) {
            return false;
        }
        return a == 0 ? fileName.matches("^CurrentAlarms_[0-9]+$") : fileName.matches("^HistoryAlarms_[0-9]+$");
    }

    public boolean validateIds() {
        if (null == this.ids || this.ids.length == 0) {
            return false;
        }
        if (this.ids.length > 100) {
            return false;
        }
        Long[] longArray = this.ids;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long s = longArray[i];
            if (s >= 0L) continue;
            return false;
        }
        FaultQueryCondition queryCond = new FaultQueryCondition();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        queryCond.setUserID(currentUser.getUserID());
        return this.faultService.listAllFault(queryCond).size() >= this.ids.length;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long[] getIds() {
        return (Long[])ArrayDeepClone.deepClone(this.ids);
    }

    public void setIds(Long[] ids) {
        this.ids = (Long[])ArrayDeepClone.deepClone(ids);
    }

    public Fault getFault() {
        return this.fault;
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFaultAdviceForIntelligentDefend() {
        return this.faultAdviceForIntelligentDefend;
    }

    public void setFaultAdviceForIntelligentDefend(String faultAdviceForIntelligentDefend) {
        this.faultAdviceForIntelligentDefend = faultAdviceForIntelligentDefend;
    }
}

