/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultDetail;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.util.List;

public class FaultDetailAction
extends BaseAction {
    private static final long serialVersionUID = -7625375826004602745L;
    private Long faultId;
    private String faultDefineId;
    private List<FaultDetail> faultDetailList;
    private String sortField = null;
    private String sortType = null;
    private String hideIndex = null;

    public String getFaultDefineId() {
        return this.faultDefineId;
    }

    public void setFaultDefineId(String faultDefineId) {
        this.faultDefineId = faultDefineId;
    }

    public String listCurtFaultDetail() {
        Byte clearStatus = 0;
        this.listFaultDetail(clearStatus);
        return "success";
    }

    public String listHisFaultDetail() {
        Byte clearStatus = 1;
        this.listFaultDetail(clearStatus);
        return "success";
    }

    private void checkSelectFaultSecurity() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if (isAdmin.booleanValue()) {
            return;
        }
        List queryFaultIds = (List)this.getSession().getAttribute("queryFaultIds");
        if (null == queryFaultIds || queryFaultIds.isEmpty()) {
            return;
        }
        if (!queryFaultIds.contains(this.faultId)) {
            this.log.info((Object)("yue quan operation:faultId" + this.faultId));
            throw new LegoCheckedException(630114L);
        }
    }

    private void listFaultDetail(Byte clearStatus) {
        if (null == this.faultId) {
            throw new LegoCheckedException(630114L);
        }
        this.checkSelectFaultSecurity();
        FaultService faultService = (FaultService)ServiceContext.getInstance().getService("faultService", FaultService.class);
        Paging page = faultService.listFaultDetail(this.faultId, this.start, this.pageSize);
        Fault fault = faultService.getFault(this.faultId);
        this.faultDefineId = fault.getFaultDefineId();
        this.total = page.getCount();
        this.faultDetailList = page.getData();
        for (FaultDetail faultDetail : this.faultDetailList) {
            String[] briefParams = faultDetail.getBriefParams(this.faultDefineId);
            for (int i = 0; i < briefParams.length; ++i) {
                try {
                    if (briefParams[i].contains(".")) {
                        if (briefParams[i].contains(",")) {
                            String[] attacktypes = briefParams[i].split(",");
                            for (int j = 0; j < attacktypes.length; ++j) {
                                briefParams[i] = 0 == j ? this.getText(attacktypes[j]) : briefParams[i] + "," + this.getText(attacktypes[j]);
                            }
                        } else {
                            briefParams[i] = this.getText(briefParams[i]);
                        }
                    }
                    briefParams[i] = this.htmlEncode(briefParams[i]);
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)e.toString().replace("\r", "").replace("\n", ""), (Throwable)e);
                }
            }
            faultDetail.setBriefParams(briefParams);
            faultDetail.setFaultDefineId(this.faultDefineId);
        }
    }

    public String htmlEncode(String text) {
        if (!text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&#39;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }

    public Long getFaultId() {
        return this.faultId;
    }

    public void setFaultId(Long faultId) {
        this.faultId = faultId;
    }

    public List<FaultDetail> getFaultDetailList() {
        return this.faultDetailList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getHideIndex() {
        return this.hideIndex;
    }

    public void setHideIndex(String hideIndex) {
        this.hideIndex = hideIndex;
    }
}

