/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.NotifyRule;
import com.hs.lego.cbb.fault.sdk.service.NotifyService;
import com.hs.lego.cbb.fault.util.ArrayDeepClone;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyRuleService;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NotifyAction
extends BaseAction {
    private static final long serialVersionUID = -2693243918316858915L;
    private NotifyRule rule;
    private String startTime;
    private String endTime;
    private RemoteNotifyRule remoteNotifyRulePO = new RemoteNotifyRule();
    private String[] phoneList = null;
    private String[] emailList = null;
    private String[] selectiveField = null;
    private String[] deviceList = null;
    private String[] alarmTypeList = null;
    private NotifyService notifyService;
    private IRemoteNotifyRuleService remoteNotifyRuleService;
    private IDataExplore dataExplore;

    public boolean validateEmail() {
        if (this.emailList != null) {
            for (String field : this.emailList) {
                if (null == field || field.matches("^[\\w.-]+@[\\w.-]+###$") && field.length() <= 64) continue;
                return false;
            }
        }
        if (this.phoneList != null) {
            for (String field : this.phoneList) {
                if (null == field || field.matches("^[\\+]?[\\d]+###$") && field.length() <= 32) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateAlarm() {
        if (this.deviceList != null) {
            for (String field : this.deviceList) {
                if (field.matches("^[\\w#.\\s]+$") && field.length() <= 100) continue;
                return false;
            }
        }
        if (this.alarmTypeList != null) {
            for (String field : this.alarmTypeList) {
                if (field.matches("^[\\w#]+$") && field.length() <= 32) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateNotifyTime() {
        if (null != this.remoteNotifyRulePO) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            df.setLenient(false);
            try {
                Date dF = null;
                Date dT = null;
                if (null != this.remoteNotifyRulePO.getStartTimeStr() && !"".equals(this.remoteNotifyRulePO.getStartTimeStr())) {
                    dF = df.parse(this.remoteNotifyRulePO.getStartTimeStr());
                }
                if (null != this.remoteNotifyRulePO.getEndTimeStr() && !"".equals(this.remoteNotifyRulePO.getEndTimeStr())) {
                    dT = df.parse(this.remoteNotifyRulePO.getEndTimeStr());
                }
                if (null != dF && null != dT && dF.after(dT)) {
                    return false;
                }
                if (null != dT && dT.getTime() < System.currentTimeMillis()) {
                    return false;
                }
            }
            catch (ParseException e) {
                return false;
            }
        }
        return this.validateNotifyDescript();
    }

    public boolean validateNotifyDescript() {
        String description;
        return null == this.remoteNotifyRulePO || null == this.remoteNotifyRulePO.getDescription() || (description = this.remoteNotifyRulePO.getDescription()).matches("^[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\r|\\n|\\w|=|\\-|_|!|@|#|$|%|\\*|\\(|\\^|\\)|\\||:|;|\\,|\\.|\"|\\'|\\+|\\}|\\{|[|]|?|&]*$") && description.length() <= 128;
    }

    public String addNotifyRule() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.startTime != null) {
            try {
                this.rule.setStartTime(dateFormat.parse(this.startTime));
            }
            catch (ParseException e) {
                this.log.error((Object)"ParseException", (Throwable)e);
            }
        }
        if (this.endTime != null) {
            try {
                this.rule.setEndTime(dateFormat.parse(this.endTime));
            }
            catch (ParseException e) {
                this.log.error((Object)"ParseException", (Throwable)e);
            }
        }
        StringBuffer sendField = new StringBuffer();
        for (String f : this.rule.getField()) {
            sendField.append(f).append(',');
        }
        this.rule.setSendField(sendField.toString());
        ArrayList<String> faultIds = new ArrayList<String>(this.rule.getFaultIds().size());
        faultIds.addAll(this.rule.getFaultIds());
        this.rule.setFaultIds(faultIds);
        this.notifyService.addNotifyRule(this.rule);
        this.getOperateLog().normal("lego.lab.fault.notify.add", "lego.dic.module.fault", this.rule.getRuleName(), false, "lego.lab.fault.notify.add", null);
        return null;
    }

    public void addNotifyRuleBase() {
        String remark;
        int index;
        int i;
        this.checkSourceSecurity();
        RemoteNotifyRule remoteNotifyRule = new RemoteNotifyRule();
        remoteNotifyRule.setLanguage(this.remoteNotifyRulePO.getLanguage());
        remoteNotifyRule.setRuleName(this.remoteNotifyRulePO.getRuleName());
        remoteNotifyRule.setIsClearEnable(true);
        remoteNotifyRule.setIsUseEnable(this.remoteNotifyRulePO.isIsUseEnable());
        remoteNotifyRule.setStartTimeStr(this.remoteNotifyRulePO.getStartTimeStr());
        remoteNotifyRule.setEndTimeStr(this.remoteNotifyRulePO.getEndTimeStr());
        remoteNotifyRule.setSmsMode(this.remoteNotifyRulePO.getSmsMode());
        remoteNotifyRule.setDescription(this.remoteNotifyRulePO.getDescription());
        if (null != this.phoneList && this.phoneList.length > 0) {
            for (i = 0; i < this.phoneList.length; ++i) {
                String phone = this.phoneList[i];
                if ("".endsWith(phone)) continue;
                index = phone.indexOf("###");
                String tel = phone.substring(0, index);
                remark = phone.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.phoneList[i] = tel + "###" + remark;
            }
        }
        if (null != this.emailList && this.emailList.length > 0) {
            for (i = 0; i < this.emailList.length; ++i) {
                String email = this.emailList[i];
                if ("".endsWith(email)) continue;
                index = email.indexOf("###");
                String ml = email.substring(0, index);
                remark = email.substring(index + 3);
                remark = remark.replaceAll("=", "=k");
                remark = remark.replaceAll("#", "#k");
                this.emailList[i] = ml + "###" + remark;
            }
        }
        for (i = 0; i < this.alarmTypeList.length; ++i) {
            String[] alarmInfo = this.alarmTypeList[i].split("###");
            this.alarmTypeList[i] = this.alarmTypeList[i] + "###" + this.getText(alarmInfo[1] + ".alarm.name");
        }
        try {
            this.remoteNotifyRuleService.addRule(remoteNotifyRule, this.emailList, this.phoneList, this.convertFromSegment(this.selectiveField), this.deviceList, this.alarmTypeList);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1556L) {
                super.responseResult("exist");
            } else if (e.getErrorCode() == 1538L) {
                super.responseResult("format");
            } else if (e.getErrorCode() == 1565L) {
                super.responseResult("time");
            } else if (e.getErrorCode() == 101L) {
                super.responseResult("database");
            }
            throw e;
        }
        catch (Exception e) {
            super.responseResult("error");
        }
        this.getOperateLog().normal("lego.lab.fault.log.notify.addrule", "lego.dic.module.fault", this.remoteNotifyRulePO.getRuleName());
    }

    private void checkSourceSecurity() {
        if (null != this.deviceList && this.deviceList.length > 0) {
            long userId = -1L;
            User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            if (!"true".equalsIgnoreCase(user.getIsAdmin())) {
                userId = user.getUserID();
            }
            TopoObjectQueryCondition condtion = new TopoObjectQueryCondition();
            if (userId > -1L) {
                condtion.setUserId(String.valueOf(userId));
            }
            ArrayList<String> moIdList = new ArrayList<String>();
            List topoObjectList = this.dataExplore.getDataList(this.start, Integer.MAX_VALUE, condtion);
            for (TopoObject item : topoObjectList) {
                moIdList.add(String.valueOf(item.getMoId()));
            }
            for (int i = 0; i < this.deviceList.length; ++i) {
                String[] source = this.deviceList[i].split("###");
                String sourceId = source[0];
                if (moIdList.contains(sourceId)) continue;
                this.log.info((Object)"yue quan operation");
                throw new LegoCheckedException(630114L);
            }
        }
    }

    public String[] convertFromSegment(String[] names) {
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.alarmLevel"))) {
                fields.add("severity:" + this.getText("lego.lab.fault.alarmLevel"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.saveAlarm.name"))) {
                fields.add("alarmName:" + this.getText("lego.lab.fault.saveAlarm.name"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.dic.warningtype"))) {
                fields.add("alarmType:" + this.getText("lego.dic.warningtype"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.saveAlarm.alarmSource"))) {
                fields.add("source:" + this.getText("lego.lab.fault.saveAlarm.alarmSource"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.fault.createTime"))) {
                fields.add("createTime:" + this.getText("lego.lab.fault.createTime"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.dic.clearstatus"))) {
                fields.add("clearStatus:" + this.getText("lego.dic.clearstatus"));
                continue;
            }
            if (name.equalsIgnoreCase(this.getText("lego.lab.com.description"))) {
                fields.add("alarmDesc:" + this.getText("lego.lab.com.description"));
                continue;
            }
            if (!name.equalsIgnoreCase(this.getText("lego.lab.fault.location"))) continue;
            fields.add("location:" + this.getText("lego.lab.fault.location"));
        }
        String[] temp = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            temp[i] = (String)fields.get(i);
        }
        return temp;
    }

    public boolean validateSendSms() {
        return !(this.rule.getSendSms() == null || this.rule.getSendSms().equals("") ? this.rule.getSendEmail() == null || this.rule.getSendEmail().equals("") : !this.rule.getSendSms().matches("[+]?[0-9]+"));
    }

    public boolean validateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        try {
            Date startDate = dateFormat.parse(this.startTime);
            Date endDate = dateFormat.parse(this.endTime);
            if (startDate.getTime() > endDate.getTime()) {
                return false;
            }
            if (endDate.getTime() < System.currentTimeMillis()) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public boolean validateSendEmail() {
        if (this.rule.getSendEmail() == null || this.rule.getSendEmail().equals("") ? this.rule.getSendSms() == null || this.rule.getSendSms().equals("") : !this.rule.getSendEmail().matches("[a-zA-Z0-9.-_]+@[a-zA-Z0-9-_.]+(\\.[a-zA-Z]+|\\.[a-zA-Z]+\\.[a-zA-Z]+)")) {
            return false;
        }
        return this.rule.getSendLang() != null && this.rule.getSendLang().intValue() <= 2 && this.rule.getSendLang().intValue() >= 1;
    }

    public boolean validateField() {
        if (this.rule.getField() == null) {
            return false;
        }
        for (String string : this.rule.getField()) {
            if (null != string && !"".equals(string) && Long.parseLong(string) <= 7L && Long.parseLong(string) >= 1L) continue;
            return false;
        }
        return true;
    }

    public boolean validateFaultIds() {
        if (this.rule.getFaultIds() == null || this.rule.getFaultIds().size() <= 0) {
            return false;
        }
        for (String string : this.rule.getFaultIds()) {
            if (null != string && !"".equals(string) && string.matches("[0-9a-zA-Z ]+")) continue;
            return false;
        }
        return true;
    }

    public boolean validateRuleName() {
        return this.rule.getRuleName() != null && !this.rule.getRuleName().trim().isEmpty() && this.rule.getRuleName().length() <= 32 && this.rule.getRuleName().matches("[a-zA-Z_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*");
    }

    public NotifyRule getRule() {
        return this.rule;
    }

    public void setRule(NotifyRule rule) {
        this.rule = rule;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public RemoteNotifyRule getRemoteNotifyRulePO() {
        return this.remoteNotifyRulePO;
    }

    public void setRemoteNotifyRulePO(RemoteNotifyRule remoteNotifyRulePO) {
        this.remoteNotifyRulePO = remoteNotifyRulePO;
    }

    public String[] getPhoneList() {
        return (String[])ArrayDeepClone.deepClone(this.phoneList);
    }

    public void setPhoneList(String[] phoneList) {
        this.phoneList = (String[])ArrayDeepClone.deepClone(phoneList);
    }

    public String[] getEmailList() {
        return (String[])ArrayDeepClone.deepClone(this.emailList);
    }

    public void setEmailList(String[] emailList) {
        this.emailList = (String[])ArrayDeepClone.deepClone(emailList);
    }

    public String[] getSelectiveField() {
        return (String[])ArrayDeepClone.deepClone(this.selectiveField);
    }

    public void setSelectiveField(String[] selectiveField) {
        this.selectiveField = (String[])ArrayDeepClone.deepClone(selectiveField);
    }

    public String[] getDeviceList() {
        return (String[])ArrayDeepClone.deepClone(this.deviceList);
    }

    public void setDeviceList(String[] deviceList) {
        this.deviceList = (String[])ArrayDeepClone.deepClone(deviceList);
    }

    public String[] getAlarmTypeList() {
        return (String[])ArrayDeepClone.deepClone(this.alarmTypeList);
    }

    public void setAlarmTypeList(String[] alarmTypeList) {
        this.alarmTypeList = (String[])ArrayDeepClone.deepClone(alarmTypeList);
    }

    public NotifyService getNotifyService() {
        return this.notifyService;
    }

    public void setNotifyService(NotifyService notifyService) {
        this.notifyService = notifyService;
    }

    public IRemoteNotifyRuleService getRemoteNotifyRuleService() {
        return this.remoteNotifyRuleService;
    }

    public void setRemoteNotifyRuleService(IRemoteNotifyRuleService remoteNotifyRuleService) {
        this.remoteNotifyRuleService = remoteNotifyRuleService;
    }

    public IDataExplore getDataExplore() {
        return this.dataExplore;
    }

    public void setDataExplore(IDataExplore dataExplore) {
        this.dataExplore = dataExplore;
    }
}

