/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.Fault;
import com.hs.lego.cbb.fault.sdk.model.FaultDefine;
import com.hs.lego.cbb.fault.sdk.model.FaultQueryCondition;
import com.hs.lego.cbb.fault.sdk.model.FaultVO;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.cbb.fault.util.FaultDefineUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.util.ExportUtil;
import com.hs.lego.ui.plat.monitor.util.FileUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class QueryFaultAction
extends BaseAction {
    private static final long serialVersionUID = 2298657590827706117L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private static final int EXPORT_MAX = 65534;
    private static final Object LOCK = new Object();
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<Fault> faultList;
    private String sortField;
    private String sortType;
    private FaultQueryCondition fault;
    private Byte severity;
    private List<LangPair> severityCheckboxList;
    private List<LangPair> severityList;
    private List<LangPair> sourceTypeList;
    private List<LangPair> confirmStatusList;
    private String severityLabel;
    private String sourceTypeLabel;
    private String confirmStatusLabel;
    private String severityChecked;
    private Boolean currentFault = false;
    private String beginTime;
    private String endTime;
    private String faultName;
    private String refreshtime = null;
    private FaultService faultService;
    private List<Fault> listAlarmNames;
    private String selAlarmNameNum;
    private String selFaultDefineId;
    private String selAlarmName;

    public String listFault() {
        this.currentFault = Boolean.TRUE;
        this.execQuery();
        return "success";
    }

    public String selectAlarmName() {
        this.listAlarmNames = new ArrayList<Fault>();
        List<FaultDefine> faultDefines = FaultDefineUtil.getInstance().getFaultDefine();
        ArrayList<String> faultStr = new ArrayList<String>();
        for (FaultDefine faultDefine : faultDefines) {
            if (null == faultDefine.getFaultDefineId() || faultStr.contains(faultDefine.getFaultDefineId())) continue;
            Fault fau = new Fault();
            fau.setFaultDefineId(faultDefine.getFaultDefineId());
            this.listAlarmNames.add(fau);
            faultStr.add(faultDefine.getFaultDefineId());
        }
        this.selAlarmNameNum = ",";
        if (null != this.selFaultDefineId && !this.selFaultDefineId.isEmpty()) {
            int gridIndex = 0;
            for (Fault fau : this.listAlarmNames) {
                if (fau.getFaultDefineId().equals(this.selFaultDefineId)) {
                    this.selAlarmNameNum = this.selAlarmNameNum + gridIndex + ",";
                    break;
                }
                ++gridIndex;
            }
        }
        return "success";
    }

    public String searchListHistoryFault() {
        this.currentFault = Boolean.FALSE;
        this.execQuery();
        return "success";
    }

    public String listHistoryFault() {
        this.currentFault = Boolean.FALSE;
        this.execQuery();
        return "success";
    }

    public void clearAllFault() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        try {
            this.faultService.clearAllFault(currentUser.getUserName());
        }
        catch (Exception e) {
            LOGGER.error((Object)"faultService.clearAllFault error", (Throwable)e);
            this.responseResult("350");
            return;
        }
        this.getOperateLog().normal("lego.lab.com.clear.all", "lego.dic.module.fault", "system");
    }

    public String exportCurtAllFault() {
        Boolean current = true;
        this.exportAllFault(current);
        return null;
    }

    public String exportHisAllFault() {
        Boolean current = false;
        this.exportAllFault(current);
        return null;
    }

    private void exportAllFault(Boolean current) {
        this.currentFault = current;
        if (null != this.fault) {
            FaultQueryCondition newFault = new FaultQueryCondition();
            if (null != this.fault.getSource()) {
                newFault.setSource(this.fault.getSource());
            }
            if (null != this.fault.getSeverity()) {
                newFault.setSeverity(this.fault.getSeverity());
            }
            if (null != this.fault.getSourceType()) {
                newFault.setSourceType(this.fault.getSourceType());
            }
            if (null != this.fault.getConfirmStatus()) {
                newFault.setConfirmStatus(this.fault.getConfirmStatus());
            }
            this.fault = newFault;
        }
        LOGGER.info((Object)"Begin FaultAction exportAllFault function");
        List<Fault> faults = this.faultService.queryFault(this.createCondition(), 0, 65534);
        FileUtil fileUtil = ExportUtil.getInstance().export(this, this.getSession(), this.getResponse(), faults, this.currentFault);
        if (this.currentFault.booleanValue()) {
            this.getOperateLog().normal("lego.lab.com.exportallcurrentalarm", "lego.dic.module.fault", "lego.lab.fault.alarm", true, "lego.dic.resulttype.all", null);
        } else {
            this.getOperateLog().normal("lego.lab.com.exportallhistoryalarm", "lego.dic.module.fault", "lego.lab.fault.alarm", true, "lego.dic.resulttype.all", null);
        }
        if (null != fileUtil) {
            String displayName = fileUtil.getDownFileName();
            this.responseResult(displayName);
        }
    }

    public String exportCurtTooMuch() {
        Boolean current = true;
        this.exportTooMuch(current);
        return null;
    }

    public String exportHisTooMuch() {
        Boolean current = false;
        this.exportTooMuch(current);
        return null;
    }

    private void exportTooMuch(Boolean current) {
        long count;
        this.currentFault = current;
        if (null != this.fault) {
            FaultQueryCondition newFault = new FaultQueryCondition();
            if (null != this.fault.getSource()) {
                newFault.setSource(this.fault.getSource());
            }
            if (null != this.fault.getSeverity()) {
                newFault.setSeverity(this.fault.getSeverity());
            }
            if (null != this.fault.getSourceType()) {
                newFault.setSourceType(this.fault.getSourceType());
            }
            if (null != this.fault.getConfirmStatus()) {
                newFault.setConfirmStatus(this.fault.getConfirmStatus());
            }
            this.fault = newFault;
        }
        if ((count = this.faultService.getAllFaultCount(this.createCondition())) > 65534L) {
            this.responseResult("TOO MUCH");
        } else {
            this.responseResult("SUCCESS");
        }
    }

    public String htmlEncode(String text) {
        if (!text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&#39;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }

    private void execQuery() {
        Paging page = this.faultService.listFault(this.createCondition());
        this.total = page.getCount();
        this.faultList = page.getData();
        ArrayList<Long> queryFaultIds = new ArrayList<Long>();
        for (Fault fau : this.faultList) {
            try {
                this.processBriefParams(fau);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.toString().replace("\r", "").replace("\n", ""), (Throwable)e);
            }
            queryFaultIds.add(fau.getId());
            this.getSession().setAttribute("queryFaultIds", queryFaultIds);
        }
        this.initListData();
    }

    private void processBriefParams(Fault fau) {
        String[] briefParams = fau.getBriefParams();
        if (null == briefParams || briefParams.length == 0) {
            return;
        }
        for (int i = 0; i < briefParams.length; ++i) {
            if (briefParams[i].contains(".")) {
                if (briefParams[i].contains(",")) {
                    String[] attacktypes = briefParams[i].split(",");
                    for (int j = 0; j < attacktypes.length; ++j) {
                        briefParams[i] = 0 == j ? this.getText(attacktypes[j]) : briefParams[i] + "," + this.getText(attacktypes[j]);
                    }
                } else {
                    briefParams[i] = this.getText(briefParams[i]);
                }
            }
            briefParams[i] = this.htmlEncode(briefParams[i]);
        }
        fau.setBriefParams(briefParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FaultQueryCondition createCondition() {
        FaultQueryCondition queryCond = null;
        if (this.fault == null) {
            queryCond = new FaultQueryCondition();
            if (this.severity != null) {
                queryCond.setSeverity(new Byte[]{this.severity});
            }
        } else {
            if (null != this.selFaultDefineId && !this.selFaultDefineId.isEmpty()) {
                this.fault.setFaultDefineId(this.selFaultDefineId);
            }
            queryCond = this.fault;
        }
        if (this.beginTime != null && !this.beginTime.equals("")) {
            try {
                Object object = LOCK;
                synchronized (object) {
                    queryCond.setBeginTime(dateFormat.parse(this.beginTime));
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)"ParseException", (Throwable)e);
            }
        }
        if (this.endTime != null && !this.endTime.equals("")) {
            try {
                Object e = LOCK;
                synchronized (e) {
                    queryCond.setEndTime(dateFormat.parse(this.endTime));
                }
            }
            catch (ParseException e) {
                LOGGER.error((Object)"ParseException", (Throwable)e);
            }
        }
        queryCond.setStart(this.start);
        queryCond.setPageSize(this.pageSize);
        queryCond.setSortField(this.sortField);
        queryCond.setSortType(this.sortType);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        queryCond.setUserID(currentUser.getUserID());
        if (this.currentFault.booleanValue()) {
            queryCond.setClearStatus(Fault.FaultClearStatus.UNCLEARED.getValue());
        } else {
            queryCond.setClearStatus(Fault.FaultClearStatus.CLEARED.getValue());
        }
        return queryCond;
    }

    /*
     * WARNING - void declaration
     */
    private void initListData() {
        void var6_14;
        String localeAll = this.getText("lego.dic.confirmstatus.all");
        if (this.severityLabel == null) {
            this.severityLabel = localeAll;
        }
        if (this.sourceTypeLabel == null) {
            this.sourceTypeLabel = localeAll;
        }
        if (this.confirmStatusLabel == null) {
            this.confirmStatusLabel = localeAll;
        }
        if (this.severity != null) {
            this.severityLabel = this.getText("lego.lab.fault.severity." + this.severity);
        }
        if (this.fault != null && this.fault.getSeverity() != null) {
            StringBuilder sb = new StringBuilder();
            for (Byte by : this.fault.getSeverity()) {
                sb.append(by).append(',');
            }
            this.severityChecked = sb.toString();
        }
        FaultVO.FaultSeverity[] severitys = FaultVO.FaultSeverity.values();
        this.severityCheckboxList = new ArrayList<LangPair>(severitys.length);
        this.severityList = new ArrayList<LangPair>(severitys.length + 1);
        this.severityList.add(new LangPair(this.getText("lego.dic.confirmstatus.all"), ""));
        for (FaultVO.FaultSeverity faultSeverity : severitys) {
            LangPair tmp = new LangPair(this.getText("lego.lab.fault.severity." + faultSeverity.getValue()), faultSeverity.getValue().toString());
            this.severityCheckboxList.add(tmp);
            this.severityList.add(tmp);
        }
        FaultVO.FaultSourceType[] faultSourceTypeArray = FaultVO.FaultSourceType.values();
        this.sourceTypeList = new ArrayList<LangPair>(faultSourceTypeArray.length + 1);
        this.sourceTypeList.add(new LangPair(this.getText("lego.dic.confirmstatus.all"), ""));
        FaultVO.FaultSourceType[] faultSourceTypeArray2 = faultSourceTypeArray;
        int n = faultSourceTypeArray2.length;
        boolean bl = false;
        while (var6_14 < n) {
            FaultVO.FaultSourceType s = faultSourceTypeArray2[var6_14];
            this.sourceTypeList.add(new LangPair(this.getText("lego.lab.fault.sourceType." + s.getValue()), s.getValue().toString()));
            ++var6_14;
        }
        Fault.FaultConfirmStatus[] confirmStatus = Fault.FaultConfirmStatus.values();
        this.confirmStatusList = new ArrayList<LangPair>(confirmStatus.length + 1);
        this.confirmStatusList.add(new LangPair(this.getText("lego.dic.confirmstatus.all"), ""));
        for (Fault.FaultConfirmStatus s : confirmStatus) {
            this.confirmStatusList.add(new LangPair(this.getText("lego.lab.fault.confirmStatus." + s.getValue()), s.getValue().toString()));
        }
    }

    public boolean validateBeginAndEndTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setLenient(false);
        try {
            Date dF = null;
            Date dT = null;
            if (null != this.beginTime && !"".equals(this.beginTime)) {
                dF = df.parse(this.beginTime);
            }
            if (null != this.endTime && !"".equals(this.endTime)) {
                dT = df.parse(this.endTime);
            }
            if (null != dF && null != dT && dF.after(dT)) {
                return false;
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public boolean validateFaultSource() {
        if (this.fault != null && this.fault.getSeverity() != null) {
            if (this.fault.getSeverity().length > 6) {
                return false;
            }
            for (Byte byte1 : this.fault.getSeverity()) {
                if (byte1.intValue() <= 4 && byte1.intValue() > 0) continue;
                return false;
            }
        }
        if (this.fault != null && this.fault.getSourceType() != null && (this.fault.getSourceType().intValue() > 8 || this.fault.getSourceType().intValue() <= 0)) {
            return false;
        }
        return this.fault == null || this.fault.getConfirmStatus() == null || this.fault.getConfirmStatus().intValue() <= 2 && this.fault.getConfirmStatus().intValue() >= 0;
    }

    public boolean validateSeverity() {
        return null == this.severity || this.severity <= 4 && this.severity >= 1;
    }

    public List<Fault> getFaultList() {
        return this.faultList;
    }

    public void setFaultList(List<Fault> faultList) {
        this.faultList = faultList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public FaultQueryCondition getFault() {
        return this.fault;
    }

    public void setFault(FaultQueryCondition fault) {
        this.fault = fault;
    }

    public Byte getSeverity() {
        return this.severity;
    }

    public void setSeverity(Byte severity) {
        this.severity = severity;
    }

    public List<LangPair> getSeverityCheckboxList() {
        return this.severityCheckboxList;
    }

    public List<LangPair> getSeverityList() {
        return this.severityList;
    }

    public List<LangPair> getSourceTypeList() {
        return this.sourceTypeList;
    }

    public List<LangPair> getConfirmStatusList() {
        return this.confirmStatusList;
    }

    public String getSeverityLabel() {
        return this.severityLabel;
    }

    public void setSeverityLabel(String severityLabel) {
        this.severityLabel = severityLabel;
    }

    public String getSourceTypeLabel() {
        return this.sourceTypeLabel;
    }

    public void setSourceTypeLabel(String sourceTypeLabel) {
        this.sourceTypeLabel = sourceTypeLabel;
    }

    public String getConfirmStatusLabel() {
        return this.confirmStatusLabel;
    }

    public void setConfirmStatusLabel(String confirmStatusLabel) {
        this.confirmStatusLabel = confirmStatusLabel;
    }

    public String getSeverityChecked() {
        return this.severityChecked;
    }

    public Boolean getCurrentFault() {
        return this.currentFault;
    }

    public void setCurrentFault(Boolean currentFault) {
        if (null != currentFault && !currentFault.booleanValue()) {
            return;
        }
        this.currentFault = currentFault;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getFaultName() {
        return this.faultName;
    }

    public void setFaultName(String faultName) {
        this.faultName = faultName;
    }

    public String getRefreshtime() {
        return this.refreshtime;
    }

    public void setRefreshtime(String refreshtime) {
        this.refreshtime = refreshtime;
    }

    public FaultService getFaultService() {
        return this.faultService;
    }

    public void setFaultService(FaultService faultService) {
        this.faultService = faultService;
    }

    public List<Fault> getListAlarmNames() {
        return this.listAlarmNames;
    }

    public void setListAlarmNames(List<Fault> listAlarmNames) {
        this.listAlarmNames = listAlarmNames;
    }

    public String getSelAlarmNameNum() {
        return this.selAlarmNameNum;
    }

    public void setSelAlarmNameNum(String selAlarmNameNum) {
        this.selAlarmNameNum = selAlarmNameNum;
    }

    public String getSelAlarmName() {
        return this.selAlarmName;
    }

    public void setSelAlarmName(String selAlarmName) {
        this.selAlarmName = selAlarmName;
    }

    public String getSelFaultDefineId() {
        return this.selFaultDefineId;
    }

    public void setSelFaultDefineId(String selFaultDefineId) {
        this.selFaultDefineId = selFaultDefineId;
    }
}

