/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.FaultDefine;
import com.hs.lego.cbb.fault.sdk.service.NotifyService;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.webapp.action.TemplatePair;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class RefreshCorrespondListAction
extends BaseAction {
    private static final long serialVersionUID = -2563373193416974770L;
    private List<TemplatePair> checkboxList = new ArrayList<TemplatePair>();
    private List<TopoObject> topoObjectList = new ArrayList<TopoObject>();
    private List<FaultDefine> alarmTypeList = new ArrayList<FaultDefine>();
    private String customedLevel = "";
    private String moMainType = null;
    private String moSubType = null;
    private String editType = null;
    private String addFlag = null;
    private String alarmTypes = null;
    private String conditionType = null;
    private String conditionValue = null;
    private String id = null;

    public boolean validateAlarmType() {
        if (null != this.alarmTypeList && this.alarmTypeList.size() != 0) {
            if (this.alarmTypeList.size() > 100) {
                return false;
            }
            for (FaultDefine field : this.alarmTypeList) {
                if (null == field) continue;
                if (!(null == field.getFaultDefineId() || field.getFaultDefineId().matches("^[\\d]*$") && field.getFaultDefineId().length() <= 32)) {
                    return false;
                }
                if (field.getSeverity() <= 0) {
                    return false;
                }
                if (field.getSourceType() <= 0) {
                    return false;
                }
                if (null == field.getKeyIndex() || field.getKeyIndex().length <= 0) continue;
                for (int i : field.getKeyIndex()) {
                    if (i > 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateTopoObj() {
        if (null != this.topoObjectList && this.topoObjectList.size() > 0) {
            for (TopoObject obj : this.topoObjectList) {
                if (null == obj) continue;
                if (null != obj.getIpAddress() && !IPUtil.isIpv4((String)obj.getIpAddress()) && !IPUtil.isIpv6((String)obj.getIpAddress())) {
                    return false;
                }
                if (null != obj.getNetMask() && !IPUtil.isIpv4((String)obj.getNetMask()) && !IPUtil.isIpv6((String)obj.getNetMask())) {
                    return false;
                }
                return this.validateTopo(obj);
            }
        }
        return true;
    }

    public boolean validateTopo(TopoObject obj) {
        if (!(null == obj.getMainType() || obj.getMainType().matches("^[\\u4e00-\\u9fa5|\\w|=|\\-|_|!|@|$|%|\\*|\\^|\\||:|;|\\,|\\.|\\+|\\}|\\{ ]*$") && obj.getMainType().length() <= 32)) {
            return false;
        }
        if (!(null == obj.getSubType() || obj.getSubType().matches("^[\\u4e00-\\u9fa5|\\w|=|\\-|_|!|@|$|%|\\*|\\^|\\||:|;|\\,|\\.|\\+|\\}|\\{ ]*$") && obj.getSubType().length() <= 32)) {
            return false;
        }
        return null == obj.getLocation() || obj.getLocation().matches("^[\\u4e00-\\u9fa5|\\w|=|\\-|_|!|@|$|%|\\*|\\^|\\||:|;|\\,|\\.|\\+|\\}|\\{ ]*$") && obj.getLocation().length() <= 32;
    }

    private String changeNewConditionValue(String newConditionValue) {
        try {
            if (null != newConditionValue && !"".equals(newConditionValue)) {
                newConditionValue = URLDecoder.decode(newConditionValue, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"UnsupportedEncodingException", (Throwable)e);
        }
        return newConditionValue;
    }

    public String refreshInsDeviceList() {
        String selectedMo = (String)this.fetchRequest().getSession().getAttribute("selectedMo");
        String subType = this.getId();
        if (null != subType) {
            subType = subType.replaceAll("'", "''");
        }
        String newAddFlag = this.getAddFlag();
        String newConditionValue = this.getConditionValue();
        newConditionValue = this.changeNewConditionValue(newConditionValue);
        String newConditionType = this.getConditionType();
        IDataExplore dataExplore = (IDataExplore)ServiceContext.getInstance().getService("deviceDataExplore", IDataExplore.class);
        TopoObject rootMo = dataExplore.getRootMO();
        if (null != subType && null != rootMo && subType.equalsIgnoreCase(rootMo.getSubType())) {
            if (null != newConditionType) {
                this.refreshSystemMo(selectedMo, newConditionValue, newConditionType, rootMo);
            } else {
                this.refreshSystemMo(selectedMo, newConditionValue, "", rootMo);
            }
            if (newAddFlag != null && newAddFlag.equals("true") && (null == this.topoObjectList || this.topoObjectList.isEmpty())) {
                this.responseResult("null");
                return "error";
            }
            this.total = this.topoObjectList.size();
            return "success";
        }
        TopoObjectQueryCondition condtion = new TopoObjectQueryCondition();
        condtion.setSubDevTypeName(subType);
        long userId = -1L;
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        if (!"true".equalsIgnoreCase(user.getIsAdmin())) {
            userId = user.getUserID();
        }
        if (userId > -1L) {
            condtion.setUserId(String.valueOf(userId));
        }
        if (this.queryConditionNotNull(newConditionType, newConditionValue)) {
            if ("1".equals(newConditionType)) {
                condtion.setDeviceNameLikeQuery(newConditionValue);
            } else if ("2".equals(newConditionType)) {
                condtion.setDevIpAddressLikeQuery(newConditionValue);
            }
        }
        if (null != selectedMo) {
            condtion.setSelectedMoIds(selectedMo.split(","));
        }
        try {
            this.topoObjectList = dataExplore.getDataList(this.start, this.pageSize, condtion);
            this.total = (int)dataExplore.getTotalDataCount(condtion);
        }
        catch (Exception e) {
            this.log.error((Object)"refreshInsDeviceList error.", (Throwable)e);
        }
        return this.addFlag(newAddFlag);
    }

    private String addFlag(String newAddFlag) {
        if (newAddFlag != null && newAddFlag.equals("true") && (null == this.topoObjectList || this.topoObjectList.isEmpty())) {
            this.responseResult("null");
            return "error";
        }
        return "success";
    }

    private boolean queryConditionNotNull(String newConditionType, String newConditionValue) {
        if (null == newConditionType) {
            return false;
        }
        if (newConditionType.length() <= 0) {
            return false;
        }
        if (null == newConditionValue) {
            return false;
        }
        return newConditionValue.length() > 0;
    }

    private void refreshSystemMo(String selectedMo, String newConditionValue, String newConditionType, TopoObject rootMo) {
        StringBuilder moId = new StringBuilder();
        moId.append(',');
        moId.append(rootMo.getMoId());
        moId.append(',');
        if (null == selectedMo || selectedMo.indexOf(moId.toString()) < 0) {
            if (null != newConditionValue && newConditionValue.length() > 0) {
                this.filterSystenMo(newConditionValue, newConditionType, rootMo);
            } else {
                this.topoObjectList.add(rootMo);
            }
        }
    }

    private void filterSystenMo(String newConditionValue, String newConditionType, TopoObject rootMo) {
        if (newConditionType.equals("1")) {
            if (rootMo.getName().toLowerCase(Locale.US).indexOf(newConditionValue.trim().toLowerCase(Locale.US)) > -1) {
                this.topoObjectList.add(rootMo);
            }
        } else if (newConditionType.equals("2") && rootMo.getIpAddress().indexOf(newConditionValue.trim()) > -1) {
            this.topoObjectList.add(rootMo);
        }
    }

    public String refreshAlarmType() {
        String selectedMo = (String)this.fetchRequest().getSession().getAttribute("selectedMo");
        String newAddFlag = this.getAddFlag();
        this.generateAlarmLevelGroup();
        String newMoMainType = this.getMoMainType();
        String newMoSubType = this.getMoSubType();
        String severities = this.getAlarmTypes();
        if (null != severities) {
            if ("".equals(severities)) {
                this.alarmTypeList.clear();
                return "success";
            }
            String[] ss = severities.split(",");
            for (int i = 0; i < ss.length; ++i) {
                FaultEnum.AlarmSeverity.getSeverity((int)Integer.parseInt(ss[i]));
            }
        } else {
            FaultEnum.AlarmSeverity.values();
        }
        Byte sourceType = this.getSourceTypeByMoType(newMoMainType, newMoSubType);
        NotifyService notifyService = (NotifyService)ServiceContext.getInstance().getService("notifyService", NotifyService.class);
        List<FaultDefine> typeList = notifyService.getFaultDefine(sourceType);
        ArrayList<FaultDefine> tempList = new ArrayList<FaultDefine>();
        HashSet<String> alarmSet = new HashSet<String>();
        for (FaultDefine faultDefine : typeList) {
            if ("0x000803220005".equals(faultDefine.getFaultDefineId()) && "lego.dic.legosystem.subtype".equals(newMoSubType)) continue;
            StringBuilder faultId = new StringBuilder();
            faultId.append(',');
            faultId.append(faultDefine.getFaultDefineId() + "_" + faultDefine.getSeverity());
            faultId.append(',');
            if (alarmSet.contains(faultDefine.getFaultDefineId() + "_" + faultDefine.getSeverity()) || null != selectedMo && selectedMo.indexOf(faultId.toString()) >= 0) continue;
            if (newMoMainType.equals("NFAdevice_i18n")) {
                if (!faultDefine.getFaultDefineId().equals("0x000803220005")) continue;
                tempList.add(faultDefine);
                alarmSet.add(faultDefine.getFaultDefineId() + "_" + faultDefine.getSeverity());
                break;
            }
            tempList.add(faultDefine);
            alarmSet.add(faultDefine.getFaultDefineId() + "_" + faultDefine.getSeverity());
        }
        if (!tempList.isEmpty()) {
            this.alarmTypeList.addAll(tempList);
        }
        if (newAddFlag != null && newAddFlag.equals("true") && (null == this.alarmTypeList || this.alarmTypeList.isEmpty())) {
            this.responseResult("null");
            return "error";
        }
        this.fetchRequest().setAttribute("customedLevel", (Object)this.customedLevel);
        this.fetchRequest().setAttribute("typeString", (Object)this.getEditType());
        return "success";
    }

    private Byte getSourceTypeByMoType(String newMoMainType, String newMoSubType) {
        Byte sourceType = 4;
        if (null == newMoMainType || null == newMoSubType || newMoMainType.isEmpty() || newMoSubType.isEmpty()) {
            return sourceType;
        }
        if ("lego.dic.legosystem.maintype".equals(newMoMainType) || "lego.dic.legosystem.subtype".equals(newMoSubType)) {
            return (byte)1;
        }
        if ("atic.portal.mainType.collector".equals(newMoMainType) || "atic.portal.subType.ddosCollector".equals(newMoSubType)) {
            return (byte)2;
        }
        if ("AntiDDoS_i18n".equals(newMoMainType)) {
            return (byte)4;
        }
        if ("atic.portal.mainType.zone".equals(newMoMainType) || "atic.portal.subType.dsosZone".equals(newMoSubType)) {
            return (byte)6;
        }
        return sourceType;
    }

    public void generateAlarmLevelGroup() {
        this.checkboxList = new ArrayList<TemplatePair>();
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.warning"), 1L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.minor"), 2L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.major"), 3L));
        this.checkboxList.add(new TemplatePair(this.getText("lego.lab.fault.alarmLevel.critical"), 4L));
    }

    public String popRuleComplexInfo() {
        return "success";
    }

    public List<TemplatePair> getCheckboxList() {
        return this.checkboxList;
    }

    public void setCheckboxList(List<TemplatePair> checkboxList) {
        this.checkboxList = checkboxList;
    }

    public List<TopoObject> getTopoObjectList() {
        return this.topoObjectList;
    }

    public void setTopoObjectList(List<TopoObject> topoObjectList) {
        this.topoObjectList = topoObjectList;
    }

    public List<FaultDefine> getAlarmTypeList() {
        return this.alarmTypeList;
    }

    public void setAlarmTypeList(List<FaultDefine> alarmTypeList) {
        this.alarmTypeList = alarmTypeList;
    }

    public String getMoMainType() {
        return this.moMainType;
    }

    public void setMoMainType(String moMainType) {
        this.moMainType = moMainType;
    }

    public String getMoSubType() {
        return this.moSubType;
    }

    public void setMoSubType(String moSubType) {
        this.moSubType = moSubType;
    }

    public String getEditType() {
        return this.editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public String getAddFlag() {
        return this.addFlag;
    }

    public void setAddFlag(String addFlag) {
        this.addFlag = addFlag;
    }

    public String getAlarmTypes() {
        return this.alarmTypes;
    }

    public void setAlarmTypes(String alarmTypes) {
        this.alarmTypes = alarmTypes;
    }

    public String getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(String conditionType) {
        this.conditionType = conditionType;
    }

    public String getConditionValue() {
        return this.conditionValue;
    }

    public void setConditionValue(String conditionValue) {
        this.conditionValue = conditionValue;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

