/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.FileSecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public abstract class FileUtil {
    private static final int TOOBIG = 524288000;
    private static final int NUM_1024 = 1024;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private String title;
    private List<String> colTitle;
    private String writeFileName;
    private String strExtend;
    private String strUsrName;
    private String strChar = "UTF-8";
    private String downFileName = "ExportResult";
    private List<String> labelName;
    private List<List<String>> colTitleList;

    public void fileSet(String strTitle, List<String> lstColTitle, String strWriteFileName) {
        this.setTitle(strTitle);
        this.setColTitle(lstColTitle);
        this.setWriteFileName(strWriteFileName + "." + this.strExtend);
    }

    public void downloadNameFile(HttpServletResponse response, String fileName) {
        this.setDownFileName(fileName);
        this.downloadFile(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(HttpServletResponse response) {
        String displayName = this.downFileName + "." + this.strExtend;
        String downloadFileName = this.getWriteFileName();
        response.setContentType("application/x-download");
        response.setCharacterEncoding("windows-1251");
        response.setHeader("Pragma", "public");
        response.setHeader("Cache-Control", "must-revalidate");
        response.addHeader("Content-Disposition", "attachment;filename=" + displayName);
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File delFile = new File(downloadFileName);
        FileInputStream fileInput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(downloadFileName);
            bis = new BufferedInputStream(fileInput);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buff = new byte[bis.available()];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                ((BufferedOutputStream)bos).write(buff, 0, bytesRead);
            }
            ((BufferedOutputStream)bos).flush();
        }
        catch (IOException e) {
            this.log.error((Object)"downloadFile");
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"downloadFile");
            }
            this.close(bis, fileInput);
            Boolean result = delFile.delete();
            if (!result.booleanValue()) {
                this.log.error((Object)"delete file error");
            }
        }
    }

    private void close(BufferedInputStream bis, FileInputStream fileInput) {
        try {
            if (bis != null) {
                bis.close();
            }
            if (null != fileInput) {
                fileInput.close();
            }
        }
        catch (IOException e) {
            this.log.error((Object)"downloadFile", (Throwable)e);
        }
    }

    public static String getNowTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDetailFile(String fileName, byte[] logDetail) {
        String securityPath = FileSecurityUtil.getSecurityPath((String)fileName);
        FileOutputStream fOut = null;
        FilterOutputStream dos = null;
        try {
            fOut = new FileOutputStream(securityPath);
            dos = new DataOutputStream(fOut);
            dos.write(logDetail);
            ((DataOutputStream)dos).flush();
            return;
        }
        catch (IOException e) {
            this.log.error((Object)"writeDetailFile");
            return;
        }
        finally {
            try {
                if (null != dos) {
                    dos.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"writeDetailFile");
            }
            finally {
                try {
                    if (null != fOut) {
                        fOut.close();
                    }
                }
                catch (IOException e) {
                    this.log.error((Object)"fOut close error: ");
                }
            }
        }
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    this.log.error((Object)"delete file error");
                }
            } else if (file.isDirectory()) {
                Boolean result;
                File[] files = file.listFiles();
                if (null != files) {
                    for (int i = 0; i < files.length; ++i) {
                        this.deleteFile(files[i]);
                    }
                }
                if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
                    this.log.error((Object)"delete file error");
                }
            }
        } else {
            this.log.error((Object)"file is not exist");
        }
    }

    public void fileSetCol(List<String> fileLabelName, List<List<String>> colLabelTitle, String strWriteFileName) {
        this.setLabelName(fileLabelName);
        this.setColTitleList(colLabelTitle);
        this.setWriteFileName(strWriteFileName + "." + this.strExtend);
    }

    public abstract void writeFile(List<List<String>> var1);

    public abstract void writeFile(List<List<String>> var1, String var2);

    public abstract void closeFile() throws IOException;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getColTitle() {
        return this.colTitle;
    }

    public void setColTitle(List<String> colTitle) {
        this.colTitle = colTitle;
    }

    public String getWriteFileName() {
        return this.writeFileName;
    }

    public void setWriteFileName(String writeFileName) {
        this.writeFileName = writeFileName;
    }

    public String getStrExtend() {
        return this.strExtend;
    }

    public void setStrExtend(String strExtend) {
        this.strExtend = strExtend;
    }

    public String getStrUsrName() {
        return this.strUsrName;
    }

    public void setStrUsrName(String strUsrName) {
        this.strUsrName = strUsrName;
    }

    public String getStrChar() {
        return this.strChar;
    }

    public void setStrChar(String strChar) {
        this.strChar = strChar;
    }

    public String getDownFileName() {
        return this.downFileName;
    }

    public void setDownFileName(String downFileName) {
        this.downFileName = downFileName;
    }

    public List<String> getLabelName() {
        return this.labelName;
    }

    public void setLabelName(List<String> labelName) {
        this.labelName = labelName;
    }

    public List<List<String>> getColTitleList() {
        return this.colTitleList;
    }

    public void setColTitleList(List<List<String>> colTitleList) {
        this.colTitleList = colTitleList;
    }
}

