/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.mediation.nepoll.PingPoll;
import com.hs.lego.core.mediation.nepoll.PollPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.List;

class InitPollThread
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IDataExplore dateExplorer = null;

    public InitPollThread(IDataExplore dateExplorer) {
        this.dateExplorer = dateExplorer;
    }

    @Override
    public void run() {
        TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
        condition.setUserId(null);
        condition.setIsManaged(Boolean.valueOf(true));
        List topoObjects = this.dateExplorer.getDataList(condition);
        for (TopoObject topoMo : topoObjects) {
            long moId = topoMo.getMoId();
            String moIP = topoMo.getIpAddress();
            String moName = topoMo.getName();
            if (!topoMo.getSupportPing().booleanValue()) {
                LOGGER.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName));
                continue;
            }
            if (topoMo.getMainType().startsWith("NFA")) {
                LOGGER.info((Object)("Skip the NFA device " + topoMo.getName() + " at the beginning"));
                continue;
            }
            if (topoMo.getMainType().startsWith("NfaCluster")) {
                LOGGER.info((Object)("Skip the NfaCluster device " + topoMo.getName() + " at the beginning"));
                continue;
            }
            if (null == moIP) {
                LOGGER.error((Object)("moIP is null, can not add a poll task while starting, moId:" + moId));
                continue;
            }
            PollPlugin.getInstance().addPingPoll(new PingPoll(moId, moIP, moName));
        }
    }
}

