/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.mediation.nepoll.PingPoll;
import com.hs.lego.core.mediation.nepoll.PollPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Map;

public class NeUpdateSubscriber {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public void onMessage(Map<Long, ManagedObject> msgObj) {
        if (null == msgObj) {
            LOGGER.error((Object)"recv a null message object, message type: COMMAND_RES_UPDATE");
            return;
        }
        try {
            Collection<ManagedObject> moList = msgObj.values();
            LOGGER.info((Object)("recv a COMMAND_RES_UPDATE message, moIds: " + msgObj.keySet()));
            for (ManagedObject mo : moList) {
                if (!(mo instanceof TopoObject)) continue;
                TopoObject topoMo = (TopoObject)mo;
                String moIP = topoMo.getIpAddress();
                if (null == moIP) {
                    LOGGER.error((Object)"moIP is null, can not add a poll task.");
                    continue;
                }
                LOGGER.info((Object)("TopoObject contained in COMMAND_RES_UPDATE message which moId: " + topoMo.getMoId() + ", moIP: " + moIP));
                this.updatePollTask(moIP, topoMo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"", (Throwable)e);
        }
    }

    private void updatePollTask(String moIP, TopoObject topoMo) {
        long moId = topoMo.getMoId();
        String moName = topoMo.getName();
        if (!topoMo.getSupportPing().booleanValue()) {
            LOGGER.error((Object)("no support ping,ip:" + moIP + ",moId:" + moId + ",moName:" + moName));
            return;
        }
        PollPlugin.getInstance().updatePingPoll(new PingPoll(moId, moIP, moName));
    }
}

