/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.cbb.resource.dao;

import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserInfo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserRelMo;
import com.hs.lego.cbb.user.sdk.hibernate.model.UserRelMoInfo;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.base.util.ConverterUtil;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.comm.QueryCondition;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.cbb.resource.dao.IResourceDao;
import com.huawei.atic.resource.model.Node;
import com.huawei.atic.south.model.SnmpPara;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

public class ResourceDaoImpl
extends CommonDaoImpl
implements IResourceDao {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IMessageCenter messageCenter = null;
    private TransactionTemplate transactionTemplate = null;

    @Override
    public void updateMoWithoutMsg(ManagedObject mo) {
        LOGGER.info((Object)("will update mo without msg, mo is : " + mo));
        super.getHibernateTemplate().update((Object)mo);
    }

    @Override
    public void updateMo(ManagedObject mo) {
        MessageUnit mu;
        LOGGER.info((Object)("will update mo, mo uuid is : " + mo.getUuid()));
        ManagedObject oldMo = this.getMoByUuid(mo.getUuid(), null);
        this.evict(oldMo);
        boolean isOffLineStatusChange = false;
        boolean isOnLineStatusChange = false;
        if (oldMo != null) {
            Integer oldStatus = oldMo.getStatus();
            Integer newStatus = mo.getStatus();
            LOGGER.info((Object)("oldStatus is : " + oldStatus + ", newStatus is : " + newStatus));
            if (this.checkStatus(oldStatus, newStatus)) {
                isOffLineStatusChange = true;
            } else if (oldStatus != null && oldStatus != -1 && newStatus != null && newStatus == -1) {
                isOnLineStatusChange = true;
            }
        }
        super.getHibernateTemplate().update((Object)mo);
        HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
        messageMap.put(mo.getMoId(), mo);
        if (mo.getIsTopMo().booleanValue()) {
            LOGGER.info((Object)("will send COMMAND_RES_UPDATE msg, msg body is : " + messageMap));
            mu = new MessageUnit();
            mu.setCmdcode(107L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
            if (isOffLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                map.put(-1L, 0);
                LOGGER.info((Object)("will send COMMAND_RES_ONLINE message, mo id is : " + mo.getMoId()));
                MessageUnit mmu = new MessageUnit();
                mmu.setCmdcode(110L);
                mmu.setObj(map);
                mmu.setMt(MessageTopic.COMMAND);
                mmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmu);
            } else if (isOnLineStatusChange) {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                map.put(mo.getMoId(), mo.getStatus());
                LOGGER.info((Object)("will send COMMAND_RES_LEAVE message, mo id is : " + mo.getMoId()));
                MessageUnit mmmu = new MessageUnit();
                mmmu.setCmdcode(109L);
                mmmu.setObj(map);
                mmmu.setMt(MessageTopic.COMMAND);
                mmmu.setSourceAppName(this.getClass().getName());
                this.messageCenter.sendMessage(mmmu);
            }
        } else if (!mo.equals((Object)oldMo)) {
            LOGGER.info((Object)("will send COMMAND_RES_UPDATE_SUB_MO msg, msg body is : " + messageMap));
            mu = new MessageUnit();
            mu.setCmdcode(108L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
        this.sendMsgIfSnmpParaChanged(mo, oldMo);
    }

    private boolean checkStatus(Integer oldStatus, Integer newStatus) {
        return oldStatus != null && oldStatus == -1 && newStatus != null && newStatus != -1;
    }

    private void sendMsgIfSnmpParaChanged(ManagedObject mo, ManagedObject oldMo) {
        if (oldMo instanceof Node && mo instanceof Node) {
            Node oldMoNode = (Node)oldMo;
            Node newMoNode = (Node)mo;
            SnmpPara oldSnmpPara = (SnmpPara)oldMoNode.getManagementProtocol(SnmpPara.class.getName());
            SnmpPara newSnmpPara = (SnmpPara)newMoNode.getManagementProtocol(SnmpPara.class.getName());
            if (oldSnmpPara != null && newSnmpPara != null && !newSnmpPara.equals(oldSnmpPara)) {
                HashMap<String, SnmpPara> msgMap = new HashMap<String, SnmpPara>();
                msgMap.put(newMoNode.getUuid(), newSnmpPara);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(114L);
                mu.setObj(msgMap);
                mu.setMt(MessageTopic.DATA);
                mu.setSourceAppName(this.getClass().getName());
                LOGGER.info((Object)("will send COMMAND_SNMP_PARA_CHANGED msg, msg body is : " + msgMap));
                this.messageCenter.sendMessage(mu);
            }
        }
    }

    @Override
    public void updateMo(List<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            this.updateMo(mo);
        }
    }

    @Override
    public void updateMoWithoutMsg(List<ManagedObject> moList) {
        for (ManagedObject mo : moList) {
            this.updateMoWithoutMsg(mo);
        }
    }

    @Override
    public ManagedObject getMoByIdAndType(Class<? extends ManagedObject> moClass, long id, Boolean managed) {
        Object obj = super.getHibernateTemplate().execute((HibernateCallback)new MoAndTypeHibernateCallback(moClass, id, managed));
        return (ManagedObject)obj;
    }

    @Override
    public List<ManagedObject> getChildMo(long parentId, Boolean managed) {
        DetachedCriteria criteria = DetachedCriteria.forClass(ManagedObject.class);
        criteria.add((Criterion)Restrictions.eq((String)"parentMo.moId", (Object)parentId));
        if (managed != null) {
            criteria.add((Criterion)Restrictions.eq((String)"managed", (Object)managed));
        }
        return super.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public Long addMoWithoutMsg(ManagedObject mo) {
        LOGGER.info((Object)("will add mo without msg, mo is : " + mo));
        return (Long)super.getHibernateTemplate().save((Object)mo);
    }

    @Override
    public Long addMo(final ManagedObject mo) {
        LOGGER.info((Object)("will add mo, mo is : " + this.getSecureString(mo.toString())));
        Long moId = (Long)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    return ResourceDaoImpl.this.save(mo);
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("save mo error, mo is : " + ResourceDaoImpl.this.getSecureString(mo.toString())), (Throwable)e);
                    throw new LegoUncheckedException((Throwable)e);
                }
            }
        });
        HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
        messageMap.put(mo.getMoId(), mo);
        if (mo.getIsTopMo().booleanValue()) {
            LOGGER.info((Object)("will send COMMAND_RES_ADD msg, msg body is : " + this.getSecureString(messageMap.toString())));
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(103L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
        return moId;
    }

    @Override
    public List<? extends ManagedObject> getMoByType(Class<?> c, Boolean managed) {
        DetachedCriteria criteria = DetachedCriteria.forClass(c);
        criteria.add((Criterion)Restrictions.eq((String)"managed", (Object)managed));
        return super.getHibernateTemplate().findByCriteria(criteria);
    }

    @Override
    public ManagedObject getMoByUuid(String uuid, Boolean managed) {
        return (ManagedObject)super.getHibernateTemplate().execute((HibernateCallback)new MoUuidHibernateCallback(uuid));
    }

    @Override
    public ManagedObject getMoByMoId(Long moid, Boolean managed) {
        Object execute = super.getHibernateTemplate().execute((HibernateCallback)new MoIdQueryHibernateCallback(moid));
        return (ManagedObject)execute;
    }

    @Override
    public TopoObject getTopoObjectByMoId(Long moid, Boolean managed) {
        return (TopoObject)super.getHibernateTemplate().execute((HibernateCallback)new TopoHibernateCallback(moid));
    }

    @Override
    public void deleteMo(final Long moId) {
        LOGGER.info((Object)("first step to delete mo, mo id is : " + moId));
        ArrayList<ManagedObject> allMo = new ArrayList<ManagedObject>();
        this.getAllSubMo(moId, allMo);
        final ManagedObject tMo = this.getMoByIdAndType(ManagedObject.class, moId, null);
        if (tMo == null) {
            LOGGER.warn((Object)("can not getMoByIdAndType in deleteMo, moid is : " + moId + ", type is : ManagedObject"));
            return;
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    LOGGER.info((Object)("will delete mo, mo is : " + tMo));
                    ResourceDaoImpl.this.delete(tMo);
                    LOGGER.info((Object)"delete mo successful");
                    return null;
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("delete mo error, moId is : " + moId), (Throwable)e);
                    throw new LegoUncheckedException((Throwable)e);
                }
            }
        });
        LOGGER.info((Object)"cascade delete mo complete and successful");
        if (tMo.getIsTopMo().booleanValue()) {
            HashMap<Long, ManagedObject> messageMap = new HashMap<Long, ManagedObject>();
            messageMap.put(tMo.getMoId(), tMo);
            LOGGER.info((Object)("will send COMMAND_RES_DEL msg, msg body is : " + messageMap));
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(105L);
            mu.setObj(messageMap);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
        }
        allMo.add(tMo);
        HashMap<Long, ManagedObject> messageMapCommon = new HashMap<Long, ManagedObject>();
        for (ManagedObject managedObject : allMo) {
            messageMapCommon.put(managedObject.getMoId(), managedObject);
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(106L);
            mu.setObj(messageMapCommon);
            mu.setMt(MessageTopic.DATA);
            mu.setSourceAppName(this.getClass().getName());
            this.messageCenter.sendMessage(mu);
            LOGGER.info((Object)("has sent COMMAND_RES_DEL_SUB_MO msg, messageMap is : " + messageMapCommon));
            messageMapCommon.clear();
        }
        HashMap<String, Long> messageMap = new HashMap<String, Long>();
        for (ManagedObject mo : allMo) {
            messageMap.put(mo.getUuid(), mo.getMoId());
        }
        LOGGER.info((Object)("will send COMMAND_RES_DEL_FOR_PERF msg, messageMap is : " + messageMap));
        MessageUnit messageUnit = new MessageUnit();
        messageUnit.setCmdcode(111L);
        messageUnit.setObj(messageMap);
        messageUnit.setMt(MessageTopic.DATA);
        messageUnit.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(messageUnit);
    }

    @Override
    public void deleteMoWithoutMsg(final Long moId) {
        LOGGER.info((Object)("first step to delete mo without msg, mo id is : " + moId));
        ArrayList<ManagedObject> allMo = new ArrayList<ManagedObject>();
        this.getAllSubMo(moId, allMo);
        final ManagedObject tMo = this.getMoByIdAndType(ManagedObject.class, moId, null);
        if (tMo == null) {
            LOGGER.warn((Object)("can not getMoByIdAndType in deleteMoWithoutMsg, moid is : " + moId + ", type is : ManagedObject"));
            return;
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus transactionstatus) {
                try {
                    LOGGER.info((Object)("will delete mo without msg, mo is : " + tMo));
                    ResourceDaoImpl.this.delete(tMo);
                    LOGGER.info((Object)"delete mo without msg successful");
                    return null;
                }
                catch (Exception e) {
                    transactionstatus.setRollbackOnly();
                    LOGGER.error((Object)("delete mo error, moId is : " + moId), (Throwable)e);
                    throw new LegoUncheckedException((Throwable)e);
                }
            }
        });
        LOGGER.info((Object)"cascade delete mo without msg complete and successful");
        allMo.add(tMo);
        HashMap<String, Long> messageMap = new HashMap<String, Long>();
        for (ManagedObject mo : allMo) {
            messageMap.put(mo.getUuid(), mo.getMoId());
        }
        LOGGER.info((Object)("will send COMMAND_RES_DEL_FOR_PERF msg, messageMap is : " + messageMap));
        MessageUnit mu = new MessageUnit();
        mu.setCmdcode(111L);
        mu.setObj(messageMap);
        mu.setMt(MessageTopic.DATA);
        mu.setSourceAppName(this.getClass().getName());
        this.messageCenter.sendMessage(mu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Paging queryRes(Class<T> resType, List<QueryCondition> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Session session = null;
        try {
            List<T> list;
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(resType);
            Criteria criteriaTotal = session.createCriteria(resType);
            if (firstRowIndex >= 0) {
                criteria.setFirstResult(firstRowIndex);
            }
            if (totalRow >= 0) {
                criteria.setMaxResults(totalRow);
            }
            if (orderByAscend) {
                criteria.addOrder(Order.asc((String)orderByField));
            } else {
                criteria.addOrder(Order.desc((String)orderByField));
            }
            int size = 0;
            if (condition == null) {
                list = criteria.list();
                size = criteriaTotal.list().size();
            } else {
                list = ResourceDaoImpl.getPerfs(condition, criteria);
                size = ResourceDaoImpl.getPerfs(condition, criteriaTotal).size();
            }
            Paging paging = new Paging();
            paging.setCount(size);
            paging.setData(list);
            Paging paging2 = paging;
            return paging2;
        }
        catch (HibernateException e) {
            LOGGER.error((Object)("queryFaults exception, choose condition is : " + condition), (Throwable)e);
        }
        finally {
            if (null != session) {
                session.close();
            }
        }
        return new Paging();
    }

    public static String convertString(String sourceStr) {
        return ConverterUtil.getInstance().convertString(sourceStr, true);
    }

    @Override
    public ManagedObject getMoByIp(String ip, Boolean managed) {
        return (ManagedObject)super.getHibernateTemplate().execute((HibernateCallback)new IPQUeryMoHibernateCallback(ip));
    }

    private static <T> List<T> getPerfs(List<QueryCondition> conditions, Criteria criteria) {
        for (QueryCondition con : conditions) {
            if (con.getType().equals("el")) {
                criteria.add((Criterion)Restrictions.eq((String)con.getKey(), (Object)con.getValue()));
                continue;
            }
            if (con.getType().equals("like")) {
                String queryStr = ResourceDaoImpl.convertString(con.getValue().toString());
                criteria.add((Criterion)Restrictions.like((String)con.getKey(), (Object)queryStr));
                continue;
            }
            if (!con.getType().equals("in")) continue;
            criteria.add(Restrictions.in((String)con.getKey(), (Collection)((Set)con.getValue())));
        }
        return criteria.list();
    }

    @Override
    public List<Node> queryMo(String devName) {
        StringBuilder hql = new StringBuilder("from Node mo where mo.name = ?");
        Session session = null;
        List<Node> resultList = new ArrayList<Node>();
        try {
            session = super.currentSession();
            org.hibernate.query.Query query = null;
            query = session.createQuery(hql.toString());
            query.setString(0, devName);
            resultList = query.list();
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)("runtime exception when query mo, devName is : " + devName), (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when query mo, devName is : " + devName), (Throwable)e);
        }
        return resultList;
    }

    @Override
    public Paging queryMo(Map<String, Object> conditionMap, Boolean managed, int firstRowIndex, int totalRow, String orderByFieldParam, boolean orderByAscend, boolean isAdmin) {
        String orderByField = orderByFieldParam;
        if ("discoveredTimeStr".equals(orderByField)) {
            orderByField = "discoveredTime";
        }
        StringBuilder hql = new StringBuilder("from Node mo where mo.parentMo = null ");
        StringBuilder countHql = new StringBuilder("select count(*) from Node mo where mo.parentMo = null ");
        hql.append(" and mo.managed = ").append(managed);
        countHql.append(" and mo.managed = ").append(managed);
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.currentSession();
            Query query = null;
            Query countQuery = null;
            Map param = null;
            if (conditionMap != null) {
                Map<String, Object> map = this.processQueryCondition(conditionMap, orderByField, orderByAscend, hql, countHql, session);
                query = (Query)map.get("query");
                countQuery = (Query)map.get("countQuery");
                param = (Map)map.get("param");
            }
            LOGGER.info((Object)("query mo hql is : " + hql.toString() + ", countQuery is : " + countQuery));
            if (query == null) {
                hql.append(" order by mo.").append(orderByField);
                this.appendOrder(orderByAscend, hql);
                hql.append(", mo.moId");
                query = session.createQuery(hql.toString());
            }
            if (countQuery == null) {
                countQuery = session.createQuery(countHql.toString());
            }
            this.setParam(query, countQuery, param);
            Long totalCountWithoutPagingLong = (Long)countQuery.uniqueResult();
            int totalCountWithoutPaging = totalCountWithoutPagingLong.intValue();
            if (isAdmin && !orderByField.equals("name")) {
                query.setFirstResult(firstRowIndex);
                query.setMaxResults(totalRow);
            }
            List resultList = query.list();
            paging.setCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)("runtime exception when query mo, conditionMap is : " + conditionMap + ", orderByField is : " + orderByField), (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when query mo, conditionMap is : " + conditionMap + ", orderByField is : " + orderByField), (Throwable)e);
        }
        return paging;
    }

    private void setParam(Query query, Query countQuery, Map<Integer, String> param) {
        if (param != null) {
            Set<Map.Entry<Integer, String>> entrys = param.entrySet();
            for (Map.Entry<Integer, String> entry : entrys) {
                query.setString(entry.getKey().intValue(), entry.getValue());
                countQuery.setString(entry.getKey().intValue(), entry.getValue());
            }
        }
    }

    private Map<String, Object> processQueryCondition(Map<String, Object> conditionMap, String orderByField, boolean orderByAscend, StringBuilder hql, StringBuilder countHql, Session session) throws ParseException {
        Date beginTimeTemp;
        String ip;
        String name = (String)conditionMap.get("name");
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        int index = 0;
        if (StringUtils.hasText((String)name)) {
            name = ConverterUtil.getInstance().convertString(name.trim(), true);
            LOGGER.info((Object)("converted result name is : " + name));
            hql.append(" and lower(mo.name) like lower(?").append(") ");
            countHql.append(" and lower(mo.name) like lower(?").append(") ");
            param.put(index++, name);
        }
        if (StringUtils.hasText((String)(ip = (String)conditionMap.get("ip")))) {
            ip = ip.trim();
            hql.append(" and mo.ipAddress = ? ");
            countHql.append(" and mo.ipAddress = ? ");
            param.put(index, ip);
        }
        String beginTime = (String)conditionMap.get("beginTime");
        String endTime = (String)conditionMap.get("endTime");
        if (beginTime == null) {
            beginTime = "";
        }
        if (endTime == null) {
            endTime = "";
        }
        beginTime = beginTime.trim();
        endTime = endTime.trim();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        org.hibernate.query.Query query = null;
        org.hibernate.query.Query countQuery = null;
        if (!beginTime.equals("") && !endTime.equals("")) {
            beginTimeTemp = dateFormat.parse(beginTime);
            Date endTimeTemp = dateFormat.parse(endTime);
            endTimeTemp = this.addOneSecond(endTimeTemp);
            hql.append(" and mo.discoveredTime >=:beginTime and mo.discoveredTime <:endTime ");
            countHql.append(" and mo.discoveredTime >=:beginTime and mo.discoveredTime <:endTime ");
            if (this.checkParams(orderByField)) {
                hql.append(" order by mo.").append(orderByField);
                this.appendOrder(orderByAscend, hql);
            }
            query = session.createQuery(hql.toString());
            query.setTimestamp("beginTime", beginTimeTemp);
            query.setTimestamp("endTime", endTimeTemp);
            countQuery = session.createQuery(countHql.toString());
            countQuery.setTimestamp("beginTime", beginTimeTemp);
            countQuery.setTimestamp("endTime", endTimeTemp);
        } else if (!beginTime.equals("")) {
            beginTimeTemp = dateFormat.parse(beginTime);
            hql.append(" and mo.discoveredTime >=:beginTime ");
            countHql.append(" and mo.discoveredTime >=:beginTime ");
            if (this.checkParams(orderByField)) {
                hql.append(" order by mo.").append(orderByField);
                this.appendOrder(orderByAscend, hql);
            }
            query = session.createQuery(hql.toString());
            query.setTimestamp("beginTime", beginTimeTemp);
            countQuery = session.createQuery(countHql.toString());
            countQuery.setTimestamp("beginTime", beginTimeTemp);
        } else if (!endTime.equals("")) {
            Date endTimeTemp = dateFormat.parse(endTime);
            endTimeTemp = this.addOneSecond(endTimeTemp);
            hql.append(" and mo.discoveredTime <:endTime");
            countHql.append(" and mo.discoveredTime <:endTime");
            if (this.checkParams(orderByField)) {
                hql.append(" order by mo.").append(orderByField);
                this.appendOrder(orderByAscend, hql);
            }
            query = session.createQuery(hql.toString());
            query.setTimestamp("endTime", endTimeTemp);
            countQuery = session.createQuery(countHql.toString());
            countQuery.setTimestamp("endTime", endTimeTemp);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", query);
        map.put("countQuery", countQuery);
        map.put("param", param);
        return map;
    }

    private boolean checkParams(String name) {
        String regular;
        return null != name && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name);
    }

    private void appendOrder(boolean orderByAscend, StringBuilder hql) {
        if (orderByAscend) {
            hql.append(" asc");
        } else {
            hql.append(" desc");
        }
    }

    private Date addOneSecond(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(14, 1000);
        return calendar.getTime();
    }

    @Override
    public void getAllSubMo(Long moId, List<ManagedObject> resultMoList) {
        List<ManagedObject> childMo = this.getChildMo(moId, null);
        if (childMo != null && !childMo.isEmpty()) {
            resultMoList.addAll(childMo);
            for (ManagedObject mo : childMo) {
                this.getAllSubMo(mo.getMoId(), resultMoList);
            }
        }
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    @Override
    public void evict(ManagedObject mo) {
        super.getHibernateTemplate().evict((Object)mo);
    }

    @Override
    public DeviceTypeRelation getDeviceTypeBySysOid(String sysoid) {
        String hsql = "from DeviceTypeRelation t where t.relationSysOid like ?";
        List regInfos = this.getHibernateTemplate().find(hsql, new Object[]{"%" + sysoid + "%"});
        if (regInfos != null && !regInfos.isEmpty()) {
            return (DeviceTypeRelation)regInfos.get(0);
        }
        return null;
    }

    @Override
    public List<TopoObject> getToObjectByIpMainType(String ipAddress, String mainType) {
        String hql = "from TopoObject where (1=1) ";
        if (!AticUtil.isNull((String)ipAddress)) {
            hql = hql + " and ipAddress=?";
        }
        if (!AticUtil.isNull((String)mainType)) {
            hql = hql + " and mainType=?";
        }
        LOGGER.info((Object)("change atic ip hql:" + hql));
        return this.getHibernateTemplate().find(hql, new Object[]{ipAddress, mainType});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getAllMoId() {
        String hql = "select moId from TopoObject";
        List moIdList = new ArrayList();
        try (Session session = null;){
            session = super.currentSession();
            moIdList = session.createQuery(hql).list();
            if (null == moIdList) {
                moIdList = new ArrayList();
            }
        }
        return moIdList;
    }

    @Override
    public void addUserMO(String username, Long moid) {
        String hql = "FROM UserInfo u where u.userName=?";
        List list = this.getHibernateTemplate().find(hql, new Object[]{username});
        if (list.isEmpty()) {
            return;
        }
        UserInfo user = (UserInfo)list.get(0);
        if (user.isIsAdmin()) {
            return;
        }
        UserRelMoInfo userRelMoInfo = new UserRelMoInfo();
        userRelMoInfo.setIsGroup(false);
        UserRelMo userRelMo = new UserRelMo();
        userRelMo.setMoId(moid);
        userRelMo.setUserId(user.getId());
        userRelMoInfo.setId(userRelMo);
        this.getHibernateTemplate().save((Object)userRelMoInfo);
    }

    @Override
    public Paging queryMoNotRelated(Map<String, Object> conditionMap, Boolean managed, int firstRowIndex, int totalRow, String orderByFieldParam, boolean orderByAscend, boolean isAdmin) {
        String orderByField = orderByFieldParam;
        if ("discoveredTimeStr".equals(orderByField)) {
            orderByField = "discoveredTime";
        }
        StringBuilder hql = new StringBuilder("from Node mo where mo.parentMo = null and mo.moId not in(select device2GroupInfo.moid from Device2GroupInfo device2GroupInfo) ");
        StringBuilder countHql = new StringBuilder("select count(*) from Node mo where mo.parentMo = null and mo.moId not in(select device2GroupInfo.moid from Device2GroupInfo device2GroupInfo) ");
        hql.append(" and mo.managed = ").append(managed);
        countHql.append(" and mo.managed = ").append(managed);
        Session session = null;
        Paging paging = new Paging();
        try {
            session = super.currentSession();
            Query query = null;
            Query countQuery = null;
            Map param = null;
            if (conditionMap != null) {
                Map<String, Object> map = this.processQueryCondition(conditionMap, orderByField, orderByAscend, hql, countHql, session);
                query = (Query)map.get("query");
                countQuery = (Query)map.get("countQuery");
                param = (Map)map.get("param");
            }
            LOGGER.info((Object)("query mo hql is : " + hql.toString() + ", countQuery is : " + countQuery));
            if (query == null) {
                if (this.checkParams(orderByField)) {
                    hql.append(" order by mo.").append(orderByField);
                    this.appendOrder(orderByAscend, hql);
                    hql.append(", mo.moId");
                }
                query = session.createQuery(hql.toString());
            }
            if (countQuery == null) {
                countQuery = session.createQuery(countHql.toString());
            }
            this.setParam(query, countQuery, param);
            Long totalCountWithoutPagingLong = (Long)countQuery.uniqueResult();
            int totalCountWithoutPaging = totalCountWithoutPagingLong.intValue();
            if (isAdmin && !orderByField.equals("name")) {
                query.setFirstResult(firstRowIndex);
                query.setMaxResults(totalRow);
            }
            List resultList = query.list();
            paging.setCount(totalCountWithoutPaging);
            paging.setData(resultList);
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)("runtime exception when query mo, conditionMap is : " + conditionMap + ", orderByField is : " + orderByField), (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)("exception when query mo, conditionMap is : " + conditionMap + ", orderByField is : " + orderByField), (Throwable)e);
        }
        return paging;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    private String getSecureString(String str) {
        if (str != null) {
            return str.replace("\r", "").replace("\n", "");
        }
        return str;
    }

    static class IPQUeryMoHibernateCallback
    implements HibernateCallback {
        private String ip;

        public IPQUeryMoHibernateCallback(String moIP) {
            this.ip = moIP;
        }

        public Object doInHibernate(Session session) {
            return session.createCriteria(TopoObject.class).add((Criterion)Restrictions.eq((String)"ipAddress", (Object)this.ip)).uniqueResult();
        }
    }

    static class TopoHibernateCallback
    implements HibernateCallback {
        private Long moid;

        public TopoHibernateCallback(Long moIdToLong) {
            this.moid = moIdToLong;
        }

        public Object doInHibernate(Session session) {
            Criteria c = session.createCriteria(TopoObject.class);
            c.add((Criterion)Restrictions.eq((String)"moId", (Object)this.moid));
            return c.uniqueResult();
        }
    }

    static class MoIdQueryHibernateCallback
    implements HibernateCallback {
        private Long moid;

        public MoIdQueryHibernateCallback(Long moIdLong) {
            this.moid = moIdLong;
        }

        public Object doInHibernate(Session session) {
            Criteria c = session.createCriteria(ManagedObject.class);
            c.add((Criterion)Restrictions.eq((String)"moId", (Object)this.moid));
            Object uniqueResult = c.uniqueResult();
            return uniqueResult;
        }
    }

    static class MoUuidHibernateCallback
    implements HibernateCallback {
        private String uuid;

        public MoUuidHibernateCallback(String uUIdStr) {
            this.uuid = uUIdStr;
        }

        public Object doInHibernate(Session session) {
            Criteria c = session.createCriteria(ManagedObject.class);
            c.add((Criterion)Restrictions.eq((String)"uuid", (Object)this.uuid));
            return c.uniqueResult();
        }
    }

    static class MoAndTypeHibernateCallback
    implements HibernateCallback {
        private Class<? extends ManagedObject> moClass;
        private long id;
        private Boolean managed;

        public MoAndTypeHibernateCallback(Class<? extends ManagedObject> mClass, long longId, Boolean isManaged) {
            this.moClass = mClass;
            this.id = longId;
            this.managed = isManaged;
        }

        public Object doInHibernate(Session session) {
            Criteria c = session.createCriteria(this.moClass);
            c.add((Criterion)Restrictions.eq((String)"moId", (Object)this.id));
            if (this.managed != null) {
                c.add((Criterion)Restrictions.eq((String)"managed", (Object)this.managed));
            }
            return c.uniqueResult();
        }
    }
}

