/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.service.dao;

import com.hs.lego.cbb.user.sdk.service.CheckChildrenMoUtil;
import com.hs.vsm.secservice.sdk.common.dao.BaseDao;
import com.huawei.atic.device.model.CollectorDevice;
import java.util.List;
import java.util.Map;

public class CollectorDeviceDao
extends BaseDao<CollectorDevice, Long> {
    public CollectorDeviceDao() {
        super(CollectorDevice.class);
    }

    public CollectorDevice save(CollectorDevice object) {
        return (CollectorDevice)super.save((Object)object);
    }

    public int getDevCountByCollectorId(Long collectorId, Map<String, String> queryMap) {
        StringBuffer hql = new StringBuffer();
        hql.append("select count(*) from CollectorDevice collectorDevice ");
        if (null != queryMap) {
            String id = String.valueOf(queryMap.get("currentUserId"));
            Long currentUserId = null;
            try {
                currentUserId = Long.valueOf(id);
            }
            catch (NumberFormatException e) {
                currentUserId = 1L;
            }
            String currentUserIsAdmin = queryMap.get("currentUserIsAdmin");
            Boolean currentUserIsAdminObj = true;
            if (null != currentUserIsAdmin && !"".equals(currentUserIsAdmin)) {
                currentUserIsAdminObj = Boolean.parseBoolean(currentUserIsAdmin);
            }
            if (null != currentUserId && currentUserIsAdminObj.equals(false)) {
                hql.append("," + CheckChildrenMoUtil.getInstanse().getGrantHqlObj());
            }
            hql.append(" where collectorDevice.collectorId = ? ");
            if (null != currentUserId && currentUserIsAdminObj.equals(false)) {
                hql.append(" and collectorDevice.deviceId = " + CheckChildrenMoUtil.getInstanse().getGrantHql(currentUserId.longValue()));
            }
        } else {
            hql.append(" where collectorDevice.collectorId = ? ");
        }
        Long devCount = (Long)super.getHibernateTemplate().find(hql.toString(), new Object[]{collectorId}).get(0);
        return devCount.intValue();
    }

    public List<CollectorDevice> getDeviceIdList(Long collectorId) {
        List list = this.findByHql(this.basicHql() + " where collectorId = ? ", collectorId);
        return list.isEmpty() ? null : list;
    }

    public List<Long> getDeviceIdList() {
        StringBuffer hql = new StringBuffer();
        hql.append("select distinct deviceId from CollectorDevice where deviceId <> NULL");
        return super.getHibernateTemplate().find(hql.toString(), new Object[0]);
    }

    public int delByCollectorId(Long collectorId) {
        try {
            List list = this.findByHql(this.basicHql() + " where collectorId = ? ", collectorId);
            if (!list.isEmpty()) {
                for (CollectorDevice cd : list) {
                    this.remove(cd.getId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("delete collector device realation failed! collectorId:" + collectorId), (Throwable)e);
            return -1;
        }
        return 0;
    }

    public void delByDevId(Long devId) {
        List list = this.findByHql(this.basicHql() + " where deviceId = ? ", devId);
        if (!list.isEmpty()) {
            for (CollectorDevice cd : list) {
                this.remove(cd.getId());
            }
        }
    }

    public Long getCollectorIdByDevId(Long devId) {
        StringBuffer hql = new StringBuffer();
        hql.append("select collectorId from CollectorDevice where deviceId = ? ");
        List collectorIds = super.getHibernateTemplate().find(hql.toString(), new Object[]{devId});
        if (collectorIds != null && !collectorIds.isEmpty()) {
            Long id = (Long)collectorIds.get(0);
            return id;
        }
        return null;
    }

    public List<CollectorDevice> getByCollectorIdAndDevId(Long collectorId, Long devId) {
        return this.findByHql(this.basicHql() + " where deviceId = ? and collectorId = ? ", new Object[]{devId, collectorId});
    }
}

