/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.service.impl;

import com.hs.atic.collector.entity.monitor.CollectorMonitorInfo;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.sdk.bis.form.BlackholeNpForm;
import com.hs.atic.sdk.bis.form.FaultSeverityRuleForm;
import com.hs.atic.sdk.bis.service.FaultSeverityRuleService;
import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.cbb.user.sdk.service.IUserMgr;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.service.dao.BlackholeNpDao;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.Collector;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.BinLogObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import com.huawei.atic.util.AticSecneConstants;
import com.huawei.atic.util.NfaFilterUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

public class CollectorServiceImpl
implements ICollectorService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private ReentrantLock lock = new ReentrantLock();
    private CollectorDao collectorDao;
    private BlackholeNpDao blackholeNpDaoCollector;
    private SecneCollectorRMIProxy collectorRMIProxy;
    private IUserMgr userMgr;
    private ILogHoldTimeService logHoldTimeService;
    private FaultSeverityRuleService faultSeverityRuleService;
    private IResourceService resourceService;
    private ICollectorDeviceService collectorDeviceService;
    private IDiscoveryService discoveryService;
    private IAticDeviceService aticDeviceService;
    private IAticDeviceNfaService aticDeviceNfaService;
    private IRestfulNfaService restfulNfaService;
    private IDataProtectService dataProtectService;

    @Override
    public List<CollectorInfo> listCollector(Map<String, String> queryMap) {
        ArrayList<CollectorInfo> collectorInfoList = new ArrayList<CollectorInfo>();
        List<Collector> collectorList = this.collectorDao.getAll(queryMap);
        for (Collector collector : collectorList) {
            CollectorInfo collectorInfo;
            CollectorInfo temp = this.toCollectorInfo(collector, collectorInfo = new CollectorInfo());
            if (temp == null) continue;
            temp.setDeviceCount(this.getDevCountByCollector(temp.getId(), queryMap));
            collectorInfoList.add(temp);
        }
        return collectorInfoList;
    }

    public List<String> listCollector() {
        ArrayList<String> collectoIpList = new ArrayList<String>();
        List<Collector> collectorList = this.collectorDao.getAll(new HashMap<String, String>());
        for (Collector collector : collectorList) {
            collectoIpList.add(collector.getIpAddress());
        }
        this.logger.info((Object)("listCollector is =" + collectoIpList));
        return collectoIpList;
    }

    private int getDevCountByCollector(long collectorId, Map<String, String> queryMap) {
        return this.collectorDeviceService.getDevCountByCollectorId(collectorId, queryMap);
    }

    private CollectorInfo toCollectorInfo(Collector collector, CollectorInfo collectorInfo) {
        if (null == collector) {
            return null;
        }
        if (null == collectorInfo) {
            collectorInfo = new CollectorInfo();
        }
        this.logger.info((Object)("collector info is  :" + collector.getDdosCollectorStatus()));
        collectorInfo.setId(collector.getMoId());
        collectorInfo.setName(collector.getCollectorName());
        collectorInfo.setIpAddress(collector.getIpAddress());
        collectorInfo.setType(collector.getCollectorType());
        collectorInfo.setEncrypKey(collector.getEncrypKey());
        collectorInfo.setStatus(collector.getDdosCollectorStatus());
        collectorInfo.setCpuUsed(collector.getCollectorCpuinfo());
        collectorInfo.setMemoryUsed(collector.getCollectorMemoryinfo());
        collectorInfo.setDiskInfo(collector.getCollectorDiskinfo());
        Class<?> clazz = collector.getClass();
        Properties properties = new Properties();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                properties.setProperty(field.getName(), String.valueOf(field.get(collector)));
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)"properties.setProperty", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error((Object)"properties.setProperty", (Throwable)e);
            }
        }
        this.logger.info((Object)("end collector info is  :" + collector.getDdosCollectorStatus()));
        return collectorInfo;
    }

    private CollectorInfo toCollectorInfo(Collector collector) {
        return this.toCollectorInfo(collector, null);
    }

    private Collector toCollector(CollectorInfo collectorInfo) {
        Collector collector = new Collector();
        collector.setMoId(collectorInfo.getId());
        collector.setCollectorName(collectorInfo.getName());
        collector.setName(collectorInfo.getName());
        collector.setIpAddress(collectorInfo.getIpAddress());
        collector.setCollectorType(collectorInfo.getType());
        collector.setEncrypKey(collectorInfo.getEncrypKey());
        collector.setDdosCollectorStatus(collectorInfo.getStatus());
        collector.setCollectorCpuinfo(collectorInfo.getCpuUsed());
        collector.setCollectorMemoryinfo(collectorInfo.getMemoryUsed());
        collector.setCollectorDiskinfo(collectorInfo.getDiskInfo());
        return collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addCollector(CollectorInfo collectorInfo, Long currentUserId) {
        this.lock.lock();
        try {
            long moId = 0L;
            this.validateCollectorInfo(collectorInfo);
            try {
                String collectorIp = collectorInfo.getIpAddress();
                CollectorMonitorInfo monitorInfo = this.getCcoMonitorInfo(collectorIp);
                if (null != monitorInfo) {
                    collectorInfo.setStatus(monitorInfo.getState());
                    collectorInfo.setCpuUsed(monitorInfo.getCpuUseRatio());
                    collectorInfo.setMemoryUsed(monitorInfo.getMemUseRatio());
                    List distInfoList = monitorInfo.getDiskList();
                    collectorInfo.setDiskInfo(AticUtil.transferDiskInfo((List)distInfoList));
                    this.updateCollectorDB(collectorInfo);
                    this.logger.info((Object)"add collector update collector db.");
                }
                moId = this.saveCollectorInfo2DB(collectorInfo);
                if (currentUserId > 0L && moId > 0L) {
                    HashSet<Long> userIds = new HashSet<Long>();
                    userIds.add(moId);
                    this.userMgr.grandObjectToUser(currentUserId.longValue(), userIds);
                }
                if (null == this.faultSeverityRuleService) {
                    this.faultSeverityRuleService = (FaultSeverityRuleService)ServiceContext.getInstance().getService("faultSeverityRuleService", FaultSeverityRuleService.class);
                }
                List<FaultSeverityRuleForm> faultSeverityRuleForms = this.faultSeverityRuleService.getAllRules();
                List<BlackholeNpForm> blackholeForms = this.blackholeNpDaoCollector.queryAllBlackholeNP();
                NotifyFaultSeverityRuleService client = this.collectorRMIProxy.getNotifyFaultSeverityRuleService(collectorIp);
                if (client != null) {
                    client.batchNotifySeverityRule(faultSeverityRuleForms);
                    client.saveAllConfigBlackholeNpData(blackholeForms);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"addCollector error!", (Throwable)e);
            }
            long l = moId;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateCollectorDB(CollectorInfo collectorInfo) {
        this.logger.info((Object)"----updateCollectorDB----");
        try {
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorInfo.getIpAddress());
            if (sysManagerService != null) {
                sysManagerService.updateSysVal("server_ip", System.getProperty("nms.server.host"));
                if (!"********".equals(collectorInfo.getEncrypKey())) {
                    sysManagerService.changeAESKeyStore(collectorInfo.getEncrypKey());
                }
                if (null == this.logHoldTimeService) {
                    this.logHoldTimeService = (ILogHoldTimeService)ServiceContext.getInstance().getService("logHoldTimeService", ILogHoldTimeService.class);
                }
                List<LogHoldTimeForm> logHoldTime = this.logHoldTimeService.findLogHoldTime();
                LogHoldTimeForm logHoldTimeForm = new LogHoldTimeForm();
                if (!logHoldTime.isEmpty()) {
                    logHoldTimeForm = logHoldTime.get(0);
                }
                String divertDelayTime = "300";
                if (logHoldTimeForm != null) {
                    if (logHoldTimeForm.getDivertDelayTime() != 0) {
                        divertDelayTime = String.valueOf(logHoldTimeForm.getDivertDelayTime());
                        sysManagerService.updateSysVal("divert_delay_time", divertDelayTime);
                    }
                    sysManagerService.setPartitionParameter(logHoldTimeForm.getHoldOriginal(), logHoldTimeForm.getHoldHour(), logHoldTimeForm.getHoldDay());
                }
            } else {
                this.logger.error((Object)"Add Collector.Get SysManagerService interface failed!");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Add Collector,Update collector.atic_system_conf table failed!", (Throwable)e);
        }
    }

    private void validateCollectorInfo(CollectorInfo collectorInfo) {
        String name = collectorInfo.getName();
        String ip = collectorInfo.getIpAddress();
        long id = collectorInfo.getId();
        if (ip != null && !ip.equals("") && this.collectorDao.isIpExists(id, ip)) {
            this.logger.info((Object)("collector ip exist :" + ip));
            throw new LegoCheckedException(570004L);
        }
        if (this.collectorDao.isNameExists(id, name)) {
            this.logger.info((Object)("collector name exist :" + name));
            throw new LegoCheckedException(570003L);
        }
    }

    @Override
    public boolean validateCollectorIpExist(Long id, String ip) {
        return ip != null && !ip.equals("") && this.collectorDao.isIpExists(id, ip);
    }

    private CollectorMonitorInfo getCcoMonitorInfo(String collectorIp) {
        try {
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorIp);
            if (sysManagerService != null) {
                String clientIp = System.getProperty("nms.server.host");
                this.logger.info((Object)("collector validate status,get hostname" + clientIp));
                CollectorMonitorInfo collectorInfo = sysManagerService.sayHello(clientIp, collectorIp);
                if (null != collectorInfo) {
                    this.logger.info((Object)("collector info is : " + collectorInfo));
                    return collectorInfo;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"get collector status error", (Throwable)e);
        }
        return null;
    }

    private long saveCollectorInfo2DB(CollectorInfo collectorInfo) {
        this.logger.info((Object)"------saveCollectorInfo2DB----");
        Collector collector = this.toCollector(collectorInfo);
        collector.setSupportPing(false);
        this.resourceService = this.getResourceService();
        if (this.resourceService != null) {
            collector.setMainType("atic.portal.mainType.collector");
            collector.setSubType("atic.portal.subType.ddosCollector");
            collector.setIsTopMo(true);
            if (collector.getMoId() == null || collector.getMoId() == 0L) {
                collector.setUuid(UUID.randomUUID().toString());
                this.resourceService.addMoAndSubMoWithoutDelete((ManagedObject)collector);
            } else {
                Collector original = this.collectorDao.findById(collector.getMoId());
                if (original == null) {
                    this.logger.error((Object)"Modify collector failed, the collector had been deleted already!");
                    return -2L;
                }
                String uuid = original.getUuid();
                collector.setUuid(uuid);
            }
            this.logger.info((Object)("-------save collector to db .ip is : " + this.getcleanedMessage(collector.getIpAddress()) + "!status is : " + collector.getDdosCollectorStatus()));
            if ("********".equals(collectorInfo.getEncrypKey())) {
                collector.setEncrypKey(this.getCollectorInfo(collector.getMoId()).getEncrypKey());
            }
            this.collectorDao.saveOrUpdate(collector);
            return collector.getMoId();
        }
        this.logger.error((Object)"Add Collector,get resourceService failed!");
        return -1L;
    }

    @Override
    public CollectorInfo modifyCollector(CollectorInfo collectorInfo) {
        long id;
        int status = collectorInfo.getStatus();
        this.logger.info((Object)("-----modify Collector ,ip is : " + this.getcleanedMessage(collectorInfo.getIpAddress()) + "!stauts is : " + status));
        if (status != 1) {
            throw new LegoCheckedException(570006L);
        }
        this.validateCollectorInfo(collectorInfo);
        String collectorIp = collectorInfo.getIpAddress();
        CollectorMonitorInfo monitorInfo = this.getCcoMonitorInfo(collectorIp);
        if (null != monitorInfo) {
            collectorInfo.setStatus(monitorInfo.getState());
            collectorInfo.setCpuUsed(monitorInfo.getCpuUseRatio());
            collectorInfo.setMemoryUsed(monitorInfo.getMemUseRatio());
            List distInfoList = monitorInfo.getDiskList();
            collectorInfo.setDiskInfo(AticUtil.transferDiskInfo((List)distInfoList));
            this.updateCollectorDB(collectorInfo);
            this.logger.info((Object)"add collector update collector db.");
        }
        if ((id = this.saveCollectorInfo2DB(collectorInfo)) == -2L) {
            throw new LegoCheckedException(570011L);
        }
        if (!"********".equals(collectorInfo.getEncrypKey())) {
            this.deployAESKey(collectorInfo);
        }
        return this.getCollectorInfo(id);
    }

    private void deployAESKey(CollectorInfo info) {
        List<Long> devIds = this.collectorDeviceService.getDeviceAccess(info.getId());
        ArrayList<String> cmds = new ArrayList<String>();
        ArrayList<String> reComd = new ArrayList<String>();
        cmds.add("system-view");
        reComd.add("system-view");
        cmds.add("anti-ddos packet-capture key " + info.getEncrypKey());
        reComd.add("anti-ddos packet-capture key ****** ");
        for (Long devId : devIds) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(devId);
            if (null == device) continue;
            if (device.getDeviceType() == 1) {
                List<String> results;
                String version = device.getVersion();
                if ("V100R001C00SPC300".equalsIgnoreCase(version) || AticUtil.isCmdSucess(results = this.aticDeviceService.execCmd(cmds, devId))) continue;
                ArrayList<String> newResult = new ArrayList<String>();
                for (String string : results) {
                    if (string.contains("anti-ddos packet-capture key")) {
                        newResult.add("anti-ddos packet-capture key ***");
                        continue;
                    }
                    newResult.add(string);
                }
                this.logger.error((Object)("deployAESKey failed! ,devid:" + devId + ",cmds :" + this.getcleanedMessage(((Object)reComd).toString()) + " results:" + this.getcleanedMessage(((Object)newResult).toString())));
                throw new LegoCheckedException(570016L);
            }
            if (device.getDeviceType() != 5) continue;
            AticDeviceNfa aticDeviceNfa = this.aticDeviceNfaService.findByMoid(devId);
            NfaInfoForm nfaInfoForm = new NfaInfoForm();
            nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
            nfaInfoForm.setIpAdress(device.getIpAddress());
            nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort());
            this.setRestFulCommand(info, nfaInfoForm);
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void setRestFulCommand(CollectorInfo cInfo, NfaInfoForm nfaInfoForm) {
        try {
            Result rt;
            BinLogObject binLogObject = new BinLogObject();
            if (null != cInfo) {
                binLogObject.setEncryKey(cInfo.getEncrypKey());
                binLogObject.setServerIp(cInfo.getIpAddress());
                binLogObject.setServerPort(AticSecneConstants.COLLECTOR_DEVICE_DEFAULT_PORT);
            }
            if (!NfaFilterUtil.isRestFulSucess(rt = this.restfulNfaService.restNfaConfBinLog(binLogObject, nfaInfoForm))) {
                this.logger.error((Object)"setRestFulCommand() Failure.");
                throw new LegoCheckedException(570016L);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"setRestFulCommand() exception", (Throwable)e);
            throw new LegoCheckedException(570016L, (Throwable)e);
        }
        this.logger.info((Object)"setRestFulCommand() Success.");
    }

    @Override
    public CollectorInfo deleteCollector(long id) {
        this.logger.info((Object)"-----deleteCollector-----");
        this.resourceService = this.getResourceService();
        Collector collector = this.collectorDao.findById(id);
        if (collector == null) {
            throw new LegoCheckedException(570007L);
        }
        this.collectorDeviceService.delByCollectorId(id);
        BatchOperation legoBo = new BatchOperation();
        legoBo.setTargetId(collector.getMoId().longValue());
        ArrayList<BatchOperation> legoList = new ArrayList<BatchOperation>();
        legoList.add(legoBo);
        this.discoveryService.deleteDeviceNew(legoList, 1L);
        return this.toCollectorInfo(collector);
    }

    @Override
    public BatchOperationResult batchDeleteCollector(List<BatchOperation> boList) {
        this.logger.info((Object)"-----batchDeleteCollector-----");
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        for (BatchOperation bo : boList) {
            try {
                this.deleteCollector(bo.getTargetId());
                bo.setOptDetail("common.collector.delete.success");
            }
            catch (LegoCheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                bo.setOptDetail("common.collector.delete.fail");
            }
            catch (LegoUncheckedException e) {
                ++fail;
                bo.setErrorCode(e.getErrorCode());
                bo.setOptDetail("common.collector.delete.fail");
            }
            catch (Exception x) {
                ++fail;
                bo.setErrorCode(200L);
                bo.setOptDetail("common.collector.delete.fail");
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        return result;
    }

    @Override
    public int validateLogin(CollectorInfo collectorInfo) {
        this.logger.info((Object)"-----validateLogin-----");
        try {
            SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorInfo.getIpAddress());
            if (sysManagerService == null) {
                throw new Exception();
            }
            String clientIp = System.getProperty("nms.server.host");
            CollectorMonitorInfo collectorMonitorInfo = sysManagerService.sayHello(clientIp, collectorInfo.getIpAddress());
            if (collectorMonitorInfo == null) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public CollectorInfo getCollectorInfo(long id) {
        this.logger.info((Object)"-----getCollectorInfo-----");
        Collector collector = this.collectorDao.findById(id);
        return this.toCollectorInfo(collector);
    }

    @Override
    public CollectorInfo getCollectorInfo(String collectorIp) {
        this.logger.info((Object)"-----getCollectorInfo-----");
        Collector collector = this.collectorDao.findByIp(collectorIp);
        return this.toCollectorInfo(collector);
    }

    public String getCollectorByIp(String collectorIp) {
        return this.collectorDao.getCollectorByIp(collectorIp);
    }

    private IResourceService getResourceService() {
        if (null == this.resourceService) {
            this.resourceService = (IResourceService)ServiceContext.getInstance().getService("resourceService", IResourceService.class);
        }
        return this.resourceService;
    }

    @Override
    public long addCollector(CollectorInfo collectorInfo) {
        return 0L;
    }

    @Override
    public List<Collector> getAllCollector() {
        return this.collectorDao.getAll();
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public SecneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(SecneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IDiscoveryService getDiscoveryService() {
        return this.discoveryService;
    }

    public void setDiscoveryService(IDiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    public ICollectorDeviceService getCollectorDeviceService() {
        return this.collectorDeviceService;
    }

    public void setCollectorDeviceService(ICollectorDeviceService collectorDeviceService) {
        this.collectorDeviceService = collectorDeviceService;
    }

    public IUserMgr getUserMgr() {
        return this.userMgr;
    }

    public void setUserMgr(IUserMgr userMgr) {
        this.userMgr = userMgr;
    }

    public IRestfulNfaService getRestfulNfaService() {
        return this.restfulNfaService;
    }

    public void setRestfulNfaService(IRestfulNfaService restfulNfaService) {
        this.restfulNfaService = restfulNfaService;
    }

    public IAticDeviceNfaService getAticDeviceNfaService() {
        return this.aticDeviceNfaService;
    }

    public void setAticDeviceNfaService(IAticDeviceNfaService aticDeviceNfaService) {
        this.aticDeviceNfaService = aticDeviceNfaService;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public BlackholeNpDao getBlackholeNpDaoCollector() {
        return this.blackholeNpDaoCollector;
    }

    public void setBlackholeNpDaoCollector(BlackholeNpDao blackholeNpDaoCollector) {
        this.blackholeNpDaoCollector = blackholeNpDaoCollector;
    }
}

