/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.util;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public final class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonUtils UTILS = new JsonUtils();
    private static ReentrantLock lock = new ReentrantLock();

    private JsonUtils() {
    }

    public static JsonUtils getInstance() {
        return UTILS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String objectToJsonString(Object value) {
        lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            try {
                sb.append(MAPPER.writeValueAsString(value));
            }
            catch (JsonGenerationException e) {
                throw new IllegalArgumentException("objectToJsonString():", e);
            }
            catch (JsonMappingException e) {
                throw new IllegalArgumentException("objectToJsonString():", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("objectToJsonString():", e);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public <T> T jsonStringToObject(String src, Class<T> type) {
        lock.lock();
        try {
            Object t;
            Object object = t = MAPPER.readValue(src, type);
            return (T)object;
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("jsonStringToObject():", e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException("jsonStringToObject():", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jsonStringToObject():", e);
        }
        finally {
            lock.unlock();
        }
    }
}

