/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class StringProcess {
    public static String convertNullToBLANK(String s) {
        return s == null || s.equals("") ? "&nbsp;" : s;
    }

    public static String[] getArrayStringForCom(String s) {
        String[] strs = null;
        if (s != null) {
            strs = s.split(",");
        }
        return strs;
    }

    public static String[] getArrayStringForSem(String s) {
        String[] strs = null;
        if (s != null) {
            strs = s.split(";");
        }
        return strs;
    }

    public static String[] getArrayStringForBR(String s) {
        String[] strs = null;
        if (s != null) {
            strs = s.split("<br/>");
        }
        return strs;
    }

    public static String[] getArrayStringForPeriod(String s) {
        String[] strs = null;
        if (s != null) {
            strs = s.split("\\.");
        }
        return strs;
    }

    public static String[] getArrayStringForFslash(String s) {
        String[] strs = null;
        if (s != null) {
            strs = s.split("/");
        }
        return strs;
    }

    public static String intArrToString(int[] ids) {
        String idsStr = "";
        if (ids != null && ids.length > 0) {
            String temp = ArrayUtils.toString((Object)ids);
            idsStr = temp.substring(1, temp.length() - 1);
        }
        return idsStr;
    }

    public static String shortArrToString(short[] shortArr) {
        String shortArrStr = "";
        if (shortArr != null && shortArr.length > 0) {
            String temp = ArrayUtils.toString((Object)shortArr);
            shortArrStr = temp.substring(1, temp.length() - 1);
        }
        return shortArrStr;
    }

    public static String stringArrToString(String[] stringArr) {
        String stringArrStr = "";
        if (stringArr != null && stringArr.length > 0) {
            String temp = ArrayUtils.toString((Object)stringArr);
            stringArrStr = temp.substring(1, temp.length() - 1);
        }
        return stringArrStr;
    }

    public static List<Integer> getListFromStr(String str) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (str != null && str.length() > 0) {
            String[] ids;
            for (String s : ids = str.split(",")) {
                result.add(Integer.valueOf(s));
            }
        }
        return result;
    }

    public static int[] getArrayFromStr(String str) {
        int[] result = new int[]{};
        if (str != null) {
            String[] ss = str.split(",");
            result = new int[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                result[i] = Integer.parseInt(ss[i]);
            }
        }
        return result;
    }

    public static boolean isNull(String s) {
        return StringUtils.isBlank((CharSequence)s) || s == null;
    }

    public static boolean containInvalidCharactor(String str) {
        String s = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_.- ";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (s.indexOf(c) != -1 || c > '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfChinese(String str) {
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) <= '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String escapeXml(String str) {
        String strXml = "";
        if (!StringProcess.isNull(str)) {
            strXml = str.replace("&", "&amp;");
            strXml = strXml.replace("<", "&lt;");
            strXml = strXml.replace(">", "&gt;");
            strXml = strXml.replace("'", "&#039;");
            strXml = strXml.replace("\"", "&#034;");
        }
        return strXml;
    }

    public static String formatAltString(String str) {
        StringBuffer formatStr = new StringBuffer();
        int maxLength = 80;
        while (str.length() > maxLength) {
            formatStr.append(str.substring(0, maxLength) + " ");
            str = str.substring(maxLength);
        }
        formatStr.append(str);
        return formatStr.toString();
    }

    public static String stringArrToStringByTILDE(String[] stringArr) {
        StringBuffer sb = new StringBuffer("");
        if (stringArr != null && stringArr.length > 0) {
            for (String str : stringArr) {
                sb.append(str).append("~");
            }
        }
        return sb.toString();
    }

    public static int idsStr2Int(String idsStr) {
        if (StringUtils.isBlank((CharSequence)idsStr)) {
            return 0;
        }
        String[] idsArr = idsStr.split(",");
        int ret = 0;
        for (String id : idsArr) {
            ret |= Integer.parseInt(id);
        }
        return ret;
    }

    public static String int2IdsStr(int v) {
        int iNT0BIT0LEN = 32;
        StringBuffer ret = new StringBuffer("");
        int j = 0;
        for (int i = 0; i < 31; ++i) {
            j = 1 << i;
            if ((v & j) == 0) continue;
            ret.append(j).append(",");
        }
        if (ret.length() > 0) {
            ret.deleteCharAt(ret.length() - 1);
        }
        return ret.toString();
    }

    public static String descOfIdsWithNewline(String descOfIds, int numberOfLine, String joinStr) {
        if (StringUtils.isBlank((CharSequence)descOfIds) || numberOfLine == 0) {
            return descOfIds;
        }
        String[] descOfIdArr = descOfIds.split(",");
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < descOfIdArr.length - 1) {
            result.append(descOfIdArr[i]).append(",");
            if (++i % numberOfLine != 0) continue;
            result.append(joinStr);
        }
        result.append(descOfIdArr[i]);
        return result.toString();
    }

    public static String convertSymbo(String condition) {
        condition = condition.replace("\\", "\\\\");
        condition = condition.replace("\"", "\\\"");
        return condition;
    }

    public static String listToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        if (null != list) {
            for (String s : list) {
                sb.append(s).append("|");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }
}

