/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.comm.south.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.south.model.FtpPara;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;

public class FtpUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final int TIME_OUT = 20000;

    public static void downloadFileByFtp(String ftpServerIp, int ftpPort, String userName, String password, String remoteRelativePath, String localPath, boolean isBinaryTransfer, int connectTimeout) throws LegoCheckedException {
        LOGGER.info((Object)("download file by ftp, ftpServerIp : " + ftpServerIp + ", ftpPort : " + ftpPort + ", userName : " + userName + ", remoteRelativePath : " + remoteRelativePath + ", localPath : " + localPath + ", connectTimeout : " + connectTimeout));
        FTPClient ftp = new FTPClient();
        OutputStream output = null;
        ftp.setConnectTimeout(connectTimeout);
        ftp.setDefaultPort(ftpPort);
        try {
            ftp.connect(ftpServerIp);
            int replyCode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftp.disconnect();
                LOGGER.error((Object)"FTP server refused connection.");
                throw new LegoCheckedException(512L);
            }
        }
        catch (IOException e) {
            FtpUtil.disConnectFtp(ftp);
            LOGGER.error((Object)"Could not connect to server.");
            throw new LegoCheckedException(513L);
        }
        try {
            if (!ftp.login(userName, password)) {
                ftp.logout();
                LOGGER.error((Object)"user name or password error.");
                throw new LegoCheckedException(514L);
            }
            LOGGER.info((Object)("remote system is " + ftp.getSystemName()));
            if (isBinaryTransfer) {
                ftp.setFileType(2);
            }
            ftp.enterLocalPassiveMode();
            output = new FileOutputStream(localPath);
            if (!ftp.retrieveFile(remoteRelativePath, output)) {
                LOGGER.error((Object)"transfer file failed");
                throw new LegoCheckedException(515L);
            }
            ftp.logout();
        }
        catch (FTPConnectionClosedException e) {
            LOGGER.error((Object)"Server closed connection.", (Throwable)e);
            throw new LegoCheckedException(516L);
        }
        catch (IOException e) {
            LOGGER.error((Object)"FTP transfer error.", (Throwable)e);
            throw new LegoCheckedException(515L);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"IOException error");
                }
            }
            FtpUtil.disConnectFtp(ftp);
        }
    }

    public static void downloadFileByFtp(String ftpServerIp, int ftpPort, String userName, String password, String remoteRelativePath, String localPath, boolean isBinaryTransfer) throws LegoCheckedException {
        FtpUtil.downloadFileByFtp(ftpServerIp, ftpPort, userName, password, remoteRelativePath, localPath, isBinaryTransfer, 20000);
    }

    public static void uploadFileByFtp(String ftpServerIp, int ftpPort, String userName, String password, String remoteRelativePath, String localPath, boolean isBinaryTransfer, int connectTimeout) throws LegoCheckedException {
        LOGGER.info((Object)("upload file by ftp, ftpServerIp : " + ftpServerIp + ", ftpPort : " + ftpPort + ", userName : " + userName + ", remoteRelativePath : " + remoteRelativePath + ", localPath : " + localPath + ", connectTimeout : " + connectTimeout));
        InputStream input = null;
        FTPClient ftp = new FTPClient();
        ftp.setConnectTimeout(connectTimeout);
        ftp.setDefaultPort(ftpPort);
        try {
            ftp.connect(ftpServerIp);
            int replyCode = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                ftp.disconnect();
                LOGGER.error((Object)"FTP server refused connection.");
                throw new LegoCheckedException(512L);
            }
        }
        catch (IOException e) {
            FtpUtil.disConnectFtp(ftp);
            LOGGER.error((Object)"Could not connect to server.");
            throw new LegoCheckedException(513L);
        }
        try {
            if (!ftp.login(userName, password)) {
                ftp.logout();
                LOGGER.error((Object)"user name or password error.");
                throw new LegoCheckedException(514L);
            }
            LOGGER.info((Object)("remote system is " + ftp.getSystemName()));
            if (isBinaryTransfer) {
                ftp.setFileType(2);
            }
            ftp.enterLocalPassiveMode();
            input = new FileInputStream(localPath);
            if (!ftp.storeFile(remoteRelativePath, input)) {
                LOGGER.error((Object)"upload file failed");
                throw new LegoCheckedException(515L);
            }
            ftp.logout();
        }
        catch (FTPConnectionClosedException e) {
            LOGGER.error((Object)"Server closed connection.", (Throwable)e);
            throw new LegoCheckedException(516L);
        }
        catch (IOException e) {
            LOGGER.error((Object)"FTP transfer error.");
            throw new LegoCheckedException(515L);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"IOException error");
                }
            }
            FtpUtil.disConnectFtp(ftp);
        }
    }

    public static void uploadFileByFtp(String ftpServerIp, int ftpPort, String userName, String password, String remoteRelativePath, String localPath, boolean isBinaryTransfer) throws LegoCheckedException {
        FtpUtil.uploadFileByFtp(ftpServerIp, ftpPort, userName, password, remoteRelativePath, localPath, isBinaryTransfer, 20000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFtpReachable(FtpPara ftpPara) {
        StringBuffer ftpPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)ftpPara.getFtpPassWord());
        if (ftpPara.getProtocol() == 0) {
            FTPClient ftp = new FTPClient();
            ftp.setConnectTimeout(20000);
            ftp.setDefaultPort(ftpPara.getPort().intValue());
            try {
                ftp.connect(ftpPara.getServiceIp());
                int replyCode = ftp.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                    ftp.disconnect();
                    LOGGER.error((Object)"FTP server refused connection.");
                    throw new LegoCheckedException(512L);
                }
            }
            catch (IOException e) {
                FtpUtil.disConnectFtp(ftp);
                LOGGER.error((Object)"Could not connect to server.");
                throw new LegoCheckedException(513L);
            }
            try {
                if (!ftp.login(ftpPara.getUserName(), ftpPwd.toString())) {
                    ftp.logout();
                    LOGGER.error((Object)"user name or password error.");
                    throw new LegoCheckedException(514L);
                }
                LOGGER.info((Object)("remote system is " + ftp.getSystemName()));
                ftp.logout();
                boolean e = true;
                return e;
            }
            catch (FTPConnectionClosedException e) {
                LOGGER.error((Object)"Server closed connection.", (Throwable)e);
                throw new LegoCheckedException(516L);
            }
            catch (IOException e) {
                LOGGER.error((Object)"FTP transfer error.");
            }
            finally {
                FtpUtil.disConnectFtp(ftp);
            }
            return false;
        }
        JSch jsch = FtpUtil.initJsch(ftpPara.getServiceIp(), ftpPara.getHostKey());
        Session session = null;
        try {
            session = jsch.getSession(ftpPara.getUserName(), ftpPara.getServiceIp(), ftpPara.getPort().intValue());
            session.setPassword(ftpPwd.toString());
            session.setConfig("StrictHostKeyChecking", "no");
            session.setConfig("cipher.c2s", "aes256-ctr");
            session.setConfig("mac.c2s", "hmac-sha2-256");
            session.setConfig("cipher.s2c", "aes256-ctr");
            session.setConfig("mac.s2c", "hmac-sha2-256");
            session.setConfig("CheckCiphers", "aes256-ctr");
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            boolean bl = true;
            return bl;
        }
        catch (JSchException e) {
            LOGGER.error((Object)"exceptino happend when use jsch sftp", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return false;
    }

    private static void disConnectFtp(FTPClient ftp) {
        if (ftp.isConnected()) {
            try {
                ftp.disconnect();
            }
            catch (IOException f) {
                LOGGER.error((Object)"disconnect ftp exception");
            }
        }
    }

    private static JSch initJsch(String ip, String hostKey) {
        JSch jsch = new JSch();
        ByteArrayInputStream in = null;
        if (null != hostKey && !"".equals(hostKey)) {
            LOGGER.info((Object)"hostKey will be validate");
            StringBuffer buffer = new StringBuffer();
            buffer.append(ip);
            buffer.append(" ");
            buffer.append("ssh-rsa");
            buffer.append(" ");
            buffer.append(hostKey);
            try {
                in = new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                jsch.setKnownHosts((InputStream)in);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("get hostkey info error" + e.getMessage()));
                throw new LegoCheckedException(571904L);
            }
            catch (JSchException e) {
                LOGGER.error((Object)(ip + "-The sftp server hostkey was not accepted by the verifier callback!"));
                throw new LegoCheckedException(571904L);
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"IOException error");
                    }
                }
            }
        }
        LOGGER.info((Object)"hostKey is null, hostKey will not be validate");
        return jsch;
    }
}

