/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.common.snmp;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.common.snmp.SnmpParameter;
import com.huawei.atic.common.snmp.SnmpV3TablePDUFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public final class SnmpUtil {
    public static final int MD5_AUTH_NUM = 20;
    public static final int SHA_AUTH_NUM = 22;
    public static final int DES_NUM = 50;
    public static final int AES_NUM = 49;
    public static final int AES128_NUM = 48;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    private SnmpUtil() {
    }

    public static String snmpGet(SnmpParameter snmpPara, String oid) throws IOException {
        if (snmpPara == null || oid == null || oid.length() == 0) {
            return null;
        }
        String value = null;
        ArrayList<String> listOid = new ArrayList<String>(1);
        listOid.add(oid);
        List<String> listResult = SnmpUtil.getMibStringValueFromAgent(snmpPara, listOid, -96);
        if (!listResult.isEmpty()) {
            value = listResult.get(0);
        }
        return value;
    }

    public static List<String> snmpGetList(SnmpParameter snmpPara, List<String> snmpOids) throws IOException {
        if (snmpPara == null || snmpOids == null || snmpOids.isEmpty()) {
            return null;
        }
        int pduType = snmpPara.getVersion() == 0 ? -96 : -91;
        return SnmpUtil.getMibStringValueFromAgent(snmpPara, snmpOids, pduType);
    }

    public static List<String[]> snmpGetTable(SnmpParameter snmpPara, String[] snmpOids) throws IOException {
        List<TableEvent> tableEventList = SnmpUtil.snmpGetTableOrigial(snmpPara, snmpOids);
        return SnmpUtil.processTableEventList(tableEventList);
    }

    public static List<TableEvent> snmpGetTableOrigial(SnmpParameter snmpPara, String[] snmpOids) throws IOException {
        if (snmpPara == null || snmpOids == null || snmpOids.length == 0) {
            return null;
        }
        int pduType = snmpPara.getVersion() == 0 ? -96 : -91;
        return SnmpUtil.getMibTableValues(snmpPara, snmpOids, pduType);
    }

    private static synchronized List<String> getMibStringValueFromAgent(SnmpParameter snmpPara, List<String> snmpoids, int pduType) throws IOException {
        List<String> snmpList = new ArrayList<String>();
        try {
            int timeout = snmpPara.getTimeout();
            snmpPara.setTimeout(timeout * 1000);
            ResponseEvent response = null;
            response = snmpPara.getVersion() == 3 ? SnmpUtil.snmpv3Get(snmpPara, snmpoids, pduType) : SnmpUtil.snmpv2Get(snmpPara, snmpoids, pduType);
            snmpPara.setTimeout(timeout);
            snmpList = SnmpUtil.getSnmpStringResultByResponse(response, snmpoids);
        }
        catch (Exception e) {
            LOGGER.error((Object)"getMibStringValueFromAgent error", (Throwable)e);
        }
        return snmpList;
    }

    private static List<TableEvent> getMibTableValues(SnmpParameter snmpPara, String[] snmpoids, int pduType) throws IOException {
        int timeout = snmpPara.getTimeout();
        snmpPara.setTimeout(timeout * 1000);
        List<TableEvent> returnList = null;
        returnList = snmpPara.getVersion() == 3 ? SnmpUtil.snmpv3GetTable(snmpPara, snmpoids, pduType) : SnmpUtil.snmpv2GetTable(snmpPara, snmpoids, pduType);
        snmpPara.setTimeout(timeout);
        return returnList;
    }

    private static List<TableEvent> snmpv3GetTable(SnmpParameter snmpPara, String[] snmpoids, int pduType) throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        UsmUser user = SnmpUtil.createUsmUser(snmpPara);
        if (snmpPara.getContextEngineId() != null) {
            snmp.getUSM().addUser(SnmpUtil.getOctString(snmpPara.getSecurityName()), SnmpUtil.getOctString(snmpPara.getContextEngineId()), user);
        } else {
            snmp.getUSM().addUser(SnmpUtil.getOctString(snmpPara.getSecurityName()), null, user);
        }
        snmp.listen();
        UserTarget target = SnmpUtil.createUserTarget(snmpPara, snmpPara.getDeviceIp());
        if (SnmpUtil.getSnmpAuthProtocolOID(snmpPara) == null) {
            target.setSecurityLevel(1);
        } else if (SnmpUtil.getSnmpPrivateProtocolOID(snmpPara) != null) {
            target.setSecurityLevel(3);
        } else {
            target.setSecurityLevel(2);
        }
        TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new SnmpV3TablePDUFactory(pduType, snmpPara));
        utils.setMaxNumRowsPerPDU(5);
        OID[] columnOids = new OID[snmpoids.length];
        for (int i = 0; i < snmpoids.length; ++i) {
            columnOids[i] = new OID(snmpoids[i]);
        }
        List tableEventList = utils.getTable((Target)target, columnOids, null, null);
        snmp.close();
        return tableEventList;
    }

    private static List<TableEvent> snmpv2GetTable(SnmpParameter snmpPara, String[] snmpoids, int pduType) throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        snmp.listen();
        TableUtils utils = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory(pduType));
        utils.setMaxNumRowsPerPDU(5);
        OID[] columnOids = new OID[snmpoids.length];
        for (int i = 0; i < snmpoids.length; ++i) {
            columnOids[i] = new OID(snmpoids[i]);
        }
        List tableEventList = utils.getTable((Target)SnmpUtil.createCommunityTargetOfV2Snmp(snmpPara, snmpPara.getDeviceIp()), columnOids, null, null);
        snmp.close();
        return tableEventList;
    }

    private static List<String[]> processTableEventList(List<TableEvent> tableEventList) {
        ArrayList<String[]> returnList = new ArrayList<String[]>();
        if (null == tableEventList || tableEventList.isEmpty()) {
            return returnList;
        }
        for (TableEvent item : tableEventList) {
            VariableBinding[] vb = item.getColumns();
            if (vb == null) continue;
            String[] row = new String[vb.length];
            for (int j = 0; j < vb.length; ++j) {
                row[j] = vb[j].getVariable().toString();
            }
            returnList.add(row);
        }
        return returnList;
    }

    private static OID getSnmpAuthProtocolOID(SnmpParameter snmp) {
        int authProtocolNum = snmp.getAuthProtocolNum();
        if (authProtocolNum == 20) {
            return AuthMD5.ID;
        }
        if (authProtocolNum == 22) {
            return AuthSHA.ID;
        }
        return null;
    }

    private static OID getSnmpPrivateProtocolOID(SnmpParameter snmp) {
        int privateProtocolNum = snmp.getEncryptProtocolNum();
        if (privateProtocolNum == 50) {
            return PrivDES.ID;
        }
        if (privateProtocolNum == 49) {
            return PrivAES256.ID;
        }
        if (privateProtocolNum == 48) {
            return PrivAES128.ID;
        }
        return null;
    }

    private static OctetString getOctString(String value) {
        if (value != null) {
            return new OctetString(value);
        }
        return null;
    }

    private static UserTarget createUserTarget(SnmpParameter snmpPara, String ipAddress) {
        UserTarget target = new UserTarget();
        UdpAddress targetaddress = new UdpAddress(ipAddress + "/" + snmpPara.getPort());
        target.setAddress((Address)targetaddress);
        target.setRetries(snmpPara.getRetries());
        target.setTimeout((long)snmpPara.getTimeout());
        target.setVersion(snmpPara.getVersion());
        target.setSecurityName(SnmpUtil.getOctString(snmpPara.getSecurityName()));
        return target;
    }

    private static UsmUser createUsmUser(SnmpParameter snmpPara) {
        String authPwd = null;
        String encryPwd = null;
        if (null != snmpPara.getAuthPwd()) {
            authPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getAuthPwd()).toString();
        }
        if (null != snmpPara.getEncryptPwd()) {
            encryPwd = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getEncryptPwd()).toString();
        }
        return new UsmUser(SnmpUtil.getOctString(snmpPara.getSecurityName()), SnmpUtil.getSnmpAuthProtocolOID(snmpPara), SnmpUtil.getOctString(authPwd), SnmpUtil.getSnmpPrivateProtocolOID(snmpPara), SnmpUtil.getOctString(encryPwd));
    }

    private static ResponseEvent snmpv2Get(SnmpParameter snmpPara, List<String> targetOidList, int pduType) throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        snmp.listen();
        CommunityTarget comtarget = SnmpUtil.createCommunityTargetOfV2Snmp(snmpPara, snmpPara.getDeviceIp());
        PDU pdu = new PDU();
        SnmpUtil.addOid2Pdu(pdu, targetOidList);
        pdu.setType(pduType);
        ResponseEvent response = snmp.get(pdu, (Target)comtarget);
        snmp.close();
        return response;
    }

    private static synchronized ResponseEvent snmpv3Get(SnmpParameter snmpPara, List<String> targetOidList, int pduType) throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
        UsmUser user = SnmpUtil.createUsmUser(snmpPara);
        if (snmpPara.getContextEngineId() != null && !"".equals(snmpPara.getContextEngineId())) {
            snmp.getUSM().addUser(SnmpUtil.getOctString(snmpPara.getSecurityName()), SnmpUtil.getOctString(snmpPara.getContextEngineId()), user);
        } else {
            snmp.getUSM().addUser(SnmpUtil.getOctString(snmpPara.getSecurityName()), null, user);
        }
        snmp.listen();
        UserTarget target = SnmpUtil.createUserTarget(snmpPara, snmpPara.getDeviceIp());
        if (SnmpUtil.getSnmpAuthProtocolOID(snmpPara) == null) {
            target.setSecurityLevel(1);
        } else if (SnmpUtil.getSnmpPrivateProtocolOID(snmpPara) != null) {
            target.setSecurityLevel(3);
        } else {
            target.setSecurityLevel(2);
        }
        ScopedPDU pdu = new ScopedPDU();
        SnmpUtil.addOid2Pdu((PDU)pdu, targetOidList);
        pdu.setType(pduType);
        if (snmpPara.getContextName() != null && !"".equals(snmpPara.getContextName())) {
            pdu.setContextName(SnmpUtil.getOctString(snmpPara.getContextName()));
        }
        if (snmpPara.getContextEngineId() != null && !"".equals(snmpPara.getContextEngineId())) {
            pdu.setContextEngineID(SnmpUtil.getOctString(snmpPara.getContextEngineId()));
        }
        ResponseEvent response = snmp.get((PDU)pdu, (Target)target);
        snmp.close();
        return response;
    }

    private static void addOid2Pdu(PDU pdu, List<String> targetOidList) {
        for (String oidValue : targetOidList) {
            pdu.add(new VariableBinding(new OID(oidValue)));
        }
    }

    private static synchronized List<String> getSnmpStringResultByResponse(ResponseEvent responseEvent, List<String> snmpOids) {
        ArrayList<String> result = new ArrayList<String>();
        PDU response = responseEvent.getResponse();
        if (response != null && response.getErrorStatus() == 0) {
            Vector vbs = response.getVariableBindings();
            for (VariableBinding vb : vbs) {
                String oid = vb.getOid().toString();
                if (snmpOids.contains(oid)) {
                    result.add(vb.getVariable().toString());
                    continue;
                }
                result.clear();
                break;
            }
        }
        return result;
    }

    private static CommunityTarget createCommunityTargetOfV2Snmp(SnmpParameter snmpPara, String ipAddress) {
        CommunityTarget comtarget = new CommunityTarget();
        StringBuffer readComm = DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpPara.getReadComm());
        OctetString community = SnmpUtil.getOctString(readComm.toString());
        comtarget.setCommunity(community);
        comtarget.setVersion(snmpPara.getVersion());
        UdpAddress targetaddress = new UdpAddress(ipAddress + "/" + snmpPara.getPort());
        comtarget.setAddress((Address)targetaddress);
        comtarget.setRetries(snmpPara.getRetries());
        comtarget.setTimeout((long)snmpPara.getTimeout());
        return comtarget;
    }
}

