/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.defendgroup.action;

import com.hs.atic.bis.util.BisConstants;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.RadioBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpSession;

public class DefendGroupAction
extends BaseAction {
    private static final long serialVersionUID = -5222724230518465819L;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private transient IDefendGroupService defendGroupService;
    private IAticDeviceService aticDeviceService;
    private String sortType;
    private String sortField;
    private List<DefendGroupForm> defendGroupFormList;
    private DefendGroupForm defendGroupForm;
    private Long defendGroupId;
    private String configGroupId;
    private String configIds;
    private Long[] ids;
    private String groupName;
    private String[] names;
    private List<AticDevice> firewallList;
    private List<AticDevice> firewallListBelongMe;
    private StringBuffer submitToken = new StringBuffer();
    private List<RadioBean> detectModeCombData;
    private List<RadioBean> cleanModeCombData;
    private List<LangPair> groupCombData;
    private String netModeCombData;
    private Long[] removeIds;
    private Long[] addIds;
    private String editType;

    public String listDefendGroup() {
        this.clearFirewallList();
        Paging page = this.defendGroupService.queryByPage(this.createQueryMap(), this.getStart(), this.getPageSize());
        this.defendGroupFormList = page.getData();
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getDeviceInfo(this.defendGroupFormList);
        this.getUpstreamGroupInfo(this.defendGroupFormList);
        this.setTotal(page.getCount());
        LOG.info((Object)("query defend group list, size = " + this.defendGroupFormList.size()));
        return "list";
    }

    public String showAddDefendGroup() {
        LOG.info((Object)"prepare to add defend group");
        this.initComb();
        this.submitToken = new StringBuffer(UUID.randomUUID().toString());
        return "add";
    }

    public List<AticDevice> queryFirewallList() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        List<AticDevice> queryFirewallList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
        List<AticDevice> nfaList = this.aticDeviceService.getSyslogDevice(currentUser.getUserID());
        List<AticDevice> nfa2000VList = this.aticDeviceService.getClusterAndNfa(currentUser.getUserID());
        if (null == queryFirewallList) {
            return new ArrayList<AticDevice>();
        }
        for (AticDevice eachNfa : nfaList) {
            if (queryFirewallList.contains(eachNfa)) continue;
            queryFirewallList.add(eachNfa);
        }
        if (!nfa2000VList.isEmpty()) {
            for (AticDevice nfa2000V : nfa2000VList) {
                if (queryFirewallList.contains(nfa2000V)) continue;
                queryFirewallList.add(nfa2000V);
            }
        }
        this.filterDeviceList(queryFirewallList);
        return queryFirewallList;
    }

    public void clearFirewallList() {
        List idListForOr = (List)this.getSession().getAttribute("idListForOr");
        List idListForMe = (List)this.getSession().getAttribute("idListForMe");
        if (null != idListForOr) {
            this.getSession().removeAttribute("idListForOr");
        }
        if (null != idListForMe) {
            this.getSession().removeAttribute("idListForMe");
        }
    }

    public String showAddFirewallList() {
        List idListForMe;
        List idListForOr = (List)this.getSession().getAttribute("idListForOr");
        List<AticDevice> filterFirewallList = this.queryFirewallList();
        if (null != idListForOr) {
            Iterator<AticDevice> iterator = filterFirewallList.iterator();
            while (iterator.hasNext()) {
                AticDevice firewall = iterator.next();
                if (!idListForOr.contains(firewall.getMoId())) continue;
                iterator.remove();
            }
        }
        if ("edit".equalsIgnoreCase(this.editType) && null != (idListForMe = (List)this.getSession().getAttribute("idListForMe"))) {
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            List<AticDevice> allFirewallList = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
            for (AticDevice firewall : allFirewallList) {
                if (!idListForMe.contains(firewall.getMoId())) continue;
                filterFirewallList.add(firewall);
            }
        }
        this.displayByPage(filterFirewallList);
        return "list";
    }

    private void displayByPage(List<AticDevice> tempList) {
        Paging page = new Paging();
        page.setData(tempList);
        this.setTotal(tempList.size());
        this.firewallList = new ArrayList<AticDevice>();
        for (int i = this.getStart(); i < this.getStart() + this.getPageSize() && i < tempList.size(); ++i) {
            this.firewallList.add(tempList.get(i));
        }
    }

    public void addToFirewallList() {
        List idListForOr = (List)this.getSession().getAttribute("idListForOr");
        List idListForMe = (List)this.getSession().getAttribute("idListForMe");
        ArrayList<Long> idList = new ArrayList<Long>(Arrays.asList(this.addIds));
        if ("edit".equalsIgnoreCase(this.editType)) {
            Iterator iterator = idList.iterator();
            while (iterator.hasNext() && null != idListForMe) {
                Long adId = (Long)iterator.next();
                if (!idListForMe.contains(adId)) continue;
                idListForMe.remove(adId);
                iterator.remove();
            }
            this.getSession().setAttribute("idListForMe", (Object)idListForMe);
        }
        if (null == idListForOr) {
            this.getSession().setAttribute("idListForOr", idList);
        } else {
            idListForOr.addAll(idList);
            this.getSession().setAttribute("idListForOr", (Object)idListForOr);
        }
        this.responseResult("success");
    }

    public void removeFromFirewallList() {
        List idListForOr = (List)this.getSession().getAttribute("idListForOr");
        List idListForMe = (List)this.getSession().getAttribute("idListForMe");
        ArrayList<Long> idList = new ArrayList<Long>(Arrays.asList(this.removeIds));
        Iterator iterator = idList.iterator();
        while (iterator.hasNext() && null != idListForOr) {
            Long adId = (Long)iterator.next();
            if (!idListForOr.contains(adId)) continue;
            idListForOr.remove(adId);
            iterator.remove();
        }
        this.getSession().setAttribute("idListForOr", (Object)idListForOr);
        if ("edit".equalsIgnoreCase(this.editType)) {
            if (null == idListForMe) {
                this.getSession().setAttribute("idListForMe", idList);
            } else {
                idListForMe.addAll(idList);
                this.getSession().setAttribute("idListForMe", (Object)idListForMe);
            }
        }
        this.responseResult("success");
    }

    public void saveConfigDefendGroup() {
        if (null != this.configGroupId) {
            String[] groupIds = this.configGroupId.split(",");
            StringBuffer object = new StringBuffer();
            for (int i = 0; i < groupIds.length; ++i) {
                DefendGroupForm dGroup = this.defendGroupService.findById(Long.valueOf(groupIds[i]));
                if (null == dGroup) {
                    throw new LegoCheckedException(571004L);
                }
                dGroup.setCleanMode(this.defendGroupForm.getCleanMode());
                dGroup.setUpstreamGroupId(this.defendGroupForm.getUpstreamGroupId());
                this.defendGroupService.saveDefendGroup(dGroup);
                object.append(dGroup.getGroupName() + ",");
            }
            if (0 != object.length()) {
                String[] detailPara = new String[]{this.defendGroupForm.getUpstreamGroupName(), this.getCleanModeI18N(this.defendGroupForm)};
                this.getOperateLog().normal("atic.public.button.config_defend_group", "lego.dic.module.AticBis", object.toString().substring(0, object.length() - 1), false, "atic.bis.defendGroup.configSummary.noNet", detailPara);
            }
        }
        LOG.info((Object)("config defendGroup : " + DefendGroupAction.getcleanedMessage(this.defendGroupForm.getGroupName()) + "successfully."));
        this.responseResult("success");
    }

    public void addDefendGroup() {
        DefendGroupForm dGroup;
        if (null == this.defendGroupForm) {
            this.getOperateLog().normal("atic.public.button.add_defend_group", "lego.dic.module.AticBis", null, false, "atic.bis.defendGroup.addSummary.failed", null);
            return;
        }
        if (null != this.defendGroupForm.getId() && null == (dGroup = this.defendGroupService.findById(this.defendGroupForm.getId()))) {
            this.getOperateLog().normal("atic.public.button.add_defend_group", "lego.dic.module.AticBis", null, false, "atic.bis.defendGroup.addSummary.failed", null);
            throw new LegoCheckedException(571004L);
        }
        this.addOperaLogForAddEditGroup(this.defendGroupForm);
        this.processBeforeSave();
        if (AticUtil.isReSubmit((HttpSession)this.getSession(), (StringBuffer)this.submitToken)) {
            this.responseResult("isReSubmit");
            this.getOperateLog().normal("atic.public.button.add_defend_group", "lego.dic.module.AticBis", null, false, "atic.bis.defendGroup.addSummary.failed", null);
            return;
        }
        this.defendGroupService.saveDefendGroup(this.defendGroupForm);
        LOG.info((Object)("add defendGroup : " + DefendGroupAction.getcleanedMessage(this.defendGroupForm.getGroupName()) + "successfully."));
        this.responseResult("success");
    }

    public static List<Long> removeRepeatZoneId(List<Long> l) {
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < l.size(); ++i) {
            set.add(l.get(i));
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            list.add((Long)it.next());
        }
        return list;
    }

    public String showEditDefendGroup() {
        this.defendGroupForm = this.defendGroupService.findById(this.defendGroupId);
        if (null == this.defendGroupForm) {
            throw new LegoCheckedException(571004L);
        }
        String devices = this.defendGroupForm.getDevices();
        this.firewallListBelongMe = new ArrayList<AticDevice>();
        if (!AticUtil.isNull((String)devices)) {
            for (String deviceId : devices.split(",")) {
                this.firewallListBelongMe.add(this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceId)));
            }
        }
        this.initComb();
        this.submitToken = new StringBuffer(UUID.randomUUID().toString());
        return "edit";
    }

    private void initComb() {
        this.detectModeCombData = new ArrayList<RadioBean>();
        RadioBean bean1 = new RadioBean();
        bean1.setKey(1);
        bean1.setLabel(this.getText("atic.bis.defend.group.detect.mode.balanced"));
        this.detectModeCombData.add(bean1);
        RadioBean bean2 = new RadioBean();
        bean2.setKey(0);
        bean2.setLabel(this.getText("atic.bis.defend.group.detect.mode.redundancy"));
        this.detectModeCombData.add(bean2);
        this.netModeCombData = this.getDefendGroupNetModeCombData();
    }

    private String getDefendGroupNetModeCombData() {
        StringBuffer combData = new StringBuffer();
        combData.append("[['").append(1).append("','").append(this.getText("atic.bis.defend.group.netmode.backward")).append("'],");
        combData.append("['").append(2).append("','").append(this.getText("atic.bis.defend.group.netmode.upward")).append("']]");
        return combData.toString();
    }

    public void editDefendGroup() {
        this.addDefendGroup();
    }

    public void deleteDefendGroup() {
        this.getOperateLog().warning("atic.bis.defend.group.del.defendGroup", "lego.dic.module.AticBis");
        this.processBeforeDel();
        HashMap<Long, String> defendTmep = new HashMap<Long, String>();
        if (null != this.ids) {
            ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
            for (int i = 0; i < this.ids.length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(this.ids[i].longValue());
                if (null != this.names) {
                    bo.setTargetName(this.names[i]);
                }
                DefendGroupForm form = this.defendGroupService.findById(this.ids[i]);
                StringBuffer deviceNames = new StringBuffer();
                String detectModeI18N = this.getDetectModeI18N(form);
                String cleanModeI18N = this.getCleanModeI18N(form);
                if (null != form) {
                    bo.setTargetName(form.getGroupName());
                    String devIds = form.getDevices();
                    defendTmep.put(this.ids[i], devIds);
                    if (!AticUtil.isNull((String)devIds)) {
                        String[] deviceIds = form.getDevices().split(",");
                        for (int j = 0; j < deviceIds.length; ++j) {
                            deviceNames.append(j != 0 ? Character.valueOf(',') : "").append(this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceIds[j])).getName());
                        }
                        String[] detailPara = new String[]{form.getGroupName(), detectModeI18N, cleanModeI18N, deviceNames.toString()};
                        bo.setTargetNameParam(detailPara);
                    } else {
                        String[] detailPara = new String[]{form.getGroupName(), detectModeI18N, cleanModeI18N};
                        bo.setTargetNameParam(detailPara);
                    }
                }
                batchOpList.add(bo);
            }
            this.batchOperationResult = this.defendGroupService.batchDelDefendGroup(batchOpList);
            List result = this.batchOperationResult.getResult();
            StringBuffer devIdBuffer = new StringBuffer();
            for (BatchOperation each : result) {
                String devStr;
                if (each.getErrorCode() != 0L || AticUtil.isNull((String)(devStr = (String)defendTmep.get(each.getTargetId())))) continue;
                devIdBuffer.append(devStr + ",");
            }
        }
        LOG.info((Object)("delete defend group : " + DefendGroupAction.getcleanedMessage(AticUtil.appendOperNameFromBatchOper((BatchOperationResult)this.batchOperationResult))));
        this.bathResult(this.batchOperationResult);
    }

    public String viewDefendGroup() {
        this.defendGroupForm = this.defendGroupService.findById(this.defendGroupId);
        if (null == this.defendGroupForm) {
            throw new LegoCheckedException(571004L);
        }
        this.defendGroupForm.setRemark(this.defendGroupForm.getRemark().replaceAll("\n", "<br/>"));
        String devices = this.defendGroupForm.getDevices();
        this.firewallList = new ArrayList<AticDevice>();
        if (!AticUtil.isNull((String)devices)) {
            for (String deviceId : devices.split(",")) {
                this.firewallList.add(this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceId)));
            }
        }
        return "view";
    }

    public String configDefendGroup() {
        if (null != this.configIds) {
            String[] groupIds = this.configIds.split(",");
            this.initConfig();
            if (groupIds.length == 1) {
                DefendGroupForm dGroupForm;
                this.defendGroupForm = this.defendGroupService.findById(Long.valueOf(groupIds[0]));
                if (null == this.defendGroupForm) {
                    throw new LegoCheckedException(571004L);
                }
                if (null != this.defendGroupForm.getUpstreamGroupId() && null != (dGroupForm = this.defendGroupService.getById(this.defendGroupForm.getUpstreamGroupId()))) {
                    this.defendGroupForm.setUpstreamGroupName(dGroupForm.getGroupName());
                }
            }
            this.initGroupList(groupIds);
        }
        this.setConfigGroupId(this.configIds);
        return "config";
    }

    private void initConfig() {
        this.cleanModeCombData = new ArrayList<RadioBean>();
        RadioBean cleanBean1 = new RadioBean();
        cleanBean1.setKey(0);
        cleanBean1.setLabel(this.getText("atic.bis.defend.group.clean.mode.disable"));
        RadioBean cleanBean2 = new RadioBean();
        cleanBean2.setKey(1);
        cleanBean2.setLabel(this.getText("atic.bis.defend.group.clean.mode.enable"));
        this.cleanModeCombData.add(cleanBean2);
        this.cleanModeCombData.add(cleanBean1);
    }

    private void initGroupList(String[] iDs) {
        this.groupCombData = new ArrayList<LangPair>();
        List<DefendGroupForm> defendGroupForms = this.defendGroupService.getAll();
        if (null == defendGroupForms || defendGroupForms.isEmpty()) {
            return;
        }
        for (int i = 0; i < iDs.length; ++i) {
            List<DefendGroupForm> defendGroupList = this.defendGroupService.findByUpstreamGroupId(Long.valueOf(iDs[i]));
            if (null == defendGroupList || defendGroupList.isEmpty()) continue;
            throw new LegoCheckedException(571007L);
        }
        for (DefendGroupForm dGroupForm : defendGroupForms) {
            boolean flag = true;
            for (int i = 0; i < iDs.length; ++i) {
                if (dGroupForm.getId() != Long.parseLong(iDs[i]) && dGroupForm.getUpstreamGroupId() == null) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            this.groupCombData.add(new LangPair(String.valueOf(dGroupForm.getId()), dGroupForm.getGroupName()));
            if (null == this.groupName) {
                this.setGroupName(dGroupForm.getGroupName());
            }
            if (null == this.defendGroupForm) {
                this.defendGroupForm = new DefendGroupForm();
            }
            if (this.defendGroupForm.getUpstreamGroupId() != null) continue;
            this.defendGroupForm.setUpstreamGroupId(dGroupForm.getId());
        }
    }

    private void processBeforeSave() {
        this.validateParams();
        if (this.defendGroupForm.getId() == null) {
            this.isExceedMaxNum();
        }
        this.isExists(this.defendGroupForm);
    }

    private Map<String, String> createQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("sortName", this.sortField);
        queryMap.put("sortType", this.sortType);
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        queryMap.put("isAdmin", String.valueOf(isAdmin));
        queryMap.put("userId", String.valueOf(currentUser.getUserID()));
        return queryMap;
    }

    private List<AticDevice> filterDeviceList(List<AticDevice> firewallLists) {
        ArrayList<String> toBeFilteredIds = new ArrayList<String>();
        List<DefendGroupForm> defendGroupFormLists = this.defendGroupService.getAll();
        for (DefendGroupForm defendGroupForms : defendGroupFormLists) {
            String devices = defendGroupForms.getDevices();
            if (AticUtil.isNull((String)devices)) continue;
            toBeFilteredIds.addAll(Arrays.asList(devices.split(",")));
        }
        Iterator<AticDevice> iterator = firewallLists.iterator();
        while (iterator.hasNext()) {
            AticDevice firewall = iterator.next();
            if (!toBeFilteredIds.contains(String.valueOf(firewall.getMoId()))) continue;
            iterator.remove();
        }
        LOG.info((Object)"filter device list successfully.");
        return firewallLists;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void validateParams() {
        String devices = this.defendGroupForm.getDevices();
        if (!AticUtil.isNull((String)devices)) {
            if (!devices.matches("(^[1-9]\\d*$)|([1-9]\\d*\\s*\\,\\s*)+[1-9]\\d*$")) {
                LOG.error((Object)"invalid devices");
                throw new LegoCheckedException(570505L);
            }
            List<String> deviceIds = Arrays.asList(devices.split(","));
            for (String idLoop : deviceIds) {
                if (null != this.aticDeviceService.getDeviceByMoid(Long.parseLong(idLoop))) continue;
                LOG.error((Object)"device has not been existed");
                throw new LegoCheckedException(571003L);
            }
            List<String> allDevices = Arrays.asList(this.defendGroupService.getDevicesNotBelongMe(this.defendGroupForm.getId()).split(","));
            for (String deviceId : devices.split(",")) {
                if (!allDevices.contains(deviceId)) continue;
                LOG.error((Object)"the device has been added to other defendGruop.");
                throw new LegoCheckedException(571005L);
            }
        }
    }

    private void isExists(DefendGroupForm defendGroupForms) {
        if (this.defendGroupService.isExists(defendGroupForms.getId(), defendGroupForms.getGroupName())) {
            LOG.error((Object)("defend group : " + DefendGroupAction.getcleanedMessage(defendGroupForms.getGroupName()) + " has been existed."));
            throw new LegoCheckedException(571001L);
        }
    }

    private void isExceedMaxNum() {
        if (this.defendGroupService.getCounts() >= 50) {
            LOG.error((Object)"defend group number exceeds max num : 50");
            throw new LegoCheckedException(571002L);
        }
    }

    private void processBeforeDel() {
        if (null == this.ids || null == this.names) {
            LOG.error((Object)"id or name is null");
            throw new LegoCheckedException(570505L);
        }
    }

    private void getDeviceInfo(List<DefendGroupForm> defendGroupFormLists) {
        for (DefendGroupForm defendGroupForms : defendGroupFormLists) {
            StringBuffer devicesStr = new StringBuffer();
            String devices = defendGroupForms.getDevices();
            if (!AticUtil.isNull((String)devices)) {
                String[] deviceArray = devices.split(",");
                for (int i = 0; i < deviceArray.length; ++i) {
                    AticDevice firewall = this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceArray[i]));
                    String deviceName = "";
                    deviceName = null == firewall ? this.getText("atic.analysis.common.unknown") + deviceArray[i] : firewall.getName();
                    if (i == 0) {
                        devicesStr.append(deviceName);
                        continue;
                    }
                    devicesStr.append(',').append(deviceName);
                }
            }
            defendGroupForms.setDevicesStr(devicesStr.toString());
        }
    }

    private void getUpstreamGroupInfo(List<DefendGroupForm> defendGroupFormLists) {
        if (null == this.defendGroupService) {
            return;
        }
        for (DefendGroupForm defendGroupForms : defendGroupFormLists) {
            DefendGroupForm dGroupForm;
            if (null == defendGroupForms.getUpstreamGroupId() || null == (dGroupForm = this.defendGroupService.findById(defendGroupForms.getUpstreamGroupId()))) continue;
            defendGroupForms.setUpstreamGroupName(dGroupForm.getGroupName());
        }
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public List<DefendGroupForm> getDefendGroupFormList() {
        return this.defendGroupFormList;
    }

    public String getDetectModeDisplay() {
        return null == this.defendGroupForm ? this.getText("atic.bis.defend.group.detect.mode.balanced") : this.getText((String)BisConstants.getDefendGroupDetectModeI18nMap().get(this.defendGroupForm.getDetectMode()));
    }

    public String getCleanModeDisplay() {
        return null == this.defendGroupForm ? this.getText("atic.bis.defend.group.clean.mode.disable") : this.getText((String)BisConstants.getDefendGroupCleanModeI18nMap().get(this.defendGroupForm.getCleanMode()));
    }

    public int getDetectModeValue() {
        return null == this.defendGroupForm ? 1 : this.defendGroupForm.getDetectMode();
    }

    public int getCleanModeValue() {
        return null == this.defendGroupForm ? 0 : this.defendGroupForm.getCleanMode();
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    private void addOperaLogForAddEditGroup(DefendGroupForm defendGroupForms) {
        String detectModeI18N = this.getDetectModeI18N(defendGroupForms);
        String cleanModeI18N = this.getCleanModeI18N(defendGroupForms);
        StringBuffer deviceNames = new StringBuffer();
        if (!AticUtil.isNull((String)defendGroupForms.getDevices())) {
            String[] deviceIds = defendGroupForms.getDevices().split(",");
            for (int i = 0; i < deviceIds.length; ++i) {
                deviceNames.append(i != 0 ? Character.valueOf(',') : "").append(this.aticDeviceService.getDeviceByMoid(Long.parseLong(deviceIds[i])).getName());
            }
        }
        if (defendGroupForms.getId() == null) {
            this.processAddLog(defendGroupForms, detectModeI18N, cleanModeI18N, deviceNames);
        } else {
            this.processModifyLog(defendGroupForms, detectModeI18N, cleanModeI18N, deviceNames);
        }
    }

    private String getDetectModeI18N(DefendGroupForm defendGroupForms) {
        if (null != defendGroupForms && null != defendGroupForms.getDetectMode()) {
            return defendGroupForms.getDetectMode() == 1 ? "atic.bis.defend.group.detect.mode.balanced" : "atic.bis.defend.group.detect.mode.redundancy";
        }
        return "atic.bis.defend.group.detect.mode.balanced";
    }

    private String getCleanModeI18N(DefendGroupForm defendGroupForms) {
        if (null != defendGroupForms && null != defendGroupForms.getCleanMode()) {
            return defendGroupForms.getCleanMode() == 0 ? "atic.bis.defend.group.clean.mode.disable" : "atic.bis.defend.group.clean.mode.enable";
        }
        return "atic.bis.defend.group.clean.mode.disable";
    }

    private void processAddLog(DefendGroupForm defendGroupForms, String detectModeI18N, String cleanModeI18N, StringBuffer deviceNames) {
        if (!AticUtil.isNull((String)defendGroupForms.getDevices())) {
            String[] detailPara = new String[]{defendGroupForms.getGroupName(), detectModeI18N, cleanModeI18N, deviceNames.toString()};
            this.getOperateLog().normal("atic.public.button.add_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.addSummary", detailPara);
        } else {
            String[] detailPara = new String[]{defendGroupForms.getGroupName(), detectModeI18N, cleanModeI18N};
            this.getOperateLog().normal("atic.public.button.add_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.addSummary.noNet", detailPara);
        }
    }

    private void processModifyLog(DefendGroupForm defendGroupForms, String detectModeI18N, String cleanModeI18N, StringBuffer deviceNames) {
        DefendGroupForm checkdefendGroupForm = this.defendGroupService.findById(defendGroupForms.getId());
        ArrayList<String> paraDetailList = new ArrayList<String>();
        if (!defendGroupForms.getGroupName().equals(checkdefendGroupForm.getGroupName())) {
            paraDetailList.add("atic.bis.defendGroup.editPart.name");
            paraDetailList.add(defendGroupForms.getGroupName());
        }
        if (!defendGroupForms.getDetectMode().equals(checkdefendGroupForm.getDetectMode())) {
            paraDetailList.add("atic.bis.defendGroup.editPart.detectMode");
            paraDetailList.add(detectModeI18N);
        }
        if (null != defendGroupForms.getCleanMode() && !defendGroupForms.getCleanMode().equals(checkdefendGroupForm.getCleanMode())) {
            paraDetailList.add("atic.bis.defendGroup.editPart.cleanMode");
            paraDetailList.add(cleanModeI18N);
        }
        if (!defendGroupForms.getDevices().equals(checkdefendGroupForm.getDevices())) {
            if (AticUtil.isNull((String)deviceNames.toString())) {
                paraDetailList.add("atic.bis.defendGroup.editPart.noSelect");
                paraDetailList.add("atic.bis.defendGroup.editPart.selectName.net");
            } else {
                paraDetailList.add("atic.bis.defendGroup.editPart.netList");
                paraDetailList.add(deviceNames.toString());
            }
        }
        if (2 == paraDetailList.size()) {
            this.getOperateLog().normal("atic.public.button.edit_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.editSummary.one", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (4 == paraDetailList.size()) {
            this.getOperateLog().normal("atic.public.button.edit_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.editSummary.two", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (6 == paraDetailList.size()) {
            this.getOperateLog().normal("atic.public.button.edit_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.editSummary.three", paraDetailList.toArray(new String[paraDetailList.size()]));
        } else if (8 == paraDetailList.size()) {
            this.getOperateLog().normal("atic.public.button.edit_defend_group", "lego.dic.module.AticBis", defendGroupForms.getGroupName(), false, "atic.bis.defendGroup.editSummary.four", paraDetailList.toArray(new String[paraDetailList.size()]));
        }
    }

    public boolean defendGroupFormValidation() {
        Integer cleanMode = this.defendGroupForm.getCleanMode();
        if (null != cleanMode) {
            if (cleanMode < 0 || cleanMode > 1) {
                return false;
            }
        } else {
            return false;
        }
        boolean flag = this.validateUpstreamGroupId();
        if (!flag) {
            return false;
        }
        String upstreamGroupName = this.defendGroupForm.getUpstreamGroupName().trim();
        if (upstreamGroupName.length() > 64) {
            LOG.error((Object)"defend group name has exceed 64 chars");
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[\u4e00-\u9fa5|\\w|\\-|*|?|!|=|+|@]*$";
        return upstreamGroupName.trim().matches(nameRegex);
    }

    public boolean validateUpstreamGroupId() {
        Long upstreamGroupId = this.defendGroupForm.getUpstreamGroupId();
        if (null != upstreamGroupId) {
            return upstreamGroupId >= 0L;
        }
        return true;
    }

    public boolean editTypeValidation() {
        return null != this.editType && (this.editType.equals("add") || this.editType.equals("edit"));
    }

    public boolean defendGroupIdValidate() {
        if (null != this.defendGroupId) {
            return this.defendGroupId >= 0L;
        }
        return false;
    }

    public boolean configIdsValidate() {
        if (null != this.configIds) {
            String[] groupIds;
            for (String testId : groupIds = this.configIds.split(",")) {
                if (!AticUtil.isNull((String)testId)) {
                    try {
                        long id = Long.parseLong(testId);
                        if (id >= 0L) continue;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean configGroupIdValidate() {
        if (null != this.configGroupId) {
            String[] groupIds;
            for (String testId : groupIds = this.configGroupId.split(",")) {
                if (!AticUtil.isNull((String)testId)) {
                    try {
                        long id = Long.parseLong(testId);
                        if (id >= 0L) continue;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public boolean idsValidate() {
        if (null != this.ids) {
            for (Long id : this.ids) {
                if (null != id && id >= 0L) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean addIdsValidate() {
        if (null != this.addIds) {
            for (Long id : this.addIds) {
                if (null == id || id >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean removeIdsValidate() {
        if (null != this.removeIds) {
            for (Long id : this.removeIds) {
                if (null != id && id >= 0L) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean namesValidate() {
        if (null != this.names) {
            for (String name : this.names) {
                if (!AticUtil.isNull((String)name)) {
                    String defendGroupName = name.trim();
                    if (defendGroupName.length() > 64) {
                        LOG.error((Object)"defend group name has exceed 64 chars");
                        return false;
                    }
                    String nameRegex = "^(?!(?i)null$)[\u4e00-\u9fa5|\\w|\\-|*|?|!|=|+|@]*$";
                    if (defendGroupName.matches(nameRegex)) continue;
                    return false;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean groupNameValidate() {
        if (null == this.defendGroupForm || AticUtil.isNull((String)this.defendGroupForm.getGroupName().trim())) {
            LOG.error((Object)"params error.");
            return false;
        }
        String defendGroupName = this.defendGroupForm.getGroupName().trim();
        if (defendGroupName.length() > 64) {
            LOG.error((Object)"defend group name has exceed 64 chars");
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[\u4e00-\u9fa5|\\w|\\-|*|?|!|=|+|@]*$";
        return defendGroupName.matches(nameRegex);
    }

    public boolean remarkValidate() {
        block5: {
            String regex = "^(?!(?i)null$)[\u4e00-\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\-|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\r|\\n]*$";
            String remark = this.defendGroupForm.getRemark();
            if (null != remark) {
                if (remark.length() > 256) {
                    LOG.error((Object)"defend group remark has exceed 256 chars");
                    return false;
                }
                try {
                    if (!remark.trim().matches(regex)) {
                        return false;
                    }
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public boolean devicesValidate() {
        String devices = this.defendGroupForm.getDevices();
        if (!AticUtil.isNullForVpn((String)devices) && !devices.matches("(^[1-9]\\d*$)|([1-9]\\d*\\s*\\,\\s*)+[1-9]\\d*$")) {
            LOG.error((Object)("invalid devices string : " + DefendGroupAction.getcleanedMessage(devices)));
            return false;
        }
        return true;
    }

    public DefendGroupForm getDefendGroupForm() {
        return this.defendGroupForm;
    }

    public void setDefendGroupForm(DefendGroupForm defendGroupForm) {
        this.defendGroupForm = defendGroupForm;
    }

    public void setDefendGroupId(Long defendGroupId) {
        this.defendGroupId = defendGroupId;
    }

    public void setIds(Long[] ids) {
        this.ids = null != ids ? (Long[])ids.clone() : null;
    }

    public void setNames(String[] names) {
        this.names = null != names ? (String[])names.clone() : null;
    }

    public List<AticDevice> getFirewallList() {
        return this.firewallList;
    }

    public List<AticDevice> getFirewallListBelongMe() {
        return this.firewallListBelongMe;
    }

    public String getNetModeCombData() {
        return this.netModeCombData;
    }

    public List<RadioBean> getDetectModeCombData() {
        return this.detectModeCombData;
    }

    public void setDetectModeCombData(List<RadioBean> detectModeCombData) {
        this.detectModeCombData = detectModeCombData;
    }

    public String getSubmitToken() {
        return this.submitToken.toString();
    }

    public void setSubmitToken(String submitToken) {
        this.submitToken = new StringBuffer(submitToken);
    }

    public void setFirewallList(List<AticDevice> firewallList) {
        this.firewallList = firewallList;
    }

    public Long[] getRemoveIds() {
        if (null != this.removeIds) {
            return (Long[])this.removeIds.clone();
        }
        return new Long[0];
    }

    public void setRemoveIds(Long[] removeIds) {
        this.removeIds = null != removeIds ? (Long[])removeIds.clone() : null;
    }

    public Long[] getAddIds() {
        if (null != this.addIds) {
            return (Long[])this.addIds.clone();
        }
        return new Long[0];
    }

    public void setAddIds(Long[] addIds) {
        this.addIds = null != addIds ? (Long[])addIds.clone() : null;
    }

    public String getEditType() {
        return this.editType;
    }

    public void setEditType(String editType) {
        this.editType = editType;
    }

    public List<RadioBean> getCleanModeCombData() {
        return this.cleanModeCombData;
    }

    public void setCleanModeCombData(List<RadioBean> cleanModeCombData) {
        this.cleanModeCombData = cleanModeCombData;
    }

    public List<LangPair> getGroupCombData() {
        return this.groupCombData;
    }

    public void setGroupCombData(List<LangPair> groupCombData) {
        this.groupCombData = groupCombData;
    }

    public String getConfigGroupId() {
        return this.configGroupId;
    }

    public void setConfigGroupId(String configGroupId) {
        this.configGroupId = configGroupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getConfigIds() {
        return this.configIds;
    }

    public void setConfigIds(String configIds) {
        this.configIds = configIds;
    }

    public IDefendGroupService getDefendGroupService() {
        return this.defendGroupService;
    }

    public void setDefendGroupService(IDefendGroupService defendGroupService) {
        this.defendGroupService = defendGroupService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

