/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.init.thread.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.sdk.perfmonitor.service.ICpuMemUsageService;
import com.huawei.atic.sdk.perfmonitor.service.IfTrafficService;
import java.util.Calendar;

public class DeleteMonitorData
extends Thread {
    private static final int SLEEP_FOR_A_WHILE = 60000;
    private static final long HOUR = 3600000L;
    private static final long RETENTION_TIME = 90L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private boolean start = false;
    private int beforeDay = 0;
    private ICpuMemUsageService iCpuMemUsageService;
    private IfTrafficService ifTrafficService;

    @Override
    public void run() {
        this.logger.info((Object)"DeleteLogDataThread run!");
        while (this.start) {
            if (this.isTime2Run(this.getCurrentDay()).booleanValue()) {
                try {
                    this.deleteMonitorData();
                }
                catch (Exception e) {
                    this.logger.error((Object)"delete device monitor data some errors happend", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("DeleteLogDataThread InterruptedException error: " + e));
            }
        }
        this.logger.info((Object)"DeleteLogDataThread stop!");
    }

    private int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(6);
        return day;
    }

    private Boolean isTime2Run(int currentDay) {
        int hour;
        Calendar cal = Calendar.getInstance();
        if (currentDay > this.beforeDay && (hour = cal.get(11)) >= 3) {
            this.beforeDay = currentDay;
            return true;
        }
        return false;
    }

    private void deleteMonitorData() {
        long time = 7776000000L;
        long curTime = System.currentTimeMillis();
        this.iCpuMemUsageService.deleteDataByTime(curTime - time);
        this.ifTrafficService.deleteDataByTime(curTime - time);
    }

    public ICpuMemUsageService getiCpuMemUsageService() {
        return this.iCpuMemUsageService;
    }

    public void setiCpuMemUsageService(ICpuMemUsageService cpuMemUsageService) {
        this.iCpuMemUsageService = cpuMemUsageService;
    }

    public IfTrafficService getIfTrafficService() {
        return this.ifTrafficService;
    }

    public void setIfTrafficService(IfTrafficService ifTrafficService) {
        this.ifTrafficService = ifTrafficService;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

