/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.init.thread.util;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.alarm.service.SecneAlarmHandler;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.resource.sdk.service.IResourceService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import com.huawei.atic.util.NfaClusterUtil;
import com.huawei.atic.util.NfaFilterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MonitorNfaDevice {
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static Map<Long, List<AticDevice>> nfaMap = null;
    private static List<AticDevice> seperateNfaList = null;
    private static List<AticDevice> allNfaList = null;
    private static Map<Long, String> nfaStatusMap = new HashMap<Long, String>();
    private IClusterService clusterService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private SecneAlarmHandler alarmHandler;
    private IResourceService resourceService;

    public void monitor() {
        this.getNfaList();
        this.groupNfaDeviceByCluster();
        this.checkMap(nfaMap);
        this.checkList(seperateNfaList);
        this.updateStatusMap();
    }

    private void updateStatusMap() {
        Set<Long> nfaSet = nfaStatusMap.keySet();
        Iterator<Long> nfaIterator = nfaSet.iterator();
        while (nfaIterator.hasNext()) {
            Long nfaMoid = nfaIterator.next();
            boolean isExist = false;
            for (int i = 0; i < allNfaList.size(); ++i) {
                if (allNfaList.get(i).getMoId() != nfaMoid.longValue()) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            nfaIterator.remove();
        }
    }

    private void getNfaList() {
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        allNfaList = aticDeviceService.getNFA2000VDevice();
    }

    private void groupNfaDeviceByCluster() {
        ArrayList<AticDevice> seperateNfaListTemp = new ArrayList<AticDevice>();
        HashMap<Long, List<AticDevice>> nfaMapTemp = new HashMap<Long, List<AticDevice>>();
        for (AticDevice nfa : allNfaList) {
            if (!this.clusterService.isBelongCluster(nfa.getMoId())) {
                seperateNfaListTemp.add(nfa);
                continue;
            }
            AticDeviceNfaCluster cluster = this.clusterService.getClusterByNfaId(nfa.getMoId());
            Long clusterId = cluster.getClusterId();
            if (nfaMapTemp.containsKey(clusterId)) {
                ((List)nfaMapTemp.get(clusterId)).add(nfa);
                continue;
            }
            ArrayList<AticDevice> list = new ArrayList<AticDevice>();
            list.add(nfa);
            nfaMapTemp.put(clusterId, list);
        }
        MonitorNfaDevice.setSeperateNfaList(seperateNfaListTemp);
        MonitorNfaDevice.setNfaMap(nfaMapTemp);
    }

    private void checkMap(Map<Long, List<AticDevice>> map) {
        Set<Map.Entry<Long, List<AticDevice>>> entrySet = map.entrySet();
        Iterator<Map.Entry<Long, List<AticDevice>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Boolean statusChanged = false;
            ArrayList<AticDevice> liveNfaList = new ArrayList<AticDevice>();
            Map.Entry<Long, List<AticDevice>> entry = iterator.next();
            List<AticDevice> nfaList = entry.getValue();
            for (AticDevice nfaDevice : nfaList) {
                String status = this.getStatus(nfaDevice);
                if (SUCCESS.equals(status)) {
                    liveNfaList.add(nfaDevice);
                }
                String preStatus = nfaStatusMap.get(nfaDevice.getMoId());
                String[] param = new String[]{nfaDevice.getName(), nfaDevice.getIpAddress()};
                if ((!SUCCESS.equals(status) || SUCCESS.equals(preStatus)) && (!FAIL.equals(status) || FAIL.equals(preStatus))) continue;
                this.alarmHandler.nfaOfflineAlarmResume(nfaDevice, param);
                nfaStatusMap.put(nfaDevice.getMoId(), status);
                ManagedObject mb = this.resourceService.getMoByMoId(nfaDevice.getMoId(), true);
                if (null == mb) continue;
                mb.setStatus(Integer.valueOf(status.equals(SUCCESS) ? 0 : -1));
                this.resourceService.updateMo(mb);
            }
            if (!statusChanged.booleanValue()) continue;
            this.logger.info((Object)("The status of the cluster with the id of " + entry.getKey() + " is changed, the live device number is " + liveNfaList.size() + ", the total number in the cluster is " + nfaList.size()));
            try {
                NfaClusterUtil.modifyInvalidNfaInCluster(entry.getKey(), liveNfaList);
            }
            catch (Exception e) {
                this.logger.error((Object)("execute modifyInvalidNfaInCluster error, the cluster id is " + entry.getKey()));
            }
        }
    }

    private void checkList(List<AticDevice> list) {
        for (AticDevice nfaDevice : list) {
            String status = this.getStatus(nfaDevice);
            String preStatus = nfaStatusMap.get(nfaDevice.getMoId());
            String[] param = new String[]{nfaDevice.getName(), nfaDevice.getIpAddress()};
            if ((!SUCCESS.equals(status) || SUCCESS.equals(preStatus)) && (!FAIL.equals(status) || FAIL.equals(preStatus))) continue;
            this.alarmHandler.nfaOfflineAlarmResume(nfaDevice, param);
            nfaStatusMap.put(nfaDevice.getMoId(), status);
            ManagedObject mb = this.resourceService.getMoByMoId(nfaDevice.getMoId(), true);
            if (null == mb) continue;
            mb.setStatus(Integer.valueOf(status.equals(SUCCESS) ? 0 : -1));
            this.resourceService.updateMo(mb);
        }
    }

    private String getStatus(AticDevice device) {
        IRestfulNfaService restfulNfaService = (IRestfulNfaService)ServiceContext.getInstance().getService("restfulNfaService", IRestfulNfaService.class);
        NfaInfoForm nfaInfoForm = NfaFilterUtil.getNfaInfoFormByDeviceId(device.getMoId());
        if (null == nfaInfoForm) {
            this.logger.info((Object)"nfaInfoForm is null.");
            return FAIL;
        }
        Result result = null;
        try {
            for (int i = 0; i < 3; ++i) {
                result = restfulNfaService.restNfaGetStatus(nfaInfoForm);
                if (result.getStatusCode() != 200 || !result.getJson().contains("ok")) continue;
                return SUCCESS;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get status failed for device" + device.getName()));
            e.printStackTrace();
        }
        this.logger.error((Object)("after tried for 3 times, cannt get the status of " + device.getName() + ", the result is " + result.toString()));
        return FAIL;
    }

    public static Map<Long, List<AticDevice>> getNfaMap() {
        return nfaMap;
    }

    public static void setNfaMap(Map<Long, List<AticDevice>> nfaMap) {
        MonitorNfaDevice.nfaMap = nfaMap;
    }

    public IClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(IClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public static List<AticDevice> getAllNfaList() {
        return allNfaList;
    }

    public static void setAllNfaList(List<AticDevice> allNfaList) {
        MonitorNfaDevice.allNfaList = allNfaList;
    }

    public static Map<Long, String> getNfaStatusMap() {
        return nfaStatusMap;
    }

    public static void setNfaStatusMap(Map<Long, String> nfaStatusMap) {
        MonitorNfaDevice.nfaStatusMap = nfaStatusMap;
    }

    public static List<AticDevice> getSeperateNfaList() {
        return seperateNfaList;
    }

    public static void setSeperateNfaList(List<AticDevice> seperateNfaList) {
        MonitorNfaDevice.seperateNfaList = seperateNfaList;
    }

    public SecneAlarmHandler getAlarmHandler() {
        return this.alarmHandler;
    }

    public void setAlarmHandler(SecneAlarmHandler alarmHandler) {
        this.alarmHandler = alarmHandler;
    }

    public IResourceService getResourceService() {
        return this.resourceService;
    }

    public void setResourceService(IResourceService resourceService) {
        this.resourceService = resourceService;
    }
}

